/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.api.util.GenerationUtils;
import com.teamabnormals.endergetic.common.block.poise.GlowingPoiseStemBlock;
import com.teamabnormals.endergetic.common.block.poise.PoiseTallBushBlock;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.other.tags.EEBlockTags;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PoiseTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private final Supplier<BlockState> POISMOSS_EUMUS = () -> ((Block)EEBlocks.EUMUS_POISMOSS.get()).m_49966_();
    private final Supplier<BlockState> POISE_STEM = () -> ((Block)EEBlocks.POISE_STEM.get()).m_49966_();
    private final Supplier<BlockState> GLOWING_POISE_STEM = () -> ((Block)EEBlocks.GLOWING_POISE_STEM.get()).m_49966_();

    public PoiseTreeFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos;
        WorldGenLevel world;
        RandomSource rand = context.m_225041_();
        int treeHeight = rand.m_188503_(19) + 13;
        int size = 0;
        float rng = rand.m_188501_();
        if (rng >= 0.45f) {
            size = rng >= 0.85f ? 2 : 1;
        }
        if (this.isValidGround((LevelAccessor)(world = context.m_159774_()), (pos = context.m_159777_()).m_7495_()) && this.isAreaOpen((LevelAccessor)world, pos)) {
            boolean[] isSutableForSizes = new boolean[]{GenerationUtils.isAreaReplacable((LevelAccessor)world, pos.m_122013_(3).m_122025_(3).m_6630_(treeHeight).m_123341_(), pos.m_122013_(3).m_122025_(3).m_6630_(treeHeight).m_123342_(), pos.m_122013_(3).m_122025_(3).m_6630_(treeHeight).m_123343_(), pos.m_122020_(3).m_122030_(3).m_6630_(treeHeight + 7).m_123341_(), pos.m_122020_(3).m_122030_(3).m_6630_(treeHeight + 7).m_123342_(), pos.m_122020_(3).m_122030_(3).m_6630_(treeHeight + 7).m_123343_()), GenerationUtils.isAreaReplacable((LevelAccessor)world, pos.m_122013_(4).m_122025_(4).m_6630_(treeHeight).m_123341_(), pos.m_122013_(4).m_122025_(4).m_6630_(treeHeight).m_123342_(), pos.m_122013_(4).m_122025_(4).m_6630_(treeHeight).m_123343_(), pos.m_122020_(4).m_122030_(4).m_6630_(treeHeight + 9).m_123341_(), pos.m_122020_(4).m_122030_(4).m_6630_(treeHeight + 9).m_123342_(), pos.m_122020_(4).m_122030_(4).m_6630_(treeHeight + 9).m_123343_()), GenerationUtils.isAreaReplacable((LevelAccessor)world, pos.m_122013_(6).m_122025_(6).m_6630_(treeHeight).m_123341_(), pos.m_122013_(6).m_122025_(6).m_6630_(treeHeight).m_123342_(), pos.m_122013_(6).m_122025_(6).m_6630_(treeHeight).m_123343_(), pos.m_122020_(6).m_122030_(6).m_6630_(treeHeight + 13).m_123341_(), pos.m_122020_(6).m_122030_(6).m_6630_(treeHeight + 13).m_123342_(), pos.m_122020_(6).m_122030_(6).m_6630_(treeHeight + 13).m_123343_())};
            if (size == 0) {
                if (GenerationUtils.isAreaReplacable((LevelAccessor)world, pos.m_122012_().m_122024_().m_123341_(), pos.m_122012_().m_122024_().m_123342_(), pos.m_122012_().m_122024_().m_123343_(), pos.m_122019_().m_122029_().m_6630_(treeHeight).m_123341_(), pos.m_122019_().m_122029_().m_6630_(treeHeight).m_123342_(), pos.m_122019_().m_122029_().m_6630_(treeHeight).m_123343_())) {
                    if (isSutableForSizes[0]) {
                        this.buildTreeBase((LevelAccessor)world, pos, rand);
                        this.buildStem((LevelAccessor)world, pos, rand, treeHeight);
                        this.buildTreeTop((LevelAccessor)world, pos, rand, treeHeight, size);
                        if (rand.m_188501_() <= 0.8f) {
                            this.tryToBuildBranch((LevelAccessor)world, pos, rand, treeHeight);
                        }
                        this.buildPoismossCircle((LevelAccessor)world, (LevelSimulatedRW)world, rand, pos);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            if (size == 1) {
                if (GenerationUtils.isAreaReplacable((LevelAccessor)world, pos.m_122012_().m_122024_().m_123341_(), pos.m_122012_().m_122024_().m_123342_(), pos.m_122012_().m_122024_().m_123343_(), pos.m_122019_().m_122029_().m_6630_(treeHeight).m_123341_(), pos.m_122019_().m_122029_().m_6630_(treeHeight).m_123342_(), pos.m_122019_().m_122029_().m_6630_(treeHeight).m_123343_())) {
                    if (isSutableForSizes[1]) {
                        this.buildTreeBase((LevelAccessor)world, pos, rand);
                        this.buildStem((LevelAccessor)world, pos, rand, treeHeight);
                        this.buildTreeTop((LevelAccessor)world, pos, rand, treeHeight, size);
                        if (rand.m_188501_() <= 0.8f) {
                            this.tryToBuildBranch((LevelAccessor)world, pos, rand, treeHeight);
                        }
                        this.buildPoismossCircle((LevelAccessor)world, (LevelSimulatedRW)world, rand, pos);
                        return true;
                    }
                    if (isSutableForSizes[0]) {
                        this.buildTreeBase((LevelAccessor)world, pos, rand);
                        this.buildStem((LevelAccessor)world, pos, rand, treeHeight);
                        this.buildTreeTop((LevelAccessor)world, pos, rand, treeHeight, 0);
                        if (rand.m_188501_() <= 0.8f) {
                            this.tryToBuildBranch((LevelAccessor)world, pos, rand, treeHeight);
                        }
                        this.buildPoismossCircle((LevelAccessor)world, (LevelSimulatedRW)world, rand, pos);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            if (GenerationUtils.isAreaReplacable((LevelAccessor)world, pos.m_122012_().m_122024_().m_123341_(), pos.m_122012_().m_122024_().m_123342_(), pos.m_122012_().m_122024_().m_123343_(), pos.m_122019_().m_122029_().m_6630_(treeHeight).m_123341_(), pos.m_122019_().m_122029_().m_6630_(treeHeight).m_123342_(), pos.m_122019_().m_122029_().m_6630_(treeHeight).m_123343_())) {
                if (isSutableForSizes[2]) {
                    this.buildTreeBase((LevelAccessor)world, pos, rand);
                    this.buildStem((LevelAccessor)world, pos, rand, treeHeight);
                    this.buildTreeTop((LevelAccessor)world, pos, rand, treeHeight, size);
                    if (rand.m_188501_() <= 0.8f) {
                        this.tryToBuildBranch((LevelAccessor)world, pos, rand, treeHeight);
                    }
                    this.buildPoismossCircle((LevelAccessor)world, (LevelSimulatedRW)world, rand, pos);
                    return true;
                }
                if (isSutableForSizes[1]) {
                    this.buildTreeBase((LevelAccessor)world, pos, rand);
                    this.buildStem((LevelAccessor)world, pos, rand, treeHeight);
                    this.buildTreeTop((LevelAccessor)world, pos, rand, treeHeight, 1);
                    if (rand.m_188501_() <= 0.8f) {
                        this.tryToBuildBranch((LevelAccessor)world, pos, rand, treeHeight);
                    }
                    this.buildPoismossCircle((LevelAccessor)world, (LevelSimulatedRW)world, rand, pos);
                    return true;
                }
                if (isSutableForSizes[0]) {
                    this.buildTreeBase((LevelAccessor)world, pos, rand);
                    this.buildStem((LevelAccessor)world, pos, rand, treeHeight);
                    this.buildTreeTop((LevelAccessor)world, pos, rand, treeHeight, 0);
                    if (rand.m_188501_() <= 0.8f) {
                        this.tryToBuildBranch((LevelAccessor)world, pos, rand, treeHeight);
                    }
                    this.buildPoismossCircle((LevelAccessor)world, (LevelSimulatedRW)world, rand, pos);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void buildTreeBase(LevelAccessor world, BlockPos pos, RandomSource rand) {
        int[] sideRandValues = new int[]{rand.m_188503_(8) + 2, rand.m_188503_(8) + 2, rand.m_188503_(8) + 2, rand.m_188503_(8) + 2};
        for (int x = pos.m_123341_() - 1; x < pos.m_123341_() + 2; ++x) {
            for (int z = pos.m_123343_() - 1; z < pos.m_123343_() + 2; ++z) {
                this.setPoiseLog(world, new BlockPos(x, pos.m_123342_(), z), rand, true, false);
            }
        }
        for (int xN = 1; xN < sideRandValues[0] + 1; ++xN) {
            this.setPoiseLog(world, pos.m_122012_().m_6630_(xN), rand, true, false);
        }
        for (int xE = 1; xE < sideRandValues[1] + 1; ++xE) {
            this.setPoiseLog(world, pos.m_122029_().m_6630_(xE), rand, true, false);
        }
        for (int xS = 1; xS < sideRandValues[2] + 1; ++xS) {
            this.setPoiseLog(world, pos.m_122019_().m_6630_(xS), rand, true, false);
        }
        for (int xW = 1; xW < sideRandValues[3] + 1; ++xW) {
            this.setPoiseLog(world, pos.m_122024_().m_6630_(xW), rand, true, false);
        }
        BlockPos downPos = pos.m_6625_(2);
        if (GenerationUtils.isAreaCompletelySolid(world, downPos.m_123341_() - 1, downPos.m_123342_(), downPos.m_123343_() - 1, downPos.m_123341_() + 1, downPos.m_123342_(), downPos.m_123343_() + 1)) {
            GenerationUtils.fillAreaWithBlockCube(world, downPos.m_123341_() - 1, downPos.m_123342_(), downPos.m_123343_() - 1, downPos.m_123341_() + 1, downPos.m_123342_() + 1, downPos.m_123343_() + 1, this.POISE_STEM.get());
        }
    }

    private void buildStem(LevelAccessor world, BlockPos pos, RandomSource rand, int height) {
        for (int y = 1; y < height; ++y) {
            boolean doBubbles = y > height - 2;
            this.setPoiseLog(world, pos.m_6630_(y), rand, false, doBubbles);
        }
    }

    private void buildTreeTop(LevelAccessor world, BlockPos pos, RandomSource rand, int arrivedPos, int size) {
        if (size == 0) {
            int z;
            int x;
            for (x = pos.m_123341_() - 1; x <= pos.m_123341_() + 1; ++x) {
                for (z = pos.m_123343_() - 1; z <= pos.m_123343_() + 1; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, pos.m_6630_(arrivedPos).m_123342_(), z), rand, false, true);
                }
            }
            for (x = pos.m_123341_() - 1; x <= pos.m_123341_() + 1; ++x) {
                for (z = pos.m_123343_() - 1; z <= pos.m_123343_() + 1; ++z) {
                    this.setBlockState(world, new BlockPos(x, pos.m_6630_(arrivedPos + 1).m_123342_(), z), this.POISMOSS_EUMUS.get());
                }
            }
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(2), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(2), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(2), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(2), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(3).m_7494_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(3).m_7494_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(3).m_7494_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(3).m_7494_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(2).m_7494_().m_122029_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(2).m_7494_().m_122024_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(2).m_7494_().m_122012_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(2).m_7494_().m_122019_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(2).m_7494_().m_122029_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(2).m_7494_().m_122024_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(2).m_7494_().m_122012_(), rand, false, true);
            this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(2).m_7494_().m_122019_(), rand, false, true);
            this.setBlockState(world, pos.m_6630_(arrivedPos).m_122013_(2).m_7494_(), this.POISMOSS_EUMUS.get());
            this.setBlockState(world, pos.m_6630_(arrivedPos).m_122030_(2).m_7494_(), this.POISMOSS_EUMUS.get());
            this.setBlockState(world, pos.m_6630_(arrivedPos).m_122020_(2).m_7494_(), this.POISMOSS_EUMUS.get());
            this.setBlockState(world, pos.m_6630_(arrivedPos).m_122025_(2).m_7494_(), this.POISMOSS_EUMUS.get());
            this.placeInnerDomeFeatures(world, rand, pos.m_6630_(arrivedPos).m_122025_(2).m_7494_());
            int[] sideRandValues = new int[]{rand.m_188503_(3) + 1, rand.m_188503_(3) + 1, rand.m_188503_(3) + 1, rand.m_188503_(3) + 1};
            for (int yn = 1; yn <= sideRandValues[0]; ++yn) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(3).m_7494_().m_6630_(yn), rand, false, true);
                if (yn != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(3).m_122029_().m_7494_().m_6630_(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(3).m_122024_().m_7494_().m_6630_(yn), rand, false, true);
            }
            for (int ye = 1; ye <= sideRandValues[1]; ++ye) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(3).m_7494_().m_6630_(ye), rand, false, true);
                if (ye != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(3).m_122019_().m_7494_().m_6630_(ye), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(3).m_122012_().m_7494_().m_6630_(ye), rand, false, true);
            }
            for (int ys = 1; ys <= sideRandValues[2]; ++ys) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(3).m_7494_().m_6630_(ys), rand, false, true);
                if (ys != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(3).m_122024_().m_7494_().m_6630_(ys), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(3).m_122029_().m_7494_().m_6630_(ys), rand, false, true);
            }
            for (int yw = 1; yw <= sideRandValues[3]; ++yw) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(3).m_7494_().m_6630_(yw), rand, false, true);
                if (yw != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(3).m_122012_().m_7494_().m_6630_(yw), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(3).m_122019_().m_7494_().m_6630_(yw), rand, false, true);
            }
            this.addTreeDomeTop(world, pos, rand, arrivedPos, 0);
        } else if (size == 1) {
            BlockPos cornerOrigin;
            int yn;
            int z;
            int x;
            BlockPos origin = pos.m_6630_(arrivedPos);
            this.setPoiseLog(world, origin, rand, false, true);
            this.setPoiseLog(world, origin.m_122012_(), rand, false, true);
            this.setPoiseLog(world, origin.m_122029_(), rand, false, true);
            this.setPoiseLog(world, origin.m_122019_(), rand, false, true);
            this.setPoiseLog(world, origin.m_122024_(), rand, false, true);
            for (x = origin.m_123341_() - 2; x <= origin.m_123341_() + 2; ++x) {
                for (z = origin.m_123343_() - 1; z <= origin.m_123343_() + 1; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.m_7494_().m_123342_(), z), rand, false, true);
                }
            }
            for (x = origin.m_123341_() - 1; x <= origin.m_123341_() + 1; ++x) {
                for (z = origin.m_123343_() - 2; z <= origin.m_123343_() + 2; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.m_7494_().m_123342_(), z), rand, false, true);
                }
            }
            this.setPoiseLog(world, origin.m_6630_(2).m_122013_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122013_(3).m_122024_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122013_(3).m_122029_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122030_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122030_(3).m_122012_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122030_(3).m_122019_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122020_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122020_(3).m_122024_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122020_(3).m_122029_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122025_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122025_(3).m_122012_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122025_(3).m_122019_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122013_(2).m_122025_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122013_(2).m_122030_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122020_(2).m_122025_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(2).m_122020_(2).m_122030_(2), rand, false, true);
            for (x = origin.m_123341_() - 2; x <= origin.m_123341_() + 2; ++x) {
                for (z = origin.m_123343_() - 1; z <= origin.m_123343_() + 1; ++z) {
                    world.m_7731_(new BlockPos(x, origin.m_6630_(2).m_123342_(), z), this.POISMOSS_EUMUS.get(), 2);
                }
            }
            for (x = origin.m_123341_() - 1; x <= origin.m_123341_() + 1; ++x) {
                for (z = origin.m_123343_() - 2; z <= origin.m_123343_() + 2; ++z) {
                    world.m_7731_(new BlockPos(x, origin.m_6630_(2).m_123342_(), z), this.POISMOSS_EUMUS.get(), 2);
                }
            }
            this.placeInnerDomeFeatures(world, rand, origin.m_6630_(2));
            int[] sideRandValues = new int[]{rand.m_188503_(3) + 1, rand.m_188503_(3) + 1, rand.m_188503_(3) + 1, rand.m_188503_(3) + 1};
            for (yn = 1; yn <= sideRandValues[0]; ++yn) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(4).m_6630_(2).m_6630_(yn), rand, false, true);
                if (yn != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(4).m_122029_().m_6630_(2).m_6630_(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(4).m_122024_().m_6630_(2).m_6630_(yn), rand, false, true);
            }
            for (yn = 1; yn <= sideRandValues[1]; ++yn) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(4).m_6630_(2).m_6630_(yn), rand, false, true);
                if (yn != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(4).m_122012_().m_6630_(2).m_6630_(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(4).m_122019_().m_6630_(2).m_6630_(yn), rand, false, true);
            }
            for (yn = 1; yn <= sideRandValues[2]; ++yn) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(4).m_6630_(2).m_6630_(yn), rand, false, true);
                if (yn != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(4).m_122029_().m_6630_(2).m_6630_(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(4).m_122024_().m_6630_(2).m_6630_(yn), rand, false, true);
            }
            for (yn = 1; yn <= sideRandValues[3]; ++yn) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(4).m_6630_(2).m_6630_(yn), rand, false, true);
                if (yn != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(4).m_122012_().m_6630_(2).m_6630_(yn), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(4).m_122019_().m_6630_(2).m_6630_(yn), rand, false, true);
            }
            boolean[] doCornerFeature = new boolean[]{rand.m_188503_(4) == 0, rand.m_188503_(4) == 0, rand.m_188503_(4) == 0, rand.m_188503_(4) == 0};
            if (doCornerFeature[0]) {
                cornerOrigin = origin.m_6630_(3).m_122013_(3).m_122025_(2);
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122024_(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122024_().m_7494_(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122019_().m_122024_(), rand, false, true);
                } else {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122024_().m_7494_(), rand, false, true);
                    if (rand.m_188499_()) {
                        this.setPoiseLog(world, cornerOrigin.m_122024_().m_6630_(2), rand, false, true);
                    }
                }
            }
            if (doCornerFeature[1]) {
                cornerOrigin = origin.m_6630_(3).m_122030_(3).m_122013_(2);
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122012_(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122012_().m_7494_(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122024_().m_122012_(), rand, false, true);
                } else {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122012_().m_7494_(), rand, false, true);
                    if (rand.m_188499_()) {
                        this.setPoiseLog(world, cornerOrigin.m_6630_(2).m_122012_(), rand, false, true);
                    }
                }
            }
            if (doCornerFeature[2]) {
                cornerOrigin = origin.m_6630_(3).m_122020_(3).m_122030_(2);
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122029_(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122029_().m_7494_(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122012_().m_122029_(), rand, false, true);
                } else {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122029_().m_7494_(), rand, false, true);
                    if (rand.m_188499_()) {
                        this.setPoiseLog(world, cornerOrigin.m_6630_(2).m_122029_(), rand, false, true);
                    }
                }
            }
            if (doCornerFeature[3]) {
                cornerOrigin = origin.m_6630_(3).m_122025_(3).m_122020_(2);
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122019_(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122019_().m_7494_(), rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_122029_().m_122019_(), rand, false, true);
                } else {
                    this.setPoiseLog(world, cornerOrigin, rand, false, true);
                    this.setPoiseLog(world, cornerOrigin.m_7494_().m_122019_(), rand, false, true);
                    if (rand.m_188499_()) {
                        this.setPoiseLog(world, cornerOrigin.m_6630_(2).m_122019_(), rand, false, true);
                    }
                }
            }
            this.addTreeDomeTop(world, pos, rand, arrivedPos, 1);
        } else {
            int yn;
            int yn2;
            int z;
            int x;
            BlockPos origin = pos.m_6630_(arrivedPos);
            this.setPoiseLog(world, origin, rand, false, true);
            if (rand.m_188501_() <= 0.75f) {
                this.setPoiseLog(world, origin.m_122012_(), rand, false, true);
            }
            if (rand.m_188501_() <= 0.75f) {
                this.setPoiseLog(world, origin.m_122029_(), rand, false, true);
            }
            if (rand.m_188501_() <= 0.75f) {
                this.setPoiseLog(world, origin.m_122019_(), rand, false, true);
            }
            if (rand.m_188501_() <= 0.75f) {
                this.setPoiseLog(world, origin.m_122024_(), rand, false, true);
            }
            GenerationUtils.fillWithRandomTwoBlocksCube(world, origin.m_7494_().m_122012_().m_122024_().m_123341_(), origin.m_7494_().m_122012_().m_122024_().m_123342_(), origin.m_7494_().m_122012_().m_122024_().m_123343_(), origin.m_6630_(2).m_122029_().m_122019_().m_123341_(), origin.m_6630_(2).m_122029_().m_122019_().m_123342_(), origin.m_6630_(2).m_122029_().m_122019_().m_123343_(), new Random(rand.m_188505_()), this.POISE_STEM.get(), this.GLOWING_POISE_STEM.get(), 0.1f);
            for (x = origin.m_123341_() - 1; x <= origin.m_123341_() + 1; ++x) {
                for (z = origin.m_123343_() - 3; z <= origin.m_123343_() + 3; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.m_6630_(3).m_123342_(), z), rand, false, true);
                }
            }
            for (x = origin.m_123341_() - 3; x <= origin.m_123341_() + 3; ++x) {
                for (z = origin.m_123343_() - 1; z <= origin.m_123343_() + 1; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.m_6630_(3).m_123342_(), z), rand, false, true);
                }
            }
            this.setPoiseLog(world, origin.m_6630_(3).m_122013_(2).m_122030_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(3).m_122013_(2).m_122025_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(3).m_122020_(2).m_122030_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(3).m_122020_(2).m_122025_(2), rand, false, true);
            for (x = origin.m_123341_() - 1; x <= origin.m_123341_() + 1; ++x) {
                for (z = origin.m_123343_() - 5; z <= origin.m_123343_() + 5; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.m_6630_(4).m_123342_(), z), rand, false, true);
                }
            }
            for (x = origin.m_123341_() - 5; x <= origin.m_123341_() + 5; ++x) {
                for (z = origin.m_123343_() - 1; z <= origin.m_123343_() + 1; ++z) {
                    this.setPoiseLog(world, new BlockPos(x, origin.m_6630_(4).m_123342_(), z), rand, false, true);
                }
            }
            this.setPoiseLog(world, origin.m_6630_(4).m_122013_(3).m_122030_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122013_(4).m_122030_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122013_(3).m_122030_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122013_(2).m_122030_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122013_(2).m_122030_(4), rand, false, true);
            world.m_7731_(origin.m_6630_(4).m_122013_(2).m_122030_(2), this.POISMOSS_EUMUS.get(), 2);
            this.setPoiseLog(world, origin.m_6630_(4).m_122030_(3).m_122020_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122030_(4).m_122020_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122030_(3).m_122020_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122030_(2).m_122020_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122030_(2).m_122020_(4), rand, false, true);
            world.m_7731_(origin.m_6630_(4).m_122030_(2).m_122020_(2), this.POISMOSS_EUMUS.get(), 2);
            this.setPoiseLog(world, origin.m_6630_(4).m_122020_(3).m_122025_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122020_(4).m_122025_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122020_(3).m_122025_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122020_(2).m_122025_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122020_(2).m_122025_(4), rand, false, true);
            world.m_7731_(origin.m_6630_(4).m_122020_(2).m_122025_(2), this.POISMOSS_EUMUS.get(), 2);
            this.setPoiseLog(world, origin.m_6630_(4).m_122025_(3).m_122013_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122025_(4).m_122013_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122025_(3).m_122013_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122025_(2).m_122013_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(4).m_122025_(2).m_122013_(4), rand, false, true);
            world.m_7731_(origin.m_6630_(4).m_122025_(2).m_122013_(2), this.POISMOSS_EUMUS.get(), 2);
            for (x = origin.m_123341_() - 1; x <= origin.m_123341_() + 1; ++x) {
                for (z = origin.m_123343_() - 3; z <= origin.m_123343_() + 3; ++z) {
                    world.m_7731_(new BlockPos(x, origin.m_6630_(4).m_123342_(), z), this.POISMOSS_EUMUS.get(), 2);
                }
            }
            for (x = origin.m_123341_() - 3; x <= origin.m_123341_() + 3; ++x) {
                for (z = origin.m_123343_() - 1; z <= origin.m_123343_() + 1; ++z) {
                    world.m_7731_(new BlockPos(x, origin.m_6630_(4).m_123342_(), z), this.POISMOSS_EUMUS.get(), 2);
                }
            }
            this.placeInnerDomeFeatures(world, rand, origin.m_6630_(4));
            this.setPoiseLog(world, origin.m_6630_(5).m_122013_(5), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122013_(5).m_122029_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122013_(5).m_122030_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122013_(5).m_122024_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122013_(5).m_122025_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122030_(5), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122030_(5).m_122012_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122030_(5).m_122013_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122030_(5).m_122019_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122030_(5).m_122020_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122020_(5), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122020_(5).m_122024_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122020_(5).m_122025_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122020_(5).m_122029_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122020_(5).m_122030_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122025_(5), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122025_(5).m_122019_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122025_(5).m_122020_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122025_(5).m_122012_(), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122025_(5).m_122013_(2), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122013_(4).m_122025_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122013_(3).m_122025_(4), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122013_(4).m_122030_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122013_(3).m_122030_(4), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122020_(4).m_122025_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122020_(3).m_122025_(4), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122020_(4).m_122030_(3), rand, false, true);
            this.setPoiseLog(world, origin.m_6630_(5).m_122020_(3).m_122030_(4), rand, false, true);
            int[] sideRandValues = new int[]{rand.m_188503_(3) + 1, rand.m_188503_(3) + 1, rand.m_188503_(3) + 1, rand.m_188503_(3) + 1};
            for (yn2 = 1; yn2 <= sideRandValues[0]; ++yn2) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(6).m_6630_(5).m_6630_(yn2), rand, false, true);
                if (yn2 != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(6).m_122024_().m_6630_(5).m_6630_(yn2), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(6).m_122029_().m_6630_(5).m_6630_(yn2), rand, false, true);
            }
            for (yn2 = 1; yn2 <= sideRandValues[1]; ++yn2) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(6).m_6630_(5).m_6630_(yn2), rand, false, true);
                if (yn2 != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(6).m_122012_().m_6630_(5).m_6630_(yn2), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(6).m_122019_().m_6630_(5).m_6630_(yn2), rand, false, true);
            }
            for (yn2 = 1; yn2 <= sideRandValues[2]; ++yn2) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(6).m_6630_(5).m_6630_(yn2), rand, false, true);
                if (yn2 != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(6).m_122024_().m_6630_(5).m_6630_(yn2), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(6).m_122029_().m_6630_(5).m_6630_(yn2), rand, false, true);
            }
            for (yn2 = 1; yn2 <= sideRandValues[3]; ++yn2) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(6).m_6630_(5).m_6630_(yn2), rand, false, true);
                if (yn2 != 1 || !(rand.m_188501_() <= 0.25f)) continue;
                if (rand.m_188499_()) {
                    this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(6).m_122019_().m_6630_(5).m_6630_(yn2), rand, false, true);
                    continue;
                }
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(6).m_122012_().m_6630_(5).m_6630_(yn2), rand, false, true);
            }
            int[] cornerRandValues = new int[]{(double)rand.m_188501_() <= 0.75 ? rand.m_188503_(3) + 1 : 0, (double)rand.m_188501_() <= 0.75 ? rand.m_188503_(3) + 1 : 0, (double)rand.m_188501_() <= 0.75 ? rand.m_188503_(3) + 1 : 0, (double)rand.m_188501_() <= 0.75 ? rand.m_188503_(3) + 1 : 0};
            for (yn = 1; yn <= cornerRandValues[0]; ++yn) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122013_(4).m_122030_(4).m_6630_(5).m_6630_(yn), rand, false, true);
            }
            for (yn = 1; yn <= cornerRandValues[1]; ++yn) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122030_(4).m_122020_(4).m_6630_(5).m_6630_(yn), rand, false, true);
            }
            for (yn = 1; yn <= cornerRandValues[2]; ++yn) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122020_(4).m_122025_(4).m_6630_(5).m_6630_(yn), rand, false, true);
            }
            for (yn = 1; yn <= cornerRandValues[3]; ++yn) {
                this.setPoiseLog(world, pos.m_6630_(arrivedPos).m_122025_(4).m_122013_(4).m_6630_(5).m_6630_(yn), rand, false, true);
            }
            this.addTreeDomeTop(world, pos, rand, arrivedPos, 2);
        }
    }

    private void addTreeDomeTop(LevelAccessor world, BlockPos pos, RandomSource rand, int arrivedPos, int size) {
        BlockPos origin = pos.m_6630_(arrivedPos);
        if (size == 0) {
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(3).m_6630_(2).m_122024_().m_123341_(), origin.m_122013_(3).m_6630_(2).m_122024_().m_123342_(), origin.m_122013_(3).m_6630_(2).m_122029_().m_123343_(), origin.m_122013_(3).m_6630_(2).m_122029_().m_123341_(), origin.m_122013_(3).m_6630_(6).m_122029_().m_123342_(), origin.m_122013_(3).m_6630_(2).m_122029_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(3).m_6630_(3).m_122025_(2).m_123341_(), origin.m_122013_(3).m_6630_(3).m_122025_(2).m_123342_(), origin.m_122013_(3).m_6630_(3).m_122025_(2).m_123343_(), origin.m_122013_(3).m_6630_(3).m_122025_(2).m_123341_(), origin.m_122013_(3).m_6630_(5).m_122025_(2).m_123342_(), origin.m_122013_(3).m_6630_(3).m_122025_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(3).m_6630_(3).m_122030_(2).m_123341_(), origin.m_122013_(3).m_6630_(3).m_122030_(2).m_123342_(), origin.m_122013_(3).m_6630_(3).m_122030_(2).m_123343_(), origin.m_122013_(3).m_6630_(3).m_122030_(2).m_123341_(), origin.m_122013_(3).m_6630_(5).m_122030_(2).m_123342_(), origin.m_122013_(3).m_6630_(3).m_122030_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(3).m_6630_(2).m_122012_().m_123341_(), origin.m_122030_(3).m_6630_(2).m_122012_().m_123342_(), origin.m_122030_(3).m_6630_(2).m_122012_().m_123343_(), origin.m_122030_(3).m_6630_(2).m_122019_().m_123341_(), origin.m_122030_(3).m_6630_(6).m_122019_().m_123342_(), origin.m_122030_(3).m_6630_(2).m_122019_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(3).m_6630_(3).m_122013_(2).m_123341_(), origin.m_122030_(3).m_6630_(3).m_122013_(2).m_123342_(), origin.m_122030_(3).m_6630_(3).m_122013_(2).m_123343_(), origin.m_122030_(3).m_6630_(3).m_122013_(2).m_123341_(), origin.m_122030_(3).m_6630_(5).m_122013_(2).m_123342_(), origin.m_122030_(3).m_6630_(3).m_122013_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(3).m_6630_(3).m_122020_(2).m_123341_(), origin.m_122030_(3).m_6630_(3).m_122020_(2).m_123342_(), origin.m_122030_(3).m_6630_(3).m_122020_(2).m_123343_(), origin.m_122030_(3).m_6630_(3).m_122020_(2).m_123341_(), origin.m_122030_(3).m_6630_(5).m_122020_(2).m_123342_(), origin.m_122030_(3).m_6630_(3).m_122020_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(3).m_6630_(2).m_122024_().m_123341_(), origin.m_122020_(3).m_6630_(2).m_122024_().m_123342_(), origin.m_122020_(3).m_6630_(2).m_122024_().m_123343_(), origin.m_122020_(3).m_6630_(2).m_122029_().m_123341_(), origin.m_122020_(3).m_6630_(6).m_122029_().m_123342_(), origin.m_122020_(3).m_6630_(2).m_122029_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(3).m_6630_(3).m_122025_(2).m_123341_(), origin.m_122020_(3).m_6630_(3).m_122025_(2).m_123342_(), origin.m_122020_(3).m_6630_(3).m_122025_(2).m_123343_(), origin.m_122020_(3).m_6630_(3).m_122025_(2).m_123341_(), origin.m_122020_(3).m_6630_(5).m_122025_(2).m_123342_(), origin.m_122020_(3).m_6630_(3).m_122025_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(3).m_6630_(3).m_122030_(2).m_123341_(), origin.m_122020_(3).m_6630_(3).m_122030_(2).m_123342_(), origin.m_122020_(3).m_6630_(3).m_122030_(2).m_123343_(), origin.m_122020_(3).m_6630_(3).m_122030_(2).m_123341_(), origin.m_122020_(3).m_6630_(5).m_122030_(2).m_123342_(), origin.m_122020_(3).m_6630_(3).m_122030_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(3).m_6630_(2).m_122012_().m_123341_(), origin.m_122025_(3).m_6630_(2).m_122012_().m_123342_(), origin.m_122025_(3).m_6630_(2).m_122012_().m_123343_(), origin.m_122025_(3).m_6630_(2).m_122019_().m_123341_(), origin.m_122025_(3).m_6630_(6).m_122019_().m_123342_(), origin.m_122025_(3).m_6630_(2).m_122019_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(3).m_6630_(3).m_122013_(2).m_123341_(), origin.m_122025_(3).m_6630_(3).m_122013_(2).m_123342_(), origin.m_122025_(3).m_6630_(3).m_122013_(2).m_123343_(), origin.m_122025_(3).m_6630_(3).m_122013_(2).m_123341_(), origin.m_122025_(3).m_6630_(5).m_122013_(2).m_123342_(), origin.m_122025_(3).m_6630_(3).m_122013_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(3).m_6630_(3).m_122020_(2).m_123341_(), origin.m_122025_(3).m_6630_(3).m_122020_(2).m_123342_(), origin.m_122025_(3).m_6630_(3).m_122020_(2).m_123343_(), origin.m_122025_(3).m_6630_(3).m_122020_(2).m_123341_(), origin.m_122025_(3).m_6630_(5).m_122020_(2).m_123342_(), origin.m_122025_(3).m_6630_(3).m_122020_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            this.setPoiseCluster(world, origin.m_122013_(2).m_6630_(2).m_122025_(2));
            this.setPoiseCluster(world, origin.m_122013_(2).m_6630_(2).m_122030_(2));
            this.setPoiseCluster(world, origin.m_122013_(2).m_6630_(6).m_122025_(2));
            this.setPoiseCluster(world, origin.m_122013_(2).m_6630_(6).m_122030_(2));
            this.setPoiseCluster(world, origin.m_122030_(2).m_6630_(2).m_122013_(2));
            this.setPoiseCluster(world, origin.m_122030_(2).m_6630_(2).m_122020_(2));
            this.setPoiseCluster(world, origin.m_122030_(2).m_6630_(6).m_122013_(2));
            this.setPoiseCluster(world, origin.m_122030_(2).m_6630_(6).m_122020_(2));
            this.setPoiseCluster(world, origin.m_122020_(2).m_6630_(2).m_122030_(2));
            this.setPoiseCluster(world, origin.m_122020_(2).m_6630_(2).m_122025_(2));
            this.setPoiseCluster(world, origin.m_122020_(2).m_6630_(6).m_122030_(2));
            this.setPoiseCluster(world, origin.m_122020_(2).m_6630_(6).m_122025_(2));
            this.setPoiseCluster(world, origin.m_122025_(2).m_6630_(2).m_122020_(2));
            this.setPoiseCluster(world, origin.m_122025_(2).m_6630_(2).m_122013_(2));
            this.setPoiseCluster(world, origin.m_122025_(2).m_6630_(6).m_122020_(2));
            this.setPoiseCluster(world, origin.m_122025_(2).m_6630_(6).m_122013_(2));
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122012_().m_122025_(2).m_6630_(7).m_123341_(), origin.m_122012_().m_122025_(2).m_6630_(7).m_123342_(), origin.m_122012_().m_122025_(2).m_6630_(7).m_123343_(), origin.m_122019_().m_122030_(2).m_6630_(7).m_123341_(), origin.m_122019_().m_122030_(2).m_6630_(7).m_123342_(), origin.m_122019_().m_122030_(2).m_6630_(7).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            this.setPoiseCluster(world, origin.m_122013_(2).m_122024_().m_6630_(7));
            this.setPoiseCluster(world, origin.m_122013_(2).m_6630_(7));
            this.setPoiseCluster(world, origin.m_122013_(2).m_122029_().m_6630_(7));
            this.setPoiseCluster(world, origin.m_122020_(2).m_122024_().m_6630_(7));
            this.setPoiseCluster(world, origin.m_122020_(2).m_6630_(7));
            this.setPoiseCluster(world, origin.m_122020_(2).m_122029_().m_6630_(7));
        } else if (size == 1) {
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(4).m_6630_(3).m_122024_().m_123341_(), origin.m_122013_(4).m_6630_(3).m_122024_().m_123342_(), origin.m_122013_(4).m_6630_(3).m_122029_().m_123343_(), origin.m_122013_(4).m_6630_(3).m_122029_().m_123341_(), origin.m_122013_(4).m_6630_(7).m_122029_().m_123342_(), origin.m_122013_(4).m_6630_(3).m_122029_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(4).m_6630_(4).m_122025_(2).m_123341_(), origin.m_122013_(4).m_6630_(4).m_122025_(2).m_123342_(), origin.m_122013_(4).m_6630_(4).m_122025_(2).m_123343_(), origin.m_122013_(4).m_6630_(4).m_122025_(2).m_123341_(), origin.m_122013_(4).m_6630_(6).m_122025_(2).m_123342_(), origin.m_122013_(4).m_6630_(4).m_122025_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(4).m_6630_(4).m_122030_(2).m_123341_(), origin.m_122013_(4).m_6630_(4).m_122030_(2).m_123342_(), origin.m_122013_(4).m_6630_(4).m_122030_(2).m_123343_(), origin.m_122013_(4).m_6630_(4).m_122030_(2).m_123341_(), origin.m_122013_(4).m_6630_(6).m_122030_(2).m_123342_(), origin.m_122013_(4).m_6630_(4).m_122030_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(4).m_6630_(3).m_122012_().m_123341_(), origin.m_122030_(4).m_6630_(3).m_122012_().m_123342_(), origin.m_122030_(4).m_6630_(3).m_122012_().m_123343_(), origin.m_122030_(4).m_6630_(3).m_122019_().m_123341_(), origin.m_122030_(4).m_6630_(7).m_122019_().m_123342_(), origin.m_122030_(4).m_6630_(3).m_122019_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(4).m_6630_(4).m_122013_(2).m_123341_(), origin.m_122030_(4).m_6630_(4).m_122013_(2).m_123342_(), origin.m_122030_(4).m_6630_(4).m_122013_(2).m_123343_(), origin.m_122030_(4).m_6630_(4).m_122013_(2).m_123341_(), origin.m_122030_(4).m_6630_(6).m_122013_(2).m_123342_(), origin.m_122030_(4).m_6630_(4).m_122013_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(4).m_6630_(4).m_122020_(2).m_123341_(), origin.m_122030_(4).m_6630_(4).m_122020_(2).m_123342_(), origin.m_122030_(4).m_6630_(4).m_122020_(2).m_123343_(), origin.m_122030_(4).m_6630_(4).m_122020_(2).m_123341_(), origin.m_122030_(4).m_6630_(6).m_122020_(2).m_123342_(), origin.m_122030_(4).m_6630_(4).m_122020_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(4).m_6630_(3).m_122024_().m_123341_(), origin.m_122020_(4).m_6630_(3).m_122024_().m_123342_(), origin.m_122020_(4).m_6630_(3).m_122024_().m_123343_(), origin.m_122020_(4).m_6630_(3).m_122029_().m_123341_(), origin.m_122020_(4).m_6630_(7).m_122029_().m_123342_(), origin.m_122020_(4).m_6630_(3).m_122029_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(4).m_6630_(4).m_122025_(2).m_123341_(), origin.m_122020_(4).m_6630_(4).m_122025_(2).m_123342_(), origin.m_122020_(4).m_6630_(4).m_122025_(2).m_123343_(), origin.m_122020_(4).m_6630_(4).m_122025_(2).m_123341_(), origin.m_122020_(4).m_6630_(6).m_122025_(2).m_123342_(), origin.m_122020_(4).m_6630_(4).m_122025_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(4).m_6630_(4).m_122030_(2).m_123341_(), origin.m_122020_(4).m_6630_(4).m_122030_(2).m_123342_(), origin.m_122020_(4).m_6630_(4).m_122030_(2).m_123343_(), origin.m_122020_(4).m_6630_(4).m_122030_(2).m_123341_(), origin.m_122020_(4).m_6630_(6).m_122030_(2).m_123342_(), origin.m_122020_(4).m_6630_(4).m_122030_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(4).m_6630_(3).m_122012_().m_123341_(), origin.m_122025_(4).m_6630_(3).m_122012_().m_123342_(), origin.m_122025_(4).m_6630_(3).m_122012_().m_123343_(), origin.m_122025_(4).m_6630_(3).m_122019_().m_123341_(), origin.m_122025_(4).m_6630_(7).m_122019_().m_123342_(), origin.m_122025_(4).m_6630_(3).m_122019_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(4).m_6630_(4).m_122013_(2).m_123341_(), origin.m_122025_(4).m_6630_(4).m_122013_(2).m_123342_(), origin.m_122025_(4).m_6630_(4).m_122013_(2).m_123343_(), origin.m_122025_(4).m_6630_(4).m_122013_(2).m_123341_(), origin.m_122025_(4).m_6630_(6).m_122013_(2).m_123342_(), origin.m_122025_(4).m_6630_(4).m_122013_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(4).m_6630_(4).m_122020_(2).m_123341_(), origin.m_122025_(4).m_6630_(4).m_122020_(2).m_123342_(), origin.m_122025_(4).m_6630_(4).m_122020_(2).m_123343_(), origin.m_122025_(4).m_6630_(4).m_122020_(2).m_123341_(), origin.m_122025_(4).m_6630_(6).m_122020_(2).m_123342_(), origin.m_122025_(4).m_6630_(4).m_122020_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            this.setPoiseCluster(world, origin.m_6630_(3).m_122013_(3).m_122025_(2));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122013_(3).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122013_(2).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(4).m_122013_(3).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(5).m_122013_(3).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(6).m_122013_(3).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122013_(3).m_122025_(2));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122013_(3).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122013_(2).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122030_(3).m_122013_(2));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122030_(3).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122030_(2).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(4).m_122030_(3).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(5).m_122030_(3).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(6).m_122030_(3).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122030_(3).m_122013_(2));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122030_(3).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122030_(2).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122020_(3).m_122030_(2));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122020_(3).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122020_(2).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(4).m_122020_(3).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(5).m_122020_(3).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(6).m_122020_(3).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122020_(3).m_122030_(2));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122020_(3).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122020_(2).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122025_(3).m_122020_(2));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122025_(3).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(3).m_122025_(2).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(4).m_122025_(3).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(5).m_122025_(3).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(6).m_122025_(3).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122025_(3).m_122020_(2));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122025_(3).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122025_(2).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122025_(2).m_122020_(2));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122020_(2).m_122030_(2));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122030_(2).m_122013_(2));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122013_(2).m_122025_(2));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122013_(3).m_122024_());
            this.setPoiseCluster(world, origin.m_6630_(8).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122013_(3).m_122029_());
            this.setPoiseCluster(world, origin.m_6630_(8).m_122030_(3).m_122012_());
            this.setPoiseCluster(world, origin.m_6630_(8).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122030_(3).m_122019_());
            this.setPoiseCluster(world, origin.m_6630_(8).m_122020_(3).m_122029_());
            this.setPoiseCluster(world, origin.m_6630_(8).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122020_(3).m_122024_());
            this.setPoiseCluster(world, origin.m_6630_(8).m_122025_(3).m_122019_());
            this.setPoiseCluster(world, origin.m_6630_(8).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122025_(3).m_122012_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122012_().m_122025_(2).m_6630_(9).m_123341_(), origin.m_122012_().m_122025_(2).m_6630_(9).m_123342_(), origin.m_122012_().m_122025_(2).m_6630_(9).m_123343_(), origin.m_122019_().m_122030_(2).m_6630_(9).m_123341_(), origin.m_122019_().m_122030_(2).m_6630_(9).m_123342_(), origin.m_122019_().m_122030_(2).m_6630_(9).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            this.setPoiseCluster(world, origin.m_122013_(2).m_122024_().m_6630_(9));
            this.setPoiseCluster(world, origin.m_122013_(2).m_6630_(9));
            this.setPoiseCluster(world, origin.m_122013_(2).m_122029_().m_6630_(9));
            this.setPoiseCluster(world, origin.m_122020_(2).m_122024_().m_6630_(9));
            this.setPoiseCluster(world, origin.m_122020_(2).m_6630_(9));
            this.setPoiseCluster(world, origin.m_122020_(2).m_122029_().m_6630_(9));
        } else {
            int z;
            int x;
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(6).m_6630_(6).m_122024_().m_123341_(), origin.m_122013_(6).m_6630_(6).m_122024_().m_123342_(), origin.m_122013_(6).m_6630_(6).m_122024_().m_123343_(), origin.m_122013_(6).m_6630_(8).m_122029_().m_123341_(), origin.m_122013_(6).m_6630_(8).m_122024_().m_123342_(), origin.m_122013_(6).m_6630_(8).m_122024_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(5).m_6630_(6).m_122025_(3).m_123341_(), origin.m_122013_(5).m_6630_(6).m_122025_(3).m_123342_(), origin.m_122013_(5).m_6630_(6).m_122025_(3).m_123343_(), origin.m_122013_(5).m_6630_(8).m_122025_(2).m_123341_(), origin.m_122013_(5).m_6630_(8).m_122025_(2).m_123342_(), origin.m_122013_(5).m_6630_(8).m_122025_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(5).m_6630_(6).m_122030_(2).m_123341_(), origin.m_122013_(5).m_6630_(6).m_122030_(2).m_123342_(), origin.m_122013_(5).m_6630_(6).m_122030_(2).m_123343_(), origin.m_122013_(5).m_6630_(8).m_122030_(3).m_123341_(), origin.m_122013_(5).m_6630_(8).m_122030_(3).m_123342_(), origin.m_122013_(5).m_6630_(8).m_122030_(3).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(5).m_6630_(9).m_122025_(2).m_123341_(), origin.m_122013_(5).m_6630_(9).m_122025_(2).m_123342_(), origin.m_122013_(5).m_6630_(9).m_122025_(2).m_123343_(), origin.m_122013_(5).m_6630_(9).m_122030_(2).m_123341_(), origin.m_122013_(5).m_6630_(9).m_122030_(2).m_123342_(), origin.m_122013_(5).m_6630_(9).m_122030_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122013_(5).m_6630_(10).m_122024_().m_123341_(), origin.m_122013_(5).m_6630_(10).m_122024_().m_123342_(), origin.m_122013_(5).m_6630_(10).m_122024_().m_123343_(), origin.m_122013_(5).m_6630_(10).m_122029_().m_123341_(), origin.m_122013_(5).m_6630_(10).m_122029_().m_123342_(), origin.m_122013_(5).m_6630_(10).m_122029_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(6).m_6630_(6).m_122012_().m_123341_(), origin.m_122030_(6).m_6630_(6).m_122012_().m_123342_(), origin.m_122030_(6).m_6630_(6).m_122012_().m_123343_(), origin.m_122030_(6).m_6630_(8).m_122019_().m_123341_(), origin.m_122030_(6).m_6630_(8).m_122019_().m_123342_(), origin.m_122030_(6).m_6630_(8).m_122019_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(5).m_6630_(6).m_122013_(3).m_123341_(), origin.m_122030_(5).m_6630_(6).m_122013_(3).m_123342_(), origin.m_122030_(5).m_6630_(6).m_122013_(3).m_123343_(), origin.m_122030_(5).m_6630_(8).m_122013_(2).m_123341_(), origin.m_122030_(5).m_6630_(8).m_122013_(2).m_123342_(), origin.m_122030_(5).m_6630_(8).m_122013_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(5).m_6630_(6).m_122020_(2).m_123341_(), origin.m_122030_(5).m_6630_(6).m_122020_(2).m_123342_(), origin.m_122030_(5).m_6630_(6).m_122020_(2).m_123343_(), origin.m_122030_(5).m_6630_(8).m_122020_(3).m_123341_(), origin.m_122030_(5).m_6630_(8).m_122020_(3).m_123342_(), origin.m_122030_(5).m_6630_(8).m_122020_(3).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(5).m_6630_(9).m_122020_(2).m_123341_(), origin.m_122030_(5).m_6630_(9).m_122013_(2).m_123342_(), origin.m_122030_(5).m_6630_(9).m_122013_(2).m_123343_(), origin.m_122030_(5).m_6630_(9).m_122020_(2).m_123341_(), origin.m_122030_(5).m_6630_(9).m_122020_(2).m_123342_(), origin.m_122030_(5).m_6630_(9).m_122020_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122030_(5).m_6630_(10).m_122012_().m_123341_(), origin.m_122030_(5).m_6630_(10).m_122012_().m_123342_(), origin.m_122030_(5).m_6630_(10).m_122012_().m_123343_(), origin.m_122030_(5).m_6630_(10).m_122019_().m_123341_(), origin.m_122030_(5).m_6630_(10).m_122019_().m_123342_(), origin.m_122030_(5).m_6630_(10).m_122019_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(6).m_6630_(6).m_122024_().m_123341_(), origin.m_122020_(6).m_6630_(6).m_122024_().m_123342_(), origin.m_122020_(6).m_6630_(6).m_122024_().m_123343_(), origin.m_122020_(6).m_6630_(8).m_122029_().m_123341_(), origin.m_122020_(6).m_6630_(8).m_122029_().m_123342_(), origin.m_122020_(6).m_6630_(8).m_122029_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(5).m_6630_(6).m_122025_(3).m_123341_(), origin.m_122020_(5).m_6630_(6).m_122025_(3).m_123342_(), origin.m_122020_(5).m_6630_(6).m_122025_(3).m_123343_(), origin.m_122020_(5).m_6630_(8).m_122025_(2).m_123341_(), origin.m_122020_(5).m_6630_(8).m_122013_(2).m_123342_(), origin.m_122020_(5).m_6630_(8).m_122025_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(5).m_6630_(6).m_122030_(2).m_123341_(), origin.m_122020_(5).m_6630_(6).m_122030_(2).m_123342_(), origin.m_122020_(5).m_6630_(6).m_122030_(2).m_123343_(), origin.m_122020_(5).m_6630_(8).m_122030_(3).m_123341_(), origin.m_122020_(5).m_6630_(8).m_122030_(3).m_123342_(), origin.m_122020_(5).m_6630_(8).m_122030_(3).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(5).m_6630_(9).m_122025_(2).m_123341_(), origin.m_122020_(5).m_6630_(9).m_122025_(2).m_123342_(), origin.m_122020_(5).m_6630_(9).m_122025_(2).m_123343_(), origin.m_122020_(5).m_6630_(9).m_122030_(2).m_123341_(), origin.m_122020_(5).m_6630_(9).m_122030_(2).m_123342_(), origin.m_122020_(5).m_6630_(9).m_122030_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122020_(5).m_6630_(10).m_122024_().m_123341_(), origin.m_122020_(5).m_6630_(10).m_122024_().m_123342_(), origin.m_122020_(5).m_6630_(10).m_122024_().m_123343_(), origin.m_122020_(5).m_6630_(10).m_122029_().m_123341_(), origin.m_122020_(5).m_6630_(10).m_122029_().m_123342_(), origin.m_122020_(5).m_6630_(10).m_122029_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(6).m_6630_(6).m_122012_().m_123341_(), origin.m_122025_(6).m_6630_(6).m_122012_().m_123342_(), origin.m_122025_(6).m_6630_(6).m_122012_().m_123343_(), origin.m_122025_(6).m_6630_(8).m_122019_().m_123341_(), origin.m_122025_(6).m_6630_(8).m_122019_().m_123342_(), origin.m_122025_(6).m_6630_(8).m_122019_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(5).m_6630_(6).m_122013_(3).m_123341_(), origin.m_122025_(5).m_6630_(6).m_122013_(3).m_123342_(), origin.m_122025_(5).m_6630_(6).m_122013_(3).m_123343_(), origin.m_122025_(5).m_6630_(8).m_122013_(2).m_123341_(), origin.m_122025_(5).m_6630_(8).m_122013_(2).m_123342_(), origin.m_122025_(5).m_6630_(8).m_122013_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(5).m_6630_(6).m_122020_(2).m_123341_(), origin.m_122025_(5).m_6630_(6).m_122020_(2).m_123342_(), origin.m_122025_(5).m_6630_(6).m_122020_(2).m_123343_(), origin.m_122025_(5).m_6630_(8).m_122020_(3).m_123341_(), origin.m_122025_(5).m_6630_(8).m_122020_(3).m_123342_(), origin.m_122025_(5).m_6630_(8).m_122020_(3).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(5).m_6630_(9).m_122013_(2).m_123341_(), origin.m_122025_(5).m_6630_(9).m_122013_(2).m_123342_(), origin.m_122025_(5).m_6630_(9).m_122013_(2).m_123343_(), origin.m_122025_(5).m_6630_(9).m_122020_(2).m_123341_(), origin.m_122025_(5).m_6630_(9).m_122020_(2).m_123342_(), origin.m_122025_(5).m_6630_(9).m_122020_(2).m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            GenerationUtils.fillAreaWithBlockCube(world, origin.m_122025_(5).m_6630_(10).m_122012_().m_123341_(), origin.m_122025_(5).m_6630_(10).m_122012_().m_123342_(), origin.m_122025_(5).m_6630_(10).m_122012_().m_123343_(), origin.m_122025_(5).m_6630_(10).m_122019_().m_123341_(), origin.m_122025_(5).m_6630_(10).m_122019_().m_123342_(), origin.m_122025_(5).m_6630_(10).m_122019_().m_123343_(), ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_());
            this.setPoiseCluster(world, origin.m_6630_(6).m_122013_(4).m_122025_(4));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122013_(4).m_122025_(4));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122013_(4).m_122025_(4));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122013_(4).m_122025_(4));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122013_(4).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122013_(4).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122013_(4).m_122025_(2));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122013_(3).m_122025_(4));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122013_(3).m_122025_(4));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122013_(2).m_122025_(4));
            this.setPoiseCluster(world, origin.m_6630_(6).m_122030_(4).m_122013_(4));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122030_(4).m_122013_(4));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122030_(4).m_122013_(4));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122030_(4).m_122013_(4));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122030_(4).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122030_(4).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122030_(4).m_122013_(2));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122030_(3).m_122013_(4));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122030_(3).m_122013_(4));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122030_(2).m_122013_(4));
            this.setPoiseCluster(world, origin.m_6630_(6).m_122020_(4).m_122030_(4));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122020_(4).m_122030_(4));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122020_(4).m_122030_(4));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122020_(4).m_122030_(4));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122020_(4).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122020_(4).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122020_(4).m_122030_(2));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122020_(3).m_122030_(4));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122020_(3).m_122030_(4));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122020_(2).m_122030_(4));
            this.setPoiseCluster(world, origin.m_6630_(6).m_122025_(4).m_122020_(4));
            this.setPoiseCluster(world, origin.m_6630_(7).m_122025_(4).m_122020_(4));
            this.setPoiseCluster(world, origin.m_6630_(8).m_122025_(4).m_122020_(4));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122025_(4).m_122020_(4));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122025_(4).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122025_(4).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122025_(4).m_122020_(2));
            this.setPoiseCluster(world, origin.m_6630_(9).m_122025_(3).m_122020_(4));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122025_(3).m_122020_(4));
            this.setPoiseCluster(world, origin.m_6630_(10).m_122025_(2).m_122020_(4));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122013_(3).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122013_(2).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122013_(2).m_122025_(4));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122013_(3).m_122025_(2));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122013_(4).m_122025_(2));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122013_(4).m_122024_());
            this.setPoiseCluster(world, origin.m_6630_(11).m_122013_(4));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122013_(4).m_122029_());
            this.setPoiseCluster(world, origin.m_6630_(11).m_122030_(3).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122030_(2).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122030_(2).m_122013_(4));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122030_(3).m_122013_(2));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122030_(4).m_122013_(2));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122030_(4).m_122012_());
            this.setPoiseCluster(world, origin.m_6630_(11).m_122030_(4));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122030_(4).m_122019_());
            this.setPoiseCluster(world, origin.m_6630_(11).m_122020_(3).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122020_(2).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122020_(2).m_122030_(4));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122020_(3).m_122030_(2));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122020_(4).m_122030_(2));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122020_(4).m_122029_());
            this.setPoiseCluster(world, origin.m_6630_(11).m_122020_(4));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122020_(4).m_122024_());
            this.setPoiseCluster(world, origin.m_6630_(11).m_122025_(3).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122025_(2).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122025_(2).m_122020_(4));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122025_(3).m_122020_(2));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122025_(4).m_122020_(2));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122025_(4).m_122019_());
            this.setPoiseCluster(world, origin.m_6630_(11).m_122025_(4));
            this.setPoiseCluster(world, origin.m_6630_(11).m_122025_(4).m_122012_());
            this.setPoiseCluster(world, origin.m_6630_(12).m_122013_(3).m_122024_());
            this.setPoiseCluster(world, origin.m_6630_(12).m_122013_(3));
            this.setPoiseCluster(world, origin.m_6630_(12).m_122013_(3).m_122029_());
            this.setPoiseCluster(world, origin.m_6630_(12).m_122030_(3).m_122012_());
            this.setPoiseCluster(world, origin.m_6630_(12).m_122030_(3));
            this.setPoiseCluster(world, origin.m_6630_(12).m_122030_(3).m_122019_());
            this.setPoiseCluster(world, origin.m_6630_(12).m_122020_(3).m_122029_());
            this.setPoiseCluster(world, origin.m_6630_(12).m_122020_(3));
            this.setPoiseCluster(world, origin.m_6630_(12).m_122020_(3).m_122024_());
            this.setPoiseCluster(world, origin.m_6630_(12).m_122025_(3).m_122012_());
            this.setPoiseCluster(world, origin.m_6630_(12).m_122025_(3));
            this.setPoiseCluster(world, origin.m_6630_(12).m_122025_(3).m_122019_());
            for (x = origin.m_123341_() - 1; x <= origin.m_123341_() + 1; ++x) {
                for (z = origin.m_123343_() - 1; z <= origin.m_123343_() + 1; ++z) {
                    this.setPoiseCluster(world, new BlockPos(x, origin.m_6630_(13).m_123342_(), z));
                }
            }
            for (x = origin.m_123341_() - 2; x <= origin.m_123341_() + 2; ++x) {
                for (z = origin.m_123343_() - 2; z <= origin.m_123343_() + 2; ++z) {
                    if (x != origin.m_123341_() + 2 && z != origin.m_123343_() + 2 && x != origin.m_123341_() - 2 && z != origin.m_123343_() - 2) continue;
                    this.setPoiseCluster(world, new BlockPos(x, origin.m_6630_(12).m_123342_(), z));
                }
            }
        }
    }

    private void tryToBuildBranch(LevelAccessor world, BlockPos pos, RandomSource rand, int treeHeight) {
        int[] branchLengths = new int[]{rand.m_188503_(3) + 1, rand.m_188503_(3) + 1, 1, 1};
        int[] branchHeights = new int[]{1, 1, rand.m_188503_(4) + 1, rand.m_188503_(4) + 4};
        Direction randDir = Direction.m_122376_((int)(rand.m_188503_(4) + 2));
        int pickedHeight = rand.m_188503_((int)Math.ceil((float)treeHeight / 3.0f)) + 6;
        BlockPos pickedPosition = pos.m_121945_(randDir).m_6630_(pickedHeight);
        if (world.m_8055_(pickedPosition).m_60767_().m_76336_() && treeHeight > 15 && this.isViableBranchArea(world, pickedPosition, randDir, 2 + branchLengths[0] + branchLengths[1], pickedPosition.m_5484_(randDir, branchLengths[0] + branchLengths[1] + branchLengths[2] + branchLengths[3]).m_6630_(3 + branchHeights[2]).m_6630_(branchHeights[3]))) {
            int y;
            int dir;
            this.setPoiseLog(world, pickedPosition, rand, false, true);
            this.setPoiseLog(world, pickedPosition.m_7494_(), rand, false, true);
            this.setPoiseLog(world, pickedPosition.m_7495_(), rand, false, true);
            for (dir = 0; dir <= branchLengths[0]; ++dir) {
                this.setPoiseLogWithDirection(world, pickedPosition.m_5484_(randDir, dir), rand, randDir);
                if (dir != branchLengths[0]) continue;
                this.setPoiseLog(world, pickedPosition.m_5484_(randDir, dir).m_7494_(), rand, false, true);
            }
            for (dir = 1; dir <= branchLengths[1]; ++dir) {
                this.setPoiseLogWithDirection(world, pickedPosition.m_5484_(randDir, dir + branchLengths[0]).m_7494_(), rand, randDir);
                if (dir != branchLengths[1]) continue;
                this.setPoiseLog(world, pickedPosition.m_5484_(randDir, branchLengths[0] + branchLengths[1]).m_6630_(2), rand, false, true);
            }
            for (dir = 1; dir <= branchLengths[2]; ++dir) {
                this.setPoiseLogWithDirection(world, pickedPosition.m_5484_(randDir, dir + branchLengths[0] + branchLengths[1]).m_6630_(2), rand, randDir);
                if (dir != branchLengths[2]) continue;
                for (y = 0; y < branchHeights[2]; ++y) {
                    this.setPoiseLog(world, pickedPosition.m_5484_(randDir, branchLengths[0] + branchLengths[1] + branchLengths[2]).m_6630_(3).m_6630_(y), rand, false, false);
                }
            }
            for (dir = 1; dir <= branchLengths[3]; ++dir) {
                this.setPoiseLogWithDirection(world, pickedPosition.m_5484_(randDir, dir + branchLengths[0] + branchLengths[1] + branchLengths[2]).m_6630_(2 + branchHeights[2]), rand, randDir);
                if (dir != branchLengths[3]) continue;
                for (y = 0; y < branchHeights[3]; ++y) {
                    this.setPoiseLog(world, pickedPosition.m_5484_(randDir, branchLengths[0] + branchLengths[1] + branchLengths[2] + branchLengths[3]).m_6630_(3 + branchHeights[2]).m_6630_(y), rand, false, false);
                }
            }
            this.buildTreeTop(world, pickedPosition.m_5484_(randDir, branchLengths[0] + branchLengths[1] + branchLengths[2] + branchLengths[3]).m_6630_(3 + branchHeights[2]).m_6630_(branchHeights[3]), rand, 0, 0);
        }
    }

    private void buildSideBubble(LevelAccessor world, BlockPos pos, RandomSource rand) {
        int variant = rand.m_188503_(100);
        if (variant >= 49) {
            Direction randDir = Direction.m_122376_((int)(rand.m_188503_(4) + 2));
            this.setPoiseCluster(world, pos.m_121945_(randDir));
        } else if (variant <= 15) {
            world.m_7731_(pos.m_7494_(), this.GLOWING_POISE_STEM.get(), 2);
            this.setPoiseCluster(world, pos.m_122012_());
            this.setPoiseCluster(world, pos.m_122029_());
            this.setPoiseCluster(world, pos.m_122019_());
            this.setPoiseCluster(world, pos.m_122024_());
            this.setPoiseCluster(world, pos.m_122012_().m_7494_());
            this.setPoiseCluster(world, pos.m_122029_().m_7494_());
            this.setPoiseCluster(world, pos.m_122019_().m_7494_());
            this.setPoiseCluster(world, pos.m_122024_().m_7494_());
        } else if (variant >= 16) {
            Direction randDir = Direction.m_122376_((int)(rand.m_188503_(4) + 2));
            if (randDir == Direction.NORTH) {
                world.m_7731_(pos.m_7494_(), this.GLOWING_POISE_STEM.get(), 2);
                this.setPoiseCluster(world, pos.m_122012_());
                this.setPoiseCluster(world, pos.m_122012_().m_122029_());
                this.setPoiseCluster(world, pos.m_122029_());
                this.setPoiseCluster(world, pos.m_122012_().m_7494_());
                this.setPoiseCluster(world, pos.m_122012_().m_122029_().m_7494_());
                this.setPoiseCluster(world, pos.m_122029_().m_7494_());
            } else if (randDir == Direction.EAST) {
                world.m_7731_(pos.m_7494_(), this.GLOWING_POISE_STEM.get(), 2);
                this.setPoiseCluster(world, pos.m_122029_());
                this.setPoiseCluster(world, pos.m_122029_().m_122019_());
                this.setPoiseCluster(world, pos.m_122019_());
                this.setPoiseCluster(world, pos.m_122029_().m_7494_());
                this.setPoiseCluster(world, pos.m_122029_().m_122019_().m_7494_());
                this.setPoiseCluster(world, pos.m_122019_().m_7494_());
            } else if (randDir == Direction.SOUTH) {
                world.m_7731_(pos.m_7494_(), this.GLOWING_POISE_STEM.get(), 2);
                this.setPoiseCluster(world, pos.m_122019_());
                this.setPoiseCluster(world, pos.m_122019_().m_122024_());
                this.setPoiseCluster(world, pos.m_122024_());
                this.setPoiseCluster(world, pos.m_122019_().m_7494_());
                this.setPoiseCluster(world, pos.m_122019_().m_122024_().m_7494_());
                this.setPoiseCluster(world, pos.m_122024_().m_7494_());
            } else if (randDir == Direction.WEST) {
                world.m_7731_(pos.m_7494_(), this.GLOWING_POISE_STEM.get(), 2);
                this.setPoiseCluster(world, pos.m_122024_());
                this.setPoiseCluster(world, pos.m_122024_().m_122012_());
                this.setPoiseCluster(world, pos.m_122012_());
                this.setPoiseCluster(world, pos.m_122024_().m_7494_());
                this.setPoiseCluster(world, pos.m_122024_().m_122012_().m_7494_());
                this.setPoiseCluster(world, pos.m_122012_().m_7494_());
            }
        } else if (variant >= 30) {
            Direction randDir = Direction.m_122376_((int)(rand.m_188503_(4) + 2));
            if (randDir == Direction.NORTH) {
                world.m_7731_(pos.m_7494_(), this.GLOWING_POISE_STEM.get(), 2);
                this.setPoiseCluster(world, pos.m_122012_());
                this.setPoiseCluster(world, pos.m_122012_().m_122024_());
                this.setPoiseCluster(world, pos.m_122013_(2).m_122024_());
                this.setPoiseCluster(world, pos.m_122012_().m_122024_().m_7494_());
                this.setPoiseCluster(world, pos.m_122012_().m_122024_().m_7495_());
                this.setPoiseCluster(world, pos.m_122012_().m_122025_(2));
                this.setPoiseCluster(world, pos.m_122024_());
            } else if (randDir == Direction.EAST) {
                world.m_7731_(pos.m_7494_(), this.GLOWING_POISE_STEM.get(), 2);
                this.setPoiseCluster(world, pos.m_122029_());
                this.setPoiseCluster(world, pos.m_122029_().m_122012_());
                this.setPoiseCluster(world, pos.m_122030_(2).m_122012_());
                this.setPoiseCluster(world, pos.m_122029_().m_122012_().m_7494_());
                this.setPoiseCluster(world, pos.m_122029_().m_122012_().m_7495_());
                this.setPoiseCluster(world, pos.m_122029_().m_122013_(2));
                this.setPoiseCluster(world, pos.m_122012_());
            } else if (randDir == Direction.SOUTH) {
                world.m_7731_(pos.m_7494_(), this.GLOWING_POISE_STEM.get(), 2);
                this.setPoiseCluster(world, pos.m_122019_());
                this.setPoiseCluster(world, pos.m_122019_().m_122029_());
                this.setPoiseCluster(world, pos.m_122020_(2).m_122029_());
                this.setPoiseCluster(world, pos.m_122019_().m_122029_().m_7494_());
                this.setPoiseCluster(world, pos.m_122019_().m_122029_().m_7495_());
                this.setPoiseCluster(world, pos.m_122019_().m_122030_(2));
                this.setPoiseCluster(world, pos.m_122029_());
            } else if (randDir == Direction.WEST) {
                world.m_7731_(pos.m_7494_(), this.GLOWING_POISE_STEM.get(), 2);
                this.setPoiseCluster(world, pos.m_122024_());
                this.setPoiseCluster(world, pos.m_122024_().m_122019_());
                this.setPoiseCluster(world, pos.m_122025_(2).m_122019_());
                this.setPoiseCluster(world, pos.m_122024_().m_122019_().m_7494_());
                this.setPoiseCluster(world, pos.m_122024_().m_122019_().m_7495_());
                this.setPoiseCluster(world, pos.m_122024_().m_122020_(2));
                this.setPoiseCluster(world, pos.m_122019_());
            }
        }
    }

    public void buildPoismossCircle(LevelAccessor world, LevelSimulatedRW reader, RandomSource random, BlockPos pos) {
        this.placePoismossCircle(world, reader, pos.m_122024_().m_122012_());
        this.placePoismossCircle(world, reader, pos.m_122030_(2).m_122012_());
        this.placePoismossCircle(world, reader, pos.m_122024_().m_122020_(2));
        this.placePoismossCircle(world, reader, pos.m_122030_(2).m_122020_(2));
        for (int i = 0; i < 5; ++i) {
            int j = random.m_188503_(64);
            int k = j % 8;
            int l = j / 8;
            if (k != 0 && k != 7 && l != 0 && l != 7) continue;
            this.placePoismossCircle(world, reader, pos.m_7918_(-3 + k, 0, -3 + l));
        }
    }

    private void placePoismossCircle(LevelAccessor world, LevelSimulatedRW reader, BlockPos center) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placePoismossAt(world, reader, center.m_7918_(i, 0, j));
            }
        }
    }

    private void placePoismossAt(LevelAccessor world, LevelSimulatedRW reader, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.m_6630_(i);
            if (world.m_8055_(blockpos).m_60734_() == EEBlocks.EUMUS.get() || world.m_8055_(blockpos).m_60734_() == Blocks.f_50259_) {
                BlockState newGround = world.m_8055_(blockpos).m_60734_() == EEBlocks.EUMUS.get() ? this.POISMOSS_EUMUS.get() : ((Block)EEBlocks.POISMOSS.get()).m_49966_();
                this.setBlockState(world, blockpos, newGround);
                break;
            }
            if (!GenerationUtils.isAir((LevelSimulatedReader)reader, blockpos) && i < 0) break;
        }
    }

    private void placeInnerDomeFeatures(LevelAccessor world, RandomSource rand, BlockPos pos) {
        BlockPos blockpos;
        int x;
        if ((double)rand.m_188501_() > 0.75) {
            return;
        }
        for (x = 0; x < 128; ++x) {
            blockpos = pos.m_7918_(rand.m_188503_(8) - rand.m_188503_(8), rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(8) - rand.m_188503_(8));
            if (!world.m_46859_(blockpos) || !((Block)EEBlocks.POISE_BUSH.get()).m_49966_().m_60710_((LevelReader)world, blockpos)) continue;
            world.m_7731_(blockpos, ((Block)EEBlocks.POISE_BUSH.get()).m_49966_(), 2);
        }
        for (x = 0; x < 128; ++x) {
            blockpos = pos.m_7918_(rand.m_188503_(8) - rand.m_188503_(8), rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(8) - rand.m_188503_(8));
            if (!(rand.m_188501_() <= 0.45f) || !world.m_46859_(blockpos) || !world.m_46859_(blockpos.m_7494_()) || !((Block)EEBlocks.TALL_POISE_BUSH.get()).m_49966_().m_60710_((LevelReader)world, blockpos)) continue;
            ((PoiseTallBushBlock)((Object)EEBlocks.TALL_POISE_BUSH.get())).placeAt(world, blockpos, 2);
        }
        for (x = 0; x < 4; ++x) {
            BlockPos randPos = pos.m_7918_(rand.m_188503_(8) - rand.m_188503_(8), rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(8) - rand.m_188503_(8));
            if (!world.m_46859_(randPos) && world.m_8055_(randPos).m_60734_() != EEBlocks.POISE_BUSH.get() || !((Block)EEBlocks.BOLLOOM_BUD.get()).m_49966_().m_60710_((LevelReader)world, randPos)) continue;
            world.m_7731_(randPos, ((Block)EEBlocks.BOLLOOM_BUD.get()).m_49966_(), 2);
        }
    }

    public boolean canFitBud(LevelAccessor world, BlockPos pos) {
        for (int y = pos.m_123342_(); y < pos.m_123342_() + 5; ++y) {
            for (int x = pos.m_123341_() - 1; x < pos.m_123341_() + 1; ++x) {
                for (int z = pos.m_123343_() - 1; z < pos.m_123343_() + 1; ++z) {
                    BlockPos newPos = new BlockPos(x, y, z);
                    if (newPos == pos || world.m_46859_(newPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void setPoiseLog(LevelAccessor world, BlockPos pos, RandomSource rand, boolean isTreeBase, boolean noBubbles) {
        BlockState logState;
        BlockState blockState = logState = rand.m_188501_() <= 0.11f ? this.GLOWING_POISE_STEM.get() : this.POISE_STEM.get();
        if (world.m_8055_(pos).m_60767_().m_76336_() || world.m_8055_(pos).m_60734_() == EEBlocks.POISE_CLUSTER.get()) {
            world.m_7731_(pos, logState, 2);
            if (!noBubbles && logState == this.GLOWING_POISE_STEM.get()) {
                if (!isTreeBase) {
                    boolean willCollide;
                    boolean bl = willCollide = world.m_8055_(pos.m_7495_()).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_6625_(2)).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_6625_(3)).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_7494_()).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_6630_(2)).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_6630_(3)).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get();
                    if (rand.m_188501_() <= 0.7f && !willCollide && world.m_8055_(pos.m_122012_()).m_60767_().m_76336_() && world.m_8055_(pos.m_122029_()).m_60767_().m_76336_() && world.m_8055_(pos.m_122019_()).m_60767_().m_76336_() && world.m_8055_(pos.m_122024_()).m_60767_().m_76336_()) {
                        this.buildSideBubble(world, pos, rand);
                    }
                } else {
                    boolean willCollide;
                    boolean bl = willCollide = world.m_8055_(pos.m_7495_()).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_6625_(2)).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_6625_(3)).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_7494_()).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_6630_(2)).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get() || world.m_8055_(pos.m_6630_(3)).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get();
                    if (rand.m_188501_() <= 0.4f && !willCollide) {
                        this.buildSideBubble(world, pos, rand);
                    }
                }
            }
        }
    }

    private void setPoiseLogWithDirection(LevelAccessor world, BlockPos pos, RandomSource rand, Direction direction) {
        BlockState logState;
        BlockState blockState = logState = rand.m_188501_() <= 0.9f ? (BlockState)this.POISE_STEM.get().m_61124_((Property)GlowingPoiseStemBlock.f_55923_, (Comparable)direction.m_122434_()) : (BlockState)this.GLOWING_POISE_STEM.get().m_61124_((Property)GlowingPoiseStemBlock.f_55923_, (Comparable)direction.m_122434_());
        if (world.m_8055_(pos).m_60767_().m_76336_()) {
            world.m_7731_(pos, logState, 2);
        }
    }

    private void setPoiseCluster(LevelAccessor world, BlockPos pos) {
        if (world.m_8055_(pos).m_60767_().m_76336_()) {
            world.m_7731_(pos, ((Block)EEBlocks.POISE_CLUSTER.get()).m_49966_(), 2);
        }
    }

    private void setBlockState(LevelAccessor world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, state, 2);
    }

    private boolean isViableBranchArea(LevelAccessor world, BlockPos pos, Direction direction, int directionLength, BlockPos topPosition) {
        int y = topPosition.m_123342_() - pos.m_123342_();
        if (direction == Direction.NORTH ? GenerationUtils.isAreaReplacable(world, pos.m_7495_().m_122024_().m_122013_(directionLength).m_123341_(), pos.m_7495_().m_122024_().m_122013_(directionLength).m_123342_(), pos.m_7495_().m_122024_().m_122013_(directionLength).m_123343_(), pos.m_6630_(y).m_122029_().m_123341_(), pos.m_6630_(y).m_122029_().m_123342_(), pos.m_6630_(y).m_122029_().m_123343_()) : (direction == Direction.EAST ? GenerationUtils.isAreaReplacable(world, pos.m_7495_().m_122012_().m_122030_(directionLength).m_123341_(), pos.m_7495_().m_122012_().m_122030_(directionLength).m_123342_(), pos.m_7495_().m_122012_().m_122030_(directionLength).m_123343_(), pos.m_6630_(y).m_122024_().m_123341_(), pos.m_6630_(y).m_122024_().m_123342_(), pos.m_6630_(y).m_122024_().m_123343_()) : (direction == Direction.SOUTH ? GenerationUtils.isAreaReplacable(world, pos.m_7495_().m_122024_().m_123341_(), pos.m_7495_().m_122024_().m_123342_(), pos.m_7495_().m_122024_().m_123343_(), pos.m_6630_(y).m_122029_().m_122020_(directionLength).m_123341_(), pos.m_6630_(y).m_122029_().m_122020_(directionLength).m_123342_(), pos.m_6630_(y).m_122029_().m_122020_(directionLength).m_123343_()) : GenerationUtils.isAreaReplacable(world, pos.m_7495_().m_122012_().m_123341_(), pos.m_7495_().m_122012_().m_123342_(), pos.m_7495_().m_122012_().m_123343_(), pos.m_6630_(y).m_122019_().m_122025_(directionLength).m_123341_(), pos.m_6630_(y).m_122019_().m_122025_(directionLength).m_123342_(), pos.m_6630_(y).m_122019_().m_122025_(directionLength).m_123343_())))) {
            return GenerationUtils.isAreaReplacable(world, topPosition.m_122013_(3).m_122025_(3).m_123341_(), topPosition.m_122013_(3).m_122025_(3).m_123342_(), topPosition.m_122013_(3).m_122025_(3).m_123343_(), topPosition.m_122020_(3).m_122030_(3).m_6630_(7).m_123341_(), topPosition.m_122020_(3).m_122030_(3).m_6630_(7).m_123342_(), topPosition.m_122020_(3).m_122030_(3).m_6630_(7).m_123343_());
        }
        return false;
    }

    public boolean isAreaOpen(LevelAccessor world, BlockPos pos) {
        for (int y = pos.m_123342_(); y < pos.m_123342_() + 1; ++y) {
            for (int x = pos.m_123341_() - 1; x < pos.m_123341_() + 2; ++x) {
                for (int z = pos.m_123343_() - 1; z < pos.m_123343_() + 2; ++z) {
                    if (world.m_8055_(new BlockPos(x, y, z)).m_60767_().m_76336_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isValidGround(LevelAccessor world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        return block == Blocks.f_50259_ || state.m_204336_(EEBlockTags.END_PLANTABLE) || state.m_204336_(EEBlockTags.POISE_PLANTABLE);
    }
}

