/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature.corrock;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.GenerationPiece;
import com.teamabnormals.endergetic.common.levelgen.configs.CorrockBranchConfig;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.AbstractCorrockFeature;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEFeatures;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class CorrockBranchFeature
extends AbstractCorrockFeature<CorrockBranchConfig> {
    public CorrockBranchFeature(Codec<CorrockBranchConfig> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<CorrockBranchConfig> context) {
        int branchCount;
        List<Pair<GenerationPiece, AbstractCorrockFeature.ChorusPlantPart>> branches;
        Pair<GenerationPiece, AbstractCorrockFeature.ChorusPlantPart> firstBranch;
        GenerationPiece firstBranchPiece;
        int baseHeight;
        RandomSource rand;
        GenerationPiece basePiece;
        BlockState belowState;
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        CorrockBranchConfig config = (CorrockBranchConfig)context.m_159778_();
        if (config.isValidGround(belowState = world.m_8055_(pos.m_7495_())) && world.m_8055_(pos.m_6625_(2)).m_60815_() && (basePiece = this.createBase((LevelAccessor)world, pos, rand = context.m_225041_(), baseHeight = rand.m_188503_(4) + 4)).canPlace((LevelAccessor)world) && (firstBranchPiece = (GenerationPiece)(firstBranch = (branches = this.createBranches((LevelAccessor)world, pos, rand, branchCount = rand.m_188499_() ? 1 : rand.m_188503_(3) + 1, baseHeight, config.getCrownChance(), config.getDecoratedBranchChance())).get(0)).getFirst()).canPlace((LevelAccessor)world)) {
            basePiece.place((LevelAccessor)world);
            firstBranchPiece.place((LevelAccessor)world);
            AbstractCorrockFeature.ChorusPlantPart firstChorusPart = (AbstractCorrockFeature.ChorusPlantPart)firstBranch.getSecond();
            if (firstChorusPart != null) {
                firstChorusPart.placeGrowth((LevelAccessor)world, rand);
            }
            for (int i = 1; i < branchCount; ++i) {
                Pair<GenerationPiece, AbstractCorrockFeature.ChorusPlantPart> branch = branches.get(i);
                GenerationPiece branchPiece = (GenerationPiece)branch.getFirst();
                if (!branchPiece.canPlace((LevelAccessor)world)) continue;
                branchPiece.place((LevelAccessor)world);
                AbstractCorrockFeature.ChorusPlantPart chorusPlantPart = (AbstractCorrockFeature.ChorusPlantPart)branch.getSecond();
                if (chorusPlantPart == null) continue;
                chorusPlantPart.placeGrowth((LevelAccessor)world, rand);
            }
            BlockPos groundModifierPos = new BlockPos(pos.m_123341_() - 1 + (rand.m_188503_(3) - rand.m_188503_(3)), pos.m_123342_() - 1, pos.m_123343_() - 1 + (rand.m_188503_(3) - rand.m_188503_(3)));
            ((ConfiguredFeature)EEFeatures.EEConfiguredFeatures.DISK_CORROCK.get()).m_224953_(world, context.m_159775_(), rand, groundModifierPos);
            BlockPos.MutableBlockPos corrockPlantPos = new BlockPos.MutableBlockPos();
            for (int x = pos.m_123341_() - 4; x < pos.m_123341_() + 4; ++x) {
                for (int y = pos.m_123342_(); y < pos.m_123342_() + baseHeight + 10; ++y) {
                    for (int z = pos.m_123343_() - 4; z < pos.m_123343_() + 4; ++z) {
                        boolean isCorrockBelow;
                        corrockPlantPos.m_122178_(x, y, z);
                        boolean bl = isCorrockBelow = world.m_8055_(corrockPlantPos.m_7495_()).m_60734_() == EEBlocks.CORROCK_END_BLOCK.get();
                        if (!(isCorrockBelow && rand.m_188501_() < 0.25f) && (isCorrockBelow || !(rand.m_188501_() < 0.025f)) || !world.m_46859_((BlockPos)corrockPlantPos) || !((BlockState)CORROCK_STATE.m_13971_()).m_60710_((LevelReader)world, (BlockPos)corrockPlantPos)) continue;
                        world.m_7731_((BlockPos)corrockPlantPos, (BlockState)CORROCK_STATE.m_13971_(), 2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private GenerationPiece createBase(LevelAccessor world, BlockPos pos, RandomSource rand, int height) {
        GenerationPiece piece = new GenerationPiece((iworld, part) -> iworld.m_46859_(part.pos));
        BlockState corrockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
        int heightMinusOne = height - 1;
        BlockPos topPos = pos.m_6630_(height);
        for (int y = 0; y < height; ++y) {
            piece.addBlockPiece(corrockState, pos.m_6630_(y));
            if (y != heightMinusOne || !(rand.m_188501_() < 0.85f)) continue;
            piece.addBlockPiece(this.randomStandingCorrockCrown(rand), topPos);
        }
        int posX = pos.m_123341_();
        int posY = pos.m_123342_();
        int posZ = pos.m_123343_();
        int startX = posX - 1;
        int startZ = posZ - 1;
        int endX = posX + 1;
        int endZ = posZ + 1;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                if (!(rand.m_188501_() < 0.4f)) continue;
                mutable.m_122178_(x, posY, z);
                if (!this.tryToMakeAreaBelowPlacableOn(piece, world, (BlockPos)mutable)) continue;
                int randSideHeight = rand.m_188503_(heightMinusOne) + 1;
                for (int y = 0; y < randSideHeight; ++y) {
                    piece.addBlockPiece(corrockState, mutable.m_6630_(y));
                }
            }
        }
        return piece;
    }

    private boolean tryToMakeAreaBelowPlacableOn(GenerationPiece piece, LevelAccessor world, BlockPos pos) {
        BlockState corrockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
        BlockPos down = pos.m_7495_();
        if (world.m_46859_(down) && !world.m_46859_(pos.m_6625_(3))) {
            piece.addBlockPiece(corrockState, down);
            BlockPos doubleDown = pos.m_6625_(2);
            if (world.m_46859_(doubleDown)) {
                piece.addBlockPiece(corrockState, doubleDown);
            }
            return true;
        }
        return false;
    }

    private List<Pair<GenerationPiece, AbstractCorrockFeature.ChorusPlantPart>> createBranches(LevelAccessor world, BlockPos pos, RandomSource rand, int count, int height, float crownChance, float decorationChance) {
        ArrayList pieces = Lists.newArrayList();
        BlockPos branchStart = pos.m_6630_(height - 1);
        for (int i = 0; i < count; ++i) {
            GenerationPiece basePiece = new GenerationPiece((iworld, part) -> world.m_46859_(part.pos));
            pieces.add(new Pair((Object)basePiece, (Object)this.createBranch(world, branchStart, rand, basePiece, this.randomHorizontalDirection(rand), rand.m_188503_(2) + 1, crownChance, decorationChance)));
        }
        return pieces;
    }

    @Nullable
    private AbstractCorrockFeature.ChorusPlantPart createBranch(LevelAccessor world, BlockPos pos, RandomSource rand, GenerationPiece basePiece, Direction horizontalStep, int subBranches, float crownChance, float decorationChance) {
        AbstractCorrockFeature.ChorusPlantPart chorusPlantPart = null;
        int branched = 0;
        int prevBranchHeight = 0;
        int branchHeight = rand.m_188503_(3) + 4;
        BlockPos offset = pos.m_121945_(horizontalStep);
        BlockState corrockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
        for (int y = 0; y < branchHeight; ++y) {
            boolean beforeLastBranched;
            boolean lastBranched;
            basePiece.addBlockPiece(corrockState, offset.m_6630_(y));
            if (y != branchHeight - 1) continue;
            boolean bl = lastBranched = branched == subBranches;
            if (rand.m_188501_() < decorationChance) {
                BlockPos crownOrigin = offset.m_6630_(y);
                this.createCrownOrbit(basePiece, world, crownOrigin, rand, crownChance);
                if (lastBranched) {
                    chorusPlantPart = new AbstractCorrockFeature.ChorusPlantPart(crownOrigin);
                    break;
                }
            } else if (lastBranched) break;
            if (rand.m_188501_() > 0.6f) {
                horizontalStep = rand.m_188499_() ? horizontalStep.m_122427_() : horizontalStep.m_122428_();
            }
            boolean bl2 = beforeLastBranched = branched == subBranches - 1;
            if (beforeLastBranched) {
                int middle = prevBranchHeight + (branchHeight - prevBranchHeight) / 2;
                y -= branchHeight - middle;
                branchHeight = middle;
                basePiece.addBlockPiece(corrockState, offset.m_6630_(branchHeight).m_121945_(horizontalStep));
                offset = offset.m_5484_(horizontalStep, 2);
            } else {
                offset = offset.m_121945_(horizontalStep);
                --y;
            }
            prevBranchHeight = --branchHeight;
            branchHeight += rand.m_188503_(3) + 4;
            ++branched;
        }
        return chorusPlantPart;
    }

    private void createCrownOrbit(GenerationPiece branch, LevelAccessor world, BlockPos pos, RandomSource rand, float crownChance) {
        for (Direction horizontal : Direction.Plane.HORIZONTAL) {
            BlockPos placingPos = pos.m_121945_(horizontal);
            if (!(rand.m_188501_() < crownChance) || !world.m_46859_(placingPos)) continue;
            branch.addBlockPiece(CorrockBranchFeature.getCorrockCrownWall(horizontal), placingPos);
        }
        if (rand.m_188501_() < crownChance && world.m_46859_(pos.m_7494_())) {
            branch.addBlockPiece(this.randomStandingCorrockCrown(rand), pos.m_7494_());
        }
    }

    private Direction randomHorizontalDirection(RandomSource rand) {
        return Direction.m_122407_((int)rand.m_188503_(6));
    }

    private BlockState randomStandingCorrockCrown(RandomSource rand) {
        return CorrockBranchFeature.getCorrockCrownStanding(rand.m_188503_(16));
    }
}

