/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature.corrock.tower;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.GenerationPiece;
import com.teamabnormals.endergetic.api.util.GenerationUtils;
import com.teamabnormals.endergetic.common.levelgen.configs.CorrockTowerConfig;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.AbstractCorrockFeature;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public final class MediumCorrockTowerFeature
extends AbstractCorrockFeature<CorrockTowerConfig> {
    public MediumCorrockTowerFeature(Codec<CorrockTowerConfig> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<CorrockTowerConfig> context) {
        BlockPos pos;
        WorldGenLevel world = context.m_159774_();
        if (world.m_46859_(pos = context.m_159777_()) && world.m_8055_(pos.m_7495_()).m_60734_() == EEBlocks.CORROCK_END_BLOCK.get() && world.m_8055_(pos.m_6625_(2)).m_60815_()) {
            BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
            GenerationPiece base = new GenerationPiece((w, p) -> w.m_46859_(p.pos));
            RandomSource rand = context.m_225041_();
            CorrockTowerConfig config = (CorrockTowerConfig)context.m_159778_();
            int height = rand.m_188503_(config.getMaxHeight() - config.getMinHeight() + 1) + config.getMinHeight();
            MediumCorrockTowerFeature.fillUp(base, corrockBlockState, pos, height);
            if (!base.canPlace((LevelAccessor)world)) {
                return false;
            }
            BlockPos downPos = pos.m_6625_(2);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            if (GenerationUtils.isAreaCompletelySolid((LevelAccessor)world, downPos.m_123341_() - 1, downPos.m_123342_(), downPos.m_123343_() - 1, downPos.m_123341_() + 1, downPos.m_123342_(), downPos.m_123343_() + 1)) {
                for (int x = downPos.m_123341_() - 1; x <= downPos.m_123341_() + 1; ++x) {
                    for (int y = downPos.m_123342_(); y <= downPos.m_123342_() + 1; ++y) {
                        for (int z = downPos.m_123343_() - 1; z <= downPos.m_123343_() + 1; ++z) {
                            mutable.m_122178_(x, y, z);
                            if (!world.m_46859_((BlockPos)mutable)) continue;
                            base.addBlockPiece(corrockBlockState, mutable.m_7949_());
                        }
                    }
                }
            } else {
                return false;
            }
            int heightMinusOne = height - 1;
            for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                BlockPos offset = pos.m_121945_(horizontal);
                BlockPos doubleOffset = pos.m_5484_(horizontal, 2);
                MediumCorrockTowerFeature.fillUp(base, corrockBlockState, offset, height);
                if (rand.m_188499_()) {
                    base.addBlockPiece(corrockBlockState, offset.m_121945_(horizontal.m_122427_()));
                }
                if (rand.m_188499_()) {
                    base.addBlockPiece(corrockBlockState, offset.m_121945_(horizontal.m_122428_()));
                }
                if (rand.m_188499_()) {
                    base.addBlockPiece(corrockBlockState, offset.m_6630_(heightMinusOne).m_121945_(horizontal.m_122427_()));
                }
                if (rand.m_188499_()) {
                    base.addBlockPiece(corrockBlockState, offset.m_6630_(heightMinusOne).m_121945_(horizontal.m_122428_()));
                }
                if (rand.m_188499_()) {
                    base.addBlockPiece(corrockBlockState, doubleOffset);
                }
                if (!rand.m_188499_()) continue;
                base.addBlockPiece(corrockBlockState, doubleOffset.m_6630_(heightMinusOne));
            }
            int x = 0;
            int z = 0;
            if (rand.m_188499_()) {
                x = rand.m_188503_(2);
            } else {
                z = rand.m_188503_(2);
            }
            Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> topPiece = MediumCorrockTowerFeature.getTop((LevelAccessor)world, pos.m_7918_(x, height + 1, z), rand, config.getCrownChance(), config.getChorusChance());
            if (base.canPlace((LevelAccessor)world) && ((GenerationPiece)topPiece.getFirst()).canPlace((LevelAccessor)world)) {
                base.place((LevelAccessor)world);
                ((GenerationPiece)topPiece.getFirst()).place((LevelAccessor)world);
                ((List)topPiece.getSecond()).forEach(growth -> growth.placeGrowth((LevelAccessor)world, rand));
                BlockPos topMiddle = pos.m_6630_(height + 1);
                BlockState corrockPlantState = (BlockState)CORROCK_STATE.m_13971_();
                for (int i = 0; i < 16; ++i) {
                    if (!(rand.m_188501_() < 0.6f) || !world.m_46859_((BlockPos)mutable.m_122154_((Vec3i)topMiddle, rand.m_188503_(6) - rand.m_188503_(6), rand.m_188503_(2) - rand.m_188503_(2), rand.m_188503_(6) - rand.m_188503_(6))) || world.m_8055_(mutable.m_7495_()).m_60734_() != CORROCK_BLOCK_BLOCK) continue;
                    world.m_7731_((BlockPos)mutable, corrockPlantState, 2);
                }
                return true;
            }
        }
        return false;
    }

    private static void fillUp(GenerationPiece piece, BlockState state, BlockPos pos, int height) {
        for (int i = 0; i < height; ++i) {
            piece.addBlockPiece(state, pos.m_6630_(i));
        }
    }

    private static Pair<GenerationPiece, List<AbstractCorrockFeature.ChorusPlantPart>> getTop(LevelAccessor world, BlockPos pos, RandomSource rand, float crownChance, float chorusChance) {
        GenerationPiece top = new GenerationPiece((w, p) -> w.m_46859_(p.pos));
        ArrayList growths = Lists.newArrayList();
        ArrayList corners = Lists.newArrayList();
        int variant = rand.m_188503_(4);
        BlockPos startNPos = pos.m_5484_(Direction.NORTH, 4).m_7918_(-2, 0, 0);
        BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startNPos.m_7918_(i, 0, 0);
            top.addBlockPiece(corrockBlockState, placePos);
            if (!(rand.m_188501_() < crownChance)) continue;
            if (rand.m_188499_()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.NORTH), placePos.m_121945_(Direction.NORTH));
                continue;
            }
            top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), placePos.m_7494_());
        }
        BlockPos startEPos = pos.m_5484_(Direction.EAST, 3).m_7918_(0, 0, 1);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startEPos.m_7918_(0, 0, -i);
            top.addBlockPiece(corrockBlockState, placePos);
            if (!(rand.m_188501_() < crownChance)) continue;
            if (rand.m_188499_()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.EAST), placePos.m_121945_(Direction.EAST));
                continue;
            }
            top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), placePos.m_7494_());
        }
        BlockPos startSPos = pos.m_5484_(Direction.SOUTH, 3).m_7918_(1, 0, 0);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startSPos.m_7918_(-i, 0, 0);
            top.addBlockPiece(corrockBlockState, placePos);
            if (!(rand.m_188501_() < crownChance)) continue;
            if (rand.m_188499_()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.SOUTH), placePos.m_121945_(Direction.SOUTH));
                continue;
            }
            top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), placePos.m_7494_());
        }
        BlockPos startWPos = pos.m_5484_(Direction.WEST, 4).m_7918_(0, 0, 1);
        for (int i = 0; i < 4; ++i) {
            BlockPos placePos = startWPos.m_7918_(0, 0, -i);
            top.addBlockPiece(corrockBlockState, placePos);
            if (!(rand.m_188501_() < crownChance)) continue;
            if (rand.m_188499_()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.WEST), placePos.m_121945_(Direction.WEST));
                continue;
            }
            top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), placePos.m_7494_());
        }
        BlockPos cornerNW = pos.m_7918_(-3, 0, -3);
        if (variant != 0) {
            corners.add(cornerNW.m_121945_(Direction.SOUTH));
            corners.add(cornerNW.m_121945_(Direction.EAST));
        }
        if (rand.m_188501_() < crownChance) {
            if (rand.m_188499_()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), cornerNW.m_7494_());
            } else {
                if (rand.m_188501_() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.NORTH), cornerNW.m_121945_(Direction.NORTH));
                }
                if (rand.m_188501_() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.WEST), cornerNW.m_121945_(Direction.WEST));
                }
            }
        }
        corners.add(cornerNW);
        BlockPos cornerNE = pos.m_7918_(2, 0, -3);
        if (variant != 1) {
            corners.add(cornerNE.m_121945_(Direction.SOUTH));
            corners.add(cornerNE.m_121945_(Direction.WEST));
        }
        if (rand.m_188501_() < crownChance) {
            if (rand.m_188499_()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), cornerNE.m_7494_());
            } else {
                if (rand.m_188501_() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.NORTH), cornerNE.m_121945_(Direction.NORTH));
                }
                if (rand.m_188501_() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.EAST), cornerNE.m_121945_(Direction.EAST));
                }
            }
        }
        corners.add(cornerNE);
        BlockPos cornerSE = pos.m_7918_(2, 0, 2);
        if (variant != 2) {
            corners.add(cornerSE.m_121945_(Direction.NORTH));
            corners.add(cornerSE.m_121945_(Direction.WEST));
        }
        if (rand.m_188501_() < crownChance) {
            if (rand.m_188499_()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), cornerSE.m_7494_());
            } else {
                if (rand.m_188501_() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.SOUTH), cornerSE.m_121945_(Direction.SOUTH));
                }
                if (rand.m_188501_() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.EAST), cornerSE.m_121945_(Direction.EAST));
                }
            }
        }
        corners.add(cornerSE);
        BlockPos cornerSW = pos.m_7918_(-3, 0, 2);
        if (variant != 3) {
            corners.add(cornerSW.m_121945_(Direction.NORTH));
            corners.add(cornerSW.m_121945_(Direction.EAST));
        }
        if (rand.m_188501_() < crownChance) {
            if (rand.m_188499_()) {
                top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), cornerSW.m_7494_());
            } else {
                if (rand.m_188501_() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.SOUTH), cornerSW.m_121945_(Direction.SOUTH));
                }
                if (rand.m_188501_() < crownChance) {
                    top.addBlockPiece(MediumCorrockTowerFeature.getCorrockCrownWall(Direction.WEST), cornerSW.m_121945_(Direction.WEST));
                }
            }
        }
        corners.add(cornerSW);
        for (int x = cornerNW.m_123341_(); x <= cornerSE.m_123341_(); ++x) {
            for (int z = cornerNW.m_123343_(); z <= cornerSE.m_123343_(); ++z) {
                BlockPos placingPos = new BlockPos(x, pos.m_123342_(), z);
                if (corners.contains(placingPos)) continue;
                if (MediumCorrockTowerFeature.isNotCloseToAnotherGrowth(growths, placingPos.m_7495_()) && rand.m_188501_() < chorusChance && world.m_46859_(placingPos) && world.m_46859_(placingPos.m_7494_())) {
                    growths.add(new AbstractCorrockFeature.ChorusPlantPart(placingPos.m_7495_()));
                    for (Direction direction : Direction.values()) {
                        if (direction == Direction.UP) continue;
                        top.addBlockPiece(corrockBlockState, placingPos.m_7495_().m_121945_(direction));
                    }
                    continue;
                }
                top.addBlockPiece(corrockBlockState, placingPos.m_7495_());
            }
        }
        for (BlockPos positions : corners) {
            top.addBlockPiece(corrockBlockState, positions);
        }
        return Pair.of((Object)top, (Object)growths);
    }
}

