/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature.corrock.tower;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.GenerationPiece;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.AbstractCorrockFeature;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;

public final class SmallCorrockTowerFeature
extends AbstractCorrockFeature<ProbabilityFeatureConfiguration> {
    public SmallCorrockTowerFeature(Codec<ProbabilityFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<ProbabilityFeatureConfiguration> context) {
        GenerationPiece base;
        BlockPos pos;
        WorldGenLevel level = context.m_159774_();
        if (level.m_46859_(pos = context.m_159777_()) && level.m_8055_(pos.m_7495_()).m_60734_() == EEBlocks.CORROCK_END_BLOCK.get() && level.m_8055_(pos.m_6625_(2)).m_60815_() && (base = SmallCorrockTowerFeature.getBase((LevelAccessor)level, pos)) != null) {
            BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
            GenerationPiece topPiece = new GenerationPiece((w, p) -> w.m_46859_(p.pos));
            RandomSource rand = context.m_225041_();
            float crownChance = ((ProbabilityFeatureConfiguration)context.m_159778_()).f_67859_;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos placingPos = pos.m_7918_(x, 1, z);
                    topPiece.addBlockPiece(corrockBlockState, placingPos);
                    if (!(rand.m_188501_() < crownChance)) continue;
                    topPiece.addBlockPiece(SmallCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), placingPos.m_7494_());
                }
            }
            float increasedCrownChance = crownChance + 0.05f;
            for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                BlockPos sidePos = pos.m_6630_(2).m_5484_(horizontal, 2);
                BlockPos rightPos = sidePos.m_121945_(horizontal.m_122427_());
                BlockPos leftPos = sidePos.m_121945_(horizontal.m_122428_());
                topPiece.addBlockPiece(corrockBlockState, sidePos);
                if (rand.m_188501_() < increasedCrownChance) {
                    topPiece.addBlockPiece(SmallCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), sidePos.m_7494_());
                }
                topPiece.addBlockPiece(corrockBlockState, rightPos);
                if (rand.m_188501_() < increasedCrownChance) {
                    topPiece.addBlockPiece(SmallCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), rightPos.m_7494_());
                }
                topPiece.addBlockPiece(corrockBlockState, leftPos);
                if (!(rand.m_188501_() < increasedCrownChance)) continue;
                topPiece.addBlockPiece(SmallCorrockTowerFeature.getCorrockCrownStanding(rand.m_188503_(16)), leftPos.m_7494_());
            }
            if (topPiece.canPlace((LevelAccessor)level)) {
                base.place((LevelAccessor)level);
                topPiece.place((LevelAccessor)level);
                level.m_7731_(pos, corrockBlockState, 2);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static GenerationPiece getBase(LevelAccessor level, BlockPos pos) {
        int successfulSides = 0;
        GenerationPiece piece = new GenerationPiece((w, p) -> w.m_46859_(p.pos) && Block.m_49936_((BlockGetter)w, (BlockPos)p.pos.m_7495_()));
        BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.m_13971_();
        for (Direction horizontal : Direction.Plane.HORIZONTAL) {
            BlockPos offset;
            int length = 0;
            for (int i = 1; i < 3 && level.m_46859_(offset = pos.m_5484_(horizontal, i)) && Block.m_49936_((BlockGetter)level, (BlockPos)offset.m_7495_()); ++i) {
                ++length;
            }
            if (length <= 0) continue;
            for (int i2 = 1; i2 < length + 1; ++i2) {
                piece.addBlockPiece(corrockBlockState, pos.m_5484_(horizontal, i2));
            }
            ++successfulSides;
        }
        return successfulSides >= 2 ? piece : null;
    }
}

