/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.mixin;

import com.google.common.collect.Lists;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomBalloon;
import com.teamabnormals.endergetic.common.entity.eetle.GliderEetle;
import com.teamabnormals.endergetic.core.interfaces.BalloonHolder;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public final class EntityMixin
implements BalloonHolder {
    private List<BolloomBalloon> balloons = Lists.newArrayList();

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;moveTo(DDDFF)V", shift=At.Shift.AFTER)}, method={"teleportTo"})
    private void updateBalloonPositions(double x, double y, double z, CallbackInfo info) {
        this.balloons.forEach(BolloomBalloon::updateAttachedPosition);
    }

    @Inject(at={@At(value="RETURN")}, method={"unRide"})
    private void detach(CallbackInfo info) {
        EntityMixin entityMixin;
        if (!this.getBalloons().isEmpty()) {
            this.detachBalloons();
        }
        if ((entityMixin = this) instanceof BolloomBalloon) {
            BolloomBalloon balloon = (BolloomBalloon)((Object)entityMixin);
            balloon.detachFromEntity();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    private void preventGliderEetleSuffocationDamage(DamageSource source, CallbackInfoReturnable<Boolean> info) {
        Entity entity;
        if (source == DamageSource.f_19310_ && (entity = (Entity)this).m_6084_() && entity.m_5830_() && entity.m_20202_() instanceof GliderEetle) {
            info.setReturnValue((Object)true);
        }
    }

    @Override
    public List<BolloomBalloon> getBalloons() {
        return this.balloons.isEmpty() ? Collections.emptyList() : Lists.newArrayList(this.balloons);
    }

    @Override
    public void attachBalloon(BolloomBalloon balloon) {
        this.balloons.add(balloon);
    }

    @Override
    public void detachBalloon(BolloomBalloon balloonEntity) {
        this.balloons.remove((Object)balloonEntity);
    }

    @Override
    public void detachBalloons() {
        this.getBalloons().forEach(BolloomBalloon::detachFromEntity);
    }
}

