/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.common.levelgen.configs.CorrockArchConfig;
import com.teamabnormals.endergetic.common.levelgen.configs.CorrockBranchConfig;
import com.teamabnormals.endergetic.common.levelgen.configs.CorrockTowerConfig;
import com.teamabnormals.endergetic.common.levelgen.configs.EndergeticPatchConfig;
import com.teamabnormals.endergetic.common.levelgen.configs.MultiPatchConfig;
import com.teamabnormals.endergetic.common.levelgen.configs.WeightedFeatureConfig;
import com.teamabnormals.endergetic.common.levelgen.feature.BolloomBudFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.EetleEggPatchFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.EndergeticEndGatewayFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.EumusPatchFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.PoiseBushFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.PoiseClusterFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.PoiseDomeFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.PoiseTreeFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.PuffBugHiveFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.SpeckledCorrockPatchFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.TallPoiseBushFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.WeightedMultiFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.CorrockArchFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.CorrockBranchFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.CorrockGroundPatchFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.CorrockPatchFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.CorrockShelfFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.tower.LargeCorrockTowerFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.tower.MediumCorrockTowerFeature;
import com.teamabnormals.endergetic.common.levelgen.feature.corrock.tower.SmallCorrockTowerFeature;
import com.teamabnormals.endergetic.common.levelgen.placement.HeightmapSpreadDoublePlacement;
import com.teamabnormals.endergetic.common.levelgen.placement.HeightmapSpreadLowerPlacement;
import com.teamabnormals.endergetic.common.levelgen.placement.NoiseHeightmap32Placement;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class EEFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"endergetic");
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> POISE_BUSH_PATCH = FEATURES.register("poise_bush_patch", () -> new PoiseBushFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> TALL_POISE_BUSH_PATCH = FEATURES.register("tall_poise_bush_patch", () -> new TallPoiseBushFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> POISE_CLUSTER = FEATURES.register("poise_cluster", () -> new PoiseClusterFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> BOLLOOM_BUD = FEATURES.register("bolloom_bud", () -> new BolloomBudFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> PUFFBUG_HIVE = FEATURES.register("puffbug_hive", () -> new PuffBugHiveFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> POISE_DOME = FEATURES.register("poise_dome", () -> new PoiseDomeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> POISE_TREE = FEATURES.register("poise_tree", () -> new PoiseTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<EndergeticPatchConfig>> CORROCK_PATCH = FEATURES.register("corrock_patch", () -> new CorrockPatchFeature(EndergeticPatchConfig.CODEC));
    public static final RegistryObject<Feature<DiskConfiguration>> CORROCK_GROUND_PATCH = FEATURES.register("corrock_ground_patch", () -> new CorrockGroundPatchFeature((Codec<DiskConfiguration>)DiskConfiguration.f_67618_));
    public static final RegistryObject<Feature<CorrockBranchConfig>> CORROCK_BRANCH = FEATURES.register("corrock_branch", () -> new CorrockBranchFeature(CorrockBranchConfig.CODEC));
    public static final RegistryObject<Feature<ProbabilityFeatureConfiguration>> SMALL_CORROCK_TOWER = FEATURES.register("small_corrock_tower", () -> new SmallCorrockTowerFeature((Codec<ProbabilityFeatureConfiguration>)ProbabilityFeatureConfiguration.f_67858_));
    public static final RegistryObject<Feature<CorrockTowerConfig>> MEDIUM_CORROCK_TOWER = FEATURES.register("medium_corrock_tower", () -> new MediumCorrockTowerFeature(CorrockTowerConfig.CODEC));
    public static final RegistryObject<Feature<CorrockTowerConfig>> LARGE_CORROCK_TOWER = FEATURES.register("large_corrock_tower", () -> new LargeCorrockTowerFeature(CorrockTowerConfig.CODEC));
    public static final RegistryObject<Feature<ProbabilityFeatureConfiguration>> CORROCK_SHELF = FEATURES.register("corrock_shelf", () -> new CorrockShelfFeature((Codec<ProbabilityFeatureConfiguration>)ProbabilityFeatureConfiguration.f_67858_));
    public static final RegistryObject<Feature<CorrockArchConfig>> CORROCK_ARCH = FEATURES.register("corrock_arch", () -> new CorrockArchFeature(CorrockArchConfig.CODEC));
    public static final RegistryObject<Feature<EndergeticPatchConfig>> EETLE_EGG = FEATURES.register("eetle_egg", () -> new EetleEggPatchFeature(EndergeticPatchConfig.CODEC));
    public static final RegistryObject<Feature<MultiPatchConfig>> EUMUS_PATCH = FEATURES.register("eumus_patch", () -> new EumusPatchFeature(MultiPatchConfig.CODEC));
    public static final RegistryObject<Feature<MultiPatchConfig>> SPECKLED_CORROCK_PATCH = FEATURES.register("speckled_corrock_patch", () -> new SpeckledCorrockPatchFeature(MultiPatchConfig.CODEC));
    public static final RegistryObject<Feature<WeightedFeatureConfig>> WEIGHTED_FEATURES = FEATURES.register("weighted_features", () -> new WeightedMultiFeature(WeightedFeatureConfig.CODEC));
    public static final RegistryObject<Feature<EndGatewayConfiguration>> ENDERGETIC_END_GATEWAY = FEATURES.register("end_gateway", () -> new EndergeticEndGatewayFeature((Codec<EndGatewayConfiguration>)EndGatewayConfiguration.f_67639_));

    public static final class EEPlacedFeatures {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"endergetic");
        public static final RegistryObject<PlacedFeature> POISE_DOME = EEPlacedFeatures.register("poise_dome", EEConfiguredFeatures.POISE_DOME, new PlacementModifier[]{PlacementUtils.m_195364_((int)3, (float)0.02f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> POISE_TREE = EEPlacedFeatures.register("poise_tree", EEConfiguredFeatures.POISE_TREE, new PlacementModifier[]{PlacementUtils.m_195364_((int)2, (float)0.05f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> POISE_CLUSTER = EEPlacedFeatures.register("poise_cluster", EEConfiguredFeatures.POISE_CLUSTER, new PlacementModifier[]{new NoiseHeightmap32Placement(-0.8, 4, 22), BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PUFF_BUG_HIVE = EEPlacedFeatures.register("puff_bug_hive", EEConfiguredFeatures.PUFF_BUG_HIVE, new PlacementModifier[]{new NoiseHeightmap32Placement(-0.8, 8, 23), BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> BOLLOOM_BUD = EEPlacedFeatures.register("bolloom_bud", EEConfiguredFeatures.BOLLOOM_BUD, new PlacementModifier[]{new NoiseHeightmap32Placement(-0.9, 90, 90), BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> POISE_BUSH_PATCH = EEPlacedFeatures.register("poise_bush_patch", EEConfiguredFeatures.POISE_BUSH_PATCH, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), PlacementUtils.f_195356_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> TALL_POISE_BUSH_PATCH = EEPlacedFeatures.register("tall_poise_bush_patch", EEConfiguredFeatures.TALL_POISE_BUSH_PATCH, new PlacementModifier[]{new NoiseHeightmap32Placement(-0.8, 2, 8), PlacementUtils.f_195356_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CORROCK_PATCH = EEPlacedFeatures.register("corrock_patch", EEConfiguredFeatures.CORROCK_PATCH, new PlacementModifier[]{CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), HeightmapSpreadDoublePlacement.MOTION_BLOCKING, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> DISK_CORROCK = EEPlacedFeatures.register("disk_corrock", EEConfiguredFeatures.DISK_CORROCK, new PlacementModifier[]{BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> SPARSE_CORROCK_BRANCH = EEPlacedFeatures.register("sparse_corrock_branch", EEConfiguredFeatures.EXTRA_BRANCH_DECORATIONS_CORROCK_BRANCH, new PlacementModifier[]{CountPlacement.m_191628_((int)5), InSquarePlacement.m_191715_(), HeightmapSpreadDoublePlacement.MOTION_BLOCKING, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CORROCK_BRANCH = EEPlacedFeatures.register("corrock_branch", EEConfiguredFeatures.EXTRA_CROWNS_CORROCK_BRANCH, new PlacementModifier[]{CountPlacement.m_191628_((int)64), InSquarePlacement.m_191715_(), HeightmapSpreadDoublePlacement.MOTION_BLOCKING, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CORROCK_TOWER = EEPlacedFeatures.register("corrock_tower", EEConfiguredFeatures.CORROCK_TOWER, new PlacementModifier[]{CountPlacement.m_191628_((int)128), InSquarePlacement.m_191715_(), HeightmapSpreadDoublePlacement.MOTION_BLOCKING, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CORROCK_SHELF = EEPlacedFeatures.register("corrock_shelf", EEConfiguredFeatures.CORROCK_SHELF, new PlacementModifier[]{CountPlacement.m_191628_((int)8), InSquarePlacement.m_191715_(), HeightmapSpreadLowerPlacement.INSTANCE, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> CORROCK_ARCH = EEPlacedFeatures.register("corrock_arch", EEConfiguredFeatures.CORROCK_ARCH, new PlacementModifier[]{CountPlacement.m_191628_((int)26), InSquarePlacement.m_191715_(), HeightmapSpreadDoublePlacement.MOTION_BLOCKING, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> EETLE_EGG_PATCH = EEPlacedFeatures.register("eetle_egg_patch", EEConfiguredFeatures.EETLE_EGG_PATCH, new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> EUMUS_PATCH = EEPlacedFeatures.register("eumus_patch", EEConfiguredFeatures.EUMUS_PATCH, new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), HeightmapSpreadDoublePlacement.MOTION_BLOCKING, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> SPECKLED_CORROCK_PATCH = EEPlacedFeatures.register("speckled_corrock", EEConfiguredFeatures.SPECKLED_CORROCK_PATCH, new PlacementModifier[]{RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, PlacementModifier ... placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)feature.getHolder().get(), (List)ImmutableList.copyOf((Object[])placementModifiers)));
        }
    }

    public static final class EEConfiguredFeatures {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"endergetic");
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> POISE_DOME = EEConfiguredFeatures.register("poise_dome", () -> new ConfiguredFeature((Feature)POISE_DOME.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> POISE_TREE = EEConfiguredFeatures.register("poise_tree", () -> new ConfiguredFeature((Feature)POISE_TREE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> POISE_CLUSTER = EEConfiguredFeatures.register("poise_cluster", () -> new ConfiguredFeature((Feature)POISE_CLUSTER.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PUFF_BUG_HIVE = EEConfiguredFeatures.register("puff_bug_hive", () -> new ConfiguredFeature((Feature)PUFFBUG_HIVE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> BOLLOOM_BUD = EEConfiguredFeatures.register("bolloom_bud", () -> new ConfiguredFeature((Feature)BOLLOOM_BUD.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> POISE_BUSH_PATCH = EEConfiguredFeatures.register("poise_bush_patch", () -> new ConfiguredFeature((Feature)POISE_BUSH_PATCH.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> TALL_POISE_BUSH_PATCH = EEConfiguredFeatures.register("tall_poise_bush_patch", () -> new ConfiguredFeature((Feature)TALL_POISE_BUSH_PATCH.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<EndergeticPatchConfig, ?>> CORROCK_PATCH = EEConfiguredFeatures.register("corrock_patch", () -> new ConfiguredFeature((Feature)CORROCK_PATCH.get(), (FeatureConfiguration)new EndergeticPatchConfig(0.175f, false)));
        public static final RegistryObject<ConfiguredFeature<DiskConfiguration, ?>> DISK_CORROCK = EEConfiguredFeatures.register("disk_corrock", () -> new ConfiguredFeature((Feature)CORROCK_GROUND_PATCH.get(), (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)((Block)EEBlocks.CORROCK_END_BLOCK.get())), BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_50259_}), (IntProvider)UniformInt.m_146622_((int)2, (int)3), 3)));
        public static final RegistryObject<ConfiguredFeature<CorrockBranchConfig, ?>> EXTRA_BRANCH_DECORATIONS_CORROCK_BRANCH = EEConfiguredFeatures.register("extra_branch_decorations_corrock_branch", () -> new ConfiguredFeature((Feature)CORROCK_BRANCH.get(), (FeatureConfiguration)new CorrockBranchConfig((List<BlockState>)ImmutableList.of((Object)Blocks.f_50259_.m_49966_(), (Object)((Block)EEBlocks.CORROCK_END_BLOCK.get()).m_49966_()), 0.4f, 0.5f)));
        public static final RegistryObject<ConfiguredFeature<CorrockBranchConfig, ?>> EXTRA_CROWNS_CORROCK_BRANCH = EEConfiguredFeatures.register("extra_crowns_corrock_branch", () -> new ConfiguredFeature((Feature)CORROCK_BRANCH.get(), (FeatureConfiguration)new CorrockBranchConfig((List<BlockState>)ImmutableList.of((Object)((Block)EEBlocks.CORROCK_END_BLOCK.get()).m_49966_(), (Object)((Block)EEBlocks.EUMUS.get()).m_49966_()), 0.5f, 0.4f)));
        public static final RegistryObject<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> SMALL_CORROCK_TOWER = EEConfiguredFeatures.register("small_corrock_tower", () -> new ConfiguredFeature((Feature)SMALL_CORROCK_TOWER.get(), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.25f)));
        public static final RegistryObject<ConfiguredFeature<CorrockTowerConfig, ?>> MEDIUM_CORROCK_TOWER = EEConfiguredFeatures.register("medium_corrock_tower", () -> new ConfiguredFeature((Feature)MEDIUM_CORROCK_TOWER.get(), (FeatureConfiguration)new CorrockTowerConfig(3, 4, 0.7f, 0.075f)));
        public static final RegistryObject<ConfiguredFeature<CorrockTowerConfig, ?>> LARGE_CORROCK_TOWER = EEConfiguredFeatures.register("large_corrock_tower", () -> new ConfiguredFeature((Feature)LARGE_CORROCK_TOWER.get(), (FeatureConfiguration)new CorrockTowerConfig(2, 5, 0.9f, 0.1f)));
        public static final RegistryObject<ConfiguredFeature<WeightedFeatureConfig, ?>> CORROCK_TOWER = EEConfiguredFeatures.register("corrock_tower", () -> new ConfiguredFeature((Feature)WEIGHTED_FEATURES.get(), (FeatureConfiguration)WeightedFeatureConfig.createFromPairs(Pair.of((Object)((Holder)SMALL_CORROCK_TOWER.getHolder().get()), (Object)6), Pair.of((Object)((Holder)MEDIUM_CORROCK_TOWER.getHolder().get()), (Object)12), Pair.of((Object)((Holder)LARGE_CORROCK_TOWER.getHolder().get()), (Object)4))));
        public static final RegistryObject<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> CORROCK_SHELF = EEConfiguredFeatures.register("corrock_shelf", () -> new ConfiguredFeature((Feature)CORROCK_SHELF.get(), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.75f)));
        public static final RegistryObject<ConfiguredFeature<CorrockArchConfig, ?>> CORROCK_ARCH = EEConfiguredFeatures.register("corrock_arch", () -> new ConfiguredFeature((Feature)CORROCK_ARCH.get(), (FeatureConfiguration)new CorrockArchConfig(0.1f, 0.25f, 13.0f, 22.0f, 7.0f)));
        public static final RegistryObject<ConfiguredFeature<EndergeticPatchConfig, ?>> EETLE_EGG_PATCH = EEConfiguredFeatures.register("eetle_egg_patch", () -> new ConfiguredFeature((Feature)EETLE_EGG.get(), (FeatureConfiguration)new EndergeticPatchConfig(0.75f, false)));
        public static final RegistryObject<ConfiguredFeature<MultiPatchConfig, ?>> EUMUS_PATCH = EEConfiguredFeatures.register("eumus_patch", () -> new ConfiguredFeature((Feature)EUMUS_PATCH.get(), (FeatureConfiguration)new MultiPatchConfig(2, 3)));
        public static final RegistryObject<ConfiguredFeature<MultiPatchConfig, ?>> SPECKLED_CORROCK_PATCH = EEConfiguredFeatures.register("speckled_corrock_patch", () -> new ConfiguredFeature((Feature)SPECKLED_CORROCK_PATCH.get(), (FeatureConfiguration)new MultiPatchConfig(2, 3)));

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, Supplier<ConfiguredFeature<FC, F>> feature) {
            return CONFIGURED_FEATURES.register(name, feature);
        }
    }
}

