/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.registry;

import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.client.particle.CorrockCrownParticle;
import com.teamabnormals.endergetic.client.particle.FastBlockParticle;
import com.teamabnormals.endergetic.client.particle.PoiseBubbleParticle;
import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EEParticleTypes {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"endergetic");
    public static final RegistryObject<SimpleParticleType> POISE_BUBBLE = EEParticleTypes.createBasicParticleType(true, "poise_bubble");
    public static final RegistryObject<SimpleParticleType> SHORT_POISE_BUBBLE = EEParticleTypes.createBasicParticleType(true, "short_poise_bubble");
    public static final RegistryObject<SimpleParticleType> ENDER_FLAME = EEParticleTypes.createBasicParticleType(true, "ender_flame");
    public static final RegistryObject<ParticleType<BlockParticleOption>> FAST_BLOCK = EEParticleTypes.createParticleType("fast_block", BlockParticleOption.f_123624_, BlockParticleOption::m_123634_);
    public static final RegistryObject<ParticleType<CorrockCrownParticleData>> OVERWORLD_CROWN = EEParticleTypes.createParticleType("overworld_crown", CorrockCrownParticleData.DESERIALIZER, CorrockCrownParticleData::codec);
    public static final RegistryObject<ParticleType<CorrockCrownParticleData>> NETHER_CROWN = EEParticleTypes.createParticleType("nether_crown", CorrockCrownParticleData.DESERIALIZER, CorrockCrownParticleData::codec);
    public static final RegistryObject<ParticleType<CorrockCrownParticleData>> END_CROWN = EEParticleTypes.createParticleType("end_crown", CorrockCrownParticleData.DESERIALIZER, CorrockCrownParticleData::codec);

    private static RegistryObject<SimpleParticleType> createBasicParticleType(boolean alwaysShow, String name) {
        return PARTICLES.register(name, () -> new SimpleParticleType(alwaysShow));
    }

    private static <T extends ParticleOptions> RegistryObject<ParticleType<T>> createParticleType(String name, ParticleOptions.Deserializer<T> deserializer, Function<ParticleType<T>, Codec<T>> function) {
        return PARTICLES.register(name, () -> new ParticleTypeWithData(deserializer, function));
    }

    static class ParticleTypeWithData<T extends ParticleOptions>
    extends ParticleType<T> {
        private final Function<ParticleType<T>, Codec<T>> function;

        public ParticleTypeWithData(ParticleOptions.Deserializer<T> deserializer, Function<ParticleType<T>, Codec<T>> function) {
            super(false, deserializer);
            this.function = function;
        }

        public Codec<T> m_7652_() {
            return this.function.apply(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="endergetic", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class RegisterParticleFactories {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerParticleTypes(RegisterParticleProvidersEvent event) {
            ParticleEngine particleManager = Minecraft.m_91087_().f_91061_;
            if (ENDER_FLAME.isPresent()) {
                particleManager.m_107378_((ParticleType)ENDER_FLAME.get(), FlameParticle.Provider::new);
            }
            if (POISE_BUBBLE.isPresent()) {
                particleManager.m_107378_((ParticleType)POISE_BUBBLE.get(), PoiseBubbleParticle.Factory::new);
            }
            if (SHORT_POISE_BUBBLE.isPresent()) {
                particleManager.m_107378_((ParticleType)SHORT_POISE_BUBBLE.get(), PoiseBubbleParticle.ShortFactory::new);
            }
            if (FAST_BLOCK.isPresent()) {
                particleManager.m_107381_((ParticleType)FAST_BLOCK.get(), (ParticleProvider)new FastBlockParticle.Factory());
            }
            if (OVERWORLD_CROWN.isPresent()) {
                particleManager.m_107378_((ParticleType)OVERWORLD_CROWN.get(), CorrockCrownParticle.Factory::new);
            }
            if (NETHER_CROWN.isPresent()) {
                particleManager.m_107378_((ParticleType)NETHER_CROWN.get(), CorrockCrownParticle.Factory::new);
            }
            if (END_CROWN.isPresent()) {
                particleManager.m_107378_((ParticleType)END_CROWN.get(), CorrockCrownParticle.Factory::new);
            }
        }
    }
}

