/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage1;

import cpw.mods.modlauncher.api.ITransformationService;
import gg.essential.loader.stage1.EssentialTransformationServiceBase;
import gg.essential.loader.stage1.util.FallbackTransformationService;
import gg.essential.loader.stage1.util.IDelegatingTransformationService;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EssentialTransformationService
extends EssentialTransformationServiceBase
implements IDelegatingTransformationService {
    private static final Logger LOGGER = LogManager.getLogger(EssentialTransformationServiceBase.class);
    private static final String KEY_LOADED = "gg.essential.loader.stage1.loaded";
    private static final String MC_VERSION = "1.17.1";

    public EssentialTransformationService(ITransformationService stage0) throws Exception {
        super(stage0, FallbackTransformationService::new, "modlauncher9", MC_VERSION);
        List<Path> sourceFiles = this.getSourceFiles(stage0.getClass());
        if (sourceFiles.isEmpty()) {
            LOGGER.error("Not able to determine current file. Mod will NOT work");
            return;
        }
        for (Path sourceFile : sourceFiles) {
            this.setupSourceFile(sourceFile);
        }
    }

    private void setupSourceFile(Path sourceFile) throws Exception {
        Path normalizedSourceFile = sourceFile.normalize();
        Field foundField = ModDirTransformerDiscoverer.class.getDeclaredField("found");
        foundField.setAccessible(true);
        ((List)foundField.get(null)).removeIf(namedPath -> Arrays.stream(namedPath.paths()).anyMatch(path -> path.normalize().equals(normalizedSourceFile)));
    }

    private List<Path> getSourceFiles(Class<?> stage0Class) {
        return stage0Class.getModule().getLayer().configuration().findModule(stage0Class.getModule().getName()).flatMap(rm -> rm.reference().location()).map(Path::of).stream().collect(Collectors.toList());
    }
}

