/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered;

import com.google.common.base.Function;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.stereowalker.tiered.TieredClientSegment;
import com.stereowalker.tiered.api.AttributeTemplate;
import com.stereowalker.tiered.api.ModifierUtils;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.compat.CuriosCompat;
import com.stereowalker.tiered.data.PoolDataLoader;
import com.stereowalker.tiered.data.TierAffixer;
import com.stereowalker.tiered.data.TierDataLoader;
import com.stereowalker.tiered.network.protocol.game.ClientboundTierSyncerPacket;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.handler.AnvilContentChangeHandler;
import com.stereowalker.unionlib.insert.handler.MenuHandler;
import com.stereowalker.unionlib.insert.handler.PlayerInsertHandler;
import com.stereowalker.unionlib.insert.handler.living.LivingInsertHandler;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.ModHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tiered")
public class Tiered
extends MinecraftMod
implements PacketHolder {
    public static final TierDataLoader TIER_DATA = new TierDataLoader();
    public static final PoolDataLoader POOL_DATA = new PoolDataLoader();
    public static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6C"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0E"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48F"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB151"), UUID.fromString("4a88bc27-9563-4eeb-96d5-fe50917cc24f"), UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7a"), UUID.fromString("3ac44786-fd3d-43db-8283-6822f7d62ea4"), UUID.fromString("2671f9f5-4ca6-4d09-b4bb-b958ac6d31e7"), UUID.fromString("31a9945e-2c8d-4894-86b6-87ba416c2e18"), UUID.fromString("63360860-88b6-4395-a561-151cd51dc91b"), UUID.fromString("7ec914a0-7b1d-4bec-ba17-d435ffa49eb4"), UUID.fromString("2dcd3ee4-cadb-4fa4-9bd4-b90b67ab77ff"), UUID.fromString("031de3a3-4368-4021-a6b1-42e8c454cfc1"), UUID.fromString("62c90c65-0f18-4d8d-afb2-340e5ff17fc5"), UUID.fromString("b8c433d5-1ae0-4ab1-9a40-000a6aab3f29"), UUID.fromString("b340cc35-ef8e-4fa6-b21f-9a60e5d4e4b3"), UUID.fromString("24cf925c-bfac-4729-9bad-57e1dc4502f7"), UUID.fromString("1732e8f1-8c5e-4f1f-aa34-b2489b4259c9")};
    public static final Map<String, UUID> CURIO_MODIFIERS = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> map.put("ring", UUID.fromString("fee48d8c-1b51-4c46-9f4b-c58162623a7b")));
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String NBT_SUBTAG_KEY = "Tiered";
    public static final String NBT_SUBTAG_DATA_KEY = "Tier";
    public static Tiered instance;

    public static ResourceLocation getKey(PotentialAttribute tier) {
        return TIER_DATA.getTiers().entrySet().stream().filter(entry -> tier.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().get();
    }

    public Tiered() {
        super("survive", () -> new TieredClientSegment(), () -> new ServerSegment());
        instance = this;
    }

    public void onModConstruct() {
        UnionLib.Modulo.Default_Bow_Draw_Speed.enable();
        if (ModHelper.isCuriosLoaded()) {
            boolean useCurios = false;
            try {
                Class.forName("top.theillusivec4.curios.api.event.CurioAttributeModifierEvent");
                useCurios = true;
            }
            catch (Exception e) {
                System.err.println("Curios support was disabled because the modifier event was not present");
            }
            if (useCurios) {
                CuriosCompat.load();
            }
        }
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
        reloadListener.listenTo((ReloadListener)TIER_DATA);
        reloadListener.listenTo((ReloadListener)POOL_DATA);
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)Inserts.LOGGED_IN, (InsertHandler.Insert)((PlayerInsertHandler.PlayerInsert)player -> {
            if (player.m_9236_().f_46443_) {
                return;
            }
            new ClientboundTierSyncerPacket(TIER_DATA.getTiers()).send((ServerPlayer)player);
        }));
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, (InsertHandler.Insert)((MenuHandler.EntityJoinLevelInsert)(player, menu) -> menu.m_38927_().forEach(Tiered::attemptToAffixTier)));
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, (InsertHandler.Insert)((LivingInsertHandler.LivingInsert)living -> {
            if (living instanceof TierAffixer) {
                TierAffixer affixer = (TierAffixer)living;
                if (affixer.InvCopy() == null) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((NonNullList<ItemStack>)affixer.player().f_36093_.f_35974_));
                    affixer.player().f_36093_.f_35974_.forEach(Tiered::attemptToAffixTier);
                }
                if (!affixer.player().f_36093_.f_35974_.equals(affixer.InvCopy())) {
                    affixer.SetInvCopy(affixer.copyDefaultedList((NonNullList<ItemStack>)affixer.player().f_36093_.f_35974_));
                    affixer.player().f_36093_.f_35974_.forEach(Tiered::attemptToAffixTier);
                }
            }
        }));
        collector.addInsert((InsertHandler)Inserts.ANVIL_CONTENT_CHANGE, (InsertHandler.Insert)((AnvilContentChangeHandler.AnvilContentChangeInsert)(left, right, name, player, output, cost, materialCost, cancel) -> {
            if (!left.m_41768_() && left.m_41737_(NBT_SUBTAG_KEY) != null) {
                PotentialAttribute reforgedAttribute = TIER_DATA.getTiers().get(new ResourceLocation(left.m_41737_(NBT_SUBTAG_KEY).m_128461_(NBT_SUBTAG_DATA_KEY)));
                if (reforgedAttribute.getReforgeItem() != null) {
                    if (RegistryHelper.getItemKey((Item)right.m_41720_()).equals((Object)new ResourceLocation(reforgedAttribute.getReforgeItem())) && right.m_41776_() - right.m_41773_() >= reforgedAttribute.getReforgeDurabilityCost()) {
                        ItemStack copy = left.m_41777_();
                        copy.m_41749_(NBT_SUBTAG_KEY);
                        output.set((Object)copy);
                        cost.set((Object)reforgedAttribute.getReforgeExperienceCost());
                    }
                } else {
                    LOGGER.info(Tiered.getKey(reforgedAttribute) + " cannot be reforged because it either does not provide any reforging info or the info it provides is not complete");
                }
            }
        }));
    }

    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(ItemRegistries.class);
        MinecraftForge.EVENT_BUS.addListener(ItemRegistries::trade);
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
        if (populator.isToolTab()) {
            populator.addItems(new Item[]{ItemRegistries.ARMORERS_HAMMER});
            populator.addItems(new Item[]{ItemRegistries.TOOLSMITHS_HAMMER});
            populator.addItems(new Item[]{ItemRegistries.WEAPONSMITHS_HAMMER});
        }
    }

    public static void attemptToAffixTier(ItemStack stack) {
        ResourceLocation potentialAttributeID;
        if (stack.m_41737_(NBT_SUBTAG_KEY) == null && !stack.m_41619_() && (potentialAttributeID = ModifierUtils.getRandomAttributeIDFor(stack.m_41720_())) != null) {
            stack.m_41698_(NBT_SUBTAG_KEY).m_128359_(NBT_SUBTAG_DATA_KEY, potentialAttributeID.toString());
        }
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation("tiered", path);
    }

    public static boolean isPreferredEquipmentSlot(ItemStack stack, EquipmentSlot slot) {
        if (stack.m_41720_() instanceof ArmorItem) {
            ArmorItem item = (ArmorItem)stack.m_41720_();
            return VersionHelper.isEquippableInSlot((ArmorItem)item, (EquipmentSlot)slot);
        }
        if (stack.m_41720_() instanceof ShieldItem) {
            return slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND;
        }
        return slot == EquipmentSlot.MAINHAND;
    }

    public static boolean isPreferredAccessorySlot(ItemStack stack, AccessorySlot slot) {
        if (stack.m_41720_() instanceof AccessoryItem) {
            AccessoryItem item = (AccessoryItem)stack.m_41720_();
            return item.getAccessorySlots().contains(slot);
        }
        return false;
    }

    public static boolean isPreferredAccessorySlot(ItemStack stack, AccessorySlot.Group group) {
        for (AccessorySlot slot : AccessorySlot.values()) {
            if (slot.getGroup() != group || Tiered.isPreferredAccessorySlot(stack, slot)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPreferredCurioSlot(ItemStack stack, String slot) {
        return stack.m_204117_(TagKey.m_203882_((ResourceKey)RegistryHelper.itemKey(), (ResourceLocation)new ResourceLocation("curios", slot)));
    }

    public void registerPackets(PacketCollector collector) {
        collector.registerClientboundPacket(new ResourceLocation("tiered", "tier_sync"), ClientboundTierSyncerPacket.class, ClientboundTierSyncerPacket::new);
    }

    public static <T> Multimap<Attribute, AttributeModifier> AppendAttributesToOriginal(ItemStack stack, T slot, boolean isPreferredSlot, String customAttributes, Multimap<Attribute, AttributeModifier> original, Function<AttributeTemplate, T[]> requiredSlotsArray, Function<AttributeTemplate, T[]> optionalSlotsArray, BiConsumer<AttributeTemplate, Multimap<Attribute, AttributeModifier>> realize) {
        LinkedListMultimap newMap = LinkedListMultimap.create();
        newMap.putAll(original);
        if (stack.m_41737_(NBT_SUBTAG_KEY) != null) {
            PotentialAttribute potentialAttribute;
            ResourceLocation tier = new ResourceLocation(stack.m_41698_(NBT_SUBTAG_KEY).m_128461_(NBT_SUBTAG_DATA_KEY));
            if (!(stack.m_41782_() && stack.m_41783_().m_128425_(customAttributes, 9) || (potentialAttribute = TIER_DATA.getTiers().get(tier)) == null)) {
                potentialAttribute.getAttributes().forEach(arg_0 -> Tiered.lambda$AppendAttributesToOriginal$8(requiredSlotsArray, slot, realize, (Multimap)newMap, optionalSlotsArray, isPreferredSlot, arg_0));
            }
        }
        return newMap;
    }

    private static /* synthetic */ void lambda$AppendAttributesToOriginal$8(Function requiredSlotsArray, Object slot, BiConsumer realize, Multimap newMap, Function optionalSlotsArray, boolean isPreferredSlot, AttributeTemplate template) {
        ArrayList<Object> optionalSlots;
        ArrayList<Object> requiredSlots;
        if (requiredSlotsArray.apply((Object)template) != null && (requiredSlots = new ArrayList<Object>(Arrays.asList((Object[])requiredSlotsArray.apply((Object)template)))).contains(slot)) {
            realize.accept(template, newMap);
        }
        if (optionalSlotsArray.apply((Object)template) != null && (optionalSlots = new ArrayList<Object>(Arrays.asList((Object[])optionalSlotsArray.apply((Object)template)))).contains(slot) && isPreferredSlot) {
            realize.accept(template, newMap);
        }
    }

    @RegistryHolder(registry=Item.class, namespace="tiered")
    public class ItemRegistries {
        @RegistryObject(value="armorers_hammer")
        public static final Item ARMORERS_HAMMER = new Item(new Item.Properties().m_41499_(20));
        @RegistryObject(value="toolsmiths_hammer")
        public static final Item TOOLSMITHS_HAMMER = new Item(new Item.Properties().m_41499_(20));
        @RegistryObject(value="weaponsmiths_hammer")
        public static final Item WEAPONSMITHS_HAMMER = new Item(new Item.Properties().m_41499_(20));

        public static void trade(VillagerTradesEvent event) {
            if (event.getType() == VillagerProfession.f_35586_) {
                ((List)event.getTrades().get(3)).add(new VillagerTrades.ItemsForEmeralds(ARMORERS_HAMMER, 64, 1, 1, 10));
            }
            if (event.getType() == VillagerProfession.f_35598_) {
                ((List)event.getTrades().get(3)).add(new VillagerTrades.ItemsForEmeralds(TOOLSMITHS_HAMMER, 64, 1, 1, 10));
            }
            if (event.getType() == VillagerProfession.f_35599_) {
                ((List)event.getTrades().get(4)).add(new VillagerTrades.ItemsForEmeralds(WEAPONSMITHS_HAMMER, 64, 1, 1, 10));
            }
        }
    }
}

