/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.stereowalker.tiered.api.TierPool;
import com.stereowalker.unionlib.resource.ReloadListener;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PoolDataLoader
extends SimpleJsonResourceReloadListener
implements ReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String PARSING_ERROR_MESSAGE = "Parsing error loading recipe {}";
    private static final String LOADED_RECIPES_MESSAGE = "Loaded {} item pools";
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<ResourceLocation, TierPool> itemPools = new HashMap<ResourceLocation, TierPool>();

    public PoolDataLoader() {
        super(GSON, "tiered_modifiers/pools");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        HashMap readItemPools = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : loader.entrySet()) {
            ResourceLocation identifier = entry.getKey();
            try {
                TierPool itemPool = (TierPool)GSON.fromJson(entry.getValue(), TierPool.class);
                if (itemPool.getTiers().isEmpty()) continue;
                readItemPools.put(identifier, itemPool);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error(PARSING_ERROR_MESSAGE, (Object)identifier, (Object)exception);
            }
        }
        this.itemPools = readItemPools;
        LOGGER.info(LOADED_RECIPES_MESSAGE, (Object)readItemPools.size());
    }

    public Map<ResourceLocation, TierPool> getPools() {
        return this.itemPools;
    }

    public void clear() {
        this.itemPools.clear();
    }

    public void replace(Map<ResourceLocation, TierPool> i) {
        this.itemPools = i;
    }

    public ResourceLocation id() {
        return new ResourceLocation("tiered", "pool_data");
    }
}

