/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.network.protocol.game;

import com.google.common.collect.Maps;
import com.stereowalker.tiered.Tiered;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.data.TierDataLoader;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ClientboundTierSyncerPacket
extends ClientboundUnionPacket {
    public int size;
    public Map<ResourceLocation, PotentialAttribute> attribute;
    public static final Map<ResourceLocation, PotentialAttribute> CACHED_ATTRIBUTES = new HashMap<ResourceLocation, PotentialAttribute>();

    public ClientboundTierSyncerPacket(Map<ResourceLocation, PotentialAttribute> attribute) {
        super(Tiered.instance.channel);
        this.attribute = attribute;
        this.size = attribute.size();
    }

    public ClientboundTierSyncerPacket(FriendlyByteBuf buf) {
        super(buf, Tiered.instance.channel);
        this.size = buf.readInt();
        this.attribute = Maps.newHashMap();
        for (int i = 0; i < this.size; ++i) {
            ResourceLocation id = buf.m_130281_();
            PotentialAttribute pa = (PotentialAttribute)TierDataLoader.GSON.fromJson(buf.m_130277_(), PotentialAttribute.class);
            this.attribute.put(id, pa);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.size);
        this.attribute.forEach((id, attribute) -> {
            buf.m_130085_(id);
            buf.m_130070_(TierDataLoader.GSON.toJson(attribute));
        });
    }

    public boolean handleOnClient(LocalPlayer player) {
        CACHED_ATTRIBUTES.putAll(Tiered.TIER_DATA.getTiers());
        Tiered.TIER_DATA.clear();
        Tiered.TIER_DATA.replace(this.attribute);
        if (Tiered.TIER_DATA.getTiers().size() == 0) {
            Tiered.TIER_DATA.replace(CACHED_ATTRIBUTES);
        }
        return true;
    }
}

