/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.crafting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public abstract class StorageDyeRecipeBase
extends CustomRecipe {
    protected StorageDyeRecipeBase(ResourceLocation registryName) {
        super(registryName);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean storagePresent = false;
        boolean dyePresent = false;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (slotStack.m_41619_()) continue;
            if (this.isDyeableStorageItem(slotStack)) {
                if (storagePresent) {
                    return false;
                }
                storagePresent = true;
                continue;
            }
            if (slotStack.m_204117_(Tags.Items.DYES)) {
                dyePresent = true;
                continue;
            }
            return false;
        }
        return storagePresent && dyePresent;
    }

    public ItemStack assemble(CraftingContainer inv) {
        HashMap<Integer, List<DyeColor>> columnDyes = new HashMap<Integer, List<DyeColor>>();
        Tuple columnStorage = null;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (slotStack.m_41619_()) continue;
            Item item = slotStack.m_41720_();
            int column = slot % inv.m_39347_();
            if (this.isDyeableStorageItem(slotStack)) {
                if (columnStorage != null) {
                    return ItemStack.f_41583_;
                }
                columnStorage = new Tuple((Object)column, (Object)slotStack);
                continue;
            }
            if (slotStack.m_204117_(Tags.Items.DYES)) {
                DyeColor dyeColor = DyeColor.getColor((ItemStack)slotStack);
                if (dyeColor == null) {
                    return ItemStack.f_41583_;
                }
                columnDyes.computeIfAbsent(column, c -> new ArrayList()).add(dyeColor);
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (columnStorage == null) {
            return ItemStack.f_41583_;
        }
        ItemStack coloredStorage = ((ItemStack)columnStorage.m_14419_()).m_41777_();
        coloredStorage.m_41764_(1);
        int storageColumn = (Integer)columnStorage.m_14418_();
        this.applyTintColors(columnDyes, coloredStorage, storageColumn);
        return coloredStorage;
    }

    protected abstract boolean isDyeableStorageItem(ItemStack var1);

    private void applyTintColors(Map<Integer, List<DyeColor>> columnDyes, ItemStack coloredStorage, int storageColumn) {
        ArrayList<DyeColor> mainDyes = new ArrayList<DyeColor>();
        ArrayList<DyeColor> trimDyes = new ArrayList<DyeColor>();
        for (Map.Entry<Integer, List<DyeColor>> entry : columnDyes.entrySet()) {
            if (entry.getKey() <= storageColumn) {
                mainDyes.addAll((Collection<DyeColor>)entry.getValue());
            }
            if (entry.getKey() < storageColumn) continue;
            trimDyes.addAll((Collection<DyeColor>)entry.getValue());
        }
        this.applyColors(coloredStorage, mainDyes, trimDyes);
    }

    protected abstract void applyColors(ItemStack var1, List<DyeColor> var2, List<DyeColor> var3);

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 1;
    }
}

