/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;

public abstract class UpgradeItemBase<T extends IUpgradeWrapper>
extends ItemBase
implements IUpgradeItem<T> {
    private final IUpgradeCountLimitConfig upgradeTypeLimitConfig;

    protected UpgradeItemBase(CreativeModeTab itemGroup, IUpgradeCountLimitConfig upgradeTypeLimitConfig) {
        super(new Item.Properties(), itemGroup);
        this.upgradeTypeLimitConfig = upgradeTypeLimitConfig;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.addAll(TranslationHelper.INSTANCE.getTranslatedLines(stack.m_41720_().m_5524_() + ".tooltip", null, ChatFormatting.DARK_GRAY));
    }

    @Override
    public int getUpgradesPerStorage(String storageType) {
        return this.upgradeTypeLimitConfig.getMaxUpgradesPerStorage(storageType, ForgeRegistries.ITEMS.getKey((Object)this));
    }

    @Override
    public int getUpgradesInGroupPerStorage(String storageType) {
        if (this.getUpgradeGroup().isSolo()) {
            return Integer.MAX_VALUE;
        }
        return this.upgradeTypeLimitConfig.getMaxUpgradesInGroupPerStorage(storageType, this.getUpgradeGroup());
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)this.m_5524_());
    }
}

