/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.commands.impl;

import com.google.common.collect.ImmutableSet;
import com.sparkuniverse.toolbox.chat.model.Message;
import gg.essential.Essential;
import gg.essential.api.commands.Command;
import gg.essential.api.commands.DefaultHandler;
import gg.essential.api.commands.DisplayName;
import gg.essential.api.commands.Greedy;
import gg.essential.commands.engine.EssentialFriend;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessagePacket;
import gg.essential.network.connectionmanager.chat.ChatManager;
import gg.essential.util.MinecraftUtils;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandMessage
extends Command {
    private static final ChatManager cm = Essential.getInstance().getConnectionManager().getChatManager();

    public CommandMessage() {
        super("essentialmessage");
    }

    @Override
    @Nullable
    public Set<Command.Alias> getCommandAliases() {
        return ImmutableSet.of((Object)new Command.Alias("emsg"));
    }

    @DefaultHandler
    public void handle(@DisplayName(value="ign") EssentialFriend friend, @DisplayName(value="message") @Greedy String message2) throws ExecutionException, InterruptedException {
        cm.sendMessage(friend.getChannel().getId(), message2, new EarlyResponseHandler(friend));
    }

    public void onConfirm(String message2) {
        MinecraftUtils.INSTANCE.sendMessage(message2);
    }

    private class EarlyResponseHandler
    implements gg.essential.network.connectionmanager.EarlyResponseHandler {
        private final EssentialFriend friend;

        public EarlyResponseHandler(EssentialFriend friend) {
            this.friend = friend;
        }

        @Override
        public void accept(Optional<Packet> packet) {
            if (packet.isPresent() && packet.get() instanceof ServerChatChannelMessagePacket) {
                Message messageObj = (Message)CollectionsKt.first(Arrays.asList(((ServerChatChannelMessagePacket)packet.get()).getMessages()));
                cm.updateReadState(messageObj, true);
                CommandMessage.this.onConfirm("\u00a7dTo " + this.friend.getIgn() + "\u00a7r: " + messageObj.getContents());
            } else {
                CommandMessage.this.onConfirm("Error!");
            }
        }

        @Override
        @NotNull
        public Consumer<Optional<Packet>> andThen(@NotNull Consumer<? super Optional<Packet>> after) {
            return packet -> {};
        }
    }
}

