/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal;

import gg.essential.elementa.impl.commonmark.node.Block;
import gg.essential.elementa.impl.commonmark.node.ThematicBreak;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParserFactory;
import gg.essential.elementa.impl.commonmark.parser.block.BlockContinue;
import gg.essential.elementa.impl.commonmark.parser.block.BlockStart;
import gg.essential.elementa.impl.commonmark.parser.block.MatchedBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.ParserState;

public class ThematicBreakParser
extends AbstractBlockParser {
    private final ThematicBreak block = new ThematicBreak();

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state2) {
        return BlockContinue.none();
    }

    private static boolean isThematicBreak(CharSequence line, int index2) {
        int dashes = 0;
        int underscores = 0;
        int asterisks = 0;
        int length = line.length();
        block6: for (int i2 = index2; i2 < length; ++i2) {
            switch (line.charAt(i2)) {
                case '-': {
                    ++dashes;
                    continue block6;
                }
                case '_': {
                    ++underscores;
                    continue block6;
                }
                case '*': {
                    ++asterisks;
                    continue block6;
                }
                case '\t': 
                case ' ': {
                    continue block6;
                }
                default: {
                    return false;
                }
            }
        }
        return dashes >= 3 && underscores == 0 && asterisks == 0 || underscores >= 3 && dashes == 0 && asterisks == 0 || asterisks >= 3 && dashes == 0 && underscores == 0;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state2, MatchedBlockParser matchedBlockParser) {
            if (state2.getIndent() >= 4) {
                return BlockStart.none();
            }
            int nextNonSpace = state2.getNextNonSpaceIndex();
            CharSequence line = state2.getLine().getContent();
            if (ThematicBreakParser.isThematicBreak(line, nextNonSpace)) {
                return BlockStart.of(new ThematicBreakParser()).atIndex(line.length());
            }
            return BlockStart.none();
        }
    }
}

