/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.svg;

import gg.essential.elementa.impl.dom4j.Document;
import gg.essential.elementa.impl.dom4j.Element;
import gg.essential.elementa.impl.dom4j.io.SAXReader;
import gg.essential.elementa.svg.PathParser;
import gg.essential.elementa.svg.data.Rotation;
import gg.essential.elementa.svg.data.SVG;
import gg.essential.elementa.svg.data.SVGCircle;
import gg.essential.elementa.svg.data.SVGElement;
import gg.essential.elementa.svg.data.SVGLine;
import gg.essential.elementa.svg.data.SVGPolyline;
import gg.essential.elementa.svg.data.SVGRect;
import gg.essential.elementa.svg.data.Transform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgg/essential/elementa/svg/SVGParser;", "", "()V", "VIEWBOX_WHITESPACE", "Lkotlin/text/Regex;", "parseDocument", "Lgg/essential/elementa/svg/data/SVG;", "document", "Lgg/essential/elementa/impl/dom4j/Document;", "parseFromResource", "file", "", "parsePath", "", "Lgg/essential/elementa/svg/data/SVGElement;", "el", "Lgg/essential/elementa/impl/dom4j/Element;", "parseTransform", "Lgg/essential/elementa/svg/data/Transform;", "attributeString", "parseViewbox", "Lgg/essential/elementa/svg/SVGParser$Viewbox;", "Viewbox", "Elementa"})
@SourceDebugExtension(value={"SMAP\nSVGParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGParser.kt\ngg/essential/elementa/svg/SVGParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,109:1\n1849#2,2:110\n1547#2:124\n1618#2,3:125\n150#3,6:112\n150#3,6:118\n*S KotlinDebug\n*F\n+ 1 SVGParser.kt\ngg/essential/elementa/svg/SVGParser\n*L\n45#1:110,2\n86#1:124\n86#1:125,3\n59#1:112,6\n60#1:118,6\n*E\n"})
public final class SVGParser {
    @NotNull
    public static final SVGParser INSTANCE = new SVGParser();
    @NotNull
    private static final Regex VIEWBOX_WHITESPACE = new Regex("[ ,]+");

    private SVGParser() {
    }

    @NotNull
    public final SVG parseFromResource(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SAXReader reader2 = new SAXReader();
        Document document = reader2.read(this.getClass().getResourceAsStream(file));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
        return this.parseDocument(document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SVG parseDocument(Document document) {
        Element svg = document.getRootElement();
        String string = svg.attributeValue("stroke-width", "1");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"svg.attributeValue(\"stroke-width\", \"1\")");
        String string2 = string;
        float svgStrokeWidth = Float.parseFloat(string2);
        boolean svgRoundLineCaps = svg.attributeValue("stroke-linecap") != null;
        boolean svgRoundLineJoins = svg.attributeValue("stroke-linejoin") != null;
        Viewbox viewBox = this.parseViewbox(svg.attributeValue("viewBox"));
        List elements = new ArrayList();
        block16: for (Element element : svg.elements()) {
            List<SVGElement> list;
            List<SVGElement> list2;
            String string3 = element.getName();
            if (string3 == null) throw new UnsupportedOperationException("Element type " + element.getName() + " is not supported!");
            int n = -1;
            switch (string3.hashCode()) {
                case 3433509: {
                    if (string3.equals("path")) {
                        n = 1;
                    }
                    break;
                }
                case 3496420: {
                    if (string3.equals("rect")) {
                        n = 2;
                    }
                    break;
                }
                case 3321844: {
                    if (string3.equals("line")) {
                        n = 3;
                    }
                    break;
                }
                case -1360216880: {
                    if (string3.equals("circle")) {
                        n = 4;
                    }
                    break;
                }
                case 561938880: {
                    if (string3.equals("polyline")) {
                        n = 5;
                    }
                    break;
                }
            }
            switch (n) {
                case 4: {
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                    list2 = CollectionsKt.listOf((Object)SVGCircle.Companion.from$Elementa(element));
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                    list2 = CollectionsKt.listOf((Object)SVGLine.Companion.from$Elementa(element));
                    break;
                }
                case 5: {
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                    list2 = CollectionsKt.listOf((Object)SVGPolyline.Companion.from$Elementa(element));
                    break;
                }
                case 1: {
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                        list = this.parsePath(element);
                    }
                    catch (PathParser.PathParseException e) {
                        e.printStackTrace();
                        break block16;
                    }
                    list2 = list;
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                    list2 = CollectionsKt.listOf((Object)SVGRect.Companion.from$Elementa(element));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Element type " + element.getName() + " is not supported!");
                }
            }
            List<SVGElement> els = list2;
            if (element.attributeValue("transform") != null) {
                List<SVGElement> attribute = list;
                boolean bl = false;
                Transform transform = INSTANCE.parseTransform((String)((Object)attribute));
                Iterable $this$forEach$iv = els;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SVGElement el = (SVGElement)element$iv;
                    boolean bl2 = false;
                    el.getAttributes().setTransform(transform);
                }
            }
            elements.addAll((Collection)els);
        }
        Viewbox viewbox = viewBox;
        Viewbox viewbox2 = viewBox;
        return new SVG(elements, viewbox != null ? Float.valueOf(viewbox.getWidth()) : null, viewbox2 != null ? Float.valueOf(viewbox2.getHeight()) : null, svgStrokeWidth, svgRoundLineCaps, svgRoundLineJoins);
    }

    /*
     * WARNING - void declaration
     */
    private final Transform parseTransform(String attributeString) {
        Object attributes = attributeString;
        Transform transform = new Transform(null, 1, null);
        while (((CharSequence)attributes).length() > 0) {
            String[] stringArray;
            int n;
            int n2;
            int firstOpenParen;
            int n3;
            int n4;
            block11: {
                int n5;
                block10: {
                    CharSequence $this$indexOfFirst$iv = (CharSequence)attributes;
                    boolean $i$f$indexOfFirst = false;
                    n4 = 0;
                    n3 = $this$indexOfFirst$iv.length();
                    while (n4 < n3) {
                        void index$iv;
                        char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                        boolean bl = false;
                        if (it == '(') {
                            n5 = index$iv;
                            break block10;
                        }
                        ++index$iv;
                    }
                    n5 = -1;
                }
                firstOpenParen = n5;
                CharSequence $this$indexOfFirst$iv = (CharSequence)attributes;
                boolean $i$f$indexOfFirst = false;
                n3 = 0;
                n2 = $this$indexOfFirst$iv.length();
                while (n3 < n2) {
                    void index$iv;
                    char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                    boolean bl = false;
                    if (it == ')') {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int firstCloseParen = n;
            String[] $i$f$indexOfFirst = attributes;
            n3 = 0;
            if ($i$f$indexOfFirst == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = $i$f$indexOfFirst.substring(n3, firstOpenParen);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (Intrinsics.areEqual((Object)string, (Object)"rotate")) {
                stringArray = attributes;
                n2 = firstOpenParen + 1;
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
            } else {
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            String string2 = stringArray.substring(n2, firstCloseParen);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            stringArray = new String[]{" "};
            List parameters = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String string3 = (String)CollectionsKt.getOrNull((List)parameters, (int)1);
            String string4 = (String)CollectionsKt.getOrNull((List)parameters, (int)2);
            transform.setRotation(new Rotation(Integer.parseInt((String)CollectionsKt.first((List)parameters)), string3 != null ? StringsKt.toFloatOrNull((String)string3) : null, string4 != null ? StringsKt.toFloatOrNull((String)string4) : null));
            String[] stringArray2 = attributes;
            n4 = firstCloseParen + 1;
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2.substring(n4), (String)"(this as java.lang.String).substring(startIndex)");
        }
        return transform;
    }

    /*
     * WARNING - void declaration
     */
    private final Viewbox parseViewbox(String attributeString) {
        if (attributeString == null) {
            return null;
        }
        try {
            void $this$mapTo$iv$iv;
            String[] stringArray = (String[])attributeString;
            Regex regex = VIEWBOX_WHITESPACE;
            Object object = " ";
            CharSequence charSequence = regex.replace((CharSequence)stringArray, (String)object);
            stringArray = new String[]{" "};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf(Float.parseFloat((String)it)));
            }
            List splits = (List)destination$iv$iv;
            if (splits.size() >= 3 && ((Number)splits.get(2)).floatValue() <= 0.0f) {
                return null;
            }
            if (splits.size() >= 4 && ((Number)splits.get(3)).floatValue() <= 0.0f) {
                return null;
            }
            return new Viewbox(((Number)splits.get(0)).floatValue(), ((Number)splits.get(1)).floatValue(), ((Number)splits.get(2)).floatValue(), ((Number)splits.get(3)).floatValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    private final List<SVGElement> parsePath(Element el) {
        String string = el.attributeValue("d");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"el.attributeValue(\"d\")");
        String string2 = string;
        return new PathParser(((Object)StringsKt.trim((CharSequence)string2)).toString()).parse();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lgg/essential/elementa/svg/SVGParser$Viewbox;", "", "x", "", "y", "width", "height", "(FFFF)V", "getHeight", "()F", "getWidth", "getX", "getY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Elementa"})
    private static final class Viewbox {
        private final float x;
        private final float y;
        private final float width;
        private final float height;

        public Viewbox(float x, float y, float width2, float height2) {
            this.x = x;
            this.y = y;
            this.width = width2;
            this.height = height2;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getHeight() {
            return this.height;
        }

        public final float component1() {
            return this.x;
        }

        public final float component2() {
            return this.y;
        }

        public final float component3() {
            return this.width;
        }

        public final float component4() {
            return this.height;
        }

        @NotNull
        public final Viewbox copy(float x, float y, float width2, float height2) {
            return new Viewbox(x, y, width2, height2);
        }

        public static /* synthetic */ Viewbox copy$default(Viewbox viewbox, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 1) != 0) {
                f = viewbox.x;
            }
            if ((n & 2) != 0) {
                f2 = viewbox.y;
            }
            if ((n & 4) != 0) {
                f3 = viewbox.width;
            }
            if ((n & 8) != 0) {
                f4 = viewbox.height;
            }
            return viewbox.copy(f, f2, f3, f4);
        }

        @NotNull
        public String toString() {
            return "Viewbox(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.x);
            result = result * 31 + Float.hashCode(this.y);
            result = result * 31 + Float.hashCode(this.width);
            result = result * 31 + Float.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Viewbox)) {
                return false;
            }
            Viewbox viewbox = (Viewbox)other;
            if (Float.compare(this.x, viewbox.x) != 0) {
                return false;
            }
            if (Float.compare(this.y, viewbox.y) != 0) {
                return false;
            }
            if (Float.compare(this.width, viewbox.width) != 0) {
                return false;
            }
            return Float.compare(this.height, viewbox.height) == 0;
        }
    }
}

