/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.utils;

import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.components.image.CacheableImage;
import gg.essential.elementa.components.image.MSDFComponent;
import gg.essential.elementa.utils.ResourceCache;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lgg/essential/elementa/utils/ResourceCache;", "", "size", "", "(I)V", "cacheMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lgg/essential/elementa/components/image/CacheableImage;", "getSize", "()I", "getMSDFComponent", "Lgg/essential/elementa/components/image/MSDFComponent;", "path", "getUIImage", "invalidate", "", "invalidateAll", "", "Elementa"})
public final class ResourceCache {
    private final int size;
    @NotNull
    private final ConcurrentHashMap<String, CacheableImage> cacheMap;

    public ResourceCache(int size) {
        this.size = size;
        this.cacheMap = new ConcurrentHashMap();
    }

    public /* synthetic */ ResourceCache(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 50;
        }
        this(n);
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final CacheableImage getUIImage(@NotNull String path) {
        UIImage uIImage;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.cacheMap.size() > this.size) {
            this.cacheMap.clear();
        }
        CacheableImage cacheableImage = this.cacheMap.computeIfAbsent(path, arg_0 -> ResourceCache.getUIImage$lambda$0((Function1)new Function1<String, CacheableImage>(this){
            final /* synthetic */ ResourceCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CacheableImage invoke(@NotNull String pth) {
                Intrinsics.checkNotNullParameter((Object)pth, (String)"pth");
                CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> getUIImage.cachedImage.1.invoke$lambda$0(this.this$0, pth));
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026tream(pth))\n            }");
                return new UIImage(completableFuture, null, null, 6, null);
            }

            private static final BufferedImage invoke$lambda$0(ResourceCache this$0, String $pth) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$pth, (String)"$pth");
                return ImageIO.read(this$0.getClass().getResourceAsStream($pth));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)cacheableImage, (String)"fun getUIImage(path: Str\u2026upply(it)\n        }\n    }");
        CacheableImage cachedImage2 = cacheableImage;
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture<BufferedImage>(null)");
        UIImage it = uIImage = new UIImage(completableFuture, null, null, 6, null);
        boolean bl = false;
        cachedImage2.supply(it);
        return uIImage;
    }

    public final void invalidateAll() {
        this.cacheMap.clear();
    }

    public final boolean invalidate(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.cacheMap.remove(path) != null;
    }

    @NotNull
    public final MSDFComponent getMSDFComponent(@NotNull String path) {
        MSDFComponent mSDFComponent;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.cacheMap.size() > this.size) {
            this.cacheMap.clear();
        }
        CacheableImage cacheableImage = this.cacheMap.computeIfAbsent(path, arg_0 -> ResourceCache.getMSDFComponent$lambda$2((Function1)new Function1<String, CacheableImage>(this){
            final /* synthetic */ ResourceCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CacheableImage invoke(@NotNull String pth) {
                Intrinsics.checkNotNullParameter((Object)pth, (String)"pth");
                CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> getMSDFComponent.cachedImage.1.invoke$lambda$0(this.this$0, pth));
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026tream(pth))\n            }");
                return new MSDFComponent(completableFuture);
            }

            private static final BufferedImage invoke$lambda$0(ResourceCache this$0, String $pth) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$pth, (String)"$pth");
                return ImageIO.read(this$0.getClass().getResourceAsStream($pth));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)cacheableImage, (String)"fun getMSDFComponent(pat\u2026upply(it)\n        }\n    }");
        CacheableImage cachedImage2 = cacheableImage;
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture<BufferedImage>(null)");
        MSDFComponent it = mSDFComponent = new MSDFComponent(completableFuture);
        boolean bl = false;
        cachedImage2.supply(it);
        return mSDFComponent;
    }

    private static final CacheableImage getUIImage$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CacheableImage)$tmp0.invoke(p0);
    }

    private static final CacheableImage getMSDFComponent$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CacheableImage)$tmp0.invoke(p0);
    }

    public ResourceCache() {
        this(0, 1, null);
    }
}

