/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.image.ImageProvider;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.essential.util.GlFrameBuffer;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0017\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ?\u0010\u0014\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0004J'\u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0017H$\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lgg/essential/gui/common/UIFrameBuffer;", "Lgg/essential/elementa/UIComponent;", "Lgg/essential/elementa/components/image/ImageProvider;", "<init>", "()V", "", "delete", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "", "width", "height", "drawFrameBuffer", "(DD)V", "x", "y", "Ljava/awt/Color;", "color", "drawImage", "(Lgg/essential/universal/UMatrixStack;DDDDLjava/awt/Color;)V", "markDirty", "", "render", "(Lgg/essential/universal/UMatrixStack;FF)V", "", "dirty", "Z", "Lgg/essential/util/GlFrameBuffer;", "frameBuffer", "Lgg/essential/util/GlFrameBuffer;", "Essential 1.19.2-forge"})
public abstract class UIFrameBuffer
extends UIComponent
implements ImageProvider {
    private boolean dirty = true;
    @NotNull
    private final GlFrameBuffer frameBuffer = new GlFrameBuffer(0, 0);

    public final void markDirty() {
        this.dirty = true;
    }

    public void delete() {
        this.frameBuffer.delete();
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDraw(matrixStack);
        double x = this.getLeft();
        double y = this.getTop();
        double width2 = this.getWidth();
        double height2 = this.getHeight();
        Color color2 = this.getColor();
        this.drawImage(matrixStack, x, y, width2, height2, color2);
        super.draw(matrixStack);
    }

    public final void drawFrameBuffer(double width2, double height2) {
        if (UResolution.getWindowWidth() == 0 || UResolution.getWindowHeight() == 0) {
            return;
        }
        float mcScale = (float)UResolution.getScaleFactor();
        float realWidth = (float)width2 * mcScale;
        float realHeight = (float)height2 * mcScale;
        int frameWidth = (int)realWidth;
        int frameHeight = (int)realHeight;
        if (frameWidth != this.frameBuffer.getWidth() || frameHeight != this.frameBuffer.getHeight()) {
            this.frameBuffer.resize(frameWidth, frameHeight);
            this.dirty = true;
        }
        if (this.dirty) {
            this.dirty = false;
            GlFrameBuffer.clear$default(this.frameBuffer, null, 0.0, 0, 7, null);
            this.frameBuffer.useAsRenderTarget((Function3<? super UMatrixStack, ? super Integer, ? super Integer, Unit>)((Function3)new Function3<UMatrixStack, Integer, Integer, Unit>(this, realWidth, realHeight){
                final /* synthetic */ UIFrameBuffer this$0;
                final /* synthetic */ float $realWidth;
                final /* synthetic */ float $realHeight;
                {
                    this.this$0 = $receiver;
                    this.$realWidth = $realWidth;
                    this.$realHeight = $realHeight;
                    super(3);
                }

                public final void invoke(@NotNull UMatrixStack stack, int n, int n2) {
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    this.this$0.render(stack, this.$realWidth, this.$realHeight);
                }
            }));
        }
    }

    @Override
    public void drawImage(@NotNull UMatrixStack matrixStack, double x, double y, double width2, double height2, @NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        this.drawFrameBuffer(width2, height2);
        this.frameBuffer.drawTexture(matrixStack, x, y, width2, height2, color2);
    }

    protected abstract void render(@NotNull UMatrixStack var1, float var2, float var3);
}

