/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common.input;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.constraints.animation.AnimatingConstraints;
import gg.essential.elementa.constraints.animation.Animations;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.effects.ScissorEffect;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.events.UIScrollEvent;
import gg.essential.elementa.font.FontProvider;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.utils.TextKt;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.ContextOptionMenu;
import gg.essential.gui.common.input.AbstractTextInput;
import gg.essential.universal.UDesktop;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010 \n\u0002\b\u000f\b&\u0018\u0000 \u00d7\u00012\u00020\u0001:\u0016\u00d6\u0001\u00d7\u0001\u00d8\u0001\u00d9\u0001\u00da\u0001\u00db\u0001\u00dc\u0001\u00dd\u0001\u00de\u0001\u00df\u0001\u00e0\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0094\u0001\u001a\u00020\u00162\u0007\u0010\u0095\u0001\u001a\u00020\u00032\u000b\u0010\u0096\u0001\u001a\u00060.R\u00020\u0000H\u0004J\t\u0010\u0097\u0001\u001a\u00020\u0016H\u0014J\t\u0010\u0098\u0001\u001a\u00020\u0016H\u0016J\u001e\u0010\u0099\u0001\u001a\u0004\u0018\u00010#2\u000b\u0010\u009a\u0001\u001a\u00060.R\u00020\u0000H\u0014\u00a2\u0006\u0003\u0010\u009b\u0001J\u001e\u0010\u009c\u0001\u001a\u0004\u0018\u00010#2\u000b\u0010\u009a\u0001\u001a\u00060.R\u00020\u0000H\u0014\u00a2\u0006\u0003\u0010\u009b\u0001J\u0012\u0010\u009d\u0001\u001a\u00020\u00162\u0007\u0010\u0095\u0001\u001a\u00020\u0003H\u0004J\u0016\u0010\u009e\u0001\u001a\u00020\u00162\u000b\u0010\u009f\u0001\u001a\u00060sR\u00020\u0000H\u0014J,\u0010\u00a0\u0001\u001a\u00020\u00162\u000b\u0010\u00a1\u0001\u001a\u00060.R\u00020\u00002\u000b\u0010\u00a2\u0001\u001a\u00060.R\u00020\u00002\u0007\u0010\u00a3\u0001\u001a\u00020\u0005H\u0004J\t\u0010\u00a4\u0001\u001a\u00020\u0016H\u0014J\t\u0010\u00a5\u0001\u001a\u00020\u0016H\u0014J\u0013\u0010\u00a6\u0001\u001a\u00020\u00162\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001H\u0014J6\u0010\u00a9\u0001\u001a\u00020\u00162\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\u0006\u0010\u0015\u001a\u00020\u00032\u0007\u0010\u00aa\u0001\u001a\u00020:2\u0007\u0010\u00ab\u0001\u001a\u00020:2\u0007\u0010\u00ac\u0001\u001a\u00020\u000fH\u0014J,\u0010\u00a9\u0001\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00032\u0007\u0010\u00aa\u0001\u001a\u00020:2\u0007\u0010\u00ab\u0001\u001a\u00020:2\u0007\u0010\u00ac\u0001\u001a\u00020\u000fH\u0015JR\u0010\u00ad\u0001\u001a\u00020\u00162\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\u0006\u0010\u0015\u001a\u00020\u00032\u0007\u0010\u00aa\u0001\u001a\u00020:2\u0007\u0010\u00ac\u0001\u001a\u00020\u000f2\u000b\b\u0002\u0010\u00ae\u0001\u001a\u0004\u0018\u00010\u00072\t\b\u0002\u0010\u00af\u0001\u001a\u00020\u00052\u000b\b\u0002\u0010\u00b0\u0001\u001a\u0004\u0018\u00010\u0007H\u0014J#\u0010\u00ad\u0001\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00032\u0007\u0010\u00aa\u0001\u001a\u00020:2\u0007\u0010\u00ac\u0001\u001a\u00020\u000fH\u0015J\u0011\u0010\u00b1\u0001\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J$\u0010\u00b2\u0001\u001a\u00060.R\u00020\u00002\u000b\u0010\u009a\u0001\u001a\u00060.R\u00020\u00002\b\u0010\u00b3\u0001\u001a\u00030\u00b4\u0001H\u0014J\u001d\u0010\u00b5\u0001\u001a\u0016\u0012\b\u0012\u00060.R\u00020\u0000\u0012\b\u0012\u00060.R\u00020\u00000OH\u0014J\t\u0010\u00b6\u0001\u001a\u00020\u0003H&J#\u0010\u00b7\u0001\u001a\u00020\u00032\u000b\u0010\u00a1\u0001\u001a\u00060.R\u00020\u00002\u000b\u0010\u00a2\u0001\u001a\u00060.R\u00020\u0000H\u0014J\t\u0010\u00b8\u0001\u001a\u00020\u0005H\u0014J\t\u0010\u00b9\u0001\u001a\u00020\u0005H\u0014J\u0007\u0010\u00ba\u0001\u001a\u00020\u0005J\u0012\u0010\u00bb\u0001\u001a\u00020\u00052\u0007\u0010\u00bc\u0001\u001a\u00020#H\u0014J+\u0010\u00bd\u0001\u001a\u00020\u00002\"\u0010\u00be\u0001\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012J\t\u0010\u00bf\u0001\u001a\u00020\u0016H$J+\u0010\u00c0\u0001\u001a\u00020\u00002\"\u0010\u00be\u0001\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012J\t\u0010\u00c1\u0001\u001a\u00020\u0016H\u0014J\t\u0010\u00c2\u0001\u001a\u00020\u0016H$J#\u0010\u00c3\u0001\u001a\u00020\u00162\u000b\u0010\u00a1\u0001\u001a\u00060.R\u00020\u00002\u000b\u0010\u00a2\u0001\u001a\u00060.R\u00020\u0000H\u0002J\u001f\u0010\u00c4\u0001\u001a\u00060.R\u00020\u00002\u0007\u0010\u00c5\u0001\u001a\u00020:2\u0007\u0010\u00c6\u0001\u001a\u00020:H$J\u0016\u0010\u00c7\u0001\u001a\u00020\u00162\u000b\u0010\u009a\u0001\u001a\u00060.R\u00020\u0000H$J\t\u0010\u00c8\u0001\u001a\u00020\u0016H\u0016J\r\u0010\u00c9\u0001\u001a\u00060.R\u00020\u0000H\u0014J\r\u0010\u00ca\u0001\u001a\u00060.R\u00020\u0000H\u0014J\u000f\u0010\u001e\u001a\u00020\u00002\u0007\u0010\u00ba\u0001\u001a\u00020\u0005J\u0016\u0010\u00cb\u0001\u001a\u00020\u00162\u000b\u0010\u00cc\u0001\u001a\u00060.R\u00020\u0000H\u0002J\u000f\u0010\u00cd\u0001\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003J\u001b\u0010\u00ce\u0001\u001a\u00020\u00162\u0007\u0010\u00cf\u0001\u001a\u00020:2\u0007\u0010\u00d0\u0001\u001a\u00020:H\u0002J!\u0010\u00d1\u0001\u001a\t\u0012\u0004\u0012\u00020\u00030\u00d2\u00012\u0006\u0010\u0015\u001a\u00020\u00032\u0007\u0010\u00d3\u0001\u001a\u00020:H\u0014J\u0018\u0010\u00d4\u0001\u001a\t\u0012\u0004\u0012\u00020\u00030\u00d2\u00012\u0006\u0010\u0015\u001a\u00020\u0003H$J\u0007\u0010\u00d5\u0001\u001a\u00020\u0016R5\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010\n\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001d\"\u0004\b'\u0010\u001fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010/\u001a\u00060.R\u00020\u00002\n\u0010-\u001a\u00060.R\u00020\u0000@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0014\u0010\r\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010)R\u001a\u00105\u001a\u00020\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010;\u001a\u00020:2\u0006\u0010-\u001a\u00020:@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u001d\"\u0004\bB\u0010\u001fR\u001a\u0010C\u001a\u00020:X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010=\"\u0004\bE\u0010?R\u0014\u0010\u000b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010)R\u001a\u0010\f\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010)\"\u0004\bH\u0010+R\u001a\u0010I\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR.\u0010N\u001a\u0016\u0012\b\u0012\u00060.R\u00020\u0000\u0012\b\u0012\u00060.R\u00020\u00000OX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020UX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR$\u0010Z\u001a\u00020:2\u0006\u0010-\u001a\u00020:@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010=\"\u0004\b\\\u0010?R\u0011\u0010]\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b^\u0010=R\u001a\u0010_\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010=\"\u0004\ba\u0010?R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010K\"\u0004\bc\u0010MR,\u0010d\u001a\u00060.R\u00020\u00002\n\u0010-\u001a\u00060.R\u00020\u0000@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u00101\"\u0004\bf\u00103R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u0017\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00070l\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010nR\u0017\u0010o\u001a\b\u0012\u0004\u0012\u00020\u00050l\u00a2\u0006\b\n\u0000\u001a\u0004\bp\u0010nR\u001e\u0010q\u001a\f\u0012\b\u0012\u00060sR\u00020\u00000rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010uR\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010)R\u001a\u0010\t\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010)\"\u0004\bx\u0010+R\u001a\u0010y\u001a\u00020zX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b{\u0010|\"\u0004\b}\u0010~R&\u0010\u007f\u001a\u00020:2\u0006\u0010-\u001a\u00020:@DX\u0084\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0080\u0001\u0010=\"\u0005\b\u0081\u0001\u0010?R\u0019\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u00030l\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0083\u0001\u0010nR#\u0010\u0084\u0001\u001a\u000e\u0012\t\u0012\u00070\u0086\u0001R\u00020\u00000\u0085\u0001X\u0084\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001R \u0010\u0089\u0001\u001a\f\u0012\b\u0012\u00060sR\u00020\u00000rX\u0084\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008a\u0001\u0010uR8\u0010\u008b\u0001\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0012X\u0084\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008c\u0001\u0010\u0018\"\u0005\b\u008d\u0001\u0010\u001aR\u001d\u0010\u008e\u0001\u001a\u00020:X\u0084\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008f\u0001\u0010=\"\u0005\b\u0090\u0001\u0010?R#\u0010\u0091\u0001\u001a\u000e\u0012\t\u0012\u00070\u0092\u0001R\u00020\u00000\u0085\u0001X\u0084\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0093\u0001\u0010\u0088\u0001\u00a8\u0006\u00e1\u0001"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput;", "Lgg/essential/elementa/UIComponent;", "placeholder", "", "contentShadow", "", "contentShadowColor", "Ljava/awt/Color;", "selectionBackgroundColor", "selectionForegroundColor", "allowInactiveSelection", "inactiveSelectionBackgroundColor", "inactiveSelectionForegroundColor", "cursorColor", "maxLength", "", "(Ljava/lang/String;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;I)V", "activateAction", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "text", "", "getActivateAction", "()Lkotlin/jvm/functions/Function1;", "setActivateAction", "(Lkotlin/jvm/functions/Function1;)V", "active", "getActive", "()Z", "setActive", "(Z)V", "getAllowInactiveSelection", "allowedCharacters", "", "", "getAllowedCharacters", "()Ljava/util/Set;", "getContentShadow", "setContentShadow", "getContentShadowColor", "()Ljava/awt/Color;", "setContentShadowColor", "(Ljava/awt/Color;)V", "contextMenuOpen", "value", "Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;", "cursor", "getCursor", "()Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;", "setCursor", "(Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;)V", "getCursorColor", "cursorComponent", "getCursorComponent", "()Lgg/essential/elementa/UIComponent;", "setCursorComponent", "(Lgg/essential/elementa/UIComponent;)V", "", "cursorHeight", "getCursorHeight", "()F", "setCursorHeight", "(F)V", "cursorNeedsRefocus", "getCursorNeedsRefocus", "setCursorNeedsRefocus", "horizontalScrollingOffset", "getHorizontalScrollingOffset", "setHorizontalScrollingOffset", "getInactiveSelectionBackgroundColor", "getInactiveSelectionForegroundColor", "setInactiveSelectionForegroundColor", "initiallySelectedLine", "getInitiallySelectedLine", "()I", "setInitiallySelectedLine", "(I)V", "initiallySelectedWord", "Lkotlin/Pair;", "getInitiallySelectedWord", "()Lkotlin/Pair;", "setInitiallySelectedWord", "(Lkotlin/Pair;)V", "lastSelectionMoveTimestamp", "", "getLastSelectionMoveTimestamp", "()J", "setLastSelectionMoveTimestamp", "(J)V", "lineHeight", "getLineHeight", "setLineHeight", "lineHeightWithPadding", "getLineHeightWithPadding", "linePadding", "getLinePadding", "setLinePadding", "getMaxLength", "setMaxLength", "otherSelectionEnd", "getOtherSelectionEnd", "setOtherSelectionEnd", "getPlaceholder", "()Ljava/lang/String;", "setPlaceholder", "(Ljava/lang/String;)V", "placeholderColor", "Lgg/essential/elementa/state/BasicState;", "getPlaceholderColor", "()Lgg/essential/elementa/state/BasicState;", "placeholderShadow", "getPlaceholderShadow", "redoStack", "Ljava/util/ArrayDeque;", "Lgg/essential/gui/common/input/AbstractTextInput$TextOperation;", "getRedoStack", "()Ljava/util/ArrayDeque;", "getSelectionBackgroundColor", "getSelectionForegroundColor", "setSelectionForegroundColor", "selectionMode", "Lgg/essential/gui/common/input/AbstractTextInput$SelectionMode;", "getSelectionMode", "()Lgg/essential/gui/common/input/AbstractTextInput$SelectionMode;", "setSelectionMode", "(Lgg/essential/gui/common/input/AbstractTextInput$SelectionMode;)V", "targetVerticalScrollingOffset", "getTargetVerticalScrollingOffset", "setTargetVerticalScrollingOffset", "textState", "getTextState", "textualLines", "", "Lgg/essential/gui/common/input/AbstractTextInput$TextualLine;", "getTextualLines", "()Ljava/util/List;", "undoStack", "getUndoStack", "updateAction", "getUpdateAction", "setUpdateAction", "verticalScrollingOffset", "getVerticalScrollingOffset", "setVerticalScrollingOffset", "visualLines", "Lgg/essential/gui/common/input/AbstractTextInput$VisualLine;", "getVisualLines", "addText", "newText", "position", "animateCursor", "animationFrame", "charAfter", "pos", "(Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;)Ljava/lang/Character;", "charBefore", "commitTextAddition", "commitTextOperation", "operation", "commitTextRemoval", "startPos", "endPos", "selectAfterUndo", "copySelection", "deleteSelection", "drawPlaceholder", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawSelectedText", "left", "right", "row", "drawUnselectedText", "color", "shadow", "shadowColor", "filterOutDisallowedCharacters", "getNearestWordBoundary", "direction", "Lgg/essential/gui/common/input/AbstractTextInput$Direction;", "getSelection", "getText", "getTextBetween", "hasSelection", "hasText", "isActive", "isBreakingCharacter", "ch", "onActivate", "listener", "onEnterPressed", "onUpdate", "recalculateAllVisualLines", "recalculateDimensions", "removeText", "screenPosToVisualPos", "x", "y", "scrollIntoView", "selectAll", "selectionEnd", "selectionStart", "setCursorPosition", "newPosition", "setText", "showOptionMenu", "posX", "posY", "splitTextForWrapping", "", "maxLineWidth", "textToLines", "undoLastOperation", "AddTextOperation", "Companion", "Direction", "Line", "LinePosition", "RemoveTextOperation", "ReplaceTextOperation", "SelectionMode", "TextOperation", "TextualLine", "VisualLine", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nAbstractTextInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTextInput.kt\ngg/essential/gui/common/input/AbstractTextInput\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 animations.kt\ngg/essential/elementa/dsl/AnimationsKt\n*L\n1#1,1126:1\n9#2,3:1127\n37#3,2:1130\n1549#4:1132\n1620#4,3:1133\n1549#4:1136\n1620#4,3:1137\n1#5:1140\n10#6,5:1141\n*S KotlinDebug\n*F\n+ 1 AbstractTextInput.kt\ngg/essential/gui/common/input/AbstractTextInput\n*L\n95#1:1127,3\n444#1:1130,2\n579#1:1132\n579#1:1133,3\n607#1:1136\n607#1:1137,3\n805#1:1141,5\n*E\n"})
public abstract class AbstractTextInput
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String placeholder;
    private boolean contentShadow;
    @Nullable
    private Color contentShadowColor;
    @NotNull
    private final Color selectionBackgroundColor;
    @NotNull
    private Color selectionForegroundColor;
    private final boolean allowInactiveSelection;
    @NotNull
    private final Color inactiveSelectionBackgroundColor;
    @NotNull
    private Color inactiveSelectionForegroundColor;
    @NotNull
    private final Color cursorColor;
    private int maxLength;
    @NotNull
    private final BasicState<Color> placeholderColor;
    @NotNull
    private final BasicState<Boolean> placeholderShadow;
    @NotNull
    private final BasicState<String> textState;
    @NotNull
    private final Set<Character> allowedCharacters;
    private boolean contextMenuOpen;
    private boolean active;
    private float cursorHeight;
    private float lineHeight;
    private float linePadding;
    @NotNull
    private Function1<? super String, Unit> updateAction;
    @NotNull
    private Function1<? super String, Unit> activateAction;
    @NotNull
    private final List<TextualLine> textualLines;
    @NotNull
    private final List<VisualLine> visualLines;
    private float verticalScrollingOffset;
    private float targetVerticalScrollingOffset;
    private float horizontalScrollingOffset;
    private boolean cursorNeedsRefocus;
    private long lastSelectionMoveTimestamp;
    @NotNull
    private SelectionMode selectionMode;
    private int initiallySelectedLine;
    @NotNull
    private Pair<LinePosition, LinePosition> initiallySelectedWord;
    @NotNull
    private final ArrayDeque<TextOperation> undoStack;
    @NotNull
    private final ArrayDeque<TextOperation> redoStack;
    @NotNull
    private UIComponent cursorComponent;
    @NotNull
    private LinePosition cursor;
    @NotNull
    private LinePosition otherSelectionEnd;

    /*
     * WARNING - void declaration
     */
    public AbstractTextInput(@NotNull String placeholder, boolean contentShadow, @Nullable Color contentShadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor, int maxLength) {
        void $this$cursorComponent_u24lambda_u240;
        UIComponent uIComponent;
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)cursorColor, (String)"cursorColor");
        this.placeholder = placeholder;
        this.contentShadow = contentShadow;
        this.contentShadowColor = contentShadowColor;
        this.selectionBackgroundColor = selectionBackgroundColor;
        this.selectionForegroundColor = selectionForegroundColor;
        this.allowInactiveSelection = allowInactiveSelection;
        this.inactiveSelectionBackgroundColor = inactiveSelectionBackgroundColor;
        this.inactiveSelectionForegroundColor = inactiveSelectionForegroundColor;
        this.cursorColor = cursorColor;
        this.maxLength = maxLength;
        this.placeholderColor = new BasicState<Color>(EssentialPalette.TEXT);
        this.placeholderShadow = new BasicState<Boolean>(true);
        this.textState = new BasicState<String>("");
        this.allowedCharacters = new LinkedHashSet();
        this.cursorHeight = 9.0f;
        this.lineHeight = 9.0f;
        this.updateAction = updateAction.1.INSTANCE;
        this.activateAction = activateAction.1.INSTANCE;
        Object[] objectArray = new TextualLine[]{new TextualLine(this, "", new IntRange(0, 0))};
        this.textualLines = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new VisualLine[]{new VisualLine("", 0)};
        this.visualLines = CollectionsKt.mutableListOf((Object[])objectArray);
        this.lastSelectionMoveTimestamp = System.currentTimeMillis();
        this.selectionMode = SelectionMode.None;
        this.initiallySelectedLine = -1;
        this.initiallySelectedWord = TuplesKt.to((Object)new LinePosition(0, 0, true), (Object)new LinePosition(0, 0, true));
        this.undoStack = new ArrayDeque();
        this.redoStack = new ArrayDeque();
        UIComponent $this$constrain$iv = new UIBlock(new Color(255, 255, 255, 0));
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        boolean bl = false;
        UIConstraints uIConstraints = $this$constrain_u24lambda_u240$iv.getConstraints();
        AbstractTextInput abstractTextInput = this;
        boolean bl2 = false;
        $this$cursorComponent_u24lambda_u240.setY(ConstraintsKt.minus(new CenterConstraint(), UtilitiesKt.pixels$default(Float.valueOf(0.5f), false, false, 3, null)));
        $this$cursorComponent_u24lambda_u240.setWidth(UtilitiesKt.pixel$default(1, false, false, 3, null));
        $this$cursorComponent_u24lambda_u240.setHeight(UtilitiesKt.pixels$default(Float.valueOf(this.cursorHeight), false, false, 3, null));
        abstractTextInput.cursorComponent = ComponentsKt.childOf(uIComponent, this);
        this.cursor = new LinePosition(0, 0, true);
        this.otherSelectionEnd = new LinePosition(0, 0, true);
        this.setHeight(UtilitiesKt.pixels$default(Float.valueOf(this.lineHeight), false, false, 3, null));
        this.setColor(EssentialPalette.TEXT_HIGHLIGHT);
        this.onKeyType((Function3<? super UIComponent, ? super Character, ? super Integer, Unit>)((Function3)new Function3<UIComponent, Character, Integer, Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UIComponent $this$onKeyType, char typedChar, int keyCode) {
                Intrinsics.checkNotNullParameter((Object)$this$onKeyType, (String)"$this$onKeyType");
                if (!this.getActive()) {
                    return;
                }
                if (keyCode == UKeyboard.KEY_ESCAPE) {
                    $this$onKeyType.releaseWindowFocus();
                } else if (UKeyboard.isKeyComboCtrlA(keyCode)) {
                    this.selectAll();
                } else if (UKeyboard.isKeyComboCtrlC(keyCode) && this.hasSelection()) {
                    this.copySelection();
                } else if (UKeyboard.isKeyComboCtrlX(keyCode) && this.hasSelection()) {
                    this.copySelection();
                    this.deleteSelection();
                } else if (UKeyboard.isKeyComboCtrlV(keyCode)) {
                    void $this$filterTo$iv$iv;
                    String $this$filter$iv = UDesktop.getClipboardString();
                    boolean $i$f$filter = false;
                    CharSequence charSequence = $this$filter$iv;
                    Appendable destination$iv$iv = new StringBuilder();
                    boolean $i$f$filterTo = false;
                    int n = $this$filterTo$iv$iv.length();
                    for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                        char element$iv$iv;
                        char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        if (!Companion.isAllowedCharacter(it)) continue;
                        destination$iv$iv.append(element$iv$iv);
                    }
                    String string = ((StringBuilder)destination$iv$iv).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String filteredClipboardString = string;
                    if (!StringsKt.isBlank((CharSequence)filteredClipboardString)) {
                        this.commitTextAddition(filteredClipboardString);
                    }
                } else if (UKeyboard.isKeyComboCtrlZ(keyCode)) {
                    this.undoLastOperation();
                } else if (UKeyboard.isKeyComboCtrlShiftZ(keyCode) || UKeyboard.isKeyComboCtrlY(keyCode)) {
                    if (this.getRedoStack().isEmpty()) {
                        return;
                    }
                    TextOperation operationToRedo = this.getRedoStack().pop();
                    operationToRedo.redo();
                    this.getUndoStack().push(operationToRedo);
                } else if (Companion.isAllowedCharacter(typedChar)) {
                    this.commitTextAddition(String.valueOf(typedChar));
                } else if (keyCode == UKeyboard.KEY_LEFT) {
                    LinePosition newCursorPosition;
                    boolean holdingShift = UKeyboard.isShiftKeyDown();
                    boolean holdingCtrl = UKeyboard.isCtrlKeyDown();
                    LinePosition linePosition = holdingCtrl ? this.getNearestWordBoundary(this.getCursor(), Direction.Left) : (this.hasSelection() ? (holdingShift ? this.getCursor().offsetColumn(-1) : this.selectionStart()) : (newCursorPosition = this.getCursor().offsetColumn(-1)));
                    if (!holdingShift) {
                        this.setCursorPosition(newCursorPosition);
                        return;
                    }
                    this.setCursor(newCursorPosition);
                    this.setCursorNeedsRefocus(true);
                } else if (keyCode == UKeyboard.KEY_RIGHT) {
                    LinePosition newCursorPosition;
                    boolean holdingShift = UKeyboard.isShiftKeyDown();
                    boolean holdingCtrl = UKeyboard.isCtrlKeyDown();
                    LinePosition linePosition = holdingCtrl ? this.getNearestWordBoundary(this.getCursor(), Direction.Right) : (this.hasSelection() ? (holdingShift ? this.getCursor().offsetColumn(1) : this.selectionEnd()) : (newCursorPosition = this.getCursor().offsetColumn(1)));
                    if (!holdingShift) {
                        this.setCursorPosition(newCursorPosition);
                        return;
                    }
                    this.setCursor(newCursorPosition);
                    this.setCursorNeedsRefocus(true);
                } else if (keyCode == UKeyboard.KEY_UP) {
                    LinePosition newVisualPos;
                    LinePosition linePosition;
                    if (this.getCursor().getLine() == 0) {
                        linePosition = new LinePosition(0, 0, true);
                    } else {
                        Pair<Float, Float> holdingCtrl = this.getCursor().toScreenPos();
                        float currX = ((Number)holdingCtrl.component1()).floatValue();
                        float currY = ((Number)holdingCtrl.component2()).floatValue();
                        linePosition = newVisualPos = this.screenPosToVisualPos(currX, currY - this.getLineHeightWithPadding());
                    }
                    if (UKeyboard.isShiftKeyDown()) {
                        this.setCursor(newVisualPos);
                        this.setCursorNeedsRefocus(true);
                    } else {
                        this.setCursorPosition(newVisualPos);
                    }
                } else if (keyCode == UKeyboard.KEY_DOWN) {
                    LinePosition newVisualPos;
                    LinePosition linePosition;
                    if (this.getCursor().getLine() == CollectionsKt.getLastIndex(this.getVisualLines())) {
                        linePosition = new LinePosition(CollectionsKt.getLastIndex(this.getVisualLines()), ((VisualLine)CollectionsKt.last(this.getVisualLines())).getLength(), true);
                    } else {
                        Pair<Float, Float> holdingCtrl = this.getCursor().toScreenPos();
                        float currX = ((Number)holdingCtrl.component1()).floatValue();
                        float currY = ((Number)holdingCtrl.component2()).floatValue();
                        linePosition = newVisualPos = this.screenPosToVisualPos(currX, currY + this.getLineHeightWithPadding());
                    }
                    if (UKeyboard.isShiftKeyDown()) {
                        this.setCursor(newVisualPos);
                        this.setCursorNeedsRefocus(true);
                    } else {
                        this.setCursorPosition(newVisualPos);
                    }
                } else if (keyCode == UKeyboard.KEY_BACKSPACE) {
                    if (this.hasSelection()) {
                        this.deleteSelection();
                    } else if (!this.getCursor().isAtAbsoluteStart()) {
                        LinePosition startPos = UKeyboard.isCtrlKeyDown() ? this.getNearestWordBoundary(this.getCursor(), Direction.Left) : this.getCursor().offsetColumn(-1).toTextualPos();
                        LinePosition endPos = this.getCursor().toTextualPos();
                        this.commitTextRemoval(startPos, endPos, false);
                    }
                } else if (keyCode == UKeyboard.KEY_DELETE) {
                    if (this.hasSelection()) {
                        this.deleteSelection();
                    } else if (!this.getCursor().isAtAbsoluteEnd()) {
                        LinePosition startPos = this.getCursor().toTextualPos();
                        LinePosition endPos = UKeyboard.isCtrlKeyDown() ? this.getNearestWordBoundary(this.getCursor(), Direction.Right) : this.getCursor().offsetColumn(1).toTextualPos();
                        this.commitTextRemoval(startPos, endPos, false);
                    }
                } else if (keyCode == UKeyboard.KEY_HOME) {
                    if (UKeyboard.isShiftKeyDown()) {
                        this.setCursor(this.getCursor().withColumn(0));
                        this.setCursorNeedsRefocus(true);
                    } else {
                        this.setCursorPosition(this.getCursor().withColumn(0));
                    }
                } else if (keyCode == UKeyboard.KEY_END) {
                    LinePosition linePosition = this.getCursor().withColumn(this.getVisualLines().get(this.getCursor().getLine()).getLength());
                    AbstractTextInput endPos = this;
                    LinePosition it = linePosition;
                    boolean bl = false;
                    if (UKeyboard.isShiftKeyDown()) {
                        endPos.setCursor(it);
                        endPos.setCursorNeedsRefocus(true);
                    } else {
                        endPos.setCursorPosition(it);
                    }
                } else if (keyCode == UKeyboard.KEY_ENTER) {
                    this.onEnterPressed();
                } else if (keyCode == UKeyboard.KEY_MENU) {
                    Pair<Float, Float> pair = this.getCursor().toScreenPos();
                    float posX = ((Number)pair.component1()).floatValue();
                    float posY = ((Number)pair.component2()).floatValue();
                    this.showOptionMenu($this$onKeyType.getLeft() + posX, $this$onKeyType.getTop() + posY);
                }
            }
        }));
        this.onMouseScroll((Function2<? super UIComponent, ? super UIScrollEvent, Unit>)((Function2)new Function2<UIComponent, UIScrollEvent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseScroll, @NotNull UIScrollEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseScroll, (String)"$this$onMouseScroll");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                float heightDifference = $this$onMouseScroll.getHeight() - (float)this.getVisualLines().size() * this.getLineHeightWithPadding() + this.getLinePadding();
                if (heightDifference >= 0.0f) {
                    return;
                }
                this.setTargetVerticalScrollingOffset(RangesKt.coerceIn((float)(this.getTargetVerticalScrollingOffset() + (float)it.getDelta() * this.getLineHeightWithPadding()), (float)heightDifference, (float)0.0f));
                it.stopPropagation();
            }
        }));
        this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getMouseButton() != 1) {
                    return;
                }
                this.showOptionMenu(event.getAbsoluteX(), event.getAbsoluteY());
                event.stopImmediatePropagation();
            }
        }));
        this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getMouseButton() != 0) {
                    return;
                }
                event.stopImmediatePropagation();
                $this$onMouseClick.grabWindowFocus();
                LinePosition clickedVisualPos = this.screenPosToVisualPos(event.getRelativeX(), event.getRelativeY());
                int clickCount = event.getClickCount() % 3;
                if (clickCount == 0 && clickedVisualPos.getLine() != this.getCursor().getLine()) {
                    clickCount = 1;
                } else if (clickCount == 2 && !Intrinsics.areEqual((Object)this.getCursor(), (Object)clickedVisualPos)) {
                    clickCount = 1;
                }
                switch (clickCount) {
                    case 0: {
                        this.setSelectionMode(SelectionMode.Line);
                        this.setOtherSelectionEnd(clickedVisualPos.withColumn(this.getVisualLines().get(this.getCursor().getLine()).getLength()));
                        this.setInitiallySelectedLine(this.getCursor().getLine());
                        break;
                    }
                    case 1: {
                        this.setSelectionMode(SelectionMode.Character);
                        this.setCursorPosition(clickedVisualPos);
                        break;
                    }
                    case 2: {
                        this.setSelectionMode(SelectionMode.Word);
                        this.setCursor(this.getNearestWordBoundary(clickedVisualPos, Direction.Left));
                        this.setCursorNeedsRefocus(true);
                        this.setOtherSelectionEnd(this.getNearestWordBoundary(clickedVisualPos, Direction.Right));
                        this.setInitiallySelectedWord((Pair<LinePosition, LinePosition>)TuplesKt.to((Object)this.getCursor(), (Object)this.getOtherSelectionEnd()));
                    }
                }
            }
        }));
        this.onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)((Function4)new Function4<UIComponent, Float, Float, Integer, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseDrag, float mouseX, float mouseY, int mouseButton) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
                if (mouseButton != 0 || this.getSelectionMode() == SelectionMode.None) {
                    return;
                }
                LinePosition draggedVisualPos = this.screenPosToVisualPos(mouseX, mouseY);
                switch (WhenMappings.$EnumSwitchMapping$0[this.getSelectionMode().ordinal()]) {
                    case 1: {
                        this.setOtherSelectionEnd(draggedVisualPos);
                        break;
                    }
                    case 2: {
                        if (this.getInitiallySelectedLine() < draggedVisualPos.getLine()) {
                            this.setCursor(new LinePosition(this.getInitiallySelectedLine(), 0, true));
                            this.setOtherSelectionEnd(draggedVisualPos.withColumn(this.getVisualLines().get(draggedVisualPos.getLine()).getLength()));
                            break;
                        }
                        this.setCursor(draggedVisualPos.withColumn(0));
                        this.setOtherSelectionEnd(new LinePosition(this.getInitiallySelectedLine(), this.getVisualLines().get(this.getInitiallySelectedLine()).getLength(), true));
                        break;
                    }
                    case 3: {
                        if (draggedVisualPos.compareTo((LinePosition)this.getInitiallySelectedWord().getFirst()) < 0) {
                            this.setCursor(this.getNearestWordBoundary(draggedVisualPos, Direction.Left));
                            this.setOtherSelectionEnd((LinePosition)this.getInitiallySelectedWord().getSecond());
                            break;
                        }
                        if (draggedVisualPos.compareTo((LinePosition)this.getInitiallySelectedWord().getSecond()) > 0) {
                            this.setCursor((LinePosition)this.getInitiallySelectedWord().getFirst());
                            this.setOtherSelectionEnd(this.getNearestWordBoundary(draggedVisualPos, Direction.Right));
                            break;
                        }
                        this.setCursor((LinePosition)this.getInitiallySelectedWord().getFirst());
                        this.setOtherSelectionEnd((LinePosition)this.getInitiallySelectedWord().getSecond());
                    }
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.getLastSelectionMoveTimestamp() > 50L) {
                    if (mouseY <= 0.0f) {
                        this.setTargetVerticalScrollingOffset(RangesKt.coerceAtMost((float)(this.getTargetVerticalScrollingOffset() + this.getLineHeightWithPadding() * $this$onMouseDrag.getTextScale()), (float)0.0f));
                        this.setLastSelectionMoveTimestamp(currentTime);
                    } else if (mouseY >= $this$onMouseDrag.getHeight()) {
                        float heightDifference = RangesKt.coerceAtMost((float)($this$onMouseDrag.getHeight() - (float)this.getVisualLines().size() * this.getLineHeightWithPadding() * $this$onMouseDrag.getTextScale() + this.getLinePadding() * $this$onMouseDrag.getTextScale()), (float)0.0f);
                        this.setTargetVerticalScrollingOffset(RangesKt.coerceIn((float)(this.getTargetVerticalScrollingOffset() - this.getLineHeightWithPadding() * $this$onMouseDrag.getTextScale()), (float)heightDifference, (float)0.0f));
                        this.setLastSelectionMoveTimestamp(currentTime);
                    } else if (mouseX <= 0.0f) {
                        this.scrollIntoView(draggedVisualPos.offsetColumn(-1));
                        this.setLastSelectionMoveTimestamp(currentTime);
                    } else if (mouseX >= $this$onMouseDrag.getWidth()) {
                        this.scrollIntoView(draggedVisualPos.offsetColumn(1));
                        this.setLastSelectionMoveTimestamp(currentTime);
                    }
                }
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[SelectionMode.values().length];
                    try {
                        nArray[SelectionMode.Character.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[SelectionMode.Line.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[SelectionMode.Word.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[SelectionMode.None.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }));
        this.onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                if (contextMenuOpen) {
                    return;
                }
                this.setSelectionMode(SelectionMode.None);
            }
        }));
        this.onFocus((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onFocus) {
                Intrinsics.checkNotNullParameter((Object)$this$onFocus, (String)"$this$onFocus");
                this.setActive(true);
            }
        }));
        this.onFocusLost((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onFocusLost) {
                Intrinsics.checkNotNullParameter((Object)$this$onFocusLost, (String)"$this$onFocusLost");
                if (contextMenuOpen) {
                    return;
                }
                this.setActive(false);
            }
        }));
        this.cursorComponent.animateAfterUnhide((Function1<? super AnimatingConstraints, Unit>)((Function1)new Function1<AnimatingConstraints, Unit>(){

            public final void invoke(@NotNull AnimatingConstraints $this$animateAfterUnhide) {
                Intrinsics.checkNotNullParameter((Object)$this$animateAfterUnhide, (String)"$this$animateAfterUnhide");
                AnimatingConstraints.setColorAnimation$default($this$animateAfterUnhide, Animations.OUT_CIRCULAR, 0.5f, UtilitiesKt.toConstraint(this.getCursorColor()), 0.0f, 8, null);
                $this$animateAfterUnhide.onComplete((Function0<Unit>)((Function0)new Function0<Unit>(){

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        AnimatingConstraints anim$iv;
                        void $this$animate$iv;
                        void var4_4;
                        if (!this.getActive()) {
                            return;
                        }
                        UIComponent uIComponent = this.getCursorComponent();
                        AbstractTextInput abstractTextInput = this;
                        boolean $i$f$animate = false;
                        void $this$animate_u24lambda_u240$iv = var4_4 = $this$animate$iv;
                        boolean bl = false;
                        AnimatingConstraints $this$invoke_u24lambda_u240 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
                        boolean bl2 = false;
                        AnimatingConstraints.setColorAnimation$default($this$invoke_u24lambda_u240, Animations.IN_CIRCULAR, 0.5f, UtilitiesKt.toConstraint(new Color(255, 255, 255, 0)), 0.0f, 8, null);
                        $this$invoke_u24lambda_u240.onComplete((Function0<Unit>)((Function0)new Function0<Unit>(abstractTextInput){
                            final /* synthetic */ AbstractTextInput this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                if (this.this$0.getActive()) {
                                    this.this$0.animateCursor();
                                }
                            }
                        }));
                        $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
                    }
                }));
            }
        }));
        this.enableEffect(new ScissorEffect(null, false, 3, null));
        this.textState.onSetValue((Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)it, (Object)this.getText())) {
                    this.setText(it);
                }
            }
        }));
    }

    public /* synthetic */ AbstractTextInput(String string, boolean bl, Color color2, Color color3, Color color4, boolean bl2, Color color5, Color color6, Color color7, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x200) != 0) {
            n = Integer.MAX_VALUE;
        }
        this(string, bl, color2, color3, color4, bl2, color5, color6, color7, n);
    }

    @NotNull
    public final String getPlaceholder() {
        return this.placeholder;
    }

    public final void setPlaceholder(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.placeholder = string;
    }

    public final boolean getContentShadow() {
        return this.contentShadow;
    }

    public final void setContentShadow(boolean bl) {
        this.contentShadow = bl;
    }

    @Nullable
    public final Color getContentShadowColor() {
        return this.contentShadowColor;
    }

    public final void setContentShadowColor(@Nullable Color color2) {
        this.contentShadowColor = color2;
    }

    @NotNull
    protected final Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    @NotNull
    protected final Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    protected final void setSelectionForegroundColor(@NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"<set-?>");
        this.selectionForegroundColor = color2;
    }

    protected final boolean getAllowInactiveSelection() {
        return this.allowInactiveSelection;
    }

    @NotNull
    protected final Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    @NotNull
    protected final Color getInactiveSelectionForegroundColor() {
        return this.inactiveSelectionForegroundColor;
    }

    protected final void setInactiveSelectionForegroundColor(@NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"<set-?>");
        this.inactiveSelectionForegroundColor = color2;
    }

    @NotNull
    protected final Color getCursorColor() {
        return this.cursorColor;
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    public final void setMaxLength(int n) {
        this.maxLength = n;
    }

    @NotNull
    public final BasicState<Color> getPlaceholderColor() {
        return this.placeholderColor;
    }

    @NotNull
    public final BasicState<Boolean> getPlaceholderShadow() {
        return this.placeholderShadow;
    }

    @NotNull
    public final BasicState<String> getTextState() {
        return this.textState;
    }

    @NotNull
    public final Set<Character> getAllowedCharacters() {
        return this.allowedCharacters;
    }

    protected final boolean getActive() {
        return this.active;
    }

    protected final void setActive(boolean bl) {
        this.active = bl;
    }

    public final float getCursorHeight() {
        return this.cursorHeight;
    }

    public final void setCursorHeight(float value2) {
        this.cursorComponent.setHeight(UtilitiesKt.pixels$default(Float.valueOf(value2), false, false, 3, null));
        this.cursorHeight = value2;
    }

    public final float getLineHeight() {
        return this.lineHeight;
    }

    public final void setLineHeight(float value2) {
        this.setHeight(UtilitiesKt.pixels$default(Float.valueOf(value2), false, false, 3, null));
        this.lineHeight = value2;
    }

    public final float getLinePadding() {
        return this.linePadding;
    }

    public final void setLinePadding(float f) {
        this.linePadding = f;
    }

    public final float getLineHeightWithPadding() {
        return this.lineHeight + this.linePadding;
    }

    @NotNull
    protected final Function1<String, Unit> getUpdateAction() {
        return this.updateAction;
    }

    protected final void setUpdateAction(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.updateAction = function1;
    }

    @NotNull
    protected final Function1<String, Unit> getActivateAction() {
        return this.activateAction;
    }

    protected final void setActivateAction(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.activateAction = function1;
    }

    @NotNull
    protected final List<TextualLine> getTextualLines() {
        return this.textualLines;
    }

    @NotNull
    protected final List<VisualLine> getVisualLines() {
        return this.visualLines;
    }

    protected final float getVerticalScrollingOffset() {
        return this.verticalScrollingOffset;
    }

    protected final void setVerticalScrollingOffset(float f) {
        this.verticalScrollingOffset = f;
    }

    protected final float getTargetVerticalScrollingOffset() {
        return this.targetVerticalScrollingOffset;
    }

    protected final void setTargetVerticalScrollingOffset(float value2) {
        float heightDifference = this.getHeight() - (float)this.visualLines.size() * this.getLineHeightWithPadding() + this.linePadding;
        this.targetVerticalScrollingOffset = RangesKt.coerceAtLeast((float)value2, (float)(-heightDifference));
    }

    protected final float getHorizontalScrollingOffset() {
        return this.horizontalScrollingOffset;
    }

    protected final void setHorizontalScrollingOffset(float f) {
        this.horizontalScrollingOffset = f;
    }

    protected final boolean getCursorNeedsRefocus() {
        return this.cursorNeedsRefocus;
    }

    protected final void setCursorNeedsRefocus(boolean bl) {
        this.cursorNeedsRefocus = bl;
    }

    protected final long getLastSelectionMoveTimestamp() {
        return this.lastSelectionMoveTimestamp;
    }

    protected final void setLastSelectionMoveTimestamp(long l) {
        this.lastSelectionMoveTimestamp = l;
    }

    @NotNull
    protected final SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    protected final void setSelectionMode(@NotNull SelectionMode selectionMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectionMode), (String)"<set-?>");
        this.selectionMode = selectionMode;
    }

    protected final int getInitiallySelectedLine() {
        return this.initiallySelectedLine;
    }

    protected final void setInitiallySelectedLine(int n) {
        this.initiallySelectedLine = n;
    }

    @NotNull
    protected final Pair<LinePosition, LinePosition> getInitiallySelectedWord() {
        return this.initiallySelectedWord;
    }

    protected final void setInitiallySelectedWord(@NotNull Pair<LinePosition, LinePosition> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"<set-?>");
        this.initiallySelectedWord = pair;
    }

    @NotNull
    protected final ArrayDeque<TextOperation> getUndoStack() {
        return this.undoStack;
    }

    @NotNull
    protected final ArrayDeque<TextOperation> getRedoStack() {
        return this.redoStack;
    }

    @NotNull
    protected final UIComponent getCursorComponent() {
        return this.cursorComponent;
    }

    protected final void setCursorComponent(@NotNull UIComponent uIComponent) {
        Intrinsics.checkNotNullParameter((Object)uIComponent, (String)"<set-?>");
        this.cursorComponent = uIComponent;
    }

    @NotNull
    public final LinePosition getCursor() {
        return this.cursor;
    }

    protected final void setCursor(@NotNull LinePosition value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.cursor = value2.toVisualPos();
    }

    @NotNull
    protected final LinePosition getOtherSelectionEnd() {
        return this.otherSelectionEnd;
    }

    protected final void setOtherSelectionEnd(@NotNull LinePosition value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.otherSelectionEnd = value2.toVisualPos();
    }

    private final void showOptionMenu(float posX, float posY) {
        this.contextMenuOpen = true;
        List options2 = new ArrayList();
        if (this.hasSelection()) {
            options2.add(new ContextOptionMenu.Option("Copy", EssentialPalette.COPY_10X7, null, null, null, null, null, (Function0)new Function0<Unit>(this){
                final /* synthetic */ AbstractTextInput this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.copySelection();
                }
            }, 124, null));
            options2.add(new ContextOptionMenu.Option("Cut", EssentialPalette.CUT_10X7, null, null, null, null, null, (Function0)new Function0<Unit>(this){
                final /* synthetic */ AbstractTextInput this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.copySelection();
                    this.this$0.deleteSelection();
                }
            }, 124, null));
        }
        options2.add(new ContextOptionMenu.Option("Paste", EssentialPalette.PASTE_10X8, null, null, null, null, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ AbstractTextInput this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.hasSelection()) {
                    this.this$0.deleteSelection();
                }
                this.this$0.commitTextAddition(UDesktop.getClipboardString());
            }
        }, 124, null));
        Collection $this$toTypedArray$iv = options2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ContextOptionMenu.Item[] itemArray = thisCollection$iv.toArray(new ContextOptionMenu.Item[0]);
        ContextOptionMenu menu = (ContextOptionMenu)ComponentsKt.childOf((UIComponent)new ContextOptionMenu(posX, posY, Arrays.copyOf(itemArray, itemArray.length), 0.0f, 8, null), Window.Companion.of(this));
        menu.init();
        menu.setFloating(true);
        menu.onClose((Function0<Unit>)((Function0)new Function0<Unit>(menu, this){
            final /* synthetic */ ContextOptionMenu $menu;
            final /* synthetic */ AbstractTextInput this$0;
            {
                this.$menu = $menu;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$menu.setFloating(false);
                this.this$0.setActive(false);
                this.this$0.grabWindowFocus();
                AbstractTextInput.access$setContextMenuOpen$p(this.this$0, false);
            }
        }));
    }

    public final void undoLastOperation() {
        if (this.undoStack.isEmpty()) {
            return;
        }
        TextOperation operationToUndo = this.undoStack.pop();
        operationToUndo.undo();
        this.redoStack.push(operationToUndo);
    }

    @NotNull
    public abstract String getText();

    @NotNull
    public final AbstractTextInput setText(@NotNull String text2) {
        AbstractTextInput abstractTextInput;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        AbstractTextInput $this$setText_u24lambda_u241 = abstractTextInput = this;
        boolean bl = false;
        String newText = $this$setText_u24lambda_u241.filterOutDisallowedCharacters(text2);
        LinePosition absoluteStart = $this$setText_u24lambda_u241.new LinePosition(0, 0, true);
        ReplaceTextOperation replaceTextOperation = $this$setText_u24lambda_u241.new ReplaceTextOperation($this$setText_u24lambda_u241.new AddTextOperation(newText, absoluteStart), $this$setText_u24lambda_u241.new RemoveTextOperation(absoluteStart, $this$setText_u24lambda_u241.new LinePosition(CollectionsKt.getLastIndex($this$setText_u24lambda_u241.visualLines), ((VisualLine)CollectionsKt.last($this$setText_u24lambda_u241.visualLines)).getLength(), true), true));
        $this$setText_u24lambda_u241.commitTextOperation(replaceTextOperation);
        return abstractTextInput;
    }

    protected abstract void scrollIntoView(@NotNull LinePosition var1);

    @NotNull
    protected abstract LinePosition screenPosToVisualPos(float var1, float var2);

    protected abstract void recalculateDimensions();

    @NotNull
    protected abstract List<String> textToLines(@NotNull String var1);

    protected abstract void onEnterPressed();

    @NotNull
    public final AbstractTextInput setActive(boolean isActive) {
        AbstractTextInput abstractTextInput;
        AbstractTextInput $this$setActive_u24lambda_u242 = abstractTextInput = this;
        boolean bl = false;
        $this$setActive_u24lambda_u242.active = isActive;
        if (isActive) {
            UIComponent.unhide$default($this$setActive_u24lambda_u242.cursorComponent, false, 1, null);
            $this$setActive_u24lambda_u242.animateCursor();
        } else {
            $this$setActive_u24lambda_u242.cursorComponent.setColor(UtilitiesKt.toConstraint(new Color(255, 255, 255, 0)));
            if (!(!$this$setActive_u24lambda_u242.hasText() || $this$setActive_u24lambda_u242.allowInactiveSelection && $this$setActive_u24lambda_u242.hasSelection())) {
                $this$setActive_u24lambda_u242.setCursorPosition($this$setActive_u24lambda_u242.new LinePosition(CollectionsKt.getLastIndex($this$setActive_u24lambda_u242.visualLines), ((VisualLine)CollectionsKt.last($this$setActive_u24lambda_u242.visualLines)).getLength(), true));
            }
        }
        return abstractTextInput;
    }

    public final boolean isActive() {
        return this.active;
    }

    @NotNull
    public final AbstractTextInput onUpdate(@NotNull Function1<? super String, Unit> listener2) {
        AbstractTextInput abstractTextInput;
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        AbstractTextInput $this$onUpdate_u24lambda_u243 = abstractTextInput = this;
        boolean bl = false;
        $this$onUpdate_u24lambda_u243.updateAction = listener2;
        return abstractTextInput;
    }

    @NotNull
    public final AbstractTextInput onActivate(@NotNull Function1<? super String, Unit> listener2) {
        AbstractTextInput abstractTextInput;
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        AbstractTextInput $this$onActivate_u24lambda_u244 = abstractTextInput = this;
        boolean bl = false;
        $this$onActivate_u24lambda_u244.activateAction = listener2;
        return abstractTextInput;
    }

    protected void commitTextOperation(@NotNull TextOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        operation.redo();
        String updatedText = this.getText();
        if (this.maxLength < 0 || updatedText.length() <= this.maxLength) {
            this.undoStack.push(operation);
            this.redoStack.clear();
        } else {
            operation.undo();
        }
    }

    private final String filterOutDisallowedCharacters(String text2) {
        if (this.allowedCharacters.isEmpty()) {
            return text2;
        }
        StringBuilder builder = new StringBuilder();
        int n = text2.length();
        for (int j = 0; j < n; ++j) {
            char c = text2.charAt(j);
            if (!this.allowedCharacters.contains(Character.valueOf(c))) continue;
            builder.append(c);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final void commitTextAddition(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        String text2 = this.filterOutDisallowedCharacters(newText);
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        AddTextOperation addTextOperation = new AddTextOperation(text2, this.cursor);
        if (this.hasSelection()) {
            RemoveTextOperation removeTextOperation = new RemoveTextOperation(this.selectionStart(), this.selectionEnd(), true);
            ReplaceTextOperation replaceTextOperation = new ReplaceTextOperation(addTextOperation, removeTextOperation);
            this.commitTextOperation(replaceTextOperation);
            return;
        }
        this.commitTextOperation(addTextOperation);
    }

    /*
     * WARNING - void declaration
     */
    protected final void addText(@NotNull String newText, @NotNull LinePosition position2) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
        String text2 = this.filterOutDisallowedCharacters(newText);
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        LinePosition textPos = position2.toTextualPos();
        TextualLine textualLine = this.textualLines.get(textPos.getLine());
        List<String> lines = this.textToLines(newText);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.size() == 1) {
            textualLine.addTextAt((String)CollectionsKt.first(lines), textPos.getColumn());
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)lines, (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new TextualLine(this, (String)it, null, 2, null));
            }
            List newTextualLines = (List)destination$iv$iv;
            if (textPos.getColumn() < textualLine.getText().length()) {
                String string = textualLine.getText().substring(textPos.getColumn());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String textAfterInsertion = string;
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = textualLine.getText().substring(0, textPos.getColumn());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                textualLine.setText(stringBuilder.append(string2).append((String)CollectionsKt.first(lines)).toString());
                TextualLine textualLine2 = (TextualLine)CollectionsKt.last((List)newTextualLines);
                textualLine2.setText(textualLine2.getText() + textAfterInsertion);
            } else {
                textualLine.addTextAt((String)CollectionsKt.first(lines), textPos.getColumn());
            }
            this.textualLines.addAll(textPos.getLine() + 1, newTextualLines);
        }
        this.recalculateAllVisualLines();
        this.setCursorPosition(textPos.offsetColumn(newText.length()).toVisualPos());
        this.updateAction.invoke((Object)this.getText());
        this.textState.set(this.getText());
    }

    /*
     * WARNING - void declaration
     */
    protected void recalculateAllVisualLines() {
        this.visualLines.clear();
        Iterator<TextualLine> iterator = this.textualLines.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int index2 = n++;
            TextualLine textualLine = iterator.next();
            List<String> splitLines = this.splitTextForWrapping(textualLine.getText(), this.getWidth());
            textualLine.setVisualIndices(new IntRange(this.visualLines.size(), this.visualLines.size() + splitLines.size()));
            Iterable iterable = splitLines;
            List<VisualLine> list = this.visualLines;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new VisualLine((String)it, index2));
            }
            list.addAll((List)destination$iv$iv);
        }
    }

    @NotNull
    protected List<String> splitTextForWrapping(@NotNull String text2, float maxLineWidth) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return TextKt.getStringSplitToWidth$default(text2, maxLineWidth, this.getTextScale(), false, false, null, 40, null);
    }

    protected final void commitTextRemoval(@NotNull LinePosition startPos, @NotNull LinePosition endPos, boolean selectAfterUndo) {
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)endPos, (String)"endPos");
        RemoveTextOperation removeTextOperation = new RemoveTextOperation(startPos, endPos, selectAfterUndo);
        this.commitTextOperation(removeTextOperation);
    }

    private final void removeText(LinePosition startPos, LinePosition endPos) {
        LinePosition textualStartPos = startPos.toTextualPos();
        LinePosition textualEndPos = endPos.toTextualPos();
        TextualLine startTextualLine = this.textualLines.get(textualStartPos.getLine());
        TextualLine endTextualLine = this.textualLines.get(textualEndPos.getLine());
        StringBuilder stringBuilder = new StringBuilder();
        String string = startTextualLine.getText().substring(0, textualStartPos.getColumn());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        String string2 = endTextualLine.getText().substring(textualEndPos.getColumn());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        startTextualLine.setText(stringBuilder2.append(string2).toString());
        int firstItemToDelete = textualStartPos.getLine() + 1;
        int n = textualEndPos.getLine() - firstItemToDelete + 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            this.textualLines.remove(firstItemToDelete);
        }
        this.recalculateAllVisualLines();
        float heightDifference = this.getHeight() - (float)this.visualLines.size() * this.getLineHeightWithPadding() + this.linePadding;
        if (this.verticalScrollingOffset < heightDifference) {
            this.setTargetVerticalScrollingOffset(RangesKt.coerceAtMost((float)heightDifference, (float)0.0f));
        }
        this.updateAction.invoke((Object)this.getText());
        this.textState.set(this.getText());
    }

    private final void setCursorPosition(LinePosition newPosition) {
        LinePosition $this$setCursorPosition_u24lambda_u248 = newPosition.toVisualPos();
        boolean bl = false;
        this.setCursor($this$setCursorPosition_u24lambda_u248);
        this.setOtherSelectionEnd($this$setCursorPosition_u24lambda_u248);
        this.cursorNeedsRefocus = true;
    }

    @NotNull
    protected String getTextBetween(@NotNull LinePosition startPos, @NotNull LinePosition endPos) {
        String string;
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)endPos, (String)"endPos");
        LinePosition textStart = startPos.toTextualPos();
        LinePosition textEnd = endPos.toTextualPos();
        if (textStart.getLine() == textEnd.getLine()) {
            String string2 = this.textualLines.get(textStart.getLine()).getText().substring(textStart.getColumn(), textEnd.getColumn());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            List lines = new ArrayList();
            String string3 = this.textualLines.get(textStart.getLine()).getText().substring(textStart.getColumn());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            lines.add(string3);
            int n = textEnd.getLine();
            for (int i2 = textStart.getLine() + 1; i2 < n; ++i2) {
                lines.add(this.textualLines.get(i2).getText());
            }
            String string4 = this.textualLines.get(textEnd.getLine()).getText().substring(0, textEnd.getColumn());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            lines.add(string4);
            string = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return string;
    }

    public void selectAll() {
        this.setCursor(new LinePosition(0, 0, true));
        this.setOtherSelectionEnd(new LinePosition(this.visualLines.size() - 1, ((VisualLine)CollectionsKt.last(this.visualLines)).getLength(), true));
    }

    protected boolean hasSelection() {
        return !Intrinsics.areEqual((Object)this.cursor, (Object)this.otherSelectionEnd);
    }

    @NotNull
    protected LinePosition selectionStart() {
        return (LinePosition)ComparisonsKt.minOf((Comparable)this.cursor, (Comparable)this.otherSelectionEnd);
    }

    @NotNull
    protected LinePosition selectionEnd() {
        return (LinePosition)ComparisonsKt.maxOf((Comparable)this.cursor, (Comparable)this.otherSelectionEnd);
    }

    @NotNull
    protected Pair<LinePosition, LinePosition> getSelection() {
        return TuplesKt.to((Object)this.selectionStart(), (Object)this.selectionEnd());
    }

    protected void deleteSelection() {
        if (!this.hasSelection()) {
            return;
        }
        this.commitTextRemoval(this.selectionStart(), this.selectionEnd(), true);
    }

    protected void copySelection() {
        LinePosition visualSelectionEnd;
        Pair<LinePosition, LinePosition> pair = this.getSelection();
        LinePosition visualSelectionStart = (LinePosition)pair.component1();
        if (Intrinsics.areEqual((Object)visualSelectionStart, (Object)(visualSelectionEnd = (LinePosition)pair.component2()))) {
            return;
        }
        UDesktop.setClipboardString(this.getTextBetween(visualSelectionStart, visualSelectionEnd));
    }

    @Nullable
    protected Character charBefore(@NotNull LinePosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        LinePosition it = pos.toTextualPos();
        boolean bl = false;
        return it.isAtAbsoluteStart() ? null : (it.isAtLineStart() ? Character.valueOf('\n') : Character.valueOf(this.textualLines.get(it.getLine()).getText().charAt(it.getColumn() - 1)));
    }

    @Nullable
    protected Character charAfter(@NotNull LinePosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        LinePosition it = pos.toTextualPos();
        boolean bl = false;
        return it.isAtAbsoluteEnd() ? null : (it.isAtLineEnd() ? Character.valueOf('\n') : Character.valueOf(this.textualLines.get(it.getLine()).getText().charAt(it.getColumn())));
    }

    protected boolean isBreakingCharacter(char ch) {
        return !Character.isLetterOrDigit(ch) && ch != '_';
    }

    @NotNull
    protected LinePosition getNearestWordBoundary(@NotNull LinePosition pos, @NotNull Direction direction) {
        char c;
        char p0;
        KFunction nextChar2;
        KProperty0 atEndOfDirection2;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        KProperty0 kProperty0 = atEndOfDirection2 = direction == Direction.Left ? (KProperty0)new PropertyReference0Impl(pos){

            @Nullable
            public Object get() {
                return ((LinePosition)this.receiver).isAtAbsoluteStart();
            }
        } : (KProperty0)new PropertyReference0Impl(pos){

            @Nullable
            public Object get() {
                return ((LinePosition)this.receiver).isAtAbsoluteEnd();
            }
        };
        if (((Boolean)atEndOfDirection2.invoke()).booleanValue()) {
            return pos;
        }
        LinePosition textualPos = pos.toTextualPos();
        int columnOffset = direction == Direction.Left ? -1 : 1;
        KFunction kFunction = nextChar2 = direction == Direction.Left ? (KFunction)new Function1<LinePosition, Character>((Object)this){

            @Nullable
            public final Character invoke(@NotNull LinePosition p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((AbstractTextInput)this.receiver).charBefore(p0);
            }
        } : (KFunction)new Function1<LinePosition, Character>((Object)this){

            @Nullable
            public final Character invoke(@NotNull LinePosition p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((AbstractTextInput)this.receiver).charAfter(p0);
            }
        };
        if (direction == Direction.Left && textualPos.isAtLineStart()) {
            TextualLine previousLine = this.textualLines.get(textualPos.getLine() - 1);
            return new LinePosition(textualPos.getLine() - 1, previousLine.getLength(), false);
        }
        if (direction == Direction.Right && textualPos.isAtLineEnd()) {
            return new LinePosition(textualPos.getLine() + 1, 0, false);
        }
        Character ch = (Character)((Function1)nextChar2).invoke((Object)textualPos);
        while (!((Boolean)atEndOfDirection2.invoke()).booleanValue()) {
            boolean bl;
            Character c2 = ch;
            if (c2 != null) {
                p0 = c2.charValue();
                boolean bl2 = false;
                bl = this.isBreakingCharacter(p0);
            } else {
                bl = false;
            }
            if (!bl) break;
            textualPos = textualPos.offsetColumn(columnOffset);
            Character c3 = ch = (Character)((Function1)nextChar2).invoke((Object)textualPos);
            c = '\n';
            if (c3 == null || c3.charValue() != c) continue;
            return textualPos;
        }
        while (!((Boolean)atEndOfDirection2.invoke()).booleanValue()) {
            boolean bl;
            Character c4 = ch;
            if (c4 != null) {
                p0 = c4.charValue();
                boolean bl3 = false;
                bl = !this.isBreakingCharacter(p0);
            } else {
                bl = false;
            }
            if (!bl) break;
            textualPos = textualPos.offsetColumn(columnOffset);
            Character c5 = ch = (Character)((Function1)nextChar2).invoke((Object)textualPos);
            c = '\n';
            if (c5 == null || c5.charValue() != c) continue;
            return textualPos;
        }
        LinePosition visualPos = textualPos.toVisualPos();
        if (direction == Direction.Left && visualPos.isAtLineEnd() && !visualPos.isInLastLine()) {
            textualPos = new LinePosition(visualPos.getLine() + 1, 0, true);
        } else if (direction == Direction.Right && visualPos.isAtLineStart() && !visualPos.isInFirstLine()) {
            textualPos = new LinePosition(visualPos.getLine() - 1, this.visualLines.get(visualPos.getLine() - 1).getText().length(), true);
        }
        return textualPos;
    }

    protected void animateCursor() {
        AnimatingConstraints anim$iv;
        UIComponent uIComponent;
        if (!this.active) {
            return;
        }
        UIComponent $this$animate$iv = this.cursorComponent;
        boolean $i$f$animate = false;
        UIComponent $this$animate_u24lambda_u240$iv = uIComponent = $this$animate$iv;
        boolean bl = false;
        AnimatingConstraints $this$animateCursor_u24lambda_u2412 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
        boolean bl2 = false;
        AnimatingConstraints.setColorAnimation$default($this$animateCursor_u24lambda_u2412, Animations.OUT_CIRCULAR, 0.5f, UtilitiesKt.toConstraint(this.cursorColor), 0.0f, 8, null);
        $this$animateCursor_u24lambda_u2412.onComplete((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AbstractTextInput this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                AnimatingConstraints anim$iv;
                void $this$animate$iv;
                void var4_4;
                if (!this.this$0.getActive()) {
                    return;
                }
                UIComponent uIComponent = this.this$0.getCursorComponent();
                AbstractTextInput abstractTextInput = this.this$0;
                boolean $i$f$animate = false;
                void $this$animate_u24lambda_u240$iv = var4_4 = $this$animate$iv;
                boolean bl = false;
                AnimatingConstraints $this$invoke_u24lambda_u240 = anim$iv = $this$animate_u24lambda_u240$iv.makeAnimation();
                boolean bl2 = false;
                AnimatingConstraints.setColorAnimation$default($this$invoke_u24lambda_u240, Animations.IN_CIRCULAR, 0.5f, UtilitiesKt.toConstraint(new Color(255, 255, 255, 0)), 0.0f, 8, null);
                $this$invoke_u24lambda_u240.onComplete((Function0<Unit>)((Function0)new Function0<Unit>(abstractTextInput){
                    final /* synthetic */ AbstractTextInput this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        if (this.this$0.getActive()) {
                            this.this$0.animateCursor();
                        }
                    }
                }));
                $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
            }
        }));
        $this$animate_u24lambda_u240$iv.animateTo(anim$iv);
    }

    protected boolean hasText() {
        return this.textualLines.size() > 1 || ((CharSequence)this.textualLines.get(0).getText()).length() > 0;
    }

    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawUnselectedText(matrixStack, text, left, row)", imports={}))
    protected void drawUnselectedText(@NotNull String text2, float left2, int row) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        AbstractTextInput.drawUnselectedText$default(this, UMatrixStack.Compat.INSTANCE.get(), text2, left2, row, null, false, null, 112, null);
    }

    protected void drawPlaceholder(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        AbstractTextInput.drawUnselectedText$default(this, matrixStack, this.placeholder, this.getLeft(), 0, this.placeholderColor.get(), this.placeholderShadow.get(), null, 64, null);
    }

    protected void drawUnselectedText(@NotNull UMatrixStack matrixStack, @NotNull String text2, float left2, int row, @Nullable Color color2, boolean shadow2, @Nullable Color shadowColor2) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        FontProvider fontProvider = this.getFontProvider();
        Color color3 = color2;
        if (color3 == null) {
            color3 = this.getColor();
        }
        fontProvider.drawString(matrixStack, text2, color3, left2 - this.horizontalScrollingOffset, this.getTop() + (this.getLineHeightWithPadding() * (float)row + 1.0f) * this.getTextScale() + this.verticalScrollingOffset, 10.0f, this.getTextScale(), shadow2, shadowColor2);
    }

    public static /* synthetic */ void drawUnselectedText$default(AbstractTextInput abstractTextInput, UMatrixStack uMatrixStack, String string, float f, int n, Color color2, boolean bl, Color color3, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: drawUnselectedText");
        }
        if ((n2 & 0x10) != 0) {
            color2 = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = abstractTextInput.contentShadow;
        }
        if ((n2 & 0x40) != 0) {
            color3 = abstractTextInput.contentShadowColor;
        }
        abstractTextInput.drawUnselectedText(uMatrixStack, string, f, n, color2, bl, color3);
    }

    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawSelectedText(matrixStack, text, left, right, row)", imports={}))
    protected void drawSelectedText(@NotNull String text2, float left2, float right, int row) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.drawSelectedText(UMatrixStack.Compat.INSTANCE.get(), text2, left2, right, row);
    }

    protected void drawSelectedText(@NotNull UMatrixStack matrixStack, @NotNull String text2, float left2, float right, int row) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        UIBlock.Companion.drawBlock(matrixStack, this.active ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor, (double)left2 - (double)this.horizontalScrollingOffset, (double)this.getTop() + (double)(this.getLineHeightWithPadding() * (float)row * this.getTextScale()) + (double)this.verticalScrollingOffset, (double)right - (double)this.horizontalScrollingOffset, (double)this.getTop() + (double)(this.getLineHeightWithPadding() * ((float)(row + 1) * this.getTextScale())) + (double)this.verticalScrollingOffset);
        if (((CharSequence)text2).length() > 0) {
            this.getFontProvider().drawString(matrixStack, text2, this.active ? this.selectionForegroundColor : this.inactiveSelectionForegroundColor, left2 - this.horizontalScrollingOffset, this.getTop() + (this.getLineHeightWithPadding() * (float)row + 1.0f) * this.getTextScale() + this.verticalScrollingOffset, 10.0f, this.getTextScale(), this.contentShadow, this.contentShadowColor);
        }
    }

    @Override
    public void animationFrame() {
        super.animationFrame();
        float diff = (this.targetVerticalScrollingOffset - this.verticalScrollingOffset) * 0.1f;
        if (Math.abs(diff) < 0.25f) {
            this.verticalScrollingOffset = this.targetVerticalScrollingOffset;
        }
        this.verticalScrollingOffset += diff;
        this.recalculateDimensions();
        if (this.cursorNeedsRefocus) {
            this.scrollIntoView(this.cursor);
            this.cursorNeedsRefocus = false;
        }
    }

    public static final /* synthetic */ void access$setContextMenuOpen$p(AbstractTextInput $this, boolean bl) {
        $this.contextMenuOpen = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$AddTextOperation;", "Lgg/essential/gui/common/input/AbstractTextInput$TextOperation;", "Lgg/essential/gui/common/input/AbstractTextInput;", "newText", "", "startPos", "Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;", "(Lgg/essential/gui/common/input/AbstractTextInput;Ljava/lang/String;Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;)V", "getNewText", "()Ljava/lang/String;", "redo", "", "undo", "essential-gui-essential"})
    protected final class AddTextOperation
    extends TextOperation {
        @NotNull
        private final String newText;
        @NotNull
        private final LinePosition startPos;

        public AddTextOperation(@NotNull String newText, LinePosition startPos) {
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
            this.newText = newText;
            this.startPos = startPos;
        }

        @NotNull
        public final String getNewText() {
            return this.newText;
        }

        @Override
        public void redo() {
            AbstractTextInput.this.addText(this.newText, this.startPos);
        }

        @Override
        public void undo() {
            AbstractTextInput.this.removeText(this.startPos, this.startPos.offsetColumn(this.newText.length()));
            AbstractTextInput.this.setCursorPosition(this.startPos.toVisualPos());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$Companion;", "", "()V", "isAllowedCharacter", "", "chr", "", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAllowedCharacter(char chr) {
            return chr != '\u00a7' && Intrinsics.compare((int)chr, (int)32) >= 0 && chr != '\u007f';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$Direction;", "", "(Ljava/lang/String;I)V", "Left", "Right", "essential-gui-essential"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction Left = new Direction();
        public static final /* enum */ Direction Right = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value2) {
            return Enum.valueOf(Direction.class, value2);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.Left, Direction.Right};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0094\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$Line;", "", "text", "", "(Lgg/essential/gui/common/input/AbstractTextInput;Ljava/lang/String;)V", "length", "", "getLength", "()I", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "essential-gui-essential"})
    protected class Line {
        @NotNull
        private String text;

        public Line(String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.text = string;
        }

        public final int getLength() {
            return this.text.length();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0016\u001a\u00020\u00042\n\u0010\u0017\u001a\u00060\u0000R\u00020\u0002H\u0096\u0002J\u0018\u0010\u0018\u001a\u00060\u0000R\u00020\u00022\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0002J\u0018\u0010\u001a\u001a\u00060\u0000R\u00020\u00022\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0002J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\u0012\u0010\u001e\u001a\u00060\u0000R\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0004J!\u0010 \u001a\u00060\u0000R\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00042\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0082\u0010J!\u0010!\u001a\u00060\u0000R\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00042\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0082\u0010J\u0018\u0010\"\u001a\u00060\u0000R\u00020\u00022\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0002J\u0018\u0010#\u001a\u00060\u0000R\u00020\u00022\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0002J\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%J\b\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u00060\u0000R\u00020\u0002J\n\u0010*\u001a\u00060\u0000R\u00020\u0002J\u0012\u0010+\u001a\u00060\u0000R\u00020\u00022\u0006\u0010,\u001a\u00020\u0004R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;", "", "Lgg/essential/gui/common/input/AbstractTextInput;", "line", "", "column", "isVisual", "", "(Lgg/essential/gui/common/input/AbstractTextInput;IIZ)V", "getColumn", "()I", "isAtAbsoluteEnd", "()Z", "isAtAbsoluteStart", "isAtLineEnd", "isAtLineStart", "isInFirstLine", "isInLastLine", "getLine", "lines", "", "Lgg/essential/gui/common/input/AbstractTextInput$Line;", "compareTo", "other", "complexOffsetColumnNegative", "pos", "complexOffsetColumnPositive", "equals", "", "hashCode", "offsetColumn", "amount", "offsetColumnNegative", "offsetColumnPositive", "simpleOffsetColumnNegative", "simpleOffsetColumnPositive", "toScreenPos", "Lkotlin/Pair;", "", "toString", "", "toTextualPos", "toVisualPos", "withColumn", "newColumn", "essential-gui-essential"})
    public final class LinePosition
    implements Comparable<LinePosition> {
        private final int line;
        private final int column;
        private final boolean isVisual;
        @NotNull
        private final List<Line> lines;

        public LinePosition(int line, int column, boolean isVisual) {
            this.line = line;
            this.column = column;
            this.isVisual = isVisual;
            this.lines = this.isVisual ? AbstractTextInput.this.getVisualLines() : AbstractTextInput.this.getTextualLines();
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }

        public final boolean isVisual() {
            return this.isVisual;
        }

        public final boolean isAtLineStart() {
            return this.column == 0;
        }

        public final boolean isAtLineEnd() {
            return this.column == this.lines.get(this.line).getLength();
        }

        public final boolean isInFirstLine() {
            return this.line == 0;
        }

        public final boolean isInLastLine() {
            return this.line == CollectionsKt.getLastIndex(this.lines);
        }

        public final boolean isAtAbsoluteStart() {
            return this.isInFirstLine() && this.isAtLineStart();
        }

        public final boolean isAtAbsoluteEnd() {
            return this.isInLastLine() && this.isAtLineEnd();
        }

        @NotNull
        public final LinePosition offsetColumn(int amount) {
            return amount > 0 ? this.offsetColumnPositive(amount, this) : (amount < 0 ? this.offsetColumnNegative(-amount, this) : this);
        }

        private final LinePosition offsetColumnNegative(int amount, LinePosition pos) {
            while (amount != 0 && !pos.isAtAbsoluteStart()) {
                LinePosition linePosition = this_;
                int n = amount - 1;
                LinePosition linePosition2 = this_.complexOffsetColumnNegative(pos);
                LinePosition this_ = linePosition;
                amount = n;
                pos = linePosition2;
            }
            return pos;
        }

        private final LinePosition complexOffsetColumnNegative(LinePosition pos) {
            if (!pos.isVisual) {
                return this.simpleOffsetColumnNegative(pos);
            }
            if (!pos.isAtLineStart()) {
                return this.simpleOffsetColumnNegative(pos);
            }
            VisualLine currentLine = AbstractTextInput.this.getVisualLines().get(pos.line);
            VisualLine previousLine = AbstractTextInput.this.getVisualLines().get(pos.line - 1);
            if (currentLine.getTextIndex() != previousLine.getTextIndex()) {
                return this.simpleOffsetColumnNegative(pos);
            }
            if (StringsKt.last((CharSequence)previousLine.getText()) != ' ') {
                return this.simpleOffsetColumnNegative(pos);
            }
            return new LinePosition(pos.line - 1, previousLine.getLength() - 1, true);
        }

        private final LinePosition simpleOffsetColumnNegative(LinePosition pos) {
            return pos.column == 0 ? new LinePosition(pos.line - 1, pos.lines.get(pos.line - 1).getLength(), pos.isVisual) : pos.withColumn(pos.column - 1);
        }

        private final LinePosition offsetColumnPositive(int amount, LinePosition pos) {
            while (amount != 0 && !pos.isAtAbsoluteEnd()) {
                LinePosition linePosition = this_;
                int n = amount - 1;
                LinePosition linePosition2 = this_.complexOffsetColumnPositive(pos);
                LinePosition this_ = linePosition;
                amount = n;
                pos = linePosition2;
            }
            return pos;
        }

        private final LinePosition complexOffsetColumnPositive(LinePosition pos) {
            if (!pos.isVisual) {
                return this.simpleOffsetColumnPositive(pos);
            }
            VisualLine currentLine = AbstractTextInput.this.getVisualLines().get(pos.line);
            if (pos.column < currentLine.getLength() - 1) {
                return this.simpleOffsetColumnPositive(pos);
            }
            if (pos.line == CollectionsKt.getLastIndex(AbstractTextInput.this.getVisualLines())) {
                return new LinePosition(pos.line, currentLine.getLength(), true);
            }
            if (pos.column == currentLine.getLength() - 1 && StringsKt.last((CharSequence)currentLine.getText()) != ' ') {
                return this.simpleOffsetColumnPositive(pos);
            }
            VisualLine nextLine = AbstractTextInput.this.getVisualLines().get(pos.line + 1);
            if (currentLine.getTextIndex() == nextLine.getTextIndex()) {
                return new LinePosition(pos.line + 1, 0, true);
            }
            return this.simpleOffsetColumnPositive(pos);
        }

        private final LinePosition simpleOffsetColumnPositive(LinePosition pos) {
            return pos.column >= pos.lines.get(pos.line).getLength() ? (pos.line == CollectionsKt.getLastIndex(pos.lines) ? new LinePosition(CollectionsKt.getLastIndex(pos.lines), ((Line)CollectionsKt.last(pos.lines)).getLength(), pos.isVisual) : new LinePosition(pos.line + 1, 0, pos.isVisual)) : pos.withColumn(pos.column + 1);
        }

        @NotNull
        public final LinePosition withColumn(int newColumn) {
            return new LinePosition(this.line, newColumn, this.isVisual);
        }

        @NotNull
        public final LinePosition toTextualPos() {
            if (!this.isVisual) {
                return this;
            }
            VisualLine visualLine = AbstractTextInput.this.getVisualLines().get(this.line);
            TextualLine textualLine = AbstractTextInput.this.getTextualLines().get(visualLine.getTextIndex());
            int totalVisualLength = 0;
            int n = this.line;
            for (int i2 = textualLine.getVisualIndices().getFirst(); i2 < n; ++i2) {
                totalVisualLength += AbstractTextInput.this.getVisualLines().get(i2).getLength();
            }
            return new LinePosition(visualLine.getTextIndex(), totalVisualLength + this.column, false);
        }

        @NotNull
        public final LinePosition toVisualPos() {
            int n;
            if (this.isVisual) {
                return this;
            }
            TextualLine textualLine = AbstractTextInput.this.getTextualLines().get(this.line);
            int lengthRemaining = this.column;
            IntRange intRange = textualLine.getVisualIndices();
            int visualLineIndex = intRange.getFirst();
            if (visualLineIndex <= (n = intRange.getLast())) {
                while (true) {
                    VisualLine visualLine;
                    if ((visualLine = AbstractTextInput.this.getVisualLines().get(visualLineIndex)).getLength() >= lengthRemaining) {
                        return new LinePosition(visualLineIndex, lengthRemaining, true);
                    }
                    lengthRemaining -= visualLine.getLength();
                    if (visualLineIndex == n) break;
                    ++visualLineIndex;
                }
            }
            System.out.println((Object)"toTextualPos: Unexpected end of function");
            return new LinePosition(0, 0, true);
        }

        @NotNull
        public final Pair<Float, Float> toScreenPos() {
            LinePosition visualPos = this.toVisualPos();
            String string = AbstractTextInput.this.getVisualLines().get(visualPos.line).getText().substring(0, visualPos.column);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            float x = UtilitiesKt.width(string, AbstractTextInput.this.getTextScale(), AbstractTextInput.this.getFontProvider()) - AbstractTextInput.this.getHorizontalScrollingOffset();
            float y = AbstractTextInput.this.getLineHeightWithPadding() * (float)visualPos.line * AbstractTextInput.this.getTextScale() + AbstractTextInput.this.getVerticalScrollingOffset();
            return TuplesKt.to((Object)Float.valueOf(x), (Object)Float.valueOf(y));
        }

        @Override
        public int compareTo(@NotNull LinePosition other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            LinePosition thisVisual = this.toVisualPos();
            LinePosition otherVisual = other.toVisualPos();
            return thisVisual.line < otherVisual.line ? -1 : (thisVisual.line > otherVisual.line ? 1 : (thisVisual.column < otherVisual.column ? -1 : (thisVisual.column > otherVisual.column ? 1 : 0)));
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof LinePosition && this.line == ((LinePosition)other).line && this.column == ((LinePosition)other).column && this.isVisual == ((LinePosition)other).isVisual;
        }

        public int hashCode() {
            int result = this.line;
            result = 31 * result + this.column;
            result = 31 * result + Boolean.hashCode(this.isVisual);
            return result;
        }

        @NotNull
        public String toString() {
            return "LinePosition(line=" + this.line + ", column=" + this.column + ", isVisual=" + this.isVisual + ')';
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0002\u0012\n\u0010\u0005\u001a\u00060\u0004R\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0012\u0010\u0005\u001a\u00060\u0004R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$RemoveTextOperation;", "Lgg/essential/gui/common/input/AbstractTextInput$TextOperation;", "Lgg/essential/gui/common/input/AbstractTextInput;", "startPos", "Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;", "endPos", "selectAfterUndo", "", "(Lgg/essential/gui/common/input/AbstractTextInput;Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;Z)V", "text", "", "getText", "()Ljava/lang/String;", "redo", "", "undo", "essential-gui-essential"})
    protected final class RemoveTextOperation
    extends TextOperation {
        @NotNull
        private final LinePosition startPos;
        @NotNull
        private final LinePosition endPos;
        private final boolean selectAfterUndo;
        @NotNull
        private final String text;

        public RemoveTextOperation(@NotNull LinePosition startPos, LinePosition endPos, boolean selectAfterUndo) {
            Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
            Intrinsics.checkNotNullParameter((Object)endPos, (String)"endPos");
            this.startPos = startPos;
            this.endPos = endPos;
            this.selectAfterUndo = selectAfterUndo;
            this.text = AbstractTextInput.this.getTextBetween(this.startPos, this.endPos);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Override
        public void redo() {
            LinePosition textualStartPos = this.startPos.toTextualPos();
            AbstractTextInput.this.removeText(textualStartPos, this.endPos);
            AbstractTextInput.this.setCursorPosition(textualStartPos);
        }

        @Override
        public void undo() {
            AbstractTextInput.this.addText(this.text, this.startPos);
            if (this.selectAfterUndo) {
                AbstractTextInput.this.setCursor(this.startPos);
                AbstractTextInput.this.setOtherSelectionEnd(this.endPos);
                AbstractTextInput.this.setCursorNeedsRefocus(true);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0002\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u00060\u0006R\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$ReplaceTextOperation;", "Lgg/essential/gui/common/input/AbstractTextInput$TextOperation;", "Lgg/essential/gui/common/input/AbstractTextInput;", "addTextOperation", "Lgg/essential/gui/common/input/AbstractTextInput$AddTextOperation;", "removeTextOperation", "Lgg/essential/gui/common/input/AbstractTextInput$RemoveTextOperation;", "(Lgg/essential/gui/common/input/AbstractTextInput;Lgg/essential/gui/common/input/AbstractTextInput$AddTextOperation;Lgg/essential/gui/common/input/AbstractTextInput$RemoveTextOperation;)V", "getAddTextOperation", "()Lgg/essential/gui/common/input/AbstractTextInput$AddTextOperation;", "getRemoveTextOperation", "()Lgg/essential/gui/common/input/AbstractTextInput$RemoveTextOperation;", "redo", "", "undo", "essential-gui-essential"})
    protected final class ReplaceTextOperation
    extends TextOperation {
        @NotNull
        private final AddTextOperation addTextOperation;
        @NotNull
        private final RemoveTextOperation removeTextOperation;

        public ReplaceTextOperation(@NotNull AddTextOperation addTextOperation, RemoveTextOperation removeTextOperation) {
            Intrinsics.checkNotNullParameter((Object)addTextOperation, (String)"addTextOperation");
            Intrinsics.checkNotNullParameter((Object)removeTextOperation, (String)"removeTextOperation");
            this.addTextOperation = addTextOperation;
            this.removeTextOperation = removeTextOperation;
        }

        @NotNull
        public final AddTextOperation getAddTextOperation() {
            return this.addTextOperation;
        }

        @NotNull
        public final RemoveTextOperation getRemoveTextOperation() {
            return this.removeTextOperation;
        }

        @Override
        public void redo() {
            this.removeTextOperation.redo();
            this.addTextOperation.redo();
        }

        @Override
        public void undo() {
            this.addTextOperation.undo();
            this.removeTextOperation.undo();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$SelectionMode;", "", "(Ljava/lang/String;I)V", "None", "Character", "Word", "Line", "essential-gui-essential"})
    public static final class SelectionMode
    extends Enum<SelectionMode> {
        public static final /* enum */ SelectionMode None = new SelectionMode();
        public static final /* enum */ SelectionMode Character = new SelectionMode();
        public static final /* enum */ SelectionMode Word = new SelectionMode();
        public static final /* enum */ SelectionMode Line = new SelectionMode();
        private static final /* synthetic */ SelectionMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SelectionMode[] values() {
            return (SelectionMode[])$VALUES.clone();
        }

        public static SelectionMode valueOf(String value2) {
            return Enum.valueOf(SelectionMode.class, value2);
        }

        @NotNull
        public static EnumEntries<SelectionMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = selectionModeArray = new SelectionMode[]{SelectionMode.None, SelectionMode.Character, SelectionMode.Word, SelectionMode.Line};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0004H&\u00a8\u0006\u0006"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$TextOperation;", "", "(Lgg/essential/gui/common/input/AbstractTextInput;)V", "redo", "", "undo", "essential-gui-essential"})
    protected abstract class TextOperation {
        public abstract void redo();

        public abstract void undo();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0004H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$TextualLine;", "Lgg/essential/gui/common/input/AbstractTextInput$Line;", "Lgg/essential/gui/common/input/AbstractTextInput;", "text", "", "visualIndices", "Lkotlin/ranges/IntRange;", "(Lgg/essential/gui/common/input/AbstractTextInput;Ljava/lang/String;Lkotlin/ranges/IntRange;)V", "getVisualIndices", "()Lkotlin/ranges/IntRange;", "setVisualIndices", "(Lkotlin/ranges/IntRange;)V", "addTextAt", "", "newText", "column", "", "toString", "essential-gui-essential"})
    protected final class TextualLine
    extends Line {
        @NotNull
        private IntRange visualIndices;
        final /* synthetic */ AbstractTextInput this$0;

        public TextualLine(@NotNull AbstractTextInput this$0, @NotNull String text2, IntRange visualIndices) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)visualIndices, (String)"visualIndices");
            this.this$0 = this$0;
            super(text2);
            this.visualIndices = visualIndices;
        }

        public /* synthetic */ TextualLine(AbstractTextInput abstractTextInput, String string, IntRange intRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                intRange = new IntRange(0, 0);
            }
            this(abstractTextInput, string, intRange);
        }

        @NotNull
        public final IntRange getVisualIndices() {
            return this.visualIndices;
        }

        public final void setVisualIndices(@NotNull IntRange intRange) {
            Intrinsics.checkNotNullParameter((Object)intRange, (String)"<set-?>");
            this.visualIndices = intRange;
        }

        public final void addTextAt(@NotNull String newText, int column) {
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            if (column >= this.getText().length()) {
                this.setText(this.getText() + newText);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string = this.getText().substring(0, column);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                StringBuilder stringBuilder2 = stringBuilder.append(string).append(newText);
                String string2 = this.getText().substring(column);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                this.setText(stringBuilder2.append(string2).toString());
            }
        }

        @NotNull
        public String toString() {
            return "TextualLine(text=" + this.getText() + ", visualIndices=" + this.visualIndices + ')';
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0004H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lgg/essential/gui/common/input/AbstractTextInput$VisualLine;", "Lgg/essential/gui/common/input/AbstractTextInput$Line;", "Lgg/essential/gui/common/input/AbstractTextInput;", "text", "", "textIndex", "", "(Lgg/essential/gui/common/input/AbstractTextInput;Ljava/lang/String;I)V", "getTextIndex", "()I", "toString", "essential-gui-essential"})
    protected final class VisualLine
    extends Line {
        private final int textIndex;

        public VisualLine(String text2, int textIndex) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(text2);
            this.textIndex = textIndex;
        }

        public final int getTextIndex() {
            return this.textIndex;
        }

        @NotNull
        public String toString() {
            return "VisualLine(text=" + this.getText() + ", textIndex=" + this.textIndex + ')';
        }
    }
}

