/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common.input;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.input.AbstractTextInput;
import gg.essential.gui.common.input.UIMultilineTextInput;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001Bc\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0014J\b\u0010\u0017\u001a\u00020\u0012H\u0014J\u001c\u0010\u0018\u001a\u00060\u0019R\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0014J\u0014\u0010\u001d\u001a\u00020\u00122\n\u0010\u001e\u001a\u00060\u0019R\u00020\u0001H\u0014J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\u0006\u0010%\u001a\u00020\u0003H\u0014R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lgg/essential/gui/common/input/UIMultilineTextInput;", "Lgg/essential/gui/common/input/AbstractTextInput;", "placeholder", "", "shadow", "", "shadowColor", "Ljava/awt/Color;", "selectionBackgroundColor", "selectionForegroundColor", "allowInactiveSelection", "inactiveSelectionBackgroundColor", "inactiveSelectionForegroundColor", "cursorColor", "(Ljava/lang/String;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "maxHeight", "Lgg/essential/elementa/constraints/HeightConstraint;", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "getText", "onEnterPressed", "recalculateDimensions", "screenPosToVisualPos", "Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;", "x", "", "y", "scrollIntoView", "pos", "setMaxHeight", "setMaxLines", "maxLines", "", "textToLines", "", "text", "essential-gui-essential"})
public final class UIMultilineTextInput
extends AbstractTextInput {
    @Nullable
    private HeightConstraint maxHeight;

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)cursorColor, (String)"cursorColor");
        super(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, cursorColor, 0, 512, null);
    }

    public /* synthetic */ UIMultilineTextInput(String string, boolean bl, Color color2, Color color3, Color color4, boolean bl2, Color color5, Color color6, Color color7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            color2 = null;
        }
        if ((n & 8) != 0) {
            color3 = EssentialPalette.TEXT_HIGHLIGHT_BACKGROUND;
        }
        if ((n & 0x10) != 0) {
            color4 = EssentialPalette.TEXT_HIGHLIGHT;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            color5 = new Color(176, 176, 176);
        }
        if ((n & 0x80) != 0) {
            Color color8 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color8, (String)"WHITE");
            color6 = color8;
        }
        if ((n & 0x100) != 0) {
            color7 = EssentialPalette.TEXT_HIGHLIGHT;
        }
        this(string, bl, color2, color3, color4, bl2, color5, color6, color7);
    }

    @NotNull
    public final UIMultilineTextInput setMaxHeight(@NotNull HeightConstraint maxHeight) {
        UIMultilineTextInput uIMultilineTextInput;
        Intrinsics.checkNotNullParameter((Object)maxHeight, (String)"maxHeight");
        UIMultilineTextInput $this$setMaxHeight_u24lambda_u240 = uIMultilineTextInput = this;
        boolean bl = false;
        $this$setMaxHeight_u24lambda_u240.maxHeight = maxHeight;
        return uIMultilineTextInput;
    }

    @NotNull
    public final UIMultilineTextInput setMaxLines(int maxLines) {
        UIMultilineTextInput uIMultilineTextInput;
        UIMultilineTextInput $this$setMaxLines_u24lambda_u241 = uIMultilineTextInput = this;
        boolean bl = false;
        $this$setMaxLines_u24lambda_u241.maxHeight = UtilitiesKt.pixels$default(Float.valueOf($this$setMaxLines_u24lambda_u241.getLineHeightWithPadding() * (float)maxLines - $this$setMaxLines_u24lambda_u241.getLinePadding()), false, false, 3, null);
        return uIMultilineTextInput;
    }

    @Override
    @NotNull
    public String getText() {
        return CollectionsKt.joinToString$default((Iterable)this.getTextualLines(), (CharSequence)"\n", null, null, (int)0, null, (Function1)getText.1.INSTANCE, (int)30, null);
    }

    @Override
    @NotNull
    protected List<String> textToLines(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        char[] cArray = new char[]{'\n'};
        return StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    @Override
    protected void scrollIntoView(@NotNull AbstractTextInput.LinePosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        AbstractTextInput.LinePosition visualPos = pos.toVisualPos();
        float visualLineOffset = (float)visualPos.getLine() * -this.getLineHeightWithPadding();
        if (this.getTargetVerticalScrollingOffset() < visualLineOffset) {
            this.setTargetVerticalScrollingOffset(visualLineOffset);
        } else if (visualLineOffset - this.getLineHeightWithPadding() < this.getTargetVerticalScrollingOffset() - this.getHeight()) {
            this.setTargetVerticalScrollingOffset(this.getTargetVerticalScrollingOffset() + (visualLineOffset - this.getLineHeightWithPadding() - (this.getTargetVerticalScrollingOffset() - this.getHeight())));
        }
    }

    @Override
    protected void recalculateDimensions() {
        HeightConstraint height2 = UtilitiesKt.pixels$default(Float.valueOf(this.getLineHeightWithPadding() * (float)this.getVisualLines().size() - this.getLinePadding()), false, false, 3, null);
        if (this.maxHeight != null) {
            SuperConstraint superConstraint = height2;
            HeightConstraint heightConstraint = this.maxHeight;
            Intrinsics.checkNotNull((Object)heightConstraint);
            height2 = ConstraintsKt.coerceAtMost(superConstraint, heightConstraint);
        }
        this.setHeight(height2);
    }

    @Override
    protected void onEnterPressed() {
        if (UKeyboard.isShiftKeyDown()) {
            this.commitTextAddition("\n");
            this.getUpdateAction().invoke((Object)this.getText());
            this.getTextState().set(this.getText());
        } else {
            this.getActivateAction().invoke((Object)this.getText());
        }
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDraw(matrixStack);
        float textScale = this.getTextScale();
        if (!this.hasText()) {
            this.drawPlaceholder(matrixStack);
        }
        if (this.hasSelection()) {
            this.getCursorComponent().hide(true);
        } else if (this.getActive()) {
            UIComponent.unhide$default(this.getCursorComponent(), false, 1, null);
            object = this.getCursor().toScreenPos();
            float cursorPosX = ((Number)object.component1()).floatValue();
            float cursorPosY = ((Number)object.component2()).floatValue();
            this.getCursorComponent().setX(UtilitiesKt.pixels$default(Float.valueOf(cursorPosX), false, false, 3, null));
            this.getCursorComponent().setY(UtilitiesKt.pixels$default(Float.valueOf(cursorPosY), false, false, 3, null));
        }
        object = this.getSelection();
        AbstractTextInput.LinePosition selectionStart = (AbstractTextInput.LinePosition)object.component1();
        AbstractTextInput.LinePosition selectionEnd = (AbstractTextInput.LinePosition)object.component2();
        Iterator<AbstractTextInput.VisualLine> iterator = this.getVisualLines().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3;
            int i2 = n++;
            AbstractTextInput.VisualLine visualLine = iterator.next();
            float topOffset = this.getLineHeightWithPadding() * (float)i2 * this.getTextScale() + this.getVerticalScrollingOffset();
            if (topOffset < -this.getLineHeightWithPadding() * this.getTextScale() || topOffset > this.getHeight() + this.getLineHeightWithPadding() * this.getTextScale()) continue;
            if (!this.hasSelection() || i2 < selectionStart.getLine() || i2 > selectionEnd.getLine()) {
                AbstractTextInput.drawUnselectedText$default(this, matrixStack, visualLine.getText(), this.getLeft(), i2, null, false, null, 112, null);
                continue;
            }
            if (i2 == selectionStart.getLine() && selectionStart.getColumn() > 0) {
                String string4 = visualLine.getText().substring(0, selectionStart.getColumn());
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            } else {
                string3 = "";
            }
            String startText = string3;
            if (selectionStart.getLine() == selectionEnd.getLine()) {
                String string5 = visualLine.getText().substring(selectionStart.getColumn(), selectionEnd.getColumn());
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            } else if (i2 > selectionStart.getLine() && i2 < selectionEnd.getLine()) {
                string2 = visualLine.getText();
            } else if (i2 == selectionStart.getLine()) {
                String string6 = visualLine.getText().substring(selectionStart.getColumn());
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            } else if (i2 == selectionEnd.getLine()) {
                String string7 = visualLine.getText().substring(0, selectionEnd.getColumn());
                string2 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            } else {
                string2 = "";
            }
            String selectedText2 = string2;
            if (i2 == selectionEnd.getLine() && selectionEnd.getColumn() < this.getVisualLines().get(i2).getLength()) {
                String string8 = visualLine.getText().substring(selectionEnd.getColumn());
                string = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
            } else {
                string = "";
            }
            String endText = string;
            float startTextWidth = UtilitiesKt.width$default(startText, textScale, null, 2, null);
            float selectedTextWidth = UtilitiesKt.width$default(selectedText2, textScale, null, 2, null);
            float newlinePadding = i2 < selectionEnd.getLine() ? UtilitiesKt.width(' ', textScale) : 0.0f;
            if (((CharSequence)startText).length() > 0) {
                AbstractTextInput.drawUnselectedText$default(this, matrixStack, startText, this.getLeft(), i2, null, false, null, 112, null);
            }
            if (((CharSequence)selectedText2).length() > 0 || !(newlinePadding == 0.0f)) {
                this.drawSelectedText(matrixStack, selectedText2, this.getLeft() + startTextWidth, this.getLeft() + startTextWidth + selectedTextWidth + newlinePadding, i2);
            }
            if (!(((CharSequence)endText).length() > 0)) continue;
            AbstractTextInput.drawUnselectedText$default(this, matrixStack, endText, this.getLeft() + startTextWidth + selectedTextWidth, i2, null, false, null, 112, null);
        }
        super.draw(matrixStack);
    }

    @Override
    @NotNull
    protected AbstractTextInput.LinePosition screenPosToVisualPos(float x, float y) {
        float realY = y - this.getVerticalScrollingOffset();
        if (realY < 0.0f) {
            return new AbstractTextInput.LinePosition(0, 0, true);
        }
        int line = (int)(realY / (this.getLineHeightWithPadding() * this.getTextScale()));
        if (line > CollectionsKt.getLastIndex(this.getVisualLines())) {
            return new AbstractTextInput.LinePosition(CollectionsKt.getLastIndex(this.getVisualLines()), ((AbstractTextInput.VisualLine)CollectionsKt.last(this.getVisualLines())).getText().length(), true);
        }
        String text2 = this.getVisualLines().get(line).getText();
        int column = 0;
        float currWidth = 0.0f;
        if (x <= 0.0f) {
            return new AbstractTextInput.LinePosition(line, 0, true);
        }
        if (x >= this.getWidth()) {
            return new AbstractTextInput.LinePosition(line, this.getVisualLines().get(line).getText().length(), true);
        }
        char[] cArray = text2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            float charWidth = UtilitiesKt.width(c, this.getTextScale());
            if (currWidth + charWidth / (float)2 >= x) {
                return new AbstractTextInput.LinePosition(line, column, true);
            }
            currWidth += charWidth;
            ++column;
        }
        return new AbstractTextInput.LinePosition(line, column, true);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, null, 256, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, null, null, 384, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, null, null, null, 448, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, false, null, null, null, 480, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, null, false, null, null, null, 496, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, shadow2, shadowColor2, null, null, false, null, null, null, 504, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow2) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, shadow2, null, null, null, false, null, null, null, 508, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, false, null, null, null, false, null, null, null, 510, null);
    }

    @JvmOverloads
    public UIMultilineTextInput() {
        this(null, false, null, null, null, false, null, null, null, 511, null);
    }
}

