/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common.shadow;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.font.FontProvider;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.MappedState;
import gg.essential.elementa.state.State;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.LoadingIcon;
import gg.essential.gui.common.SequenceAnimatedUIImage;
import gg.essential.gui.common.shadow.EssentialUIText;
import gg.essential.gui.common.shadow.ShadowEffect;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgg/essential/gui/common/shadow/ShadowEffect;", "Lgg/essential/elementa/effects/Effect;", "shadowColor", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "shadowColorState", "Lgg/essential/elementa/state/MappedState;", "beforeDraw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "getDebugInfo", "", "rebindColor", "state", "Lgg/essential/elementa/state/State;", "essential-gui-essential"})
public final class ShadowEffect
extends Effect {
    @NotNull
    private final MappedState<Color, Color> shadowColorState;

    public ShadowEffect(@NotNull Color shadowColor2) {
        Intrinsics.checkNotNullParameter((Object)shadowColor2, (String)"shadowColor");
        this.shadowColorState = new BasicState<Color>(shadowColor2).map(shadowColorState.1.INSTANCE);
    }

    public /* synthetic */ ShadowEffect(Color color2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            color2 = EssentialPalette.COMPONENT_BACKGROUND;
        }
        this(color2);
    }

    @Override
    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        UIComponent boundComponent = this.getBoundComponent();
        if (boundComponent instanceof EssentialUIText) {
            String text2 = ((EssentialUIText)boundComponent).getText();
            if (((CharSequence)text2).length() == 0 || boundComponent.getColor().getAlpha() <= 10) {
                return;
            }
            UIConstraints constraints = boundComponent.getConstraints();
            float scale2 = constraints.getTextScale();
            FontProvider fontProvider = constraints.getFontProvider();
            float x = boundComponent.getLeft();
            float y = boundComponent.getTop() + (constraints.getY() instanceof CenterConstraint ? fontProvider.getBelowLineHeight() * scale2 : 0.0f);
            Color color2 = (Color)this.shadowColorState.get();
            UGraphics.enableBlend();
            FontProvider.drawString$default(fontProvider, matrixStack, text2, color2, x + 1.0f, y + 1.0f, 10.0f, scale2, false, null, 256, null);
        } else if (boundComponent instanceof SequenceAnimatedUIImage) {
            UIImage uIImage = ((SequenceAnimatedUIImage)boundComponent).getCurrentFrameComponent();
            if (uIImage == null) {
                return;
            }
            UIImage child = uIImage;
            child.drawImage(matrixStack, (double)boundComponent.getLeft() + 1.0, (double)boundComponent.getTop() + 1.0, boundComponent.getWidth(), boundComponent.getHeight(), (Color)this.shadowColorState.get());
        } else if (boundComponent instanceof UIBlock ? true : boundComponent instanceof UIContainer) {
            if (boundComponent.getColor().getAlpha() == 0) {
                return;
            }
            double x = boundComponent.getLeft();
            double y = boundComponent.getTop();
            double x2 = boundComponent.getRight();
            double y2 = boundComponent.getBottom();
            Color color3 = (Color)this.shadowColorState.get();
            UIBlock.Companion.drawBlock(matrixStack, color3, x + 1.0, y + 1.0, x2 + 1.0, y2 + 1.0);
        } else if (boundComponent instanceof UIImage) {
            ((UIImage)boundComponent).drawImage(matrixStack, (double)boundComponent.getLeft() + 1.0, (double)boundComponent.getTop() + 1.0, boundComponent.getWidth(), boundComponent.getHeight(), (Color)this.shadowColorState.get());
        } else if (boundComponent instanceof LoadingIcon) {
            float xCenter = (boundComponent.getLeft() + boundComponent.getRight()) / (float)2;
            float yCenter = (boundComponent.getTop() + boundComponent.getBottom()) / (float)2;
            LoadingIcon.Companion.draw(matrixStack, xCenter + (float)((int)((LoadingIcon)boundComponent).getScale()), yCenter + (float)((int)((LoadingIcon)boundComponent).getScale()), ((LoadingIcon)boundComponent).getScale(), ((LoadingIcon)boundComponent).getTime(), (Color)this.shadowColorState.get());
        } else {
            throw new UnsupportedOperationException("Shadow effect cannot be applied to " + this.getDebugInfo());
        }
    }

    @NotNull
    public final ShadowEffect rebindColor(@NotNull State<Color> state2) {
        ShadowEffect shadowEffect;
        Intrinsics.checkNotNullParameter(state2, (String)"state");
        ShadowEffect $this$rebindColor_u24lambda_u240 = shadowEffect = this;
        boolean bl = false;
        $this$rebindColor_u24lambda_u240.shadowColorState.rebind(state2);
        return shadowEffect;
    }

    private final String getDebugInfo() {
        return this.getBoundComponent().getComponentName() + ' ' + this.getBoundComponent().getClass().getName();
    }

    public ShadowEffect() {
        this(null, 1, null);
    }
}

