/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.essentialmarkdown;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.events.UIEvent;
import gg.essential.elementa.font.FontProvider;
import gg.essential.gui.elementa.essentialmarkdown.DrawState;
import gg.essential.gui.elementa.essentialmarkdown.MarkdownConfig;
import gg.essential.gui.elementa.essentialmarkdown.MarkdownRenderer;
import gg.essential.gui.elementa.essentialmarkdown.drawables.BlockquoteDrawable;
import gg.essential.gui.elementa.essentialmarkdown.drawables.Drawable;
import gg.essential.gui.elementa.essentialmarkdown.drawables.DrawableList;
import gg.essential.gui.elementa.essentialmarkdown.drawables.HeaderDrawable;
import gg.essential.gui.elementa.essentialmarkdown.drawables.ListDrawable;
import gg.essential.gui.elementa.essentialmarkdown.drawables.ParagraphDrawable;
import gg.essential.gui.elementa.essentialmarkdown.selection.Cursor;
import gg.essential.gui.elementa.essentialmarkdown.selection.Selection;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.universal.UDesktop;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 >2\u00020\u0001:\u0003>?@B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010/\u001a\u00020 H\u0016J\u0006\u00100\u001a\u00020 J\b\u00101\u001a\u00020\u001aH\u0002J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0016J\u0015\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b7J\u0006\u00108\u001a\u00020 J%\u00109\u001a\u00020 2\u001d\u0010:\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!J\b\u0010;\u001a\u00020 H\u0002J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u000e\u0010=\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u001c\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0)2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown;", "Lgg/essential/elementa/UIComponent;", "text", "", "config", "Lgg/essential/gui/elementa/essentialmarkdown/MarkdownConfig;", "disableSelection", "", "(Ljava/lang/String;Lgg/essential/gui/elementa/essentialmarkdown/MarkdownConfig;Z)V", "Lgg/essential/gui/elementa/state/v2/State;", "(Lgg/essential/gui/elementa/state/v2/State;Lgg/essential/gui/elementa/essentialmarkdown/MarkdownConfig;Z)V", "baseX", "", "baseY", "canDrag", "getConfig", "()Lgg/essential/gui/elementa/essentialmarkdown/MarkdownConfig;", "configState", "Lgg/essential/gui/elementa/state/v2/MutableState;", "cursor", "Lgg/essential/gui/elementa/essentialmarkdown/selection/Cursor;", "drawables", "Lgg/essential/gui/elementa/essentialmarkdown/drawables/DrawableList;", "getDrawables", "()Lgg/essential/gui/elementa/essentialmarkdown/drawables/DrawableList;", "lastValues", "Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown$ConstraintValues;", "layoutFailed", "linkClickListeners", "", "Lkotlin/Function2;", "Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown$LinkClickEvent;", "", "Lkotlin/ExtensionFunctionType;", "maxHeight", "Lgg/essential/elementa/constraints/HeightConstraint;", "<set-?>", "maxTextLineWidth", "getMaxTextLineWidth", "()F", "needsInitialLayout", "", "sectionOffsets", "getSectionOffsets", "()Ljava/util/Map;", "selection", "Lgg/essential/gui/elementa/essentialmarkdown/selection/Selection;", "animationFrame", "clearSelection", "constraintValues", "draw", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "fireLinkClickEvent", "event", "fireLinkClickEvent$essential_gui_elementa", "layout", "onLinkClicked", "block", "reparse", "setMaxHeight", "updateConfig", "Companion", "ConstraintValues", "LinkClickEvent", "essential-gui-elementa"})
@SourceDebugExtension(value={"SMAP\nEssentialMarkdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EssentialMarkdown.kt\ngg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown\n+ 2 Extensions.kt\ngg/essential/vigilance/utils/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,287:1\n22#2,5:288\n1855#3,2:293\n800#3,11:295\n1179#3,2:306\n1253#3,4:308\n800#3,11:312\n1855#3,2:324\n1#4:323\n*S KotlinDebug\n*F\n+ 1 EssentialMarkdown.kt\ngg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown\n*L\n80#1:288,5\n159#1:293,2\n163#1:295,11\n163#1:306,2\n163#1:308,4\n170#1:312,11\n226#1:324,2\n*E\n"})
public final class EssentialMarkdown
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final State<String> text;
    private final boolean disableSelection;
    @NotNull
    private final MutableState<MarkdownConfig> configState;
    @NotNull
    private final DrawableList drawables;
    @NotNull
    private Map<String, Float> sectionOffsets;
    private float baseX;
    private float baseY;
    private ConstraintValues lastValues;
    @NotNull
    private HeightConstraint maxHeight;
    @Nullable
    private Cursor<?> cursor;
    @Nullable
    private Selection selection;
    private boolean canDrag;
    private boolean needsInitialLayout;
    @NotNull
    private final List<Function2<EssentialMarkdown, LinkClickEvent, Unit>> linkClickListeners;
    private float maxTextLineWidth;
    private boolean layoutFailed;
    public static final boolean DEBUG = false;

    public EssentialMarkdown(@NotNull State<String> text2, @NotNull MarkdownConfig config, boolean disableSelection) {
        Intrinsics.checkNotNullParameter(text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.text = text2;
        this.disableSelection = disableSelection;
        this.configState = StateKt.mutableStateOf(config);
        this.drawables = new DrawableList(this, CollectionsKt.emptyList());
        this.sectionOffsets = MapsKt.emptyMap();
        this.baseX = -1.0f;
        this.baseY = -1.0f;
        this.maxHeight = UtilitiesKt.pixels$default(Integer.MAX_VALUE, false, false, 3, null);
        this.needsInitialLayout = true;
        this.linkClickListeners = new ArrayList();
        UIComponent $this$onLeftClick$iv = this;
        boolean $i$f$onLeftClick = false;
        $this$onLeftClick$iv.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ EssentialMarkdown this$0;
            {
                this.this$0 = essentialMarkdown;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getMouseButton() == 0) {
                    void it2;
                    UIClickEvent uIClickEvent = it;
                    UIComponent $this$_init__u24lambda_u240 = $this$onMouseClick;
                    boolean bl = false;
                    float xShift = $this$_init__u24lambda_u240.getLeft() - EssentialMarkdown.access$getBaseX$p(this.this$0);
                    float yShift = $this$_init__u24lambda_u240.getTop() - EssentialMarkdown.access$getBaseY$p(this.this$0);
                    EssentialMarkdown.access$setCursor$p(this.this$0, this.this$0.getDrawables().cursorAt(it2.getAbsoluteX() - xShift, it2.getAbsoluteY() - yShift, false, it2.getMouseButton()));
                    Selection selection = EssentialMarkdown.access$getSelection$p(this.this$0);
                    if (selection != null) {
                        selection.remove();
                    }
                    EssentialMarkdown.access$setSelection$p(this.this$0, null);
                    $this$_init__u24lambda_u240.releaseWindowFocus();
                }
            }
        }));
        if (!this.disableSelection) {
            this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(){

                public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    canDrag = true;
                }
            }));
            this.onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(){

                public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                    canDrag = false;
                }
            }));
            this.onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)((Function4)new Function4<UIComponent, Float, Float, Integer, Unit>(){

                public final void invoke(@NotNull UIComponent $this$onMouseDrag, float mouseX, float mouseY, int mouseButton) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
                    if (mouseButton != 0 || !canDrag) {
                        return;
                    }
                    float x = baseX + RangesKt.coerceIn((float)mouseX, (float)0.0f, (float)$this$onMouseDrag.getWidth());
                    float y = baseY + RangesKt.coerceIn((float)mouseY, (float)0.0f, (float)$this$onMouseDrag.getHeight());
                    Cursor<?> otherEnd = this.getDrawables().cursorAt(x, y, true, mouseButton);
                    if (Intrinsics.areEqual((Object)cursor, otherEnd)) {
                        return;
                    }
                    Selection selection = selection;
                    if (selection != null) {
                        selection.remove();
                    }
                    Cursor cursor = cursor;
                    Intrinsics.checkNotNull((Object)cursor);
                    selection = Selection.Companion.fromCursors(cursor, otherEnd);
                    $this$onMouseDrag.grabWindowFocus();
                }
            }));
            this.onKeyType((Function3<? super UIComponent, ? super Character, ? super Integer, Unit>)((Function3)new Function3<UIComponent, Character, Integer, Unit>(){

                public final void invoke(@NotNull UIComponent $this$onKeyType, char c, int keyCode) {
                    Intrinsics.checkNotNullParameter((Object)$this$onKeyType, (String)"$this$onKeyType");
                    if (selection != null && keyCode == UKeyboard.KEY_C && UKeyboard.isCtrlKeyDown()) {
                        UDesktop.setClipboardString(this.getDrawables().selectedText(UKeyboard.isShiftKeyDown()));
                    }
                }
            }));
        }
        this.configState.onSetValue(this, (Function1<MarkdownConfig, Unit>)((Function1)new Function1<MarkdownConfig, Unit>(){

            public final void invoke(@NotNull MarkdownConfig it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.reparse();
                this.layout();
            }
        }));
        this.text.onSetValue(this, (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.reparse();
                this.layout();
            }
        }));
    }

    public /* synthetic */ EssentialMarkdown(State state2, MarkdownConfig markdownConfig, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            markdownConfig = new MarkdownConfig(null, null, null, null, null, null, null, null, false, 511, null);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(state2, markdownConfig, bl);
    }

    @JvmOverloads
    public EssentialMarkdown(@NotNull String text2, @NotNull MarkdownConfig config, boolean disableSelection) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(StateKt.stateOf(text2), config, disableSelection);
    }

    public /* synthetic */ EssentialMarkdown(String string, MarkdownConfig markdownConfig, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            markdownConfig = new MarkdownConfig(null, null, null, null, null, null, null, null, false, 511, null);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, markdownConfig, bl);
    }

    @NotNull
    public final MarkdownConfig getConfig() {
        return (MarkdownConfig)this.configState.get();
    }

    @NotNull
    public final DrawableList getDrawables() {
        return this.drawables;
    }

    @NotNull
    public final Map<String, Float> getSectionOffsets() {
        return this.sectionOffsets;
    }

    public final float getMaxTextLineWidth() {
        return this.maxTextLineWidth;
    }

    @NotNull
    public final EssentialMarkdown setMaxHeight(@NotNull HeightConstraint maxHeight) {
        EssentialMarkdown essentialMarkdown;
        Intrinsics.checkNotNullParameter((Object)maxHeight, (String)"maxHeight");
        EssentialMarkdown $this$setMaxHeight_u24lambda_u241 = essentialMarkdown = this;
        boolean bl = false;
        $this$setMaxHeight_u24lambda_u241.maxHeight = maxHeight;
        return essentialMarkdown;
    }

    private final void reparse() {
        this.drawables.setDrawables(new MarkdownRenderer(this.text.get(), this, this.getConfig()).render());
    }

    /*
     * WARNING - void declaration
     */
    public final void layout() {
        try {
            Float f;
            Object object;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            this.layoutFailed = false;
            this.baseX = this.getLeft();
            this.baseY = this.getTop();
            float currY = 0.0f;
            currY = this.baseY;
            float width2 = this.getWidth();
            Iterable $this$forEach$iv = this.drawables;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Drawable it = (Drawable)element$iv;
                boolean bl = false;
                currY += it.layout(this.baseX, currY, width2).getHeight();
            }
            $this$forEach$iv = this.drawables;
            EssentialMarkdown essentialMarkdown = this;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof HeaderDrawable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo2 = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                object = destination$iv$iv2;
                HeaderDrawable it = (HeaderDrawable)element$iv$iv;
                boolean bl = false;
                it = TuplesKt.to((Object)it.getId$essential_gui_elementa(), (Object)Float.valueOf(it.getY()));
                object.put(it.getFirst(), it.getSecond());
            }
            essentialMarkdown.sectionOffsets = destination$iv$iv2;
            this.setHeight(UtilitiesKt.pixels$default(Float.valueOf(RangesKt.coerceAtMost((float)(currY - this.baseY), (float)this.maxHeight.getHeight(this))), false, false, 3, null));
            Iterable iterable = this.drawables;
            essentialMarkdown = this;
            Iterator iterator2 = iterable.iterator();
            if (!iterator2.hasNext()) {
                f = null;
            } else {
                float f2;
                Drawable drawable = (Drawable)iterator2.next();
                boolean bl = false;
                Drawable $i$f$associateTo2 = drawable;
                if ($i$f$associateTo2 instanceof ParagraphDrawable) {
                    f2 = ((ParagraphDrawable)drawable).getMaxTextLineWidth();
                } else if ($i$f$associateTo2 instanceof HeaderDrawable) {
                    Float f3;
                    void $this$filterIsInstanceTo$iv$iv2;
                    Iterable $this$filterIsInstance$iv2 = drawable.getChildren();
                    boolean $i$f$filterIsInstance22 = false;
                    object = $this$filterIsInstance$iv2;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo2 = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                        if (!(element$iv$iv instanceof ParagraphDrawable)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    Iterator $i$f$filterIsInstance22 = ((Iterable)((List)destination$iv$iv3)).iterator();
                    if (!$i$f$filterIsInstance22.hasNext()) {
                        f3 = null;
                    } else {
                        ParagraphDrawable it22 = (ParagraphDrawable)$i$f$filterIsInstance22.next();
                        boolean bl2 = false;
                        float it22 = it22.getMaxTextLineWidth();
                        while ($i$f$filterIsInstance22.hasNext()) {
                            ParagraphDrawable it32 = (ParagraphDrawable)$i$f$filterIsInstance22.next();
                            $i$a$-maxOfOrNull-EssentialMarkdown$layout$3$1 = false;
                            float it32 = it32.getMaxTextLineWidth();
                            it22 = Math.max(it22, it32);
                        }
                        f3 = Float.valueOf(it22);
                    }
                    f2 = f3 != null ? f3.floatValue() : 0.0f;
                } else {
                    f2 = $i$f$associateTo2 instanceof ListDrawable ? ((ListDrawable)drawable).getMaxTextLineWidth() : ($i$f$associateTo2 instanceof BlockquoteDrawable ? ((BlockquoteDrawable)drawable).getMaxTextLineWidth() : 0.0f);
                }
                float f4 = f2;
                while (iterator2.hasNext()) {
                    float f5;
                    Drawable drawable2 = (Drawable)iterator2.next();
                    $i$a$-maxOfOrNull-EssentialMarkdown$layout$3 = false;
                    Drawable drawable3 = drawable2;
                    if (drawable3 instanceof ParagraphDrawable) {
                        f5 = ((ParagraphDrawable)drawable2).getMaxTextLineWidth();
                    } else if (drawable3 instanceof HeaderDrawable) {
                        Float f6;
                        void $this$filterIsInstanceTo$iv$iv3;
                        Iterable $this$filterIsInstance$iv3 = drawable2.getChildren();
                        boolean $i$f$filterIsInstance2 = false;
                        Object it32 = $this$filterIsInstance$iv3;
                        Collection destination$iv$iv4 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo3 = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                            if (!(element$iv$iv instanceof ParagraphDrawable)) continue;
                            destination$iv$iv4.add(element$iv$iv);
                        }
                        Iterator iterator3 = ((Iterable)((List)destination$iv$iv4)).iterator();
                        if (!iterator3.hasNext()) {
                            f6 = null;
                        } else {
                            it32 = (ParagraphDrawable)iterator3.next();
                            boolean bl3 = false;
                            float f7 = ((ParagraphDrawable)it32).getMaxTextLineWidth();
                            while (iterator3.hasNext()) {
                                ParagraphDrawable it = (ParagraphDrawable)iterator3.next();
                                $i$a$-maxOfOrNull-EssentialMarkdown$layout$3$1 = false;
                                float f8 = it.getMaxTextLineWidth();
                                f7 = Math.max(f7, f8);
                            }
                            f6 = Float.valueOf(f7);
                        }
                        f5 = f6 != null ? f6.floatValue() : 0.0f;
                    } else {
                        f5 = drawable3 instanceof ListDrawable ? ((ListDrawable)drawable2).getMaxTextLineWidth() : (drawable3 instanceof BlockquoteDrawable ? ((BlockquoteDrawable)drawable2).getMaxTextLineWidth() : 0.0f);
                    }
                    float f9 = f5;
                    f4 = Math.max(f4, f9);
                }
                f = Float.valueOf(f4);
            }
            essentialMarkdown.maxTextLineWidth = f != null ? f.floatValue() : 0.0f;
        }
        catch (Exception e) {
            LogManager.getLogger().error("Failed to layout markdown", (Throwable)e);
            this.layoutFailed = true;
        }
    }

    @Override
    public void animationFrame() {
        super.animationFrame();
        if (this.needsInitialLayout) {
            this.needsInitialLayout = false;
            this.reparse();
            this.layout();
            this.lastValues = this.constraintValues();
        }
        ConstraintValues currentValues = this.constraintValues();
        ConstraintValues constraintValues = this.lastValues;
        if (constraintValues == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastValues");
            constraintValues = null;
        }
        if (!Intrinsics.areEqual((Object)currentValues, (Object)constraintValues)) {
            this.layout();
        }
        this.lastValues = currentValues;
    }

    public final void updateConfig(@NotNull MarkdownConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.configState.set(config);
    }

    public final void clearSelection() {
        Selection selection = this.selection;
        if (selection != null) {
            selection.remove();
        }
        this.selection = null;
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        if (this.needsInitialLayout) {
            this.animationFrame();
        }
        this.beforeDraw(matrixStack);
        if (this.layoutFailed) {
            FontProvider.drawString$default(this.getFontProvider(), matrixStack, "Failed to render markdown", new Color(0xCC2929), this.getLeft(), this.getTop(), 10.0f, 1.0f, false, null, 384, null);
            super.draw(matrixStack);
            return;
        }
        DrawState drawState = new DrawState(this.getLeft() - this.baseX, this.getTop() - this.baseY);
        Window parentWindow = Window.Companion.of(this);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            if (!parentWindow.isAreaVisible((double)it.getLayout().getLeft() + (double)drawState.getXShift(), (double)it.getLayout().getTop() + (double)drawState.getYShift(), (double)it.getLayout().getRight() + (double)drawState.getXShift(), (double)it.getLayout().getBottom() + (double)drawState.getYShift())) continue;
            it.draw(matrixStack, drawState);
        }
        if (!this.disableSelection) {
            Selection selection = this.selection;
            if (selection != null) {
                selection.draw(matrixStack, drawState);
            } else {
                Cursor<?> cursor = this.cursor;
                if (cursor != null) {
                    cursor.draw(matrixStack, drawState);
                }
            }
        }
        super.draw(matrixStack);
    }

    private final ConstraintValues constraintValues() {
        return new ConstraintValues(this.getWidth(), this.getTextScale());
    }

    public final void onLinkClicked(@NotNull Function2<? super EssentialMarkdown, ? super LinkClickEvent, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.linkClickListeners.add(block);
    }

    public final boolean fireLinkClickEvent$essential_gui_elementa(@NotNull LinkClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (Function2<EssentialMarkdown, LinkClickEvent, Unit> listener2 : this.linkClickListeners) {
            listener2.invoke((Object)this, (Object)event);
            if (!event.getPropagationStoppedImmediately()) continue;
            return false;
        }
        return !event.getPropagationStopped();
    }

    @JvmOverloads
    public EssentialMarkdown(@NotNull String text2, @NotNull MarkdownConfig config) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(text2, config, false, 4, null);
    }

    @JvmOverloads
    public EssentialMarkdown(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this(text2, null, false, 6, null);
    }

    public static final /* synthetic */ void access$setCursor$p(EssentialMarkdown $this, Cursor cursor) {
        $this.cursor = cursor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown$Companion;", "", "()V", "DEBUG", "", "essential-gui-elementa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown$ConstraintValues;", "", "width", "", "textScale", "(FF)V", "getTextScale", "()F", "getWidth", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "essential-gui-elementa"})
    public static final class ConstraintValues {
        private final float width;
        private final float textScale;

        public ConstraintValues(float width2, float textScale) {
            this.width = width2;
            this.textScale = textScale;
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getTextScale() {
            return this.textScale;
        }

        public final float component1() {
            return this.width;
        }

        public final float component2() {
            return this.textScale;
        }

        @NotNull
        public final ConstraintValues copy(float width2, float textScale) {
            return new ConstraintValues(width2, textScale);
        }

        public static /* synthetic */ ConstraintValues copy$default(ConstraintValues constraintValues, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = constraintValues.width;
            }
            if ((n & 2) != 0) {
                f2 = constraintValues.textScale;
            }
            return constraintValues.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "ConstraintValues(width=" + this.width + ", textScale=" + this.textScale + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.width);
            result = result * 31 + Float.hashCode(this.textScale);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConstraintValues)) {
                return false;
            }
            ConstraintValues constraintValues = (ConstraintValues)other;
            if (Float.compare(this.width, constraintValues.width) != 0) {
                return false;
            }
            return Float.compare(this.textScale, constraintValues.textScale) == 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown$LinkClickEvent;", "Lgg/essential/elementa/events/UIEvent;", "url", "", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "essential-gui-elementa"})
    public static final class LinkClickEvent
    extends UIEvent {
        @NotNull
        private final String url;

        public LinkClickEvent(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }
    }
}

