/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.essentialmarkdown.drawables;

import gg.essential.elementa.components.UIBlock;
import gg.essential.gui.elementa.essentialmarkdown.BlockquoteConfig;
import gg.essential.gui.elementa.essentialmarkdown.DrawState;
import gg.essential.gui.elementa.essentialmarkdown.EssentialMarkdown;
import gg.essential.gui.elementa.essentialmarkdown.drawables.BlockquoteDrawable;
import gg.essential.gui.elementa.essentialmarkdown.drawables.Drawable;
import gg.essential.gui.elementa.essentialmarkdown.drawables.DrawableList;
import gg.essential.gui.elementa.essentialmarkdown.drawables.ParagraphDrawable;
import gg.essential.gui.elementa.essentialmarkdown.selection.Cursor;
import gg.essential.universal.UMatrixStack;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\f\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\fH\u0014J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0018H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Lgg/essential/gui/elementa/essentialmarkdown/drawables/BlockquoteDrawable;", "Lgg/essential/gui/elementa/essentialmarkdown/drawables/Drawable;", "md", "Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown;", "drawables", "Lgg/essential/gui/elementa/essentialmarkdown/drawables/DrawableList;", "(Lgg/essential/gui/elementa/essentialmarkdown/EssentialMarkdown;Lgg/essential/gui/elementa/essentialmarkdown/drawables/DrawableList;)V", "children", "", "getChildren", "()Ljava/util/List;", "dividerHeight", "", "getDrawables", "()Lgg/essential/gui/elementa/essentialmarkdown/drawables/DrawableList;", "<set-?>", "maxTextLineWidth", "getMaxTextLineWidth", "()F", "cursorAt", "Lgg/essential/gui/elementa/essentialmarkdown/selection/Cursor;", "mouseX", "mouseY", "dragged", "", "mouseButton", "", "cursorAtEnd", "cursorAtStart", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "state", "Lgg/essential/gui/elementa/essentialmarkdown/DrawState;", "layoutImpl", "Lgg/essential/gui/elementa/essentialmarkdown/drawables/Drawable$Layout;", "x", "y", "width", "selectedText", "", "asMarkdown", "essential-gui-elementa"})
@SourceDebugExtension(value={"SMAP\nBlockquoteDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockquoteDrawable.kt\ngg/essential/gui/elementa/essentialmarkdown/drawables/BlockquoteDrawable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1855#2,2:96\n1855#2,2:98\n*S KotlinDebug\n*F\n+ 1 BlockquoteDrawable.kt\ngg/essential/gui/elementa/essentialmarkdown/drawables/BlockquoteDrawable\n*L\n43#1:96,2\n78#1:98,2\n*E\n"})
public final class BlockquoteDrawable
extends Drawable {
    @NotNull
    private final DrawableList drawables;
    private float dividerHeight;
    private float maxTextLineWidth;

    public BlockquoteDrawable(@NotNull EssentialMarkdown md, @NotNull DrawableList drawables) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)drawables, (String)"drawables");
        super(md);
        this.drawables = drawables;
        this.dividerHeight = -1.0f;
        this.drawables.setParent(this);
    }

    @NotNull
    public final DrawableList getDrawables() {
        return this.drawables;
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        return this.drawables;
    }

    public final float getMaxTextLineWidth() {
        return this.maxTextLineWidth;
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width2) {
        Float f;
        BlockquoteConfig config = this.getConfig().getBlockquoteConfig();
        float padding = config.getSpaceBeforeDivider() + config.getDividerWidth() + config.getSpaceAfterDivider();
        float currY = 0.0f;
        currY = y;
        float dividerStart = currY += this.getInsertSpaceBefore() ? config.getSpaceBeforeBlockquote() : 0.0f;
        currY += config.getDividerPaddingTop();
        Drawable.Companion.trim(this.drawables);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            currY += it.layout(x + padding, currY, width2 - padding).getHeight();
        }
        this.dividerHeight = (currY += config.getDividerPaddingBottom()) - dividerStart;
        if (this.getInsertSpaceAfter()) {
            currY += config.getSpaceAfterBlockquote();
        }
        float height2 = currY - y;
        Iterable iterable = this.drawables;
        BlockquoteDrawable blockquoteDrawable = this;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            f = null;
        } else {
            float f2;
            Drawable drawable = (Drawable)iterator.next();
            boolean bl = false;
            ParagraphDrawable paragraphDrawable = drawable instanceof ParagraphDrawable ? (ParagraphDrawable)drawable : null;
            float f3 = f2 = paragraphDrawable != null ? paragraphDrawable.getMaxTextLineWidth() + padding : 0.0f;
            while (iterator.hasNext()) {
                Drawable drawable2 = (Drawable)iterator.next();
                $i$a$-maxOfOrNull-BlockquoteDrawable$layoutImpl$2 = false;
                ParagraphDrawable paragraphDrawable2 = drawable2 instanceof ParagraphDrawable ? (ParagraphDrawable)drawable2 : null;
                float f4 = paragraphDrawable2 != null ? paragraphDrawable2.getMaxTextLineWidth() + padding : 0.0f;
                f2 = Math.max(f2, f4);
            }
            f = Float.valueOf(f2);
        }
        blockquoteDrawable.maxTextLineWidth = f != null ? f.floatValue() : 0.0f;
        return new Drawable.Layout(x, y, width2, height2, new Drawable.Margin(0.0f, config.getSpaceBeforeBlockquote(), 0.0f, config.getSpaceAfterBlockquote()));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state2) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        UIBlock.Companion.drawBlockSized(matrixStack, this.getConfig().getBlockquoteConfig().getDividerColor(), (double)(this.getX() + state2.getXShift()) + (double)this.getConfig().getBlockquoteConfig().getSpaceBeforeDivider(), (double)(this.getY() + state2.getYShift()) + (double)this.getConfig().getBlockquoteConfig().getSpaceBeforeBlockquote(), this.getConfig().getBlockquoteConfig().getDividerWidth(), this.dividerHeight);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            it.drawCompat(matrixStack, state2);
        }
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        return this.drawables.cursorAt(mouseX, mouseY, dragged, mouseButton);
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        return this.drawables.cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        return this.drawables.cursorAtEnd();
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (!this.hasSelectedText()) {
            return "";
        }
        String text2 = this.drawables.selectedText(asMarkdown);
        return asMarkdown ? CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)text2), (CharSequence)"\n", null, null, (int)0, null, (Function1)selectedText.1.INSTANCE, (int)30, null) : text2;
    }
}

