/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.state.v2;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.animation.AnimationStrategy;
import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.state.v2.ReferenceHolder;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgg/essential/gui/elementa/state/v2/AnimationDriver;", "Lgg/essential/elementa/effects/Effect;", "driver", "Lgg/essential/gui/elementa/state/v2/State;", "", "resultStateWeakReference", "Ljava/lang/ref/WeakReference;", "Lgg/essential/gui/elementa/state/v2/MutableState;", "duration", "animationStrategy", "Lgg/essential/elementa/constraints/animation/AnimationStrategy;", "(Lgg/essential/gui/elementa/state/v2/State;Ljava/lang/ref/WeakReference;FLgg/essential/elementa/constraints/animation/AnimationStrategy;)V", "animationEventList", "", "Lgg/essential/gui/elementa/state/v2/AnimationDriver$AnimationEvent;", "driverEffect", "Lkotlin/Function0;", "", "durationFrames", "", "isDestroying", "", "previousDriverStateValue", "animationFrame", "destroy", "getAnimationValue", "setup", "AnimationEvent", "essential-elementa-statev2"})
@SourceDebugExtension(value={"SMAP\nanimate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 animate.kt\ngg/essential/gui/elementa/state/v2/AnimationDriver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1855#2,2:100\n1789#2,3:102\n*S KotlinDebug\n*F\n+ 1 animate.kt\ngg/essential/gui/elementa/state/v2/AnimationDriver\n*L\n63#1:100,2\n85#1:102,3\n*E\n"})
final class AnimationDriver
extends Effect {
    @NotNull
    private final State<Float> driver;
    @NotNull
    private final WeakReference<MutableState<Float>> resultStateWeakReference;
    private final float duration;
    @NotNull
    private final AnimationStrategy animationStrategy;
    @NotNull
    private final List<AnimationEvent> animationEventList;
    private Function0<Unit> driverEffect;
    private int durationFrames;
    private float previousDriverStateValue;
    private boolean isDestroying;

    public AnimationDriver(@NotNull State<Float> driver, @NotNull WeakReference<MutableState<Float>> resultStateWeakReference, float duration, @NotNull AnimationStrategy animationStrategy) {
        Intrinsics.checkNotNullParameter(driver, (String)"driver");
        Intrinsics.checkNotNullParameter(resultStateWeakReference, (String)"resultStateWeakReference");
        Intrinsics.checkNotNullParameter((Object)animationStrategy, (String)"animationStrategy");
        this.driver = driver;
        this.resultStateWeakReference = resultStateWeakReference;
        this.duration = duration;
        this.animationStrategy = animationStrategy;
        this.animationEventList = new ArrayList();
        this.durationFrames = 1;
    }

    @Override
    public void setup() {
        this.previousDriverStateValue = ((Number)this.driver.getUntracked()).floatValue();
        this.durationFrames = RangesKt.coerceAtLeast((int)((int)((float)Window.Companion.of(this.getBoundComponent()).getAnimationFPS() * this.duration)), (int)1);
        this.driverEffect = StateKt.effect(ReferenceHolder.Weak.INSTANCE, (Function1<? super Observer, Unit>)((Function1)new Function1<Observer, Unit>(this){
            final /* synthetic */ AnimationDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Observer $this$effect) {
                Intrinsics.checkNotNullParameter((Object)$this$effect, (String)"$this$effect");
                float input2 = ((Number)$this$effect.invoke(AnimationDriver.access$getDriver$p(this.this$0))).floatValue();
                AnimationDriver.access$getAnimationEventList$p(this.this$0).add(new AnimationEvent(AnimationDriver.access$getPreviousDriverStateValue$p(this.this$0), input2, AnimationDriver.access$getDurationFrames$p(this.this$0), 0, 8, null));
                AnimationDriver.access$setPreviousDriverStateValue$p(this.this$0, input2);
            }
        }));
    }

    @Override
    public void animationFrame() {
        MutableState resultState = (MutableState)this.resultStateWeakReference.get();
        if (resultState == null) {
            this.destroy();
        } else {
            Iterable $this$forEach$iv = this.animationEventList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnimationEvent it = (AnimationEvent)element$iv;
                boolean bl = false;
                int n = it.getAge();
                it.setAge(n + 1);
            }
            this.animationEventList.removeIf(arg_0 -> AnimationDriver.animationFrame$lambda$1((Function1)new Function1<AnimationEvent, Boolean>(this){
                final /* synthetic */ AnimationDriver this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull AnimationEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getAge() >= AnimationDriver.access$getDurationFrames$p(this.this$0);
                }
            }, arg_0));
            resultState.set(Float.valueOf(this.getAnimationValue()));
        }
    }

    private final void destroy() {
        if (this.isDestroying) {
            return;
        }
        this.isDestroying = true;
        Function0<Unit> function0 = this.driverEffect;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"driverEffect");
            function0 = null;
        }
        function0.invoke();
        Window.Companion.enqueueRenderOperation((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AnimationDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AnimationDriver.access$getBoundComponent(this.this$0).removeEffect(this.this$0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final float getAnimationValue() {
        void $this$fold$iv;
        if (this.animationEventList.isEmpty()) {
            return this.previousDriverStateValue;
        }
        Iterable iterable = this.animationEventList;
        float initial$iv = ((AnimationEvent)CollectionsKt.first(this.animationEventList)).getStartValue();
        boolean $i$f$fold = false;
        float accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void event;
            AnimationEvent animationEvent = (AnimationEvent)element$iv;
            float acc = accumulator$iv;
            boolean bl = false;
            float linearProgress = (float)event.getAge() / (float)event.getDuration();
            float animatedProgress = this.animationStrategy.getValue(linearProgress);
            accumulator$iv = acc + (event.getEndValue() - acc) * animatedProgress;
        }
        return accumulator$iv;
    }

    private static final boolean animationFrame$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ State access$getDriver$p(AnimationDriver $this) {
        return $this.driver;
    }

    public static final /* synthetic */ List access$getAnimationEventList$p(AnimationDriver $this) {
        return $this.animationEventList;
    }

    public static final /* synthetic */ float access$getPreviousDriverStateValue$p(AnimationDriver $this) {
        return $this.previousDriverStateValue;
    }

    public static final /* synthetic */ int access$getDurationFrames$p(AnimationDriver $this) {
        return $this.durationFrames;
    }

    public static final /* synthetic */ void access$setPreviousDriverStateValue$p(AnimationDriver $this, float f) {
        $this.previousDriverStateValue = f;
    }

    public static final /* synthetic */ UIComponent access$getBoundComponent(AnimationDriver $this) {
        return $this.getBoundComponent();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lgg/essential/gui/elementa/state/v2/AnimationDriver$AnimationEvent;", "", "startValue", "", "endValue", "duration", "", "age", "(FFII)V", "getAge", "()I", "setAge", "(I)V", "getDuration", "getEndValue", "()F", "getStartValue", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "essential-elementa-statev2"})
    private static final class AnimationEvent {
        private final float startValue;
        private final float endValue;
        private final int duration;
        private int age;

        public AnimationEvent(float startValue, float endValue, int duration, int age) {
            this.startValue = startValue;
            this.endValue = endValue;
            this.duration = duration;
            this.age = age;
        }

        public /* synthetic */ AnimationEvent(float f, float f2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            this(f, f2, n, n2);
        }

        public final float getStartValue() {
            return this.startValue;
        }

        public final float getEndValue() {
            return this.endValue;
        }

        public final int getDuration() {
            return this.duration;
        }

        public final int getAge() {
            return this.age;
        }

        public final void setAge(int n) {
            this.age = n;
        }

        public final float component1() {
            return this.startValue;
        }

        public final float component2() {
            return this.endValue;
        }

        public final int component3() {
            return this.duration;
        }

        public final int component4() {
            return this.age;
        }

        @NotNull
        public final AnimationEvent copy(float startValue, float endValue, int duration, int age) {
            return new AnimationEvent(startValue, endValue, duration, age);
        }

        public static /* synthetic */ AnimationEvent copy$default(AnimationEvent animationEvent, float f, float f2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                f = animationEvent.startValue;
            }
            if ((n3 & 2) != 0) {
                f2 = animationEvent.endValue;
            }
            if ((n3 & 4) != 0) {
                n = animationEvent.duration;
            }
            if ((n3 & 8) != 0) {
                n2 = animationEvent.age;
            }
            return animationEvent.copy(f, f2, n, n2);
        }

        @NotNull
        public String toString() {
            return "AnimationEvent(startValue=" + this.startValue + ", endValue=" + this.endValue + ", duration=" + this.duration + ", age=" + this.age + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.startValue);
            result = result * 31 + Float.hashCode(this.endValue);
            result = result * 31 + Integer.hashCode(this.duration);
            result = result * 31 + Integer.hashCode(this.age);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnimationEvent)) {
                return false;
            }
            AnimationEvent animationEvent = (AnimationEvent)other;
            if (Float.compare(this.startValue, animationEvent.startValue) != 0) {
                return false;
            }
            if (Float.compare(this.endValue, animationEvent.endValue) != 0) {
                return false;
            }
            if (this.duration != animationEvent.duration) {
                return false;
            }
            return this.age == animationEvent.age;
        }
    }
}

