/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.state.v2.impl.minimal;

import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.ObserverImpl;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.impl.minimal.Node;
import gg.essential.gui.elementa.state.v2.impl.minimal.NodeKind;
import gg.essential.gui.elementa.state.v2.impl.minimal.NodeState;
import gg.essential.gui.elementa.state.v2.impl.minimal.Update;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010(\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\u00020\u0004B8\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\b\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0002J\u0006\u0010\"\u001a\u00020 J\b\u0010#\u001a\u00020 H\u0002J\u0013\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\u0003\u00a2\u0006\u0002\u0010&J\r\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\bH\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010.\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0002J\u0014\u0010/\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0002J\u0013\u00100\u001a\u00020 2\u0006\u00101\u001a\u00028\u0000\u00a2\u0006\u0002\u00102J\u000e\u0010*\u001a\u00020 2\u0006\u0010*\u001a\u00020+J\u0011\u00103\u001a\u00028\u0000*\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010&J&\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000005*\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u00110\u000fH\u0002R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0000\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u00066"}, d2={"Lgg/essential/gui/elementa/state/v2/impl/minimal/Node;", "T", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/elementa/state/v2/Observer;", "Lgg/essential/gui/elementa/state/v2/ObserverImpl;", "kind", "Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeKind;", "state", "Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeState;", "func", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "value", "(Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeKind;Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeState;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;)V", "dependencies", "", "dependents", "Ljava/lang/ref/WeakReference;", "getKind", "()Lgg/essential/gui/elementa/state/v2/impl/minimal/NodeKind;", "observed", "", "observerImpl", "getObserverImpl", "()Lgg/essential/gui/elementa/state/v2/ObserverImpl;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "getReferenceQueue", "()Ljava/lang/ref/ReferenceQueue;", "referenceQueueField", "Ljava/lang/Object;", "addDependent", "", "node", "cleanup", "cleanupStaleReferences", "getTracked", "observer", "(Lgg/essential/gui/elementa/state/v2/Observer;)Ljava/lang/Object;", "getUntracked", "()Ljava/lang/Object;", "mark", "update", "Lgg/essential/gui/elementa/state/v2/impl/minimal/Update;", "newState", "markDirty", "markToBeChecked", "removeDependent", "set", "newValue", "(Ljava/lang/Object;)V", "get", "iter", "", "essential-elementa-statev2"})
@SourceDebugExtension(value={"SMAP\nimpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 impl.kt\ngg/essential/gui/elementa/state/v2/impl/minimal/Node\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n1#2:318\n350#3,7:319\n*S KotlinDebug\n*F\n+ 1 impl.kt\ngg/essential/gui/elementa/state/v2/impl/minimal/Node\n*L\n259#1:319,7\n*E\n"})
final class Node<T>
implements State<T>,
Observer,
ObserverImpl {
    @NotNull
    private final NodeKind kind;
    @NotNull
    private NodeState state;
    @NotNull
    private final Function1<Observer, T> func;
    @Nullable
    private T value;
    @NotNull
    private final Set<Node<?>> observed;
    @NotNull
    private final List<Node<?>> dependencies;
    @NotNull
    private final List<WeakReference<Node<?>>> dependents;
    @Nullable
    private ReferenceQueue<Node<?>> referenceQueueField;

    public Node(@NotNull NodeKind kind, @NotNull NodeState state2, @NotNull Function1<? super Observer, ? extends T> func, @Nullable T value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        this.kind = kind;
        this.state = state2;
        this.func = func;
        this.value = value2;
        this.observed = new LinkedHashSet();
        this.dependencies = new ArrayList();
        this.dependents = new ArrayList();
    }

    @NotNull
    public final NodeKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public ObserverImpl getObserverImpl() {
        return this;
    }

    @Override
    public T get(@NotNull Observer $this$get) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        return this.getTracked($this$get);
    }

    public final T getTracked(@NotNull Observer observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        ObserverImpl impl = observer.getObserverImpl();
        if (impl instanceof Node) {
            ((Node)impl).observed.add(this);
        }
        return this.getUntracked();
    }

    @Override
    public T getUntracked() {
        if (this.state != NodeState.Clean) {
            this.update(Update.Companion.get());
        }
        return this.value;
    }

    public final void set(T newValue) {
        boolean bl;
        boolean bl2 = bl = this.kind == NodeKind.Mutable;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (Intrinsics.areEqual(this.value, newValue)) {
            return;
        }
        this.value = newValue;
        Update update2 = Update.Companion.get();
        Iterator<Node<?>> iterator = this.iter(this.dependents);
        while (iterator.hasNext()) {
            Node<?> dep = iterator.next();
            super.markDirty(update2);
        }
        update2.flush();
    }

    private final void mark(Update update2, NodeState newState) {
        NodeState oldState = this.state;
        if (oldState.ordinal() >= newState.ordinal()) {
            return;
        }
        if (this.kind == NodeKind.Effect && oldState == NodeState.Clean) {
            update2.queueNode(this);
        }
        this.state = newState;
    }

    private final void markDirty(Update update2) {
        this.mark(update2, NodeState.Dirty);
        Iterator<Node<?>> iterator = this.iter(this.dependents);
        while (iterator.hasNext()) {
            Node<?> dep = iterator.next();
            super.markToBeChecked(update2);
        }
    }

    private final void markToBeChecked(Update update2) {
        if (this.state != NodeState.Clean) {
            return;
        }
        this.mark(update2, NodeState.ToBeChecked);
        Iterator<Node<?>> iterator = this.iter(this.dependents);
        while (iterator.hasNext()) {
            Node<?> dep = iterator.next();
            super.markToBeChecked(update2);
        }
    }

    public final void update(@NotNull Update update2) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        if (this.state == NodeState.Clean) {
            return;
        }
        if (this.state == NodeState.ToBeChecked) {
            for (Node<?> dep : this.dependencies) {
                dep.update(update2);
                if (this.state != NodeState.Dirty) continue;
            }
        }
        if (this.state == NodeState.Dirty) {
            Object newValue = this.func.invoke((Object)this);
            if (this.state == NodeState.Dead) {
                return;
            }
            int n = this.dependencies.size() + -1;
            if (0 <= n) {
                do {
                    int i2;
                    Node<?> dep;
                    if (this.observed.contains(dep = this.dependencies.get(i2 = n--))) continue;
                    this.dependencies.remove(i2);
                    super.removeDependent(this);
                } while (0 <= n);
            }
            for (Node<?> dep : this.observed) {
                if (this.dependencies.contains(dep)) continue;
                this.dependencies.add(dep);
                super.addDependent(this);
            }
            this.observed.clear();
            if (!Intrinsics.areEqual(this.value, (Object)newValue)) {
                this.value = newValue;
                Iterator<Node<?>> iterator = this.iter(this.dependents);
                while (iterator.hasNext()) {
                    Node<?> dep = iterator.next();
                    super.mark(update2, NodeState.Dirty);
                }
            }
        }
        this.state = NodeState.Clean;
    }

    public final void cleanup() {
        for (Node<?> dep : this.dependencies) {
            super.removeDependent(this);
        }
        this.dependencies.clear();
        this.state = NodeState.Dead;
    }

    private final ReferenceQueue<Node<?>> getReferenceQueue() {
        ReferenceQueue<Node<Object>> referenceQueue = this.referenceQueueField;
        if (referenceQueue == null) {
            ReferenceQueue referenceQueue2;
            ReferenceQueue it = referenceQueue2 = new ReferenceQueue();
            boolean bl = false;
            this.referenceQueueField = it;
            referenceQueue = referenceQueue2;
        }
        return referenceQueue;
    }

    private final void addDependent(Node<?> node2) {
        this.cleanupStaleReferences();
        this.dependents.add(new WeakReference(node2, this.getReferenceQueue()));
    }

    private final void removeDependent(Node<?> node2) {
        int index2;
        block3: {
            int n;
            List<WeakReference<Node<?>>> $this$indexOfFirst$iv = this.dependents;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<WeakReference<Node<?>>> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                WeakReference<Node<?>> item$iv;
                WeakReference<Node<?>> it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual(it.get(), node2)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index2 = -1;
        }
        if (index2 >= 0) {
            this.dependents.remove(index2);
        }
    }

    private final void cleanupStaleReferences() {
        ReferenceQueue<Node<?>> referenceQueue = this.referenceQueueField;
        if (referenceQueue == null) {
            return;
        }
        ReferenceQueue<Node<?>> queue = referenceQueue;
        if (queue.poll() == null) {
            return;
        }
        while (queue.poll() != null) {
        }
        this.dependents.removeIf(arg_0 -> Node.cleanupStaleReferences$lambda$2(cleanupStaleReferences.1.INSTANCE, arg_0));
    }

    private final Iterator<Node<?>> iter(List<WeakReference<Node<?>>> $this$iter) {
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)$this$iter), (Function1)iter.1.INSTANCE).iterator();
    }

    private static final boolean cleanupStaleReferences$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

