/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.bytebuf;

import gg.essential.gui.screenshot.bytebuf.WrappedByteBuf;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001b\u0010\u0016\u001a\u00060\u0015R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017JY\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r26\u0010\u0003\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u001d\u0010\u0012J\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u001e\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#\u00a8\u0006%"}, d2={"Lgg/essential/gui/screenshot/bytebuf/LimitedAllocator;", "Lio/netty/buffer/AbstractByteBufAllocator;", "Lio/netty/buffer/ByteBufAllocator;", "alloc", "", "limit", "<init>", "(Lio/netty/buffer/ByteBufAllocator;J)V", "getAllocatedBytes", "()J", "", "isDirectBufferPooled", "()Z", "", "initialCapacity", "maxCapacity", "Lio/netty/buffer/ByteBuf;", "newDirectBuffer", "(II)Lio/netty/buffer/ByteBuf;", "newHeapBuffer", "buf", "Lgg/essential/gui/screenshot/bytebuf/LimitedAllocator$TrackedByteBuf;", "trackNew", "(Lio/netty/buffer/ByteBuf;)Lgg/essential/gui/screenshot/bytebuf/LimitedAllocator$TrackedByteBuf;", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "tryAlloc", "(IILkotlin/jvm/functions/Function2;)Lio/netty/buffer/ByteBuf;", "tryDirectBuffer", "tryHeapBuffer", "Lio/netty/buffer/ByteBufAllocator;", "Ljava/util/concurrent/atomic/AtomicLong;", "allocatedBytes", "Ljava/util/concurrent/atomic/AtomicLong;", "J", "TrackedByteBuf", "Essential 1.19.2-forge"})
public final class LimitedAllocator
extends AbstractByteBufAllocator {
    @NotNull
    private final ByteBufAllocator alloc;
    private final long limit;
    @NotNull
    private final AtomicLong allocatedBytes;

    public LimitedAllocator(@NotNull ByteBufAllocator alloc, long limit) {
        Intrinsics.checkNotNullParameter((Object)alloc, (String)"alloc");
        this.alloc = alloc;
        this.limit = limit;
        this.allocatedBytes = new AtomicLong();
    }

    public final long getAllocatedBytes() {
        return this.allocatedBytes.get();
    }

    @Nullable
    public final ByteBuf tryHeapBuffer(int initialCapacity, int maxCapacity) {
        return this.tryAlloc(initialCapacity, maxCapacity, (Function2<? super Integer, ? super Integer, ? extends ByteBuf>)((Function2)new Function2<Integer, Integer, ByteBuf>((Object)this){

            public final ByteBuf invoke(int p0, int p1) {
                return ((LimitedAllocator)((Object)this.receiver)).heapBuffer(p0, p1);
            }
        }));
    }

    @Nullable
    public final ByteBuf tryDirectBuffer(int initialCapacity, int maxCapacity) {
        return this.tryAlloc(initialCapacity, maxCapacity, (Function2<? super Integer, ? super Integer, ? extends ByteBuf>)((Function2)new Function2<Integer, Integer, ByteBuf>((Object)this){

            public final ByteBuf invoke(int p0, int p1) {
                return ((LimitedAllocator)((Object)this.receiver)).directBuffer(p0, p1);
            }
        }));
    }

    private final ByteBuf tryAlloc(int initialCapacity, int maxCapacity, Function2<? super Integer, ? super Integer, ? extends ByteBuf> alloc) {
        if ((long)initialCapacity > this.limit) {
            return (ByteBuf)alloc.invoke((Object)initialCapacity, (Object)maxCapacity);
        }
        long prev = 0L;
        long next = 0L;
        do {
            if ((next = (prev = this.allocatedBytes.get()) + (long)initialCapacity) <= this.limit) continue;
            return null;
        } while (!this.allocatedBytes.compareAndSet(prev, next));
        Object object = alloc.invoke((Object)initialCapacity, (Object)maxCapacity);
        ByteBuf it = (ByteBuf)object;
        boolean bl = false;
        this.allocatedBytes.addAndGet(-((long)initialCapacity));
        return (ByteBuf)object;
    }

    private final TrackedByteBuf trackNew(ByteBuf buf) {
        int trackedCapacity = buf.capacity();
        this.allocatedBytes.addAndGet(trackedCapacity);
        return new TrackedByteBuf(buf, trackedCapacity);
    }

    @NotNull
    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        ByteBuf byteBuf = this.alloc.heapBuffer(initialCapacity, maxCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"heapBuffer(...)");
        return this.trackNew(byteBuf);
    }

    @NotNull
    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        ByteBuf byteBuf = this.alloc.directBuffer(initialCapacity, maxCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"directBuffer(...)");
        return this.trackNew(byteBuf);
    }

    public boolean isDirectBufferPooled() {
        return this.alloc.isDirectBufferPooled();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\fJ\u0017\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001e\u0010!J\u000f\u0010\"\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\"\u0010\fJ\u000f\u0010#\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b#\u0010\fJ\u001f\u0010#\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010\u0010J\u000f\u0010$\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b$\u0010\fJ\u001f\u0010$\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b$\u0010\u0010J\u001b\u0010&\u001a\u00060\u0000R\u00020%2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010(\u00a8\u0006)"}, d2={"Lgg/essential/gui/screenshot/bytebuf/LimitedAllocator$TrackedByteBuf;", "Lgg/essential/gui/screenshot/bytebuf/WrappedByteBuf;", "Lio/netty/buffer/ByteBuf;", "buf", "", "trackedCapacity", "<init>", "(Lgg/essential/gui/screenshot/bytebuf/LimitedAllocator;Lio/netty/buffer/ByteBuf;I)V", "Lio/netty/buffer/ByteBufAllocator;", "alloc", "()Lio/netty/buffer/ByteBufAllocator;", "asReadOnly", "()Lio/netty/buffer/ByteBuf;", "copy", "index", "length", "(II)Lio/netty/buffer/ByteBuf;", "", "deallocate", "()V", "duplicate", "Ljava/nio/ByteOrder;", "endianness", "order", "(Ljava/nio/ByteOrder;)Lio/netty/buffer/ByteBuf;", "readBytes", "(I)Lio/netty/buffer/ByteBuf;", "readRetainedSlice", "readSlice", "", "release", "()Z", "decrement", "(I)Z", "retainedDuplicate", "retainedSlice", "slice", "Lgg/essential/gui/screenshot/bytebuf/LimitedAllocator;", "trackShared", "(Lio/netty/buffer/ByteBuf;)Lgg/essential/gui/screenshot/bytebuf/LimitedAllocator$TrackedByteBuf;", "I", "Essential 1.19.2-forge"})
    private final class TrackedByteBuf
    extends WrappedByteBuf {
        private final int trackedCapacity;

        public TrackedByteBuf(ByteBuf buf, int trackedCapacity) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            super(buf);
            this.trackedCapacity = trackedCapacity;
        }

        private final TrackedByteBuf trackShared(ByteBuf buf) {
            TrackedByteBuf trackedByteBuf = buf instanceof TrackedByteBuf ? (TrackedByteBuf)buf : null;
            if (trackedByteBuf == null) {
                trackedByteBuf = new TrackedByteBuf(buf, this.trackedCapacity);
            }
            return trackedByteBuf;
        }

        private final void deallocate() {
            LimitedAllocator.this.allocatedBytes.addAndGet(-((long)this.trackedCapacity));
        }

        @Override
        public boolean release() {
            if (super.release()) {
                this.deallocate();
                return true;
            }
            return false;
        }

        @Override
        public boolean release(int decrement) {
            if (super.release(decrement)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public ByteBufAllocator alloc() {
            return (ByteBufAllocator)LimitedAllocator.this;
        }

        @Override
        @NotNull
        public ByteBuf slice() {
            ByteBuf byteBuf = super.slice();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"slice(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf retainedSlice() {
            ByteBuf byteBuf = super.retainedSlice();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"retainedSlice(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf retainedSlice(int index2, int length) {
            ByteBuf byteBuf = super.retainedSlice(index2, length);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"retainedSlice(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf retainedDuplicate() {
            ByteBuf byteBuf = super.retainedDuplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"retainedDuplicate(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf readRetainedSlice(int length) {
            ByteBuf byteBuf = super.readRetainedSlice(length);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"readRetainedSlice(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf slice(int index2, int length) {
            ByteBuf byteBuf = super.slice(index2, length);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"slice(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf duplicate() {
            ByteBuf byteBuf = super.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"duplicate(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf readSlice(int length) {
            ByteBuf byteBuf = super.readSlice(length);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"readSlice(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf asReadOnly() {
            ByteBuf byteBuf = super.asReadOnly();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"asReadOnly(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf order(@NotNull ByteOrder endianness) {
            Intrinsics.checkNotNullParameter((Object)endianness, (String)"endianness");
            ByteBuf byteBuf = super.order(endianness);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"order(...)");
            return this.trackShared(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf readBytes(int length) {
            ByteBuf byteBuf = super.readBytes(length);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"readBytes(...)");
            return LimitedAllocator.this.trackNew(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf copy() {
            ByteBuf byteBuf = super.copy();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"copy(...)");
            return LimitedAllocator.this.trackNew(byteBuf);
        }

        @Override
        @NotNull
        public ByteBuf copy(int index2, int length) {
            ByteBuf byteBuf = super.copy(index2, length);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"copy(...)");
            return LimitedAllocator.this.trackNew(byteBuf);
        }
    }
}

