/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.components;

import gg.essential.elementa.utils.ExtensionsKt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007B'\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\rJ\u0010\u0010\u000e\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u000fJ8\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\"\u0010\f\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010 \u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010#R\"\u0010\u000b\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010 \u001a\u0004\b$\u0010\u000f\"\u0004\b%\u0010#R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010 \u001a\u0004\b&\u0010\u000f\"\u0004\b'\u0010#R\"\u0010\n\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010 \u001a\u0004\b(\u0010\u000f\"\u0004\b)\u0010#\u00a8\u0006*"}, d2={"Lgg/essential/gui/screenshot/components/HSBColor;", "", "Ljava/awt/Color;", "color", "<init>", "(Ljava/awt/Color;)V", "", "(I)V", "", "hue", "saturation", "brightness", "alpha", "(FFFF)V", "component1", "()F", "component2", "component3", "component4", "copy", "(FFFF)Lgg/essential/gui/screenshot/components/HSBColor;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toColor", "()Ljava/awt/Color;", "", "toString", "()Ljava/lang/String;", "F", "getAlpha", "setAlpha", "(F)V", "getBrightness", "setBrightness", "getHue", "setHue", "getSaturation", "setSaturation", "Essential 1.19.2-forge"})
public final class HSBColor {
    private float hue;
    private float saturation;
    private float brightness;
    private float alpha;

    public HSBColor(float hue, float saturation, float brightness, float alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.alpha = alpha;
    }

    public final float getHue() {
        return this.hue;
    }

    public final void setHue(float f) {
        this.hue = f;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final void setSaturation(float f) {
        this.saturation = f;
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final void setBrightness(float f) {
        this.brightness = f;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(float f) {
        this.alpha = f;
    }

    public HSBColor(@NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        this(0.0f, 0.0f, 0.0f, (float)color2.getAlpha() / 255.0f);
        float[] hsb = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
    }

    public HSBColor(int color2) {
        this(new Color(color2));
    }

    @NotNull
    public final Color toColor() {
        return ExtensionsKt.withAlpha(new Color(Color.HSBtoRGB(this.hue, this.saturation, this.brightness)), this.alpha);
    }

    public final float component1() {
        return this.hue;
    }

    public final float component2() {
        return this.saturation;
    }

    public final float component3() {
        return this.brightness;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final HSBColor copy(float hue, float saturation, float brightness, float alpha) {
        return new HSBColor(hue, saturation, brightness, alpha);
    }

    public static /* synthetic */ HSBColor copy$default(HSBColor hSBColor, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = hSBColor.hue;
        }
        if ((n & 2) != 0) {
            f2 = hSBColor.saturation;
        }
        if ((n & 4) != 0) {
            f3 = hSBColor.brightness;
        }
        if ((n & 8) != 0) {
            f4 = hSBColor.alpha;
        }
        return hSBColor.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "HSBColor(hue=" + this.hue + ", saturation=" + this.saturation + ", brightness=" + this.brightness + ", alpha=" + this.alpha + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.hue);
        result = result * 31 + Float.hashCode(this.saturation);
        result = result * 31 + Float.hashCode(this.brightness);
        result = result * 31 + Float.hashCode(this.alpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HSBColor)) {
            return false;
        }
        HSBColor hSBColor = (HSBColor)other;
        if (Float.compare(this.hue, hSBColor.hue) != 0) {
            return false;
        }
        if (Float.compare(this.saturation, hSBColor.saturation) != 0) {
            return false;
        }
        if (Float.compare(this.brightness, hSBColor.brightness) != 0) {
            return false;
        }
        return Float.compare(this.alpha, hSBColor.alpha) == 0;
    }
}

