/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.components;

import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.Essential;
import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.state.BasicState;
import gg.essential.gui.InternalEssentialGUI;
import gg.essential.gui.common.ExtensionsKt;
import gg.essential.gui.common.modal.Modal;
import gg.essential.gui.common.modal.PropertiesModal;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.overlay.ModalManager;
import gg.essential.gui.screenshot.LocalScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.components.FocusEditComponent;
import gg.essential.gui.screenshot.components.FocusListComponent;
import gg.essential.gui.screenshot.components.FocusType;
import gg.essential.gui.screenshot.components.ListViewComponent;
import gg.essential.gui.screenshot.components.ScreenshotBrowser;
import gg.essential.gui.screenshot.components.ScreenshotOptionsDropdown;
import gg.essential.gui.screenshot.components.ScreenshotProperties;
import gg.essential.gui.screenshot.components.ScreenshotProviderManager;
import gg.essential.gui.screenshot.components.ScreenshotStateManager;
import gg.essential.gui.screenshot.components.View;
import gg.essential.gui.screenshot.handler.ScreenshotMetadataManager;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.network.connectionmanager.media.ScreenshotCollectionChangeEvent;
import gg.essential.network.connectionmanager.media.ScreenshotManager;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMinecraft;
import gg.essential.util.GuiUtil;
import gg.essential.util.HelpersKt;
import gg.essential.util.Multithreading;
import gg.essential.util.UuidNameLookup;
import gg.essential.util.lwjgl3.api.ImageData;
import gg.essential.util.lwjgl3.api.NativeImageReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 g2\u00020\u0001:\u0001gB\u0013\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u000f\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\nJ\u001d\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0019\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001e0\u001c0\u001b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b#\u0010\fJ\r\u0010$\u001a\u00020\b\u00a2\u0006\u0004\b$\u0010\fJ\u0015\u0010$\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b$\u0010\nJ\u0015\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\nJ'\u0010*\u001a\u00020\b2\u0006\u0010&\u001a\u00020%2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b,\u0010\fR \u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r0-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001d\u00102\u001a\b\u0012\u0004\u0012\u000201008\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u0017\u00107\u001a\u0002068\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0017\u0010<\u001a\u00020;8\u0006\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?R\u001d\u0010A\u001a\b\u0012\u0004\u0012\u00020@008\u0006\u00a2\u0006\f\n\u0004\bA\u00103\u001a\u0004\bB\u00105R\u001f\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0006008\u0006\u00a2\u0006\f\n\u0004\bC\u00103\u001a\u0004\bD\u00105R\u0017\u0010F\u001a\u00020E8\u0006\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\u001f\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0006008\u0006\u00a2\u0006\f\n\u0004\bJ\u00103\u001a\u0004\bK\u00105R\u0017\u0010M\u001a\u00020L8\u0006\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010PR\u0017\u0010R\u001a\u00020Q8\u0006\u00a2\u0006\f\n\u0004\bR\u0010S\u001a\u0004\bT\u0010UR\u001a\u0010X\u001a\b\u0012\u0004\u0012\u00020W0V8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bX\u0010YR\u001c\u0010\\\u001a\u00070Z\u00a2\u0006\u0002\b[8\u0006\u00a2\u0006\f\n\u0004\b\\\u0010]\u001a\u0004\b^\u0010_R\u0017\u0010a\u001a\u00020`8\u0006\u00a2\u0006\f\n\u0004\ba\u0010b\u001a\u0004\bc\u0010dR\u0016\u0010e\u001a\u0002018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\be\u0010f\u00a8\u0006h"}, d2={"Lgg/essential/gui/screenshot/components/ScreenshotBrowser;", "Lgg/essential/gui/InternalEssentialGUI;", "Ljava/nio/file/Path;", "editPath", "<init>", "(Ljava/nio/file/Path;)V", "Lgg/essential/gui/screenshot/components/ScreenshotProperties;", "properties", "", "changeFocusedComponent", "(Lgg/essential/gui/screenshot/components/ScreenshotProperties;)V", "closeFocus", "()V", "Lkotlin/Function0;", "function", "closeOperation", "(Lkotlin/jvm/functions/Function0;)V", "displayPropertiesModal", "newScreenshot", "", "openFocusView", "editCallback", "(Ljava/nio/file/Path;Z)V", "", "paths", "externalDelete", "(Ljava/util/Set;)V", "", "Lkotlin/Pair;", "", "Lgg/essential/gui/elementa/state/v2/State;", "generateImageProperties", "(Lgg/essential/gui/screenshot/components/ScreenshotProperties;)Ljava/util/List;", "onEscapeButtonPressed", "()Z", "onScreenClose", "openEditor", "Lnet/minecraft/client/Minecraft;", "mcIn", "", "w", "h", "resize", "(Lnet/minecraft/client/Minecraft;II)V", "updateGuiScale", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "closeOperations", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lgg/essential/elementa/state/BasicState;", "Lgg/essential/gui/screenshot/components/View;", "currentView", "Lgg/essential/elementa/state/BasicState;", "getCurrentView", "()Lgg/essential/elementa/state/BasicState;", "Lgg/essential/gui/screenshot/components/FocusEditComponent;", "focusEditComponent", "Lgg/essential/gui/screenshot/components/FocusEditComponent;", "getFocusEditComponent", "()Lgg/essential/gui/screenshot/components/FocusEditComponent;", "Lgg/essential/gui/screenshot/components/FocusListComponent;", "focusListComponent", "Lgg/essential/gui/screenshot/components/FocusListComponent;", "getFocusListComponent", "()Lgg/essential/gui/screenshot/components/FocusListComponent;", "Lgg/essential/gui/screenshot/components/FocusType;", "focusType", "getFocusType", "focusing", "getFocusing", "Lgg/essential/gui/screenshot/components/ListViewComponent;", "listViewComponent", "Lgg/essential/gui/screenshot/components/ListViewComponent;", "getListViewComponent", "()Lgg/essential/gui/screenshot/components/ListViewComponent;", "menuDialogOwner", "getMenuDialogOwner", "Lgg/essential/gui/screenshot/components/ScreenshotOptionsDropdown;", "optionsDropdown", "Lgg/essential/gui/screenshot/components/ScreenshotOptionsDropdown;", "getOptionsDropdown", "()Lgg/essential/gui/screenshot/components/ScreenshotOptionsDropdown;", "Lgg/essential/gui/screenshot/components/ScreenshotProviderManager;", "providerManager", "Lgg/essential/gui/screenshot/components/ScreenshotProviderManager;", "getProviderManager", "()Lgg/essential/gui/screenshot/components/ScreenshotProviderManager;", "Ljava/util/function/Consumer;", "Lgg/essential/network/connectionmanager/media/ScreenshotCollectionChangeEvent;", "refreshHandler", "Ljava/util/function/Consumer;", "Lgg/essential/network/connectionmanager/media/ScreenshotManager;", "Lorg/jetbrains/annotations/NotNull;", "screenshotManager", "Lgg/essential/network/connectionmanager/media/ScreenshotManager;", "getScreenshotManager", "()Lgg/essential/network/connectionmanager/media/ScreenshotManager;", "Lgg/essential/gui/screenshot/components/ScreenshotStateManager;", "stateManager", "Lgg/essential/gui/screenshot/components/ScreenshotStateManager;", "getStateManager", "()Lgg/essential/gui/screenshot/components/ScreenshotStateManager;", "stateToRestore", "Lgg/essential/gui/screenshot/components/View;", "Companion", "Essential 1.19.2-forge"})
@SourceDebugExtension(value={"SMAP\nScreenshotBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotBrowser.kt\ngg/essential/gui/screenshot/components/ScreenshotBrowser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,303:1\n1#2:304\n*E\n"})
public final class ScreenshotBrowser
extends InternalEssentialGUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentLinkedQueue<Function0<Unit>> closeOperations;
    @NotNull
    private final BasicState<ScreenshotProperties> focusing;
    @NotNull
    private final BasicState<View> currentView;
    @NotNull
    private final BasicState<FocusType> focusType;
    @NotNull
    private final ScreenshotManager screenshotManager;
    @NotNull
    private final ScreenshotStateManager stateManager;
    @NotNull
    private final ListViewComponent listViewComponent;
    @NotNull
    private final ScreenshotProviderManager providerManager;
    @NotNull
    private final FocusListComponent focusListComponent;
    @NotNull
    private final FocusEditComponent focusEditComponent;
    @NotNull
    private final BasicState<ScreenshotProperties> menuDialogOwner;
    @NotNull
    private final ScreenshotOptionsDropdown optionsDropdown;
    @NotNull
    private View stateToRestore;
    @NotNull
    private final Consumer<ScreenshotCollectionChangeEvent> refreshHandler;
    @NotNull
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public ScreenshotBrowser(@Nullable Path editPath) {
        super(ElementaVersion.V6, "Pictures", 0, false, "Browsing pictures", 12, null);
        this.closeOperations = new ConcurrentLinkedQueue();
        this.focusing = new BasicState<Object>(null);
        this.currentView = this.focusing.map(currentView.1.INSTANCE);
        this.focusType = new BasicState<FocusType>(FocusType.VIEW);
        ScreenshotManager screenshotManager = Essential.getInstance().getConnectionManager().getScreenshotManager();
        Intrinsics.checkNotNullExpressionValue((Object)screenshotManager, (String)"getScreenshotManager(...)");
        this.screenshotManager = screenshotManager;
        this.stateManager = new ScreenshotStateManager(this.screenshotManager);
        this.listViewComponent = new ListViewComponent(this);
        this.providerManager = new ScreenshotProviderManager(this, this.listViewComponent.getScreenshotScrollComponent());
        this.focusListComponent = new FocusListComponent(this);
        this.focusEditComponent = new FocusEditComponent(this);
        this.menuDialogOwner = new BasicState<Object>(null);
        this.optionsDropdown = new ScreenshotOptionsDropdown(this, (gg.essential.elementa.state.State<ScreenshotProperties>)this.menuDialogOwner);
        this.stateToRestore = View.LIST;
        this.refreshHandler = arg_0 -> ScreenshotBrowser.refreshHandler$lambda$0(this, arg_0);
        ExtensionsKt.bindParent$default((UIComponent)this.getTitleText(), (UIComponent)this.getTitleBar(), this.listViewComponent.getActive(), false, null, 12, null);
        this.currentView.map(1.INSTANCE).onSetValue((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                this.setBackButtonVisible(it);
            }
        });
        CollectionsKt.removeFirst(this.getWindow().getKeyTypedListeners());
        this.getWindow().onKeyType((Function3<? super UIComponent, ? super Character, ? super Integer, Unit>)((Function3)new Function3<UIComponent, Character, Integer, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onKeyType, char typedChar, int keyCode) {
                Intrinsics.checkNotNullParameter((Object)$this$onKeyType, (String)"$this$onKeyType");
                if (keyCode == UKeyboard.KEY_ESCAPE && this.onEscapeButtonPressed()) {
                    return;
                }
                this.defaultKeyBehavior(typedChar, keyCode);
            }
        }));
        if (editPath != null) {
            ScreenshotId screenshotId = new LocalScreenshot(editPath);
            ScreenshotMetadataManager screenshotMetadataManager = this.screenshotManager.getScreenshotMetadataManager();
            File file = editPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            this.openEditor(new ScreenshotProperties(screenshotId, screenshotMetadataManager.getMetadata(file)));
        }
        this.screenshotManager.registerScreenshotCollectionChangeHandler(this.refreshHandler);
    }

    public /* synthetic */ ScreenshotBrowser(Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = null;
        }
        this(path);
    }

    @NotNull
    public final BasicState<ScreenshotProperties> getFocusing() {
        return this.focusing;
    }

    @NotNull
    public final BasicState<View> getCurrentView() {
        return this.currentView;
    }

    @NotNull
    public final BasicState<FocusType> getFocusType() {
        return this.focusType;
    }

    @NotNull
    public final ScreenshotManager getScreenshotManager() {
        return this.screenshotManager;
    }

    @NotNull
    public final ScreenshotStateManager getStateManager() {
        return this.stateManager;
    }

    @NotNull
    public final ListViewComponent getListViewComponent() {
        return this.listViewComponent;
    }

    @NotNull
    public final ScreenshotProviderManager getProviderManager() {
        return this.providerManager;
    }

    @NotNull
    public final FocusListComponent getFocusListComponent() {
        return this.focusListComponent;
    }

    @NotNull
    public final FocusEditComponent getFocusEditComponent() {
        return this.focusEditComponent;
    }

    @NotNull
    public final BasicState<ScreenshotProperties> getMenuDialogOwner() {
        return this.menuDialogOwner;
    }

    @NotNull
    public final ScreenshotOptionsDropdown getOptionsDropdown() {
        return this.optionsDropdown;
    }

    public final void openFocusView(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        this.changeFocusedComponent(properties2);
        this.focusType.set(FocusType.VIEW);
    }

    public final void changeFocusedComponent(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        this.focusing.set(properties2);
        this.focusListComponent.beginPreview(properties2);
    }

    public final void displayPropertiesModal(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        List<Pair<String, State<String>>> metadata2 = this.generateImageProperties(properties2);
        GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)new Function1<ModalManager, Modal>(metadata2){
            final /* synthetic */ List<Pair<String, State<String>>> $metadata;
            {
                this.$metadata = $metadata;
                super(1);
            }

            @NotNull
            public final Modal invoke(@NotNull ModalManager manager) {
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                return new PropertiesModal(manager, MapsKt.toMap((Iterable)this.$metadata));
            }
        }));
    }

    private final List<Pair<String, State<String>>> generateImageProperties(ScreenshotProperties properties2) {
        DateTime editTime;
        DateTime imageTime;
        List pairList = new ArrayList();
        pairList.add(TuplesKt.to((Object)"Name", StateKt.stateOf(properties2.getId().getName())));
        ClientScreenshotMetadata metadata2 = properties2.getMetadata();
        if (metadata2 != null) {
            String string = metadata2.getLocationMetadata().getIdentifier();
            if (string == null) {
                string = "";
            }
            String locationIdentifier = string;
            switch (WhenMappings.$EnumSwitchMapping$0[metadata2.getLocationMetadata().getType().ordinal()]) {
                case 1: {
                    pairList.add(TuplesKt.to((Object)"Location", StateKt.stateOf("Unknown")));
                    break;
                }
                case 2: {
                    pairList.add(TuplesKt.to((Object)"Server", StateKt.stateOf(locationIdentifier)));
                    break;
                }
                case 3: {
                    pairList.add(TuplesKt.to((Object)"Menu", StateKt.stateOf(locationIdentifier)));
                    break;
                }
                case 4: {
                    pairList.add(TuplesKt.to((Object)"World", StateKt.stateOf(locationIdentifier)));
                    break;
                }
                case 5: {
                    UUID host = Essential.getInstance().getConnectionManager().getSpsManager().getHostFromSpsAddress(locationIdentifier);
                    if (host != null) {
                        pairList.add(TuplesKt.to((Object)"Location", StateKt.stateOf("Shared World")));
                        pairList.add(TuplesKt.to((Object)"Host", UuidNameLookup.nameState(host, "Loading...")));
                        break;
                    }
                    pairList.add(TuplesKt.to((Object)"Location", StateKt.stateOf(locationIdentifier)));
                }
            }
            pairList.add(TuplesKt.to((Object)"Creator", UuidNameLookup.nameState(metadata2.getAuthorId(), "Loading...")));
        }
        if ((imageTime = HelpersKt.getImageTime(properties2, false)).getTime() > 0L) {
            Instant instant = Instant.ofEpochMilli(imageTime.getTime());
            LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
            String string = imageTime.format(new SimpleDateFormat("EEEE", Locale.ENGLISH));
            Intrinsics.checkNotNull((Object)localDate);
            pairList.add(TuplesKt.to((Object)"Date", StateKt.stateOf(string + ", " + HelpersKt.formatDate$default(localDate, false, 2, null))));
            Intrinsics.checkNotNull((Object)instant);
            pairList.add(TuplesKt.to((Object)"Time", StateKt.stateOf(HelpersKt.formatTime(instant, true))));
        }
        ClientScreenshotMetadata clientScreenshotMetadata = properties2.getMetadata();
        DateTime dateTime = editTime = clientScreenshotMetadata != null ? clientScreenshotMetadata.getEditTime() : null;
        if (editTime != null) {
            Instant instant = Instant.ofEpochMilli(editTime.getTime());
            LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
            String string = editTime.format(new SimpleDateFormat("EEEE", Locale.ENGLISH));
            Intrinsics.checkNotNull((Object)localDate);
            pairList.add(TuplesKt.to((Object)"Edit Date", StateKt.stateOf(string + ", " + HelpersKt.formatDate$default(localDate, false, 2, null))));
            Intrinsics.checkNotNull((Object)instant);
            pairList.add(TuplesKt.to((Object)"Edit Time", StateKt.stateOf(HelpersKt.formatTime(instant, true))));
        }
        MutableState<String> dimension = StateKt.mutableStateOf("Loading...");
        Multithreading.runAsync(() -> ScreenshotBrowser.generateImageProperties$lambda$3(properties2, this, dimension));
        pairList.add(TuplesKt.to((Object)"Dimensions", dimension));
        return pairList;
    }

    public final void openEditor(@NotNull ScreenshotProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        this.stateToRestore = this.currentView.get();
        this.focusing.set(properties2);
        this.focusType.set(FocusType.EDIT);
    }

    public final void openEditor() {
        ScreenshotProperties screenshotProperties = this.focusing.get();
        Intrinsics.checkNotNull((Object)screenshotProperties);
        this.openEditor(screenshotProperties);
    }

    public final void closeFocus() {
        if (this.focusType.get() == FocusType.EDIT) {
            this.focusEditComponent.onClose();
        } else {
            this.focusListComponent.onClose();
        }
        if (this.stateToRestore == View.LIST) {
            this.focusing.set((ScreenshotProperties)((Object)closeFocus.1.INSTANCE));
        } else {
            this.focusType.set(FocusType.VIEW);
            this.stateToRestore = View.LIST;
        }
    }

    private final boolean onEscapeButtonPressed() {
        if (this.currentView.get() != View.FOCUS) {
            return false;
        }
        if (this.focusType.get() == FocusType.EDIT) {
            this.focusEditComponent.onBackButtonPressed();
        } else {
            this.closeFocus();
        }
        return true;
    }

    @Override
    public void onScreenClose() {
        super.onScreenClose();
        this.providerManager.cleanup();
        for (Function0<Unit> closeOperation : this.closeOperations) {
            closeOperation.invoke();
        }
    }

    public final void externalDelete(@NotNull Set<? extends Path> paths2) {
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        this.providerManager.externalDelete(paths2);
        this.listViewComponent.reload();
        ScreenshotProperties screenshotProperties = this.focusing.get();
        if (screenshotProperties == null) {
            return;
        }
        ScreenshotProperties focused = screenshotProperties;
        if (focused.getId() instanceof LocalScreenshot && paths2.contains(((LocalScreenshot)focused.getId()).getPath())) {
            this.stateToRestore = View.LIST;
            this.closeFocus();
        } else if (this.focusType.get() == FocusType.VIEW) {
            this.openFocusView(focused);
        }
    }

    @Override
    public void updateGuiScale() {
        this.setNewGuiScale(GuiUtil.INSTANCE.getGuiScale());
        super.updateGuiScale();
    }

    public void m_6574_(@NotNull Minecraft mcIn, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)mcIn, (String)"mcIn");
        this.setNewGuiScale(GuiUtil.INSTANCE.getGuiScale());
        super.m_6574_(mcIn, w, h);
    }

    public final void editCallback(@NotNull Path newScreenshot, boolean openFocusView) {
        ScreenshotProperties properties2;
        Intrinsics.checkNotNullParameter((Object)newScreenshot, (String)"newScreenshot");
        this.providerManager.reloadItems();
        this.listViewComponent.reload();
        ScreenshotProperties screenshotProperties = this.focusing.get();
        if (screenshotProperties != null) {
            ScreenshotProperties it = screenshotProperties;
            boolean bl = false;
            this.focusListComponent.beginPreview(it);
        }
        if (openFocusView && (properties2 = this.providerManager.getPropertyMap().get(new LocalScreenshot(newScreenshot))) != null) {
            if (this.focusType.get() == FocusType.EDIT) {
                this.closeFocus();
            }
            this.openFocusView(properties2);
        }
    }

    public final void closeOperation(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.closeOperations.add(function);
    }

    private static final void refreshHandler$lambda$0(ScreenshotBrowser this$0, ScreenshotCollectionChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.screenshotsDeleted()) {
            Set<Path> set2 = it.getDeletedPaths();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"getDeletedPaths(...)");
            this$0.externalDelete(set2);
        } else if (it.screenshotsCreated()) {
            this$0.providerManager.reloadItems();
            this$0.listViewComponent.reload();
        }
    }

    private static final void generateImageProperties$lambda$3$lambda$2(MutableState $dimension, String $text) {
        Intrinsics.checkNotNullParameter((Object)$dimension, (String)"$dimension");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        $dimension.set($text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void generateImageProperties$lambda$3(ScreenshotProperties $properties, ScreenshotBrowser this$0, MutableState $dimension) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$properties, (String)"$properties");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dimension, (String)"$dimension");
        try {
            byte[] byArray;
            Closeable closeable = $properties.getId().open();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ByteBuf bytes = Unpooled.wrappedBuffer((byte[])byArray);
            NativeImageReader nativeImageReader = this$0.screenshotManager.getNativeImageReader();
            Intrinsics.checkNotNull((Object)bytes);
            UnpooledByteBufAllocator unpooledByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)unpooledByteBufAllocator, (String)"DEFAULT");
            ImageData image2 = nativeImageReader.getImageData(bytes, (ByteBufAllocator)unpooledByteBufAllocator);
            image2.release();
            object = image2.getWidth() + "x" + image2.getHeight() + " pixels";
        }
        catch (Exception e) {
            Essential.logger.error("Failed to read image dimensions: ", (Throwable)e);
            object = "Unknown";
        }
        String text2 = object;
        gg.essential.util.ExtensionsKt.getExecutor(UMinecraft.getMinecraft()).execute(() -> ScreenshotBrowser.generateImageProperties$lambda$3$lambda$2($dimension, text2));
    }

    public ScreenshotBrowser() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgg/essential/gui/screenshot/components/ScreenshotBrowser$Companion;", "", "<init>", "()V", "Ljava/text/DateFormat;", "DATE_FORMAT", "Ljava/text/DateFormat;", "getDATE_FORMAT", "()Ljava/text/DateFormat;", "Essential 1.19.2-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateFormat getDATE_FORMAT() {
            return DATE_FORMAT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientScreenshotMetadata.Location.Type.values().length];
            try {
                nArray[ClientScreenshotMetadata.Location.Type.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientScreenshotMetadata.Location.Type.MULTIPLAYER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientScreenshotMetadata.Location.Type.MENU.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientScreenshotMetadata.Location.Type.SINGLE_PLAYER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientScreenshotMetadata.Location.Type.SHARED_WORLD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

