/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.handler;

import gg.essential.gui.screenshot.handler.ChecksumSnapshot;
import gg.essential.gui.screenshot.handler.SerializedChecksum;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.util.HelpersKt;
import gg.essential.vigilance.impl.nightconfig.core.utils.ObservedMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0005J\u001a\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000bJ\u0017\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J \u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR0\u0010\u001f\u001a\u001e\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\t0\t0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;", "", "Ljava/io/File;", "cacheFile", "<init>", "(Ljava/io/File;)V", "file", "", "delete", "", "get", "(Ljava/io/File;)Ljava/lang/String;", "Lgg/essential/gui/screenshot/handler/ChecksumSnapshot;", "getChecksumSnapshot", "(Ljava/io/File;)Lgg/essential/gui/screenshot/handler/ChecksumSnapshot;", "checksum", "", "Ljava/nio/file/Path;", "getPathsForChecksum", "(Ljava/lang/String;)Ljava/util/List;", "readFileChecksum", "name", "remove", "(Ljava/lang/String;)Ljava/lang/String;", "saveState", "()V", "set", "(Ljava/io/File;Ljava/lang/String;)V", "Ljava/io/File;", "Lgg/essential/vigilance/impl/nightconfig/core/utils/ObservedMap;", "kotlin.jvm.PlatformType", "entries", "Lgg/essential/vigilance/impl/nightconfig/core/utils/ObservedMap;", "Lgg/essential/lib/gson/Gson;", "gson", "Lgg/essential/lib/gson/Gson;", "", "persistChanges", "Z", "Essential 1.19.2-forge"})
@SourceDebugExtension(value={"SMAP\nScreenshotChecksumManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotChecksumManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotChecksumManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,159:1\n766#2:160\n857#2,2:161\n1549#2:163\n1620#2,3:164\n288#2,2:167\n125#3:169\n152#3,3:170\n*S KotlinDebug\n*F\n+ 1 ScreenshotChecksumManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotChecksumManager\n*L\n97#1:160\n97#1:161,2\n99#1:163\n99#1:164,3\n110#1:167,2\n127#1:169\n127#1:170,3\n*E\n"})
public final class ScreenshotChecksumManager {
    @NotNull
    private final File cacheFile;
    @NotNull
    private final Gson gson;
    private boolean persistChanges;
    @NotNull
    private final ObservedMap<ChecksumSnapshot, String> entries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenshotChecksumManager(@NotNull File cacheFile) {
        Intrinsics.checkNotNullParameter((Object)cacheFile, (String)"cacheFile");
        this.cacheFile = cacheFile;
        this.gson = new Gson();
        this.persistChanges = true;
        this.entries = new ObservedMap(new LinkedHashMap(), () -> ScreenshotChecksumManager.entries$lambda$0(this));
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            boolean bl = false;
            if (this.cacheFile.exists()) {
                try {
                    this.persistChanges = false;
                    SerializedChecksum[] data = this.gson.fromJson(FileUtils.readFileToString((File)this.cacheFile, (Charset)StandardCharsets.UTF_8), SerializedChecksum[].class);
                    if (data != null) {
                        for (SerializedChecksum entry : data) {
                            ((Map)this.entries).put(entry.getSnapshot(), entry.getChecksum());
                        }
                    }
                }
                catch (JsonSyntaxException e) {
                    this.cacheFile.delete();
                }
                finally {
                    this.persistChanges = true;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@NotNull File file, @NotNull String checksum) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            boolean bl = false;
            ((Map)this.entries).put(this.getChecksumSnapshot(file), checksum);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String get(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            String string;
            boolean bl = false;
            ChecksumSnapshot checksumSnapshot = this.getChecksumSnapshot(file);
            String get2 = this.entries.get(checksumSnapshot);
            if (get2 != null) {
                string = get2;
            } else {
                String fileChecksum;
                String string2 = fileChecksum = this.readFileChecksum(file);
                if (string2 != null) {
                    String string3;
                    String it = string3 = string2;
                    boolean bl2 = false;
                    ((Map)this.entries).put(checksumSnapshot, fileChecksum);
                    string = string3;
                } else {
                    string = null;
                }
            }
            String string4 = string;
            return string4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> getPathsForChecksum(@NotNull String checksum) {
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Set<Map.Entry<ChecksumSnapshot, String>> set2 = this.entries.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
            Iterable $this$filter$iv = set2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getValue(), (Object)checksum)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new File(HelpersKt.getScreenshotFolder(), ((ChecksumSnapshot)it.getKey()).getName()).toPath());
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String remove(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            String string;
            Object v1;
            block6: {
                boolean bl = false;
                Set<Map.Entry<ChecksumSnapshot, String>> set2 = this.entries.entrySet();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
                Iterable $this$firstOrNull$iv = set2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((ChecksumSnapshot)it.getKey()).getName(), (Object)name2)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            Map.Entry entry = v1;
            if (entry != null) {
                Map.Entry it = entry;
                boolean bl = false;
                this.entries.remove(it.getKey());
                string = (String)it.getValue();
            } else {
                string = null;
            }
            String string2 = string;
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveState() {
        if (!this.persistChanges) {
            return;
        }
        ObservedMap<ChecksumSnapshot, String> observedMap = this.entries;
        synchronized (observedMap) {
            Collection<SerializedChecksum> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            Map map2 = this.entries;
            Gson gson = this.gson;
            File file = this.cacheFile;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                String string = (String)v;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                collection.add(new SerializedChecksum(string, (ChecksumSnapshot)k));
            }
            collection = (List)destination$iv$iv;
            FileUtils.write((File)file, (CharSequence)gson.toJson(collection), (Charset)StandardCharsets.UTF_8);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String readFileChecksum(File file) {
        String string;
        try {
            string = DigestUtils.md5Hex((byte[])FileUtils.readFileToByteArray((File)file));
        }
        catch (IOException e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }

    private final ChecksumSnapshot getChecksumSnapshot(File file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new ChecksumSnapshot(string, file.lastModified(), file.length());
    }

    public final void delete(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.entries.remove(this.getChecksumSnapshot(file));
    }

    private static final void entries$lambda$0(ScreenshotChecksumManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.saveState();
    }
}

