/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.image;

import gg.essential.clipboard.AWTClipboard;
import gg.essential.clipboard.Clipboard;
import gg.essential.gui.screenshot.image.ForkedImageClipboard;
import gg.essential.util.ForkedJvm;
import gg.essential.util.OperatingSystem;
import gg.essential.util.OperatingSystemKt;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lgg/essential/gui/screenshot/image/ForkedImageClipboard;", "Ljava/lang/AutoCloseable;", "<init>", "()V", "", "close", "Ljava/io/File;", "file", "", "copy", "(Ljava/io/File;)Z", "Ljava/io/DataInputStream;", "inputStream", "Ljava/io/DataInputStream;", "Lgg/essential/util/ForkedJvm;", "jvm", "Lgg/essential/util/ForkedJvm;", "Companion", "Essential 1.19.2-forge"})
public final class ForkedImageClipboard
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ForkedJvm jvm;
    @NotNull
    private final DataInputStream inputStream;
    @NotNull
    private static final Lazy<Path> extractedClipboardJar$delegate = LazyKt.lazy((Function0)Companion.extractedClipboardJar.2.INSTANCE);

    public ForkedImageClipboard() {
        String string = ForkedImageClipboard.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.jvm = new ForkedJvm(string, ForkedImageClipboard.Companion.classpath(), null, 4, null);
        this.inputStream = new DataInputStream(this.jvm.getProcess().getInputStream());
    }

    @Override
    public void close() {
        if (OperatingSystemKt.getOs() != OperatingSystem.LINUX) {
            this.jvm.close();
        }
    }

    public final boolean copy(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OutputStream outputStream = this.jvm.getProcess().getOutputStream();
        String string = file.getAbsoluteFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        outputStream.write(StringsKt.encodeToByteArray((String)string));
        this.jvm.getProcess().getOutputStream().flush();
        this.jvm.getProcess().getOutputStream().close();
        return this.inputStream.read() == 1;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u001b\u0010\u0011\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lgg/essential/gui/screenshot/image/ForkedImageClipboard$Companion;", "", "<init>", "()V", "", "classpath", "()Ljava/lang/String;", "", "args", "", "main", "([Ljava/lang/String;)V", "Ljava/nio/file/Path;", "extractedClipboardJar$delegate", "Lkotlin/Lazy;", "getExtractedClipboardJar", "()Ljava/nio/file/Path;", "extractedClipboardJar", "Essential 1.19.2-forge"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getExtractedClipboardJar() {
            Lazy lazy2 = extractedClipboardJar$delegate;
            Object object = lazy2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Path)object;
        }

        private final String classpath() {
            return this.getExtractedClipboardJar() + System.getProperty("path.separator") + ForkedJvm.Companion.defaultClassPath();
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"in");
            File file = new File(StringsKt.decodeToString((byte[])ByteStreamsKt.readBytes((InputStream)inputStream)));
            if (!file.exists()) {
                System.out.write(0);
                System.out.close();
                return;
            }
            Clipboard clipboard = Clipboard.Companion.current();
            boolean success = clipboard.copyPNG(file);
            System.out.write(success ? 1 : 0);
            System.out.close();
            if (OperatingSystemKt.getOs() == OperatingSystem.LINUX && clipboard instanceof AWTClipboard) {
                ((AWTClipboard)clipboard).getLostOwnership().acquire();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

