/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ActivityType;
import gg.essential.data.OnboardingData;
import gg.essential.event.gui.GuiOpenEvent;
import gg.essential.event.network.server.ServerJoinEvent;
import gg.essential.event.network.server.ServerLeaveEvent;
import gg.essential.event.network.server.SingleplayerJoinEvent;
import gg.essential.event.sps.SPSStartEvent;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.ext.client.multiplayer.ServerDataExt;
import gg.essential.mixins.ext.client.multiplayer.ServerDataExtKt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.util.AddressUtil;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import org.jetbrains.annotations.Nullable;

public class ServerStatusHandler {
    @Subscribe
    public void onGuiSwitch(GuiOpenEvent event) {
        if (event.getGui() instanceof TitleScreen) {
            this.setActivity(null, null);
        }
    }

    @Subscribe
    public void disconnectEvent(ServerLeaveEvent event) {
        this.setActivity(null, null);
    }

    private void setActivity(@Nullable ActivityType activityType, @Nullable String metadata2) {
        if (!OnboardingData.hasAcceptedTos() || !EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        connectionManager.getProfileManager().updatePlayerActivity(activityType, metadata2);
    }

    @Subscribe
    public void connect(ServerJoinEvent event) {
        ServerData serverData = event.getServerData();
        ServerDataExt serverDataExt = ServerDataExtKt.getExt(serverData);
        Boolean shareWithFriends = serverDataExt.getEssential$shareWithFriends();
        if (shareWithFriends == null) {
            shareWithFriends = EssentialConfig.INSTANCE.getSendServerUpdates();
        }
        if (!shareWithFriends.booleanValue()) {
            return;
        }
        String serverIP = serverData.f_105363_;
        if (AddressUtil.isLanOrLocalAddress(serverIP)) {
            this.setActivity(ActivityType.PLAYING, "Local Server");
        } else {
            this.setActivity(ActivityType.PLAYING, AddressUtil.removeDefaultPort(serverIP));
        }
    }

    @Subscribe
    public void joinSinglePlayer(SingleplayerJoinEvent event) {
        this.setActivity(ActivityType.PLAYING, "Singleplayer");
    }

    @Subscribe
    public void hostWorld(SPSStartEvent event) {
        if (!EssentialConfig.INSTANCE.getSendServerUpdates()) {
            return;
        }
        this.setActivity(ActivityType.PLAYING, event.getAddress());
    }
}

