/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.gson.internal.bind;

import gg.essential.lib.gson.FieldNamingStrategy;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.lib.gson.TypeAdapter;
import gg.essential.lib.gson.TypeAdapterFactory;
import gg.essential.lib.gson.annotations.JsonAdapter;
import gg.essential.lib.gson.annotations.SerializedName;
import gg.essential.lib.gson.internal.$Gson$Types;
import gg.essential.lib.gson.internal.ConstructorConstructor;
import gg.essential.lib.gson.internal.Excluder;
import gg.essential.lib.gson.internal.ObjectConstructor;
import gg.essential.lib.gson.internal.Primitives;
import gg.essential.lib.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import gg.essential.lib.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import gg.essential.lib.gson.internal.reflect.ReflectionHelper;
import gg.essential.lib.gson.reflect.TypeToken;
import gg.essential.lib.gson.stream.JsonReader;
import gg.essential.lib.gson.stream.JsonToken;
import gg.essential.lib.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingPolicy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.excluder = excluder;
        this.jsonAdapterFactory = jsonAdapterFactory;
    }

    public boolean excludeField(Field f, boolean serialize) {
        return ReflectiveTypeAdapterFactory.excludeField(f, serialize, this.excluder);
    }

    static boolean excludeField(Field f, boolean serialize, Excluder excluder) {
        return !excluder.excludeClass(f.getType(), serialize) && !excluder.excludeField(f, serialize);
    }

    private List<String> getFieldNames(Field f) {
        SerializedName annotation2 = f.getAnnotation(SerializedName.class);
        if (annotation2 == null) {
            String name2 = this.fieldNamingPolicy.translateName(f);
            return Collections.singletonList(name2);
        }
        String serializedName = annotation2.value();
        String[] alternates = annotation2.alternate();
        if (alternates.length == 0) {
            return Collections.singletonList(serializedName);
        }
        ArrayList<String> fieldNames = new ArrayList<String>(alternates.length + 1);
        fieldNames.add(serializedName);
        for (String alternate : alternates) {
            fieldNames.add(alternate);
        }
        return fieldNames;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> raw = type.getRawType();
        if (!Object.class.isAssignableFrom(raw)) {
            return null;
        }
        ObjectConstructor<T> constructor = this.constructorConstructor.get(type);
        return new Adapter<T>(constructor, this.getBoundFields(gson, type, raw));
    }

    private BoundField createBoundField(final Gson context, final Field field2, String name2, final TypeToken<?> fieldType, boolean serialize, boolean deserialize) {
        boolean jsonAdapterPresent;
        final boolean isPrimitive = Primitives.isPrimitive(fieldType.getRawType());
        JsonAdapter annotation2 = field2.getAnnotation(JsonAdapter.class);
        TypeAdapter<?> mapped = null;
        if (annotation2 != null) {
            mapped = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, context, fieldType, annotation2);
        }
        boolean bl = jsonAdapterPresent = mapped != null;
        if (mapped == null) {
            mapped = context.getAdapter(fieldType);
        }
        final TypeAdapter<?> typeAdapter = mapped;
        return new BoundField(name2, serialize, deserialize){

            @Override
            void write(JsonWriter writer, Object value2) throws IOException, IllegalAccessException {
                Object fieldValue = field2.get(value2);
                TypeAdapter t = jsonAdapterPresent ? typeAdapter : new TypeAdapterRuntimeTypeWrapper(context, typeAdapter, fieldType.getType());
                t.write(writer, fieldValue);
            }

            @Override
            void read(JsonReader reader2, Object value2) throws IOException, IllegalAccessException {
                Object fieldValue = typeAdapter.read(reader2);
                if (fieldValue != null || !isPrimitive) {
                    field2.set(value2, fieldValue);
                }
            }

            @Override
            public boolean writeField(Object value2) throws IOException, IllegalAccessException {
                if (!this.serialized) {
                    return false;
                }
                Object fieldValue = field2.get(value2);
                return fieldValue != value2;
            }
        };
    }

    private Map<String, BoundField> getBoundFields(Gson context, TypeToken<?> type, Class<?> raw) {
        LinkedHashMap<String, BoundField> result = new LinkedHashMap<String, BoundField>();
        if (raw.isInterface()) {
            return result;
        }
        Type declaredType = type.getType();
        while (raw != Object.class) {
            Field[] fields;
            for (Field field2 : fields = raw.getDeclaredFields()) {
                boolean serialize = this.excludeField(field2, true);
                boolean deserialize = this.excludeField(field2, false);
                if (!serialize && !deserialize) continue;
                ReflectionHelper.makeAccessible(field2);
                Type fieldType = $Gson$Types.resolve(type.getType(), raw, field2.getGenericType());
                List<String> fieldNames = this.getFieldNames(field2);
                BoundField previous = null;
                int size = fieldNames.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    String name2 = fieldNames.get(i2);
                    if (i2 != 0) {
                        serialize = false;
                    }
                    BoundField boundField = this.createBoundField(context, field2, name2, TypeToken.get(fieldType), serialize, deserialize);
                    BoundField replaced = result.put(name2, boundField);
                    if (previous != null) continue;
                    previous = replaced;
                }
                if (previous == null) continue;
                throw new IllegalArgumentException(declaredType + " declares multiple JSON fields named " + previous.name);
            }
            type = TypeToken.get($Gson$Types.resolve(type.getType(), raw, raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return result;
    }

    public static final class Adapter<T>
    extends TypeAdapter<T> {
        private final ObjectConstructor<T> constructor;
        private final Map<String, BoundField> boundFields;

        Adapter(ObjectConstructor<T> constructor, Map<String, BoundField> boundFields) {
            this.constructor = constructor;
            this.boundFields = boundFields;
        }

        @Override
        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            T instance2 = this.constructor.construct();
            try {
                in.beginObject();
                while (in.hasNext()) {
                    String name2 = in.nextName();
                    BoundField field2 = this.boundFields.get(name2);
                    if (field2 == null || !field2.deserialized) {
                        in.skipValue();
                        continue;
                    }
                    field2.read(in, instance2);
                }
            }
            catch (IllegalStateException e) {
                throw new JsonSyntaxException(e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            in.endObject();
            return instance2;
        }

        @Override
        public void write(JsonWriter out, T value2) throws IOException {
            if (value2 == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    if (!boundField.writeField(value2)) continue;
                    out.name(boundField.name);
                    boundField.write(out, value2);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            out.endObject();
        }
    }

    static abstract class BoundField {
        final String name;
        final boolean serialized;
        final boolean deserialized;

        protected BoundField(String name2, boolean serialized, boolean deserialized) {
            this.name = name2;
            this.serialized = serialized;
            this.deserialized = deserialized;
        }

        abstract boolean writeField(Object var1) throws IOException, IllegalAccessException;

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;

        abstract void read(JsonReader var1, Object var2) throws IOException, IllegalAccessException;
    }
}

