/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j;

import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.ice.NetworkUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class TransportAddress
extends InetSocketAddress {
    private static final long serialVersionUID = 5076001401234631237L;
    private final Transport transport;

    public TransportAddress(String hostname, int port, Transport transport) {
        super(hostname, port);
        this.transport = transport;
    }

    public TransportAddress(byte[] ipAddress, int port, Transport transport) throws UnknownHostException {
        this(InetAddress.getByAddress(ipAddress), port, transport);
    }

    public TransportAddress(InetSocketAddress address, Transport transport) {
        this(address.getAddress(), address.getPort(), transport);
    }

    public TransportAddress(InetAddress address, int port, Transport transport) {
        super(address, port);
        this.transport = transport;
    }

    public byte[] getAddressBytes() {
        return this.getAddress().getAddress();
    }

    @Override
    public String toString() {
        String hostAddress = this.getHostAddress();
        if (hostAddress == null) {
            hostAddress = this.getHostName();
        }
        StringBuilder bldr = new StringBuilder(hostAddress);
        if (this.isIPv6()) {
            bldr.insert(0, "[").append("]");
        }
        bldr.append(":").append(this.getPort());
        bldr.append("/").append((Object)this.getTransport());
        return bldr.toString();
    }

    public String getHostAddress() {
        String addressStr;
        InetAddress addr = this.getAddress();
        String string = addressStr = addr != null ? addr.getHostAddress() : null;
        if (addr instanceof Inet6Address) {
            addressStr = NetworkUtils.stripScopeID(addressStr);
        }
        return addressStr;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public boolean equals(TransportAddress transportAddress) {
        return this.equalsTransportAddress(transportAddress);
    }

    public boolean equalsTransportAddress(Object obj) {
        return super.equals(obj) && ((TransportAddress)obj).getTransport() == this.getTransport();
    }

    public boolean isIPv6() {
        return this.getAddress() instanceof Inet6Address;
    }

    public boolean canReach(TransportAddress dst) {
        if (this.getTransport() != dst.getTransport()) {
            return false;
        }
        if (this.isIPv6() != dst.isIPv6()) {
            return false;
        }
        if (this.isIPv6()) {
            Inet6Address srcAddr = (Inet6Address)this.getAddress();
            Inet6Address dstAddr = (Inet6Address)dst.getAddress();
            if (srcAddr.isLinkLocalAddress() != dstAddr.isLinkLocalAddress()) {
                return Boolean.getBoolean("gg.essential.lib.ice4j.ALLOW_LINK_TO_GLOBAL_REACHABILITY");
            }
        }
        return true;
    }
}

