/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.attribute;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.attribute.AlternateServerAttribute;
import gg.essential.lib.ice4j.attribute.Attribute;
import gg.essential.lib.ice4j.attribute.ChangeRequestAttribute;
import gg.essential.lib.ice4j.attribute.ChangedAddressAttribute;
import gg.essential.lib.ice4j.attribute.ChannelNumberAttribute;
import gg.essential.lib.ice4j.attribute.ConnectionIdAttribute;
import gg.essential.lib.ice4j.attribute.DataAttribute;
import gg.essential.lib.ice4j.attribute.DontFragmentAttribute;
import gg.essential.lib.ice4j.attribute.ErrorCodeAttribute;
import gg.essential.lib.ice4j.attribute.EvenPortAttribute;
import gg.essential.lib.ice4j.attribute.FingerprintAttribute;
import gg.essential.lib.ice4j.attribute.IceControlledAttribute;
import gg.essential.lib.ice4j.attribute.IceControllingAttribute;
import gg.essential.lib.ice4j.attribute.LifetimeAttribute;
import gg.essential.lib.ice4j.attribute.MappedAddressAttribute;
import gg.essential.lib.ice4j.attribute.MessageIntegrityAttribute;
import gg.essential.lib.ice4j.attribute.NonceAttribute;
import gg.essential.lib.ice4j.attribute.OptionalAttribute;
import gg.essential.lib.ice4j.attribute.PriorityAttribute;
import gg.essential.lib.ice4j.attribute.RealmAttribute;
import gg.essential.lib.ice4j.attribute.ReflectedFromAttribute;
import gg.essential.lib.ice4j.attribute.RequestedAddressFamilyAttribute;
import gg.essential.lib.ice4j.attribute.RequestedTransportAttribute;
import gg.essential.lib.ice4j.attribute.ReservationTokenAttribute;
import gg.essential.lib.ice4j.attribute.ResponseAddressAttribute;
import gg.essential.lib.ice4j.attribute.SoftwareAttribute;
import gg.essential.lib.ice4j.attribute.SourceAddressAttribute;
import gg.essential.lib.ice4j.attribute.UnknownAttributesAttribute;
import gg.essential.lib.ice4j.attribute.UseCandidateAttribute;
import gg.essential.lib.ice4j.attribute.UsernameAttribute;
import gg.essential.lib.ice4j.attribute.XorMappedAddressAttribute;
import gg.essential.lib.ice4j.attribute.XorOnlyAttribute;
import gg.essential.lib.ice4j.attribute.XorPeerAddressAttribute;
import gg.essential.lib.ice4j.attribute.XorRelayedAddressAttribute;

public class AttributeDecoder {
    public static Attribute decode(byte[] bytes, int offset2, int length) throws StunException {
        if (bytes == null || bytes.length < 4) {
            throw new StunException(2, "Could not decode the specified binary array.");
        }
        char attributeType = (char)((bytes[offset2] & 0xFF) << 8 | bytes[offset2 + 1] & 0xFF);
        char attributeLength = (char)((bytes[offset2 + 2] & 0xFF) << 8 | bytes[offset2 + 3] & 0xFF);
        if (attributeLength > bytes.length - offset2) {
            throw new StunException(2, "Could not decode the specified binary array.");
        }
        Attribute decodedAttribute = null;
        switch (attributeType) {
            case '\u0003': {
                decodedAttribute = new ChangeRequestAttribute();
                break;
            }
            case '\u0005': {
                decodedAttribute = new ChangedAddressAttribute();
                break;
            }
            case '\u0001': {
                decodedAttribute = new MappedAddressAttribute();
                break;
            }
            case '\t': {
                decodedAttribute = new ErrorCodeAttribute();
                break;
            }
            case '\b': {
                decodedAttribute = new MessageIntegrityAttribute();
                break;
            }
            case '\u000b': {
                decodedAttribute = new ReflectedFromAttribute();
                break;
            }
            case '\u0002': {
                decodedAttribute = new ResponseAddressAttribute();
                break;
            }
            case '\u0004': {
                decodedAttribute = new SourceAddressAttribute();
                break;
            }
            case '\n': {
                decodedAttribute = new UnknownAttributesAttribute();
                break;
            }
            case ' ': {
                decodedAttribute = new XorMappedAddressAttribute();
                break;
            }
            case '!': {
                decodedAttribute = new XorOnlyAttribute();
                break;
            }
            case '\u8022': {
                decodedAttribute = new SoftwareAttribute();
                break;
            }
            case '\u0006': {
                decodedAttribute = new UsernameAttribute();
                break;
            }
            case '\u0014': {
                decodedAttribute = new RealmAttribute();
                break;
            }
            case '\u0015': {
                decodedAttribute = new NonceAttribute();
                break;
            }
            case '\u8028': {
                decodedAttribute = new FingerprintAttribute();
                break;
            }
            case '\u8023': {
                decodedAttribute = new AlternateServerAttribute();
                break;
            }
            case '\f': {
                decodedAttribute = new ChannelNumberAttribute();
                break;
            }
            case '\r': {
                decodedAttribute = new LifetimeAttribute();
                break;
            }
            case '\u0012': {
                decodedAttribute = new XorPeerAddressAttribute();
                break;
            }
            case '\u0013': {
                decodedAttribute = new DataAttribute();
                break;
            }
            case '\u0016': {
                decodedAttribute = new XorRelayedAddressAttribute();
                break;
            }
            case '\u0018': {
                decodedAttribute = new EvenPortAttribute();
                break;
            }
            case '\u0019': {
                decodedAttribute = new RequestedTransportAttribute();
                break;
            }
            case '\u001a': {
                decodedAttribute = new DontFragmentAttribute();
                break;
            }
            case '\"': {
                decodedAttribute = new ReservationTokenAttribute();
                break;
            }
            case '$': {
                decodedAttribute = new PriorityAttribute();
                break;
            }
            case '\u802a': {
                decodedAttribute = new IceControllingAttribute();
                break;
            }
            case '\u8029': {
                decodedAttribute = new IceControlledAttribute();
                break;
            }
            case '%': {
                decodedAttribute = new UseCandidateAttribute();
                break;
            }
            case '\u0017': {
                decodedAttribute = new RequestedAddressFamilyAttribute();
                break;
            }
            case '*': {
                decodedAttribute = new ConnectionIdAttribute();
                break;
            }
            default: {
                decodedAttribute = new OptionalAttribute('\u8000');
            }
        }
        decodedAttribute.setAttributeType(attributeType);
        decodedAttribute.setLocationInMessage(offset2);
        decodedAttribute.decodeAttributeBody(bytes, (char)(4 + offset2), attributeLength);
        return decodedAttribute;
    }
}

