/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.attribute;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.attribute.ChangeRequestAttribute;
import gg.essential.lib.ice4j.attribute.ChangedAddressAttribute;
import gg.essential.lib.ice4j.attribute.ChannelNumberAttribute;
import gg.essential.lib.ice4j.attribute.ConnectionIdAttribute;
import gg.essential.lib.ice4j.attribute.DataAttribute;
import gg.essential.lib.ice4j.attribute.DestinationAddressAttribute;
import gg.essential.lib.ice4j.attribute.ErrorCodeAttribute;
import gg.essential.lib.ice4j.attribute.EvenPortAttribute;
import gg.essential.lib.ice4j.attribute.FingerprintAttribute;
import gg.essential.lib.ice4j.attribute.IceControlledAttribute;
import gg.essential.lib.ice4j.attribute.IceControllingAttribute;
import gg.essential.lib.ice4j.attribute.LifetimeAttribute;
import gg.essential.lib.ice4j.attribute.MagicCookieAttribute;
import gg.essential.lib.ice4j.attribute.MappedAddressAttribute;
import gg.essential.lib.ice4j.attribute.MessageIntegrityAttribute;
import gg.essential.lib.ice4j.attribute.NonceAttribute;
import gg.essential.lib.ice4j.attribute.PriorityAttribute;
import gg.essential.lib.ice4j.attribute.RealmAttribute;
import gg.essential.lib.ice4j.attribute.ReflectedFromAttribute;
import gg.essential.lib.ice4j.attribute.RequestedAddressFamilyAttribute;
import gg.essential.lib.ice4j.attribute.RequestedTransportAttribute;
import gg.essential.lib.ice4j.attribute.ReservationTokenAttribute;
import gg.essential.lib.ice4j.attribute.ResponseAddressAttribute;
import gg.essential.lib.ice4j.attribute.SoftwareAttribute;
import gg.essential.lib.ice4j.attribute.SourceAddressAttribute;
import gg.essential.lib.ice4j.attribute.UnknownAttributesAttribute;
import gg.essential.lib.ice4j.attribute.UseCandidateAttribute;
import gg.essential.lib.ice4j.attribute.UsernameAttribute;
import gg.essential.lib.ice4j.attribute.XorMappedAddressAttribute;
import gg.essential.lib.ice4j.attribute.XorPeerAddressAttribute;
import gg.essential.lib.ice4j.attribute.XorRelayedAddressAttribute;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;

public class AttributeFactory {
    public static ChangeRequestAttribute createChangeRequestAttribute() {
        return AttributeFactory.createChangeRequestAttribute(false, false);
    }

    public static ChangeRequestAttribute createChangeRequestAttribute(boolean changeIP, boolean changePort) {
        ChangeRequestAttribute attribute = new ChangeRequestAttribute();
        attribute.setChangeIpFlag(changeIP);
        attribute.setChangePortFlag(changePort);
        return attribute;
    }

    public static ChangedAddressAttribute createChangedAddressAttribute(TransportAddress address) {
        ChangedAddressAttribute attribute = new ChangedAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(byte errorClass, byte errorNumber) throws StunException {
        return AttributeFactory.createErrorCodeAttribute(errorClass, errorNumber, null);
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(byte errorClass, byte errorNumber, String reasonPhrase) throws StunException {
        ErrorCodeAttribute attribute = new ErrorCodeAttribute();
        attribute.setErrorClass(errorClass);
        attribute.setErrorNumber(errorNumber);
        attribute.setReasonPhrase(reasonPhrase == null ? ErrorCodeAttribute.getDefaultReasonPhrase(attribute.getErrorCode()) : reasonPhrase);
        return attribute;
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(char errorCode) throws StunException {
        return AttributeFactory.createErrorCodeAttribute(errorCode, null);
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(char errorCode, String reasonPhrase) throws IllegalArgumentException {
        ErrorCodeAttribute attribute = new ErrorCodeAttribute();
        attribute.setErrorCode(errorCode);
        attribute.setReasonPhrase(reasonPhrase == null ? ErrorCodeAttribute.getDefaultReasonPhrase(attribute.getErrorCode()) : reasonPhrase);
        return attribute;
    }

    public static MappedAddressAttribute createMappedAddressAttribute(TransportAddress address) {
        MappedAddressAttribute attribute = new MappedAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static ReflectedFromAttribute createReflectedFromAttribute(TransportAddress address) {
        ReflectedFromAttribute attribute = new ReflectedFromAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static ResponseAddressAttribute createResponseAddressAttribute(TransportAddress address) {
        ResponseAddressAttribute attribute = new ResponseAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static SourceAddressAttribute createSourceAddressAttribute(TransportAddress address) {
        SourceAddressAttribute attribute = new SourceAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static UnknownAttributesAttribute createUnknownAttributesAttribute() {
        UnknownAttributesAttribute attribute = new UnknownAttributesAttribute();
        return attribute;
    }

    public static XorRelayedAddressAttribute createXorRelayedAddressAttribute(TransportAddress address, byte[] tranID) {
        XorRelayedAddressAttribute attribute = new XorRelayedAddressAttribute();
        attribute.setAddress(address, tranID);
        return attribute;
    }

    public static XorPeerAddressAttribute createXorPeerAddressAttribute(TransportAddress address, byte[] tranID) {
        XorPeerAddressAttribute attribute = new XorPeerAddressAttribute();
        attribute.setAddress(address, tranID);
        return attribute;
    }

    public static XorMappedAddressAttribute createXorMappedAddressAttribute(TransportAddress address, byte[] tranID) {
        XorMappedAddressAttribute attribute = new XorMappedAddressAttribute();
        attribute.setAddress(address, tranID);
        return attribute;
    }

    public static UsernameAttribute createUsernameAttribute(byte[] username) {
        UsernameAttribute attribute = new UsernameAttribute();
        attribute.setUsername(username);
        return attribute;
    }

    public static UsernameAttribute createUsernameAttribute(String username) {
        UsernameAttribute attribute = new UsernameAttribute();
        try {
            attribute.setUsername(username.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ueex) {
            throw new UndeclaredThrowableException(ueex);
        }
        return attribute;
    }

    public static MessageIntegrityAttribute createMessageIntegrityAttribute(String username) {
        MessageIntegrityAttribute attribute = new MessageIntegrityAttribute();
        attribute.setUsername(username);
        return attribute;
    }

    public static FingerprintAttribute createFingerprintAttribute() {
        FingerprintAttribute attribute = new FingerprintAttribute();
        return attribute;
    }

    public static ChannelNumberAttribute createChannelNumberAttribute(char channelNumber) {
        ChannelNumberAttribute attribute = new ChannelNumberAttribute();
        attribute.setChannelNumber(channelNumber);
        return attribute;
    }

    public static RealmAttribute createRealmAttribute(byte[] realm) {
        RealmAttribute attribute = new RealmAttribute();
        attribute.setRealm(realm);
        return attribute;
    }

    public static NonceAttribute createNonceAttribute(byte[] nonce) {
        NonceAttribute attribute = new NonceAttribute();
        attribute.setNonce(nonce);
        return attribute;
    }

    public static SoftwareAttribute createSoftwareAttribute(byte[] software) {
        SoftwareAttribute attribute = new SoftwareAttribute();
        attribute.setSoftware(software);
        return attribute;
    }

    public static EvenPortAttribute createEvenPortAttribute(boolean rFlag) {
        EvenPortAttribute attribute = new EvenPortAttribute();
        attribute.setRFlag(rFlag);
        return attribute;
    }

    public static LifetimeAttribute createLifetimeAttribute(int lifetime) {
        LifetimeAttribute attribute = new LifetimeAttribute();
        attribute.setLifetime(lifetime);
        return attribute;
    }

    public static RequestedTransportAttribute createRequestedTransportAttribute(byte protocol) {
        RequestedTransportAttribute attribute = new RequestedTransportAttribute();
        attribute.setRequestedTransport(protocol);
        return attribute;
    }

    public static ReservationTokenAttribute createReservationTokenAttribute(byte[] token) {
        ReservationTokenAttribute attribute = new ReservationTokenAttribute();
        attribute.setReservationToken(token);
        return attribute;
    }

    public static DataAttribute createDataAttribute(byte[] data) {
        DataAttribute attribute = new DataAttribute();
        attribute.setData(data);
        return attribute;
    }

    public static DataAttribute createDataAttributeWithoutPadding(byte[] data) {
        DataAttribute attribute = new DataAttribute(false);
        attribute.setData(data);
        return attribute;
    }

    public static IceControlledAttribute createIceControlledAttribute(long tieBreaker) {
        IceControlledAttribute attribute = new IceControlledAttribute();
        attribute.setTieBreaker(tieBreaker);
        return attribute;
    }

    public static PriorityAttribute createPriorityAttribute(long priority) throws IllegalArgumentException {
        PriorityAttribute attribute = new PriorityAttribute();
        attribute.setPriority(priority);
        return attribute;
    }

    public static UseCandidateAttribute createUseCandidateAttribute() {
        UseCandidateAttribute attribute = new UseCandidateAttribute();
        return attribute;
    }

    public static IceControllingAttribute createIceControllingAttribute(long tieBreaker) {
        IceControllingAttribute attribute = new IceControllingAttribute();
        attribute.setTieBreaker(tieBreaker);
        return attribute;
    }

    public static MagicCookieAttribute createMagicCookieAttribute() {
        MagicCookieAttribute attribute = new MagicCookieAttribute();
        return attribute;
    }

    public static DestinationAddressAttribute createDestinationAddressAttribute(TransportAddress address) {
        DestinationAddressAttribute attribute = new DestinationAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static RequestedAddressFamilyAttribute createRequestedAddressFamilyAttribute(char family) {
        RequestedAddressFamilyAttribute attribute = new RequestedAddressFamilyAttribute();
        boolean isSet = attribute.setFamily(family);
        if (!isSet) {
            attribute = null;
        }
        return attribute;
    }

    public static ConnectionIdAttribute createConnectionIdAttribute(int connectionIdValue) {
        ConnectionIdAttribute attribute = new ConnectionIdAttribute();
        attribute.setConnectionIdValue(connectionIdValue);
        return attribute;
    }

    public static ConnectionIdAttribute createConnectionIdAttribute() {
        ConnectionIdAttribute attribute = new ConnectionIdAttribute();
        int connectionIdValue = attribute.hashCode();
        attribute.setConnectionIdValue(connectionIdValue);
        return attribute;
    }
}

