/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.attribute;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.attribute.Attribute;
import gg.essential.lib.ice4j.attribute.ContentDependentAttribute;
import gg.essential.lib.ice4j.stack.StunStack;
import java.util.zip.CRC32;

public class FingerprintAttribute
extends Attribute
implements ContentDependentAttribute {
    public static final String NAME = "FINGERPRINT";
    public static final byte[] XOR_MASK = new byte[]{83, 84, 85, 78};
    private byte[] crc;

    FingerprintAttribute() {
        super('\u8028');
    }

    public byte[] getChecksum() {
        return this.crc;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FingerprintAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        FingerprintAttribute att = (FingerprintAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength();
    }

    @Override
    public byte[] encode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ContentDependentAttributes should be encoded through the contend-dependent encode method");
    }

    @Override
    public byte[] encode(StunStack stunStack, byte[] content, int offset2, int length) {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        byte[] xorCrc32 = FingerprintAttribute.calculateXorCRC32(content, offset2, length);
        binValue[4] = xorCrc32[0];
        binValue[5] = xorCrc32[1];
        binValue[6] = xorCrc32[2];
        binValue[7] = xorCrc32[3];
        return binValue;
    }

    @Override
    public void decodeAttributeBody(byte[] attributeValue, char offset2, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("length invalid");
        }
        byte[] incomingCrcBytes = new byte[]{attributeValue[offset2], attributeValue[offset2 + '\u0001'], attributeValue[offset2 + 2], attributeValue[offset2 + 3]};
        this.crc = incomingCrcBytes;
    }

    public static byte[] calculateXorCRC32(byte[] message2, int offset2, int len) {
        CRC32 checksum = new CRC32();
        checksum.update(message2, offset2, len);
        long crc = checksum.getValue();
        byte[] xorCRC32 = new byte[]{(byte)((byte)(crc >> 24 & 0xFFL) ^ XOR_MASK[0]), (byte)((byte)(crc >> 16 & 0xFFL) ^ XOR_MASK[1]), (byte)((byte)(crc >> 8 & 0xFFL) ^ XOR_MASK[2]), (byte)((byte)(crc & 0xFFL) ^ XOR_MASK[3])};
        return xorCRC32;
    }
}

