/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.attribute;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.attribute.Attribute;

public class PriorityAttribute
extends Attribute {
    private static final char DATA_LENGTH_PRIORITY = '\u0004';
    private long priority = 0L;

    public PriorityAttribute() {
        super('$');
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset2, char length) throws StunException {
        long[] values = new long[4];
        char c = offset2;
        offset2 = (char)(offset2 + '\u0001');
        values[0] = (attributeValue[c] & 0xFF) << 24;
        char c2 = offset2;
        offset2 = (char)(offset2 + '\u0001');
        values[1] = (attributeValue[c2] & 0xFF) << 16;
        char c3 = offset2;
        offset2 = (char)(offset2 + '\u0001');
        values[2] = (attributeValue[c3] & 0xFF) << 8;
        char c4 = offset2;
        offset2 = (char)(offset2 + '\u0001');
        values[3] = attributeValue[c4] & 0xFF;
        this.priority = values[0] | values[1] | values[2] | values[3];
    }

    @Override
    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        binValue[4] = (byte)((this.priority & 0xFF000000L) >> 24);
        binValue[5] = (byte)((this.priority & 0xFF0000L) >> 16);
        binValue[6] = (byte)((this.priority & 0xFF00L) >> 8);
        binValue[7] = (byte)(this.priority & 0xFFL);
        return binValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PriorityAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PriorityAttribute att = (PriorityAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && this.priority == att.priority;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public String getName() {
        return "PRIORITY";
    }

    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) throws IllegalArgumentException {
        if (priority <= 0L || priority > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Priority must be between 0 and (2**31 - 1)");
        }
        this.priority = priority;
    }
}

