/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.attribute;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.attribute.Attribute;
import java.util.ArrayList;
import java.util.Iterator;

public class UnknownAttributesAttribute
extends Attribute {
    public static String NAME = "UNKNOWN-ATTRIBUTES";
    private ArrayList<Character> unknownAttributes = new ArrayList();

    UnknownAttributesAttribute() {
        super('\n');
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public char getDataLength() {
        char len = (char)this.unknownAttributes.size();
        if (len % 2 != 0) {
            len = (char)(len + '\u0001');
        }
        return (char)(len * 2);
    }

    public void addAttributeID(char attributeID) {
        if (!this.contains(attributeID)) {
            this.unknownAttributes.add(Character.valueOf(attributeID));
        }
    }

    public boolean contains(char attributeID) {
        return this.unknownAttributes.contains(Character.valueOf(attributeID));
    }

    public Iterator<Character> getAttributes() {
        return this.unknownAttributes.iterator();
    }

    public int getAttributeCount() {
        return this.unknownAttributes.size();
    }

    public char getAttribute(int index2) {
        return this.unknownAttributes.get(index2).charValue();
    }

    @Override
    public byte[] encode() {
        char att;
        byte[] binValue = new byte[this.getDataLength() + 4];
        int offset2 = 0;
        binValue[offset2++] = (byte)(this.getAttributeType() >> 8);
        binValue[offset2++] = (byte)(this.getAttributeType() & 0xFF);
        binValue[offset2++] = (byte)(this.getDataLength() >> 8);
        binValue[offset2++] = (byte)(this.getDataLength() & 0xFF);
        Iterator<Character> attributes = this.getAttributes();
        while (attributes.hasNext()) {
            att = attributes.next().charValue();
            binValue[offset2++] = (byte)(att >> 8);
            binValue[offset2++] = (byte)(att & 0xFF);
        }
        if (offset2 < binValue.length) {
            att = this.getAttribute(0);
            binValue[offset2++] = (byte)(att >> 8);
            binValue[offset2++] = (byte)(att & 0xFF);
        }
        return binValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UnknownAttributesAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        UnknownAttributesAttribute att = (UnknownAttributesAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && this.unknownAttributes.equals(att.unknownAttributes);
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset2, char length) throws StunException {
        if (length % 2 != 0) {
            throw new StunException("Attribute IDs are 2 bytes long and the passed binary array has an odd length value.");
        }
        int originalOffset = offset2;
        for (int i2 = offset2; i2 < originalOffset + length; i2 += 2) {
            int n = offset2;
            int n2 = offset2 = (char)(offset2 + '\u0001');
            offset2 = (char)(offset2 + '\u0001');
            char attributeID = (char)((attributeValue[n] & 0xFF) << 8 | attributeValue[n2] & 0xFF);
            this.addAttributeID(attributeID);
        }
    }
}

