/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice;

import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.CandidatePair;
import gg.essential.lib.ice4j.ice.CandidatePairState;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.RemoteCandidate;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.MergingDatagramSocket;
import gg.essential.lib.jitsi.utils.logging2.Logger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;

public class ComponentSocket
extends MergingDatagramSocket
implements PropertyChangeListener {
    private final Object authorizedAddressesSyncRoot = new Object();
    private Set<SocketAddress> authorizedAddresses = new HashSet<SocketAddress>();
    private Component component;
    private boolean initializedActive = false;
    private final Object initializedActiveSyncRoot = new Object();

    ComponentSocket(Component component3, Logger parentLogger) throws SocketException {
        super(parentLogger);
        this.component = component3;
        component3.getParentStream().addPairChangeListener(this);
    }

    @Override
    protected boolean accept(DatagramPacket p) {
        return this.authorizedAddresses.contains(p.getSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAuthorizedAddress(SocketAddress address) {
        Object object = this.authorizedAddressesSyncRoot;
        synchronized (object) {
            if (this.authorizedAddresses.contains(address)) {
                return;
            }
            this.logger.info("Adding allowed address: " + address);
            HashSet<SocketAddress> newSet = new HashSet<SocketAddress>();
            newSet.addAll(this.authorizedAddresses);
            newSet.add(address);
            this.authorizedAddresses = newSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof CandidatePair)) {
            return;
        }
        CandidatePair pair = (CandidatePair)event.getSource();
        if (!pair.getParentComponent().equals(this.component)) {
            return;
        }
        String propertyName = event.getPropertyName();
        if ("PairStateChanged".equals(propertyName)) {
            CandidatePairState newState = (CandidatePairState)((Object)event.getNewValue());
            if (CandidatePairState.SUCCEEDED.equals((Object)newState)) {
                this.addAuthorizedAddress(pair.getRemoteCandidate().getTransportAddress());
            }
        } else if ("PairNominated".equals(propertyName)) {
            Object object = this.initializedActiveSyncRoot;
            synchronized (object) {
                if (this.initializedActive) {
                    return;
                }
                LocalCandidate localCandidate = pair.getLocalCandidate();
                LocalCandidate base = (LocalCandidate)localCandidate.getBase();
                if (base != null) {
                    localCandidate = base;
                }
                TransportAddress remoteAddress = null;
                RemoteCandidate remoteCandidate = pair.getRemoteCandidate();
                if (remoteCandidate != null) {
                    remoteAddress = remoteCandidate.getTransportAddress();
                }
                IceSocketWrapper socketWrapper = localCandidate.getCandidateIceSocketWrapper(remoteAddress);
                this.initializeActive(socketWrapper, remoteAddress);
                this.initializedActive = true;
            }
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            Component component3 = this.component;
            if (component3 != null) {
                component3.getParentStream().removePairStateChangeListener(this);
                this.component = null;
            }
        }
    }
}

