/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice;

import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.Candidate;
import gg.essential.lib.ice4j.ice.CandidateType;
import java.util.Hashtable;
import java.util.Map;

public class FoundationsRegistry {
    private int lastAssignedFoundation = 0;
    private int lastAssignedRemoteFoundation = 10000;
    private Map<String, String> foundations = new Hashtable<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignFoundation(Candidate<?> candidate2) {
        String server;
        CandidateType candidateType = candidate2.getType();
        String type = candidateType.toString();
        String base = ((Candidate)candidate2.getBase()).getTransportAddress().getHostAddress();
        switch (candidateType) {
            case SERVER_REFLEXIVE_CANDIDATE: {
                TransportAddress serverAddress = candidate2.getStunServerAddress();
                server = serverAddress == null ? "" : serverAddress.getHostAddress();
                break;
            }
            case RELAYED_CANDIDATE: {
                server = candidate2.getRelayServerAddress().getHostAddress();
                break;
            }
            default: {
                server = null;
            }
        }
        String transport = candidate2.getTransport().toString();
        StringBuffer foundationStringBuff = new StringBuffer(type);
        foundationStringBuff.append(base);
        if (server != null) {
            foundationStringBuff.append(server);
        }
        foundationStringBuff.append(transport);
        String foundationString = foundationStringBuff.toString();
        String foundationValue = null;
        Map<String, String> map2 = this.foundations;
        synchronized (map2) {
            foundationValue = this.foundations.get(foundationString);
            if (foundationValue == null) {
                foundationValue = Integer.toString(++this.lastAssignedFoundation);
                this.foundations.put(foundationString, foundationValue);
            }
        }
        candidate2.setFoundation(foundationValue);
    }

    public String obtainFoundationForPeerReflexiveCandidate() {
        return Integer.toString(this.lastAssignedRemoteFoundation++);
    }

    public int size() {
        return this.foundations.size();
    }
}

