/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice;

import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.CandidateExtendedType;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.StunDatagramPacketFilter;
import gg.essential.lib.ice4j.socket.TurnDatagramPacketFilter;

public class HostCandidate
extends LocalCandidate {
    private final IceSocketWrapper socket;

    public HostCandidate(IceSocketWrapper socket, Component parentComponent) {
        this(socket, parentComponent, Transport.UDP);
    }

    public HostCandidate(TransportAddress transportAddress, Component parentComponent) {
        super(transportAddress, parentComponent, CandidateType.HOST_CANDIDATE, CandidateExtendedType.HOST_CANDIDATE, null);
        this.socket = null;
        this.setBase(this);
    }

    public HostCandidate(IceSocketWrapper socket, Component parentComponent, Transport transport) {
        super(new TransportAddress(socket.getLocalAddress(), socket.getLocalPort(), transport), parentComponent, CandidateType.HOST_CANDIDATE, CandidateExtendedType.HOST_CANDIDATE, null);
        this.socket = socket;
        this.setBase(this);
    }

    @Override
    protected StunDatagramPacketFilter createStunDatagramPacketFilter(TransportAddress serverAddress) {
        return new TurnDatagramPacketFilter(serverAddress);
    }

    @Override
    public IceSocketWrapper getCandidateIceSocketWrapper() {
        return this.socket;
    }
}

