/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.StackProperties;
import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.NetworkUtils;
import gg.essential.lib.ice4j.ice.harvest.AbstractUdpListener;
import gg.essential.lib.ice4j.ice.harvest.GoogleTurnSSLCandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.HarvestConfig;
import gg.essential.lib.ice4j.ice.harvest.HostCandidateHarvester;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.MuxServerSocketChannelFactory;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractTcpListener {
    private static final Logger logger = Logger.getLogger(AbstractTcpListener.class.getName());
    private AcceptThread acceptThread;
    private boolean close = false;
    protected final List<TransportAddress> localAddresses = new LinkedList<TransportAddress>();
    private final List<SocketChannel> newChannels = new LinkedList<SocketChannel>();
    private final Selector readSelector = Selector.open();
    private ReadThread readThread;
    private final List<ServerSocketChannel> serverSocketChannels = new LinkedList<ServerSocketChannel>();

    static void closeNoExceptions(Channel channel2) {
        try {
            channel2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static List<TransportAddress> getLocalAddresses(int port, List<NetworkInterface> interfaces) {
        LinkedList<TransportAddress> addresses = new LinkedList<TransportAddress>();
        for (NetworkInterface iface : interfaces) {
            if (NetworkUtils.isInterfaceLoopback(iface) || !NetworkUtils.isInterfaceUp(iface) || !HostCandidateHarvester.isInterfaceAllowed(iface)) continue;
            Enumeration<InetAddress> ifaceAddresses = iface.getInetAddresses();
            while (ifaceAddresses.hasMoreElements()) {
                InetAddress addr = ifaceAddresses.nextElement();
                addresses.add(new TransportAddress(addr, port, Transport.TCP));
            }
        }
        return addresses;
    }

    public AbstractTcpListener(int port) throws IOException {
        this(port, Collections.list(NetworkInterface.getNetworkInterfaces()));
    }

    public AbstractTcpListener(int port, List<NetworkInterface> interfaces) throws IOException {
        this(AbstractTcpListener.getLocalAddresses(port, interfaces));
    }

    public AbstractTcpListener(List<TransportAddress> transportAddresses) throws IOException {
        this.addLocalAddresses(transportAddresses);
        this.init();
    }

    protected void addLocalAddresses(List<TransportAddress> transportAddresses) throws IOException {
        String[] allowedAddressesStr = StackProperties.getStringArray("gg.essential.lib.ice4j.ice.harvest.ALLOWED_ADDRESSES", ";");
        InetAddress[] allowedAddresses = null;
        if (allowedAddressesStr != null) {
            allowedAddresses = new InetAddress[allowedAddressesStr.length];
            for (int i2 = 0; i2 < allowedAddressesStr.length; ++i2) {
                allowedAddresses[i2] = InetAddress.getByName(allowedAddressesStr[i2]);
            }
        }
        String[] blockedAddressesStr = StackProperties.getStringArray("gg.essential.lib.ice4j.ice.harvest.BLOCKED_ADDRESSES", ";");
        InetAddress[] blockedAddresses = null;
        if (blockedAddressesStr != null) {
            blockedAddresses = new InetAddress[blockedAddressesStr.length];
            for (int i3 = 0; i3 < blockedAddressesStr.length; ++i3) {
                blockedAddresses[i3] = InetAddress.getByName(blockedAddressesStr[i3]);
            }
        }
        for (TransportAddress transportAddress : transportAddresses) {
            boolean found;
            InetAddress address = transportAddress.getAddress();
            if (address.isLoopbackAddress() || !HarvestConfig.config.useIpv6() && address instanceof Inet6Address) continue;
            if (!HarvestConfig.config.useLinkLocalAddresses() && address.isLinkLocalAddress()) {
                logger.info("Not using link-local address " + address + " for TCP candidates.");
                continue;
            }
            if (allowedAddresses != null) {
                found = false;
                for (InetAddress allowedAddress : allowedAddresses) {
                    if (!allowedAddress.equals(address)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    logger.info("Not using " + address + " for TCP candidates, because it is not in the allowed list.");
                    continue;
                }
            }
            if (blockedAddresses != null) {
                found = false;
                for (InetAddress blockedAddress : blockedAddresses) {
                    if (!blockedAddress.equals(address)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    logger.info("Not using " + address + " for TCP candidates, because it is in the blocked list.");
                    continue;
                }
            }
            this.localAddresses.add(transportAddress);
        }
    }

    public void close() {
        this.close = true;
    }

    protected void init() throws IOException {
        boolean bindWildcard = StackProperties.getBoolean("gg.essential.lib.ice4j.BIND_WILDCARD", false);
        HashSet<InetSocketAddress> addressesToBind = new HashSet<InetSocketAddress>();
        for (TransportAddress transportAddress : this.localAddresses) {
            addressesToBind.add(new InetSocketAddress(bindWildcard ? null : transportAddress.getAddress(), transportAddress.getPort()));
        }
        for (InetSocketAddress addressToBind : addressesToBind) {
            this.addSocketChannel(addressToBind);
        }
        this.acceptThread = new AcceptThread();
        this.acceptThread.start();
        this.readThread = new ReadThread();
        this.readThread.start();
    }

    private void addSocketChannel(InetSocketAddress address) throws IOException {
        ServerSocketChannel channel2 = MuxServerSocketChannelFactory.openAndBindServerSocketChannel(null, address, 0);
        this.serverSocketChannels.add(channel2);
    }

    protected abstract void acceptSession(Socket var1, String var2, DatagramPacket var3) throws IOException, IllegalStateException;

    private class ReadThread
    extends Thread {
        public ReadThread() {
            this.setName("TcpHarvester ReadThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForNewChannels() {
            List list = AbstractTcpListener.this.newChannels;
            synchronized (list) {
                for (SocketChannel channel2 : AbstractTcpListener.this.newChannels) {
                    try {
                        channel2.configureBlocking(false);
                        channel2.register(AbstractTcpListener.this.readSelector, 1, new ChannelDesc(channel2));
                    }
                    catch (IOException ioe) {
                        logger.info("Failed to register channel: " + ioe);
                        AbstractTcpListener.closeNoExceptions(channel2);
                    }
                }
                AbstractTcpListener.this.newChannels.clear();
            }
        }

        private void readFromChannel(ChannelDesc channel2, SelectionKey key) {
            if (channel2.buffer == null) {
                channel2.buffer = !channel2.checkedForSSLHandshake && channel2.length == -1 ? ByteBuffer.allocate(GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length) : (channel2.length == -1 ? ByteBuffer.allocate(2) : ByteBuffer.allocate(channel2.length));
            }
            try {
                int read2 = channel2.channel.read(channel2.buffer);
                if (read2 == -1) {
                    throw new IOException("End of stream!");
                }
                if (!channel2.buffer.hasRemaining()) {
                    if (!channel2.checkedForSSLHandshake) {
                        byte[] bytesRead = new byte[GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length];
                        channel2.buffer.flip();
                        channel2.buffer.get(bytesRead);
                        channel2.buffer = null;
                        channel2.checkedForSSLHandshake = true;
                        if (Arrays.equals(bytesRead, GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE)) {
                            ByteBuffer byteBuffer = ByteBuffer.wrap(GoogleTurnSSLCandidateHarvester.SSL_SERVER_HANDSHAKE);
                            channel2.channel.write(byteBuffer);
                        } else {
                            byte fb = bytesRead[0];
                            byte sb = bytesRead[1];
                            channel2.length = (fb & 0xFF) << 8 | sb & 0xFF;
                            byte[] preBuffered = Arrays.copyOfRange(bytesRead, 2, bytesRead.length);
                            if (channel2.length <= bytesRead.length - 2) {
                                this.processFirstDatagram(preBuffered, channel2, key);
                            } else {
                                channel2.preBuffered = preBuffered;
                                channel2.length -= channel2.preBuffered.length;
                            }
                        }
                    } else if (channel2.length == -1) {
                        channel2.buffer.flip();
                        byte fb = channel2.buffer.get();
                        byte sb = channel2.buffer.get();
                        channel2.length = (fb & 0xFF) << 8 | sb & 0xFF;
                        channel2.buffer = null;
                    } else {
                        byte[] bytesRead = new byte[channel2.length];
                        channel2.buffer.flip();
                        channel2.buffer.get(bytesRead);
                        if (channel2.preBuffered != null) {
                            byte[] newBytesRead = new byte[channel2.preBuffered.length + bytesRead.length];
                            System.arraycopy(channel2.preBuffered, 0, newBytesRead, 0, channel2.preBuffered.length);
                            System.arraycopy(bytesRead, 0, newBytesRead, channel2.preBuffered.length, bytesRead.length);
                            bytesRead = newBytesRead;
                            channel2.preBuffered = null;
                        }
                        this.processFirstDatagram(bytesRead, channel2, key);
                    }
                }
            }
            catch (Exception e) {
                logger.info("Failed to handle TCP socket " + channel2.channel.socket() + ": " + e.getMessage());
                key.cancel();
                AbstractTcpListener.closeNoExceptions(channel2.channel);
            }
        }

        private void processFirstDatagram(byte[] bytesRead, ChannelDesc channel2, SelectionKey key) throws IOException, IllegalStateException {
            String ufrag = AbstractUdpListener.getUfrag(bytesRead, 0, (char)bytesRead.length);
            if (ufrag == null) {
                throw new IOException("Cannot extract ufrag");
            }
            key.cancel();
            channel2.channel.configureBlocking(true);
            DatagramPacket p = new DatagramPacket(bytesRead, bytesRead.length);
            Socket socket = channel2.channel.socket();
            p.setAddress(socket.getInetAddress());
            p.setPort(socket.getPort());
            AbstractTcpListener.this.acceptSession(socket, ufrag, p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Iterator<SelectionKey> iterator;
            while (true) {
                iterator = AbstractTcpListener.this;
                synchronized (iterator) {
                    if (AbstractTcpListener.this.close) {
                        break;
                    }
                }
                this.checkForNewChannels();
                for (SelectionKey selectionKey : AbstractTcpListener.this.readSelector.keys()) {
                    if (!selectionKey.isValid()) continue;
                    ChannelDesc channelDesc = (ChannelDesc)selectionKey.attachment();
                    this.readFromChannel(channelDesc, selectionKey);
                }
                AbstractTcpListener.this.readSelector.selectedKeys().clear();
                try {
                    AbstractTcpListener.this.readSelector.select(7500L);
                }
                catch (IOException ioe) {
                    logger.info("Failed to select a read-ready channel.");
                }
            }
            iterator = AbstractTcpListener.this.newChannels;
            synchronized (iterator) {
                for (SocketChannel channel2 : AbstractTcpListener.this.newChannels) {
                    AbstractTcpListener.closeNoExceptions(channel2);
                }
                AbstractTcpListener.this.newChannels.clear();
            }
            for (SelectionKey selectionKey : AbstractTcpListener.this.readSelector.keys()) {
                SelectableChannel channel2;
                if (!selectionKey.isValid() || !(channel2 = selectionKey.channel()).isOpen()) continue;
                AbstractTcpListener.closeNoExceptions(channel2);
            }
            try {
                AbstractTcpListener.this.readSelector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static class PushBackIceSocketWrapper
    extends IceSocketWrapper {
        private DatagramPacket datagramPacket;
        private final IceSocketWrapper wrapped;

        public PushBackIceSocketWrapper(IceSocketWrapper wrappedWrapper, DatagramPacket datagramPacket) {
            this.wrapped = wrappedWrapper;
            this.datagramPacket = datagramPacket;
        }

        @Override
        public void close() {
            this.wrapped.close();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.wrapped.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.wrapped.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.wrapped.getLocalSocketAddress();
        }

        @Override
        public Socket getTCPSocket() {
            return this.wrapped.getTCPSocket();
        }

        @Override
        public DatagramSocket getUDPSocket() {
            return this.wrapped.getUDPSocket();
        }

        @Override
        public void receive(DatagramPacket p) throws IOException {
            if (this.datagramPacket != null) {
                int len = Math.min(p.getLength(), this.datagramPacket.getLength());
                System.arraycopy(this.datagramPacket.getData(), 0, p.getData(), 0, len);
                p.setAddress(this.datagramPacket.getAddress());
                p.setPort(this.datagramPacket.getPort());
                this.datagramPacket = null;
            } else {
                this.wrapped.receive(p);
            }
        }

        @Override
        public void send(DatagramPacket p) throws IOException {
            this.wrapped.send(p);
        }
    }

    private static class ChannelDesc {
        public final SocketChannel channel;
        ByteBuffer buffer = null;
        boolean checkedForSSLHandshake = false;
        byte[] preBuffered = null;
        int length = -1;

        public ChannelDesc(SocketChannel channel2) {
            this.channel = channel2;
        }
    }

    private class AcceptThread
    extends Thread {
        private final Selector selector;

        public AcceptThread() throws IOException {
            this.setName("TcpHarvester AcceptThread");
            this.setDaemon(true);
            this.selector = Selector.open();
            for (ServerSocketChannel channel2 : AbstractTcpListener.this.serverSocketChannels) {
                channel2.configureBlocking(false);
                channel2.register(this.selector, 16);
            }
        }

        private void notifyReadThread() {
            AbstractTcpListener.this.readSelector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!AbstractTcpListener.this.close) {
                IOException exception = null;
                LinkedList<SocketChannel> channelsToAdd = new LinkedList<SocketChannel>();
                long selectTimeout = 3000L;
                for (SelectionKey key : this.selector.keys()) {
                    SocketChannel channel2;
                    if (!key.isValid()) continue;
                    boolean acceptable = key.isAcceptable();
                    try {
                        channel2 = ((ServerSocketChannel)key.channel()).accept();
                    }
                    catch (IOException ioe) {
                        exception = ioe;
                        break;
                    }
                    if (channel2 != null) {
                        channelsToAdd.add(channel2);
                        continue;
                    }
                    if (!acceptable) continue;
                    selectTimeout = 100L;
                }
                this.selector.selectedKeys().clear();
                if (!channelsToAdd.isEmpty()) {
                    List list = AbstractTcpListener.this.newChannels;
                    synchronized (list) {
                        AbstractTcpListener.this.newChannels.addAll(channelsToAdd);
                    }
                    this.notifyReadThread();
                }
                if (exception != null) {
                    logger.info("Failed to accept a socket, which should have been ready to accept: " + exception);
                    break;
                }
                try {
                    this.selector.select(selectTimeout);
                }
                catch (IOException ioe) {
                    logger.info("Failed to select an accept-ready socket: " + ioe);
                    break;
                }
            }
            for (ServerSocketChannel serverSocketChannel : AbstractTcpListener.this.serverSocketChannels) {
                AbstractTcpListener.closeNoExceptions(serverSocketChannel);
            }
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

