/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.Agent;
import gg.essential.lib.ice4j.ice.CandidateExtendedType;
import gg.essential.lib.ice4j.ice.CandidateTcpType;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.ComponentSocket;
import gg.essential.lib.ice4j.ice.IceMediaStream;
import gg.essential.lib.ice4j.ice.IceProcessingState;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.ServerReflexiveCandidate;
import gg.essential.lib.ice4j.ice.TcpHostCandidate;
import gg.essential.lib.ice4j.ice.harvest.AbstractTcpListener;
import gg.essential.lib.ice4j.ice.harvest.CandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.HarvestStatistics;
import gg.essential.lib.ice4j.ice.harvest.MappingCandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.MappingCandidateHarvesters;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.IceTcpSocketWrapper;
import gg.essential.lib.ice4j.socket.MultiplexingSocket;
import gg.essential.lib.ice4j.socket.StunDatagramPacketFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpHarvester
extends AbstractTcpListener
implements CandidateHarvester {
    private static final Logger logger = Logger.getLogger(TcpHarvester.class.getName());
    private static final int PURGE_INTERVAL = 20;
    private final Map<String, WeakReference<Component>> components = new HashMap<String, WeakReference<Component>>();
    private final Map<InetAddress, InetAddress> mappedAddresses = new HashMap<InetAddress, InetAddress>();
    private final Set<Integer> mappedPorts = new HashSet<Integer>();
    private int purgeCounter = 0;
    private final boolean ssltcp;
    private HarvestStatistics harvestStatistics = new HarvestStatistics();

    public TcpHarvester(int port) throws IOException {
        super(port);
        this.ssltcp = false;
        this.addMappedAddresses();
    }

    public TcpHarvester(int port, boolean ssltcp) throws IOException {
        super(port, Collections.list(NetworkInterface.getNetworkInterfaces()));
        this.ssltcp = ssltcp;
        this.addMappedAddresses();
    }

    public TcpHarvester(int port, List<NetworkInterface> interfaces, boolean ssltcp) throws IOException {
        super(port, interfaces);
        this.ssltcp = ssltcp;
        this.addMappedAddresses();
    }

    public TcpHarvester(List<TransportAddress> transportAddresses) throws IOException {
        super(transportAddresses);
        this.ssltcp = false;
        this.addMappedAddresses();
    }

    public TcpHarvester(List<TransportAddress> transportAddresses, boolean ssltcp) throws IOException {
        super(transportAddresses);
        this.ssltcp = ssltcp;
        this.addMappedAddresses();
    }

    private void addMappedAddresses() {
        for (MappingCandidateHarvester harvester : MappingCandidateHarvesters.getHarvesters()) {
            this.addMappedAddress(harvester.getMask().getAddress(), harvester.getFace().getAddress());
        }
    }

    public void addMappedAddress(InetAddress publicAddress, InetAddress localAddress) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding a mapped address: " + localAddress + " => " + publicAddress);
        }
        this.mappedAddresses.put(publicAddress, localAddress);
    }

    public void addMappedPort(int port) {
        this.mappedPorts.add(port);
    }

    private List<LocalCandidate> createLocalCandidates(Component component3) {
        LinkedList<TcpHostCandidate> hostCandidates = new LinkedList<TcpHostCandidate>();
        for (Object transportAddress : this.localAddresses) {
            TcpHostCandidate tcpHostCandidate = new TcpHostCandidate((TransportAddress)transportAddress, component3);
            tcpHostCandidate.setTcpType(CandidateTcpType.PASSIVE);
            if (this.ssltcp) {
                tcpHostCandidate.setSSL(true);
            }
            hostCandidates.add(tcpHostCandidate);
        }
        LinkedList<ServerReflexiveCandidate> mappedCandidates = new LinkedList<ServerReflexiveCandidate>();
        for (Map.Entry entry : this.mappedAddresses.entrySet()) {
            InetAddress inetAddress = (InetAddress)entry.getValue();
            for (TcpHostCandidate base : hostCandidates) {
                TransportAddress baseTransportAddress = base.getTransportAddress();
                if (!inetAddress.equals(baseTransportAddress.getAddress())) continue;
                InetAddress publicAddress = (InetAddress)entry.getKey();
                ServerReflexiveCandidate mappedCandidate = new ServerReflexiveCandidate(new TransportAddress(publicAddress, baseTransportAddress.getPort(), Transport.TCP), base, base.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (base.isSSL()) {
                    mappedCandidate.setSSL(true);
                }
                mappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                mappedCandidates.add(mappedCandidate);
            }
        }
        LinkedList<ServerReflexiveCandidate> portMappedCandidates = new LinkedList<ServerReflexiveCandidate>();
        for (TcpHostCandidate tcpHostCandidate : hostCandidates) {
            for (Integer port : this.mappedPorts) {
                ServerReflexiveCandidate portMappedCandidate = new ServerReflexiveCandidate(new TransportAddress(tcpHostCandidate.getTransportAddress().getAddress(), (int)port, Transport.TCP), tcpHostCandidate, tcpHostCandidate.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (tcpHostCandidate.isSSL()) {
                    portMappedCandidate.setSSL(true);
                }
                portMappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                portMappedCandidates.add(portMappedCandidate);
            }
        }
        for (LocalCandidate localCandidate : mappedCandidates) {
            TcpHostCandidate base = (TcpHostCandidate)localCandidate.getBase();
            for (Integer port : this.mappedPorts) {
                ServerReflexiveCandidate portMappedCandidate = new ServerReflexiveCandidate(new TransportAddress(localCandidate.getTransportAddress().getAddress(), (int)port, Transport.TCP), base, base.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (base.isSSL()) {
                    portMappedCandidate.setSSL(true);
                }
                portMappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                portMappedCandidates.add(portMappedCandidate);
            }
        }
        LinkedList<LocalCandidate> linkedList = new LinkedList<LocalCandidate>();
        linkedList.addAll(hostCandidates);
        linkedList.addAll(mappedCandidates);
        linkedList.addAll(portMappedCandidates);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getComponent(String localUfrag) {
        Map<String, WeakReference<Component>> map2 = this.components;
        synchronized (map2) {
            WeakReference<Component> wr = this.components.get(localUfrag);
            if (wr != null) {
                Component component3 = (Component)wr.get();
                if (component3 == null) {
                    this.components.remove(localUfrag);
                }
                return component3;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<LocalCandidate> harvest(Component component3) {
        IceMediaStream stream = component3.getParentStream();
        Agent agent = stream.getParentAgent();
        if (stream.getComponentCount() != 1 || agent.getStreamCount() != 1) {
            logger.info("More than one Component for an Agent, cannot harvest.");
            return new LinkedList<LocalCandidate>();
        }
        List<LocalCandidate> candidates = this.createLocalCandidates(component3);
        for (LocalCandidate candidate2 : candidates) {
            component3.addLocalCandidate(candidate2);
        }
        Map<String, WeakReference<Component>> map2 = this.components;
        synchronized (map2) {
            this.components.put(agent.getLocalUfrag(), new WeakReference<Component>(component3));
            this.purgeComponents();
        }
        return candidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeComponents() {
        ++this.purgeCounter;
        if (this.purgeCounter % 20 == 0) {
            Map<String, WeakReference<Component>> map2 = this.components;
            synchronized (map2) {
                Iterator<WeakReference<Component>> i2 = this.components.values().iterator();
                while (i2.hasNext()) {
                    if (i2.next().get() != null) continue;
                    i2.remove();
                }
            }
        }
    }

    @Override
    protected void acceptSession(Socket socket, String ufrag, DatagramPacket pushback) throws IOException, IllegalStateException {
        Component component3 = this.getComponent(ufrag);
        if (component3 == null) {
            throw new IllegalStateException("No component found for ufrag " + ufrag);
        }
        this.addSocketToComponent(socket, component3, pushback);
    }

    private void addSocketToComponent(Socket socket, Component component3, DatagramPacket datagramPacket) throws IOException, IllegalStateException {
        IceProcessingState state2 = component3.getParentStream().getParentAgent().getState();
        if (!IceProcessingState.WAITING.equals((Object)state2) && !IceProcessingState.RUNNING.equals((Object)state2)) {
            if (component3.getComponentSocket() == null) {
                throw new IllegalStateException("The associated Agent is in state " + (Object)((Object)state2) + " and we are not using a component socket");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding a socket to an Agent in state " + (Object)((Object)state2));
            }
        }
        IceTcpSocketWrapper candidateSocket = null;
        IceSocketWrapper stunSocket = null;
        MultiplexingSocket multiplexing = new MultiplexingSocket(socket);
        candidateSocket = new IceTcpSocketWrapper(multiplexing);
        stunSocket = new IceTcpSocketWrapper(multiplexing.getSocket(new StunDatagramPacketFilter()));
        stunSocket = new AbstractTcpListener.PushBackIceSocketWrapper(stunSocket, datagramPacket);
        TcpHostCandidate candidate2 = this.findCandidate(component3, socket);
        if (candidate2 == null) {
            throw new IOException("Failed to find the local candidate for socket: " + socket);
        }
        component3.getParentStream().getParentAgent().getStunStack().addSocket(stunSocket);
        candidate2.addSocket(candidateSocket);
        ComponentSocket componentSocket = component3.getComponentSocket();
        if (componentSocket != null) {
            componentSocket.add(multiplexing);
        }
    }

    private TcpHostCandidate findCandidate(Component component3, Socket socket) {
        InetAddress localAddress = socket.getLocalAddress();
        int localPort = socket.getLocalPort();
        for (LocalCandidate candidate2 : component3.getLocalCandidates()) {
            TransportAddress transportAddress = candidate2.getTransportAddress();
            if (!(candidate2 instanceof TcpHostCandidate) || !Transport.TCP.equals((Object)transportAddress.getTransport()) || localPort != transportAddress.getPort() || !localAddress.equals(transportAddress.getAddress())) continue;
            return (TcpHostCandidate)candidate2;
        }
        return null;
    }

    @Override
    public boolean isHostHarvester() {
        return true;
    }

    @Override
    public HarvestStatistics getHarvestStatistics() {
        return this.harvestStatistics;
    }
}

