/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.StunResponseEvent;
import gg.essential.lib.ice4j.ice.GoogleRelayedCandidate;
import gg.essential.lib.ice4j.ice.harvest.GoogleTurnCandidateHarvest;
import gg.essential.lib.ice4j.message.Request;
import gg.essential.lib.ice4j.message.Response;
import gg.essential.lib.ice4j.socket.GoogleRelayedCandidateDelegate;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.logging.Logger;

public class GoogleRelayedCandidateDatagramSocket
extends DatagramSocket {
    private static final Logger logger = Logger.getLogger(GoogleRelayedCandidateDatagramSocket.class.getName());
    private boolean closed = false;
    private final GoogleRelayedCandidate relayedCandidate;
    private final GoogleTurnCandidateHarvest turnCandidateHarvest;
    private final GoogleRelayedCandidateDelegate socketDelegate;

    public GoogleRelayedCandidateDatagramSocket(GoogleRelayedCandidate relayedCandidate, GoogleTurnCandidateHarvest turnCandidateHarvest, String username) throws SocketException {
        super((SocketAddress)null);
        this.socketDelegate = new GoogleRelayedCandidateDelegate(turnCandidateHarvest, username);
        this.relayedCandidate = relayedCandidate;
        this.turnCandidateHarvest = turnCandidateHarvest;
        logger.finest("Create new GoogleRelayedCandidateDatagramSocket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GoogleRelayedCandidateDatagramSocket googleRelayedCandidateDatagramSocket = this;
        synchronized (googleRelayedCandidateDatagramSocket) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.socketDelegate.close();
        this.turnCandidateHarvest.close(this);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getLocalSocketAddress().getAddress();
    }

    @Override
    public int getLocalPort() {
        return this.getLocalSocketAddress().getPort();
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.getRelayedCandidate().getTransportAddress();
    }

    public final GoogleRelayedCandidate getRelayedCandidate() {
        return this.relayedCandidate;
    }

    public void processSuccess(Response response2, Request request2) {
        this.socketDelegate.processSuccess(response2, request2);
    }

    public void processResponse(StunResponseEvent response2) {
        this.socketDelegate.processResponse(response2);
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        this.socketDelegate.receive(p);
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        this.socketDelegate.send(p);
    }
}

