/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.socket.DatagramPacketFilter;
import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;

class SocketReceiveBuffer {
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = 0x100000;
    private static final int DATAGRAMS_BUFFER_CAPACITY = 10000;
    private final BlockingQueue<DatagramPacket> buffer = new ArrayBlockingQueue<DatagramPacket>(10000);
    private final DatagramSizeTracker tracker;

    public SocketReceiveBuffer(Callable<Integer> receiveBufferSizeSupplier) {
        this.tracker = new DatagramSizeTracker(receiveBufferSizeSupplier);
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public void add(DatagramPacket p) {
        while (!this.buffer.offer(p)) {
            this.poll();
        }
        this.tracker.trackDatagramAdded(p);
        while (this.tracker.isExceedReceiveBufferSize() && this.buffer.size() > 1) {
            this.poll();
        }
    }

    public DatagramPacket poll() {
        DatagramPacket p = (DatagramPacket)this.buffer.poll();
        if (p != null) {
            this.tracker.trackDatagramRemoved(p);
        }
        return p;
    }

    public List<DatagramPacket> scan(DatagramPacketFilter filter2) {
        ArrayList<DatagramPacket> matchedDatagrams = null;
        Iterator it = this.buffer.iterator();
        while (it.hasNext()) {
            DatagramPacket p = (DatagramPacket)it.next();
            if (!filter2.accept(p)) continue;
            if (matchedDatagrams == null) {
                matchedDatagrams = new ArrayList<DatagramPacket>();
            }
            matchedDatagrams.add(p);
            it.remove();
            this.tracker.trackDatagramRemoved(p);
        }
        if (matchedDatagrams != null) {
            return matchedDatagrams;
        }
        return Collections.emptyList();
    }

    private final class DatagramSizeTracker {
        private int cachedReceiveBufferSize;
        private int totalBuffersByteSize;
        private int totalDatagramsAdded;
        private final Callable<Integer> receiveBufferSizeSupplier;

        public DatagramSizeTracker(Callable<Integer> receiveBufferSizeSupplier) {
            this.receiveBufferSizeSupplier = receiveBufferSizeSupplier;
        }

        boolean isExceedReceiveBufferSize() {
            return this.totalBuffersByteSize > this.cachedReceiveBufferSize;
        }

        void trackDatagramAdded(DatagramPacket p) {
            int receiveBufferSize;
            ++this.totalDatagramsAdded;
            int pSize = p.getLength();
            if (pSize <= 0) {
                return;
            }
            this.totalBuffersByteSize += pSize;
            if (SocketReceiveBuffer.this.buffer.size() > 1 && ((receiveBufferSize = this.cachedReceiveBufferSize) <= 0 || this.totalDatagramsAdded % 1000 == 0)) {
                try {
                    receiveBufferSize = this.receiveBufferSizeSupplier.call();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (receiveBufferSize <= 0) {
                    receiveBufferSize = 0x100000;
                } else if (receiveBufferSize < 0x100000 && (receiveBufferSize *= 2) <= 0) {
                    receiveBufferSize = 0x100000;
                }
                this.cachedReceiveBufferSize = receiveBufferSize;
            }
        }

        void trackDatagramRemoved(DatagramPacket p) {
            int pSize = p.getLength();
            if (pSize <= 0) {
                return;
            }
            this.totalBuffersByteSize -= pSize;
            if (this.totalBuffersByteSize < 0) {
                this.totalBuffersByteSize = 0;
            }
        }
    }
}

