/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.message.Message;
import gg.essential.lib.ice4j.socket.DatagramPacketFilter;
import java.net.DatagramPacket;

public class StunDatagramPacketFilter
implements DatagramPacketFilter {
    protected final TransportAddress stunServer;

    public StunDatagramPacketFilter() {
        this(null);
    }

    public StunDatagramPacketFilter(TransportAddress stunServer) {
        this.stunServer = stunServer;
    }

    @Override
    public boolean accept(DatagramPacket p) {
        if (this.stunServer != null && !this.stunServer.equals(p.getSocketAddress())) {
            return false;
        }
        if (StunDatagramPacketFilter.isStunPacket(p)) {
            byte[] data = p.getData();
            int offset2 = p.getOffset();
            byte b0 = data[offset2];
            byte b1 = data[offset2 + 1];
            char method = (char)(b0 & 0xFE | b1 & 0xEF);
            return this.acceptMethod(method);
        }
        return false;
    }

    protected boolean acceptMethod(char method) {
        switch (method) {
            case '\u0000': 
            case '\u0001': 
            case '\u0002': {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static boolean isStunPacket(DatagramPacket p) {
        boolean isStunPacket = false;
        byte[] data = p.getData();
        int offset2 = p.getOffset();
        int length = p.getLength();
        if (length >= 20) {
            if (data[offset2 + 4] == Message.MAGIC_COOKIE[0] && data[offset2 + 5] == Message.MAGIC_COOKIE[1] && data[offset2 + 6] == Message.MAGIC_COOKIE[2] && data[offset2 + 7] == Message.MAGIC_COOKIE[3]) {
                isStunPacket = true;
            } else {
                byte b0 = data[offset2];
                boolean areFirstTwoBitsValid = (b0 & 0xC0) == 0;
                int total_header_length = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF) + 20;
                boolean isHeaderLengthValid = length == total_header_length;
                isStunPacket = areFirstTwoBitsValid && isHeaderLengthValid;
            }
        }
        return isStunPacket;
    }
}

