/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.socket.MultiplexingSocket;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;

public class TCPInputStream
extends InputStream {
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = 65536;
    private final byte[] b = new byte[1];
    private boolean inRead;
    private DatagramPacket packet;
    private byte[] packetData;
    private int packetLength;
    private int packetOffset;
    private final Object readSyncRoot = new Object();
    private final MultiplexingSocket socket;

    public TCPInputStream(MultiplexingSocket socket) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        this.socket = socket;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.readSyncRoot;
        synchronized (object) {
            this.waitWhileInRead();
            this.inRead = true;
        }
        try {
            while (true) {
                int read2;
                if ((read2 = this.read0(this.b, 0, 1)) == -1) {
                    int n = read2;
                    return n;
                }
                if (read2 != 1) continue;
                byte by = this.b[0];
                return by;
            }
        }
        finally {
            Object object2 = this.readSyncRoot;
            synchronized (object2) {
                this.inRead = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read2;
        if (len == 0) {
            read2 = 0;
        } else {
            Object object = this.readSyncRoot;
            synchronized (object) {
                this.waitWhileInRead();
                this.inRead = true;
            }
            try {
                read2 = this.read0(b, off, len);
            }
            finally {
                object = this.readSyncRoot;
                synchronized (object) {
                    this.inRead = false;
                }
            }
        }
        return read2;
    }

    protected int read0(byte[] b, int off, int len) throws IOException {
        int read2;
        while (true) {
            if (this.packetLength > 0) {
                read2 = Math.min(this.packetLength, len);
                System.arraycopy(this.packetData, this.packetOffset, b, off, read2);
                this.packetLength -= read2;
                this.packetOffset += read2;
                break;
            }
            int receiveBufferSize = this.socket.getReceiveBufferSize();
            if (receiveBufferSize < 1) {
                receiveBufferSize = 65536;
            }
            if (this.packetData == null || this.packetData.length < receiveBufferSize) {
                this.packetData = new byte[receiveBufferSize];
            }
            if (this.packet == null) {
                this.packet = new DatagramPacket(this.packetData, 0, this.packetData.length);
            } else {
                this.packet.setData(this.packetData, 0, this.packetData.length);
            }
            this.packetLength = 0;
            this.packetOffset = 0;
            this.socket.receive(this.packet);
            this.packetData = this.packet.getData();
            this.packetLength = this.packet.getLength();
            this.packetOffset = this.packet.getOffset();
        }
        return read2;
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhileInRead() {
        boolean interrupted = false;
        Object object = this.readSyncRoot;
        synchronized (object) {
            while (this.inRead) {
                try {
                    this.readSyncRoot.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

