/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.stack;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.StunMessageEvent;
import gg.essential.lib.ice4j.message.Message;
import gg.essential.lib.ice4j.stack.ErrorHandler;
import gg.essential.lib.ice4j.stack.MessageEventHandler;
import gg.essential.lib.ice4j.stack.NetAccessManager;
import gg.essential.lib.ice4j.stack.RawMessage;
import gg.essential.lib.ice4j.stack.StunStack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Logger;

class MessageProcessingTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(MessageProcessingTask.class.getName());
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final NetAccessManager netAccessManager;
    private final ErrorHandler errorHandler;
    private final MessageEventHandler messageEventHandler;
    private RawMessage rawMessage;
    private Consumer<MessageProcessingTask> rawMessageProcessedHandler;

    MessageProcessingTask(NetAccessManager netAccessManager) throws IllegalArgumentException {
        if (netAccessManager == null) {
            throw new NullPointerException("netAccessManager");
        }
        MessageEventHandler messageEventHandler = netAccessManager.getMessageEventHandler();
        if (messageEventHandler == null) {
            throw new IllegalArgumentException("The message event handler may not be null");
        }
        this.netAccessManager = netAccessManager;
        this.messageEventHandler = messageEventHandler;
        this.errorHandler = netAccessManager;
    }

    void setMessage(RawMessage message2, Consumer<MessageProcessingTask> onProcessed) {
        if (message2 == null) {
            throw new IllegalArgumentException("The message may not be null");
        }
        this.rawMessage = message2;
        this.rawMessageProcessedHandler = onProcessed;
    }

    void resetState() {
        this.cancelled.set(false);
        this.rawMessage = null;
        this.rawMessageProcessedHandler = null;
    }

    public void cancel() {
        this.cancelled.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Consumer<MessageProcessingTask> onProcessed = this.rawMessageProcessedHandler;
        RawMessage message2 = this.rawMessage;
        try {
            Message stunMessage;
            if (message2 == null) {
                return;
            }
            this.rawMessage = null;
            this.rawMessageProcessedHandler = null;
            if (this.cancelled.get()) {
                return;
            }
            StunStack stunStack = this.netAccessManager.getStunStack();
            try {
                stunMessage = Message.decode(message2.getBytes(), 0, message2.getMessageLength());
            }
            catch (StunException ex) {
                this.errorHandler.handleError("Failed to decode a stun message!", ex);
                if (onProcessed != null) {
                    onProcessed.accept(this);
                }
                return;
            }
            logger.finest("Dispatching a StunMessageEvent.");
            StunMessageEvent stunMessageEvent = new StunMessageEvent(stunStack, message2, stunMessage);
            this.messageEventHandler.handleMessageEvent(stunMessageEvent);
        }
        catch (Throwable err) {
            this.errorHandler.handleFatalError(Thread.currentThread(), "Unexpected Error!", err);
        }
        finally {
            if (onProcessed != null) {
                onProcessed.accept(this);
            }
        }
    }
}

