/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.stack;

import gg.essential.lib.ice4j.stack.StunClientTransaction;
import gg.essential.lib.ice4j.stack.StunServerTransaction;
import gg.essential.lib.ice4j.stack.StunStack;
import java.util.Arrays;
import java.util.Random;

public class TransactionID {
    public static final int RFC5389_TRANSACTION_ID_LENGTH = 12;
    public static final int RFC3489_TRANSACTION_ID_LENGTH = 16;
    private final byte[] transactionID;
    private Object applicationData = null;
    private static final Random random = new Random(System.currentTimeMillis());
    private int hashCode = 0;

    private TransactionID() {
        this(false);
    }

    private TransactionID(boolean rfc3489Compatibility) {
        this.transactionID = new byte[rfc3489Compatibility ? 16 : 12];
    }

    public static TransactionID createNewTransactionID() {
        TransactionID tid = new TransactionID();
        TransactionID.generateTransactionID(tid, 12);
        return tid;
    }

    public static TransactionID createNewRFC3489TransactionID() {
        TransactionID tid = new TransactionID(true);
        TransactionID.generateTransactionID(tid, 16);
        return tid;
    }

    private static void generateTransactionID(TransactionID tid, int nb) {
        long left2 = System.currentTimeMillis();
        long right = random.nextLong();
        int b = nb / 2;
        for (int i2 = 0; i2 < b; ++i2) {
            tid.transactionID[i2] = (byte)(left2 >> i2 * 8 & 0xFFL);
            tid.transactionID[i2 + b] = (byte)(right >> i2 * 8 & 0xFFL);
        }
        tid.hashCode = tid.transactionID[3] << 24 & 0xFF000000 | tid.transactionID[2] << 16 & 0xFF0000 | tid.transactionID[1] << 8 & 0xFF00 | tid.transactionID[0] & 0xFF;
    }

    public static TransactionID createTransactionID(StunStack stunStack, byte[] transactionID) {
        StunClientTransaction cliTran = stunStack.getClientTransaction(transactionID);
        if (cliTran != null) {
            return cliTran.getTransactionID();
        }
        StunServerTransaction serTran = stunStack.getServerTransaction(transactionID);
        if (serTran != null) {
            return serTran.getTransactionID();
        }
        TransactionID tid = null;
        tid = new TransactionID(transactionID.length == 16);
        System.arraycopy(transactionID, 0, tid.transactionID, 0, tid.transactionID.length);
        tid.hashCode = tid.transactionID[3] << 24 & 0xFF000000 | tid.transactionID[2] << 16 & 0xFF0000 | tid.transactionID[1] << 8 & 0xFF00 | tid.transactionID[0] & 0xFF;
        return tid;
    }

    public byte[] getBytes() {
        return this.transactionID;
    }

    public boolean isRFC3489Compatible() {
        return this.transactionID.length == 16;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TransactionID)) {
            return false;
        }
        byte[] targetBytes = ((TransactionID)obj).transactionID;
        return Arrays.equals(this.transactionID, targetBytes);
    }

    public boolean equals(byte[] targetID) {
        return Arrays.equals(this.transactionID, targetID);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return TransactionID.toString(this.transactionID);
    }

    public static String toString(byte[] transactionID) {
        StringBuilder idStr = new StringBuilder();
        idStr.append("0x");
        for (int i2 = 0; i2 < transactionID.length; ++i2) {
            if ((transactionID[i2] & 0xFF) <= 15) {
                idStr.append("0");
            }
            idStr.append(Integer.toHexString(transactionID[i2] & 0xFF).toUpperCase());
        }
        return idStr.toString();
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }
}

