/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.concurrent;

import gg.essential.lib.jitsi.utils.concurrent.RecurringRunnable;

public abstract class PeriodicRunnable
implements RecurringRunnable {
    private long _lastProcessTime;
    private long _period;

    public PeriodicRunnable(long period) {
        this(period, false);
    }

    public PeriodicRunnable(long period, boolean invokeImmediately) {
        if (period < 1L) {
            throw new IllegalArgumentException("period " + period);
        }
        this._period = period;
        this._lastProcessTime = invokeImmediately ? -1L : System.currentTimeMillis();
    }

    public final long getLastProcessTime() {
        return this._lastProcessTime;
    }

    public final long getPeriod() {
        return this._period;
    }

    public void setPeriod(long period) {
        this._period = period;
    }

    @Override
    public long getTimeUntilNextRun() {
        if (this._lastProcessTime < 0L) {
            return 0L;
        }
        long timeSinceLastProcess = Math.max(System.currentTimeMillis() - this._lastProcessTime, 0L);
        return Math.max(this.getPeriod() - timeSinceLastProcess, 0L);
    }

    @Override
    public void run() {
        this._lastProcessTime = this._lastProcessTime < 0L ? System.currentTimeMillis() : (this._lastProcessTime += this._period);
    }
}

